/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.ide.Ide;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;

public abstract class AbstractPP
extends DefaultTraversablePanel
implements ApplyListener {
    private static final long serialVersionUID = -2110266704679839622L;
    private static final String UNTITLED_DESIGN = oracle.dbtools.crest.model.Messages.getString("Design.Untitled");
    protected String names = "";
    protected static Settings global_settings;
    public static Settings settings;
    private ApplicationView appView = this.getApplicationView();
    private String gs;
    private static boolean oldBoxInBox;
    private static int oldNotation;
    private boolean oldKeepFKNamesSynchronized;
    private static final Logger LOGGER;

    public AbstractPP() {
        if (settings == null) {
            global_settings = this.appView.getSettings();
            this.gs = global_settings.saveSettingsToString();
            settings = new Settings(this.appView);
            settings.loadSettingsFromString(this.gs);
            oldNotation = global_settings.getNotation();
            oldBoxInBox = global_settings.isBoxInBox();
        }
        this.oldKeepFKNamesSynchronized = settings.isKeepFKNamesSynchronized();
        this.setLayout(new GridBagLayout());
    }

    public final void setObjectConstraints(JPanel panel, Component c, int x, int y) {
        SpringLayout.Constraints labelCons = ((SpringLayout)panel.getLayout()).getConstraints(c);
        labelCons.setX(Spring.constant(x));
        labelCons.setY(Spring.constant(y));
    }

    public void setBG(Component c) {
        c.setBackground(Color.WHITE);
        if (!c.getFont().isPlain()) {
            c.setFont(new Font(c.getFont().getName(), 0, c.getFont().getSize()));
        }
    }

    public final int getPreferredIconSize() {
        return 16;
    }

    public final Dimension getPreferredPanelSize() {
        return new Dimension(580, 390);
    }

    public ApplicationView getApplicationView() {
        return ApplicationView.getInstance();
    }

    public Design getCurrentDesign() {
        return this.getApplicationView().getCurrentDesign();
    }

    public void cancel(ApplyEvent e) {
    }

    public void apply(ApplyEvent e) {
        if (this.getCurrentDesign().getName().equals(UNTITLED_DESIGN + "_1") && this.appView.getDesigns().size() == 1) {
            global_settings.loadSettingsFromString(settings.saveSettingsToString());
            this.appView.getInitialSettings().loadSettingsFromString(settings.saveSettingsToString());
        } else {
            global_settings.loadSettingsFromString(settings.saveSettingsToString());
            this.appView.getInitialSettings().loadSettingsFromString(settings.saveSettingsToString());
        }
        int newNotation = settings.getNotation();
        boolean applyNotation = false;
        if (oldNotation != newNotation) {
            applyNotation = true;
            this.names = "".equals(this.names) ? "\"Notation\"" : this.names + ", \"Notation\"";
        }
        boolean newBoxInBox = settings.isBoxInBox();
        boolean applyBoxInBox = false;
        if (oldBoxInBox != newBoxInBox) {
            applyBoxInBox = true;
            this.names = "".equals(this.names) ? "\"Box-In-Box Presentation\"" : this.names + ", \"Box-In-Box Presentation\"";
        }
        if (!"".equals(this.names)) {
            int res = JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("OptionsDialog.ApplyNewSettings"), this.names), MessageFormat.format(Messages.getString("OptionsDialog.ChangeIn"), this.names), 0, 3, null, new String[]{Messages.getString("OptionsDialog.Yes"), Messages.getString("OptionsDialog.No")}, Messages.getString("OptionsDialog.No"));
            if (res == 0) {
                this.getApplicationView().updateSettings(applyNotation, applyBoxInBox);
            } else {
                this.getApplicationView().updateSettings(false, false);
            }
        } else {
            this.getApplicationView().updateSettings(false, false);
        }
        ApplicationView.PROPAGATE_FKATTRIBUTE_DESCRIPTION = settings.isPropagatePKAttrNotes();
        if (settings.isKeepFKNamesSynchronized() && !this.oldKeepFKNamesSynchronized) {
            this.getCurrentDesign().getLogicalDesign().synchronizeFKAttributesName();
        }
        settings.refreshDefaultTypes();
        settings.refreshDefaultDomains();
    }

    protected void addItem(JPanel p, JComponent c, int x, int y, int width, int height, int align, int wx, int wy) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = x;
        gc.gridy = y;
        gc.gridwidth = width;
        gc.gridheight = height;
        gc.weightx = wx;
        gc.weighty = wy;
        gc.insets = new Insets(0, 0, 0, 5);
        gc.anchor = align;
        gc.fill = 2;
        p.add((Component)c, gc);
    }

    protected void addItem(JPanel p, JComponent c, int x, int y, int width, int height, int align, int wx, int wy, int insTop, int insLeft, int insBottom, int insRight) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = x;
        gc.gridy = y;
        gc.gridwidth = width;
        gc.gridheight = height;
        gc.weightx = wx;
        gc.weighty = wy;
        gc.insets = new Insets(insTop, insLeft, insBottom, insRight);
        gc.anchor = align;
        gc.fill = 2;
        p.add((Component)c, gc);
    }

    protected String getDialogName() {
        return null;
    }

    protected void createDialog(String[][] value, JTextField field) {
        KeyDialog keyDialog = new KeyDialog(this.getApplicationView(), this.getDialogName());
        keyDialog.setValues(value);
        keyDialog.setVisible(true);
        StringBuffer buffer = new StringBuffer();
        int cursorPos = field.getCaretPosition();
        int tfSize = field.getText().length();
        if (cursorPos == 0) {
            buffer.append(keyDialog.getProviderName());
        }
        if (tfSize != 0) {
            for (int i = 0; i < tfSize; ++i) {
                String providerName;
                buffer.append(field.getText().charAt(i));
                if (cursorPos != i + 1 || (providerName = keyDialog.getProviderName()) == null) continue;
                buffer.append(providerName);
            }
            field.setText(buffer.toString());
        } else {
            field.setText(keyDialog.getProviderName());
        }
    }

    public static void validateDirectory(JTextField tf) {
        try {
            File f = new File(tf.getText());
            if (!f.exists()) {
                tf.setForeground(Color.RED);
                tf.setToolTipText(Messages.getString("DirectoryFieldValidator.DirectoryDoesNotExist"));
            } else {
                tf.setForeground(Color.BLACK);
                tf.setToolTipText(null);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error on directory validation : ", e);
        }
    }

    static {
        LOGGER = new Logger(AbstractPP.class);
    }

    public static class KeyDialog
    extends JDialog {
        private static final String KEY_ESCAPE = "ESCAPE";
        private JTable nameTable;
        private JScrollPane pane;
        private JPanel buttonsPanel;
        private String[][] values = new String[0][];
        private NameProvider provider = new NameProvider();
        private Action escapeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.dispose();
            }
        };

        public KeyDialog(ApplicationView view, String dialogName) {
            super(view.getFrame());
            this.setTitle(dialogName);
            this.nameTable = new JTable(new KeyTableModel());
            this.nameTable.setSelectionMode(0);
            this.nameTable.setTableHeader(null);
            this.pane = new JScrollPane(this.nameTable);
            this.pane.setPreferredSize(new Dimension(600, 200));
            this.getContentPane().add(this.pane);
            this.getContentPane().add((Component)this.getButtonPanel(), "South");
            this.setResizable(true);
            this.setModal(true);
            this.pack();
            CommonUtil.centerOnScreen(this);
            int condition = 1;
            JComponent c = (JComponent)this.getContentPane();
            c.getInputMap(condition).put(KeyStroke.getKeyStroke(KEY_ESCAPE), KEY_ESCAPE);
            c.getActionMap().put(KEY_ESCAPE, this.escapeAction);
        }

        protected JPanel getButtonPanel() {
            if (this.buttonsPanel == null) {
                this.buttonsPanel = new JPanel();
                JButton ok = new JButton(Messages.getString("OptionsDialog.OK"));
                ok.setMnemonic(79);
                ok.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (nameTable.getSelectedRow() != -1) {
                            provider.setName(nameTable.getValueAt(nameTable.getSelectedRow(), 0).toString());
                        }
                        this.dispose();
                    }
                });
                JButton cancel = new JButton(Messages.getString("OptionsDialog.Cancel"));
                cancel.setMnemonic(67);
                cancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                cancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.dispose();
                    }
                });
                this.buttonsPanel.add(ok);
                this.buttonsPanel.add(cancel);
            }
            return this.buttonsPanel;
        }

        public String getProviderName() {
            return this.provider.getName();
        }

        public void setValues(String[][] value) {
            this.values = value;
        }

        class KeyTableModel
        extends AbstractTableModel {
            KeyTableModel() {
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public int getRowCount() {
                return KeyDialog.this.values.length;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return KeyDialog.this.values[rowIndex][columnIndex];
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        }
    }

    static class NameProvider {
        private String name = "";

        NameProvider() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String newName) {
            this.name = newName;
        }
    }
}

