/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Map;
import oracle.dbtools.crest.exports.reports.RSGeneral;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.model.design.glossary.GlossaryWord;
import oracle.dbtools.crest.util.GUID;

public class RSGlossaryTerms
extends RSGeneral {
    public static void export(Glossary glossary, Map map, Connection connection) throws Exception {
        ArrayList list = new ArrayList(1000);
        int count = 0;
        String glossaryID = glossary.getId();
        String glossaryOVID = (String)map.get(glossaryID);
        String query = "INSERT INTO DMRS_GLOSSARY_TERMS (Term_ID, Term_OVID, Term_Name, Short_Description, Abbrev, Alt_Abbrev, Prime_Word, Class_Word, Modifier, Qualifier, Glossary_ID, Glossary_OVID, Glossary_Name, Plural) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = connection.prepareStatement(query);
        for (GlossaryWord word : glossary.getWords()) {
            String termID = word.getId();
            String termOVID = new GUID().toString();
            map.put(termID, termOVID);
            stmt.setString(1, termID);
            stmt.setString(2, termOVID);
            stmt.setString(3, word.getName());
            if (word.getShortDescription().length() > 4000) {
                stmt.setString(4, word.getShortDescription().substring(0, 4000));
            } else {
                stmt.setString(4, word.getShortDescription());
            }
            stmt.setString(5, word.getAbbreviation());
            stmt.setString(6, word.getAltAbbrevation());
            stmt.setString(7, word.isPrimaryWord() ? "Y" : "N");
            stmt.setString(8, word.isClassWord() ? "Y" : "N");
            stmt.setString(9, word.isModifier() ? "Y" : "N");
            stmt.setString(10, word.isQualifier() ? "Y" : "N");
            stmt.setString(11, glossaryID);
            stmt.setString(12, glossaryOVID);
            stmt.setString(13, glossary.getName());
            stmt.setString(14, word.getPlural());
            stmt.addBatch();
            if (++count != 1000) continue;
            count = 0;
            stmt.executeBatch();
        }
        if (count > 0) {
            count = 0;
            stmt.executeBatch();
        }
        stmt.close();
        stmt = null;
    }
}

