/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.sqlserver.v2k;

import oracle.dbtools.crest.exports.ddl.sqlserver.AbstractSSBSqlServer;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.sqlserver.DataBaseSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSetSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.UserSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.LoginSqlServerv2k;

public class SSBGrantDefaultDBAccessSqlServerv2k
extends AbstractSSBSqlServer {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer buffer, Object object, boolean prettyPrint) {
        LoginSqlServerv2k login = (LoginSqlServerv2k)object;
        this.storageDesign = login.getStorageDesign();
        this.appendGrantDBAccess(buffer, login, prettyPrint);
    }

    private void appendGrantDBAccess(StringBuffer buffer, LoginSqlServerv2k login, boolean prettyPrint) {
        if (login.getDefaultDatabase() != null && !this.existUserForDB(login, login.getDefaultDatabase())) {
            if (!login.getDefaultDatabase().isNullInstance()) {
                SSBGrantDefaultDBAccessSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                SSBGrantDefaultDBAccessSqlServerv2k.appendStringWithSpace(buffer, "USE");
                SSBGrantDefaultDBAccessSqlServerv2k.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(login.getDefaultDatabase().getName()));
                SSBGrantDefaultDBAccessSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
                SSBGrantDefaultDBAccessSqlServerv2k.appendStringWithSpace(buffer, "GO");
                SSBGrantDefaultDBAccessSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            }
            SSBGrantDefaultDBAccessSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBGrantDefaultDBAccessSqlServerv2k.appendStringWithSpace(buffer, "EXEC");
            SSBGrantDefaultDBAccessSqlServerv2k.appendStringWithSpace(buffer, "sp_grantdbaccess");
            SSBGrantDefaultDBAccessSqlServerv2k.appendString(buffer, '\'');
            SSBGrantDefaultDBAccessSqlServerv2k.appendString(buffer, login.getName());
            SSBGrantDefaultDBAccessSqlServerv2k.appendString(buffer, '\'');
            SSBGrantDefaultDBAccessSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
            SSBGrantDefaultDBAccessSqlServerv2k.appendStringWithSpace(buffer, "GO");
            SSBGrantDefaultDBAccessSqlServerv2k.appendNewLine(buffer, prettyPrint, 0);
        }
    }

    private boolean existUserForDB(LoginSqlServerv2k login, DataBaseSqlServer db) {
        UserSetSqlServer users = ((StorageDesignSqlServer)login.getStorageDesign()).getUserSet();
        UserSqlServer u = null;
        for (String user : login.getUserSet()) {
            u = (UserSqlServer)users.getByName(user);
            if (u.getDatabase() == null || u.getDatabase() != db) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canHandle(Object object) {
        return object instanceof LoginSqlServerv2k && !((LoginSqlServerv2k)object).getBeforeDefaults() && ((LoginSqlServerv2k)object).isMarkedGenerate();
    }
}

