/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.csv;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.exports.csv.ExportHandler;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;

public class EHAttribute
extends ExportHandler {
    public EHAttribute(CSVExporter csvExporter) {
        super(csvExporter);
    }

    @Override
    public void Export() {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        sb.append("Attribute_Name").append(",");
        sb.append("ObjectID").append(",");
        sb.append("NumOID").append(",");
        sb.append("ImportID").append(",");
        sb.append("ContainerID").append(",");
        sb.append("Num_ContainerID").append(",");
        sb.append("Mandatory").append(",");
        sb.append("DataType_Kind").append(",");
        sb.append("Value_Type").append(",");
        sb.append("Formula").append(",");
        sb.append("ScopeEntityID").append(",");
        sb.append("Num_ScopeEntityID").append(",");
        sb.append("Domain_ID").append(",");
        sb.append("Num_Domain_ID").append(",");
        sb.append("Logical_Type_ID").append(",");
        sb.append("Num_Logical_Type_ID").append(",");
        sb.append("Distinct_Type_ID").append(",");
        sb.append("Num_Distinct_Type_ID").append(",");
        sb.append("Structured_Type_ID").append(",");
        sb.append("Num_Structured_Type_ID").append(",");
        sb.append("Collection_Type_ID").append(",");
        sb.append("Num_Collection_Type_ID").append(",");
        sb.append("Check_Constraint_Name").append(",");
        sb.append("Default_Value").append(",");
        sb.append("Use_Domain_Constraint").append(",");
        sb.append("Domain_Name").append(",");
        sb.append("Logical_Type_Name").append(",");
        sb.append("Structured_Type_Name").append(",");
        sb.append("Distinct_Type_Name").append(",");
        sb.append("Collection_Type_Name").append(",");
        sb.append("Synonyms").append(",");
        sb.append("Preferred_Abbreviation").append(",");
        sb.append("Relation_ID").append(",");
        sb.append("Num_Relation_ID").append(",");
        sb.append("Entity_Name").append(",");
        sb.append("PK_Flag").append(",");
        sb.append("FK_Flag").append(",");
        sb.append("Relation_Name").append(",");
        sb.append("Sequence").append(",");
        sb.append("T_Size").append(",");
        sb.append("T_Precision").append(",");
        sb.append("T_Scale").append(",");
        sb.append("Data_Source");
        lines.add(sb.toString());
        LogicalDesign logDesign = this.getDesign().getLogicalDesign();
        if (this.getCsvExporter().isModelSelected(logDesign)) {
            Iterator it = logDesign.getAttributeSet().iterator();
            while (it.hasNext()) {
                Attribute attribute = (Attribute)it.next();
                if (attribute.getContainer() == null) continue;
                sb = new StringBuffer();
                sb.append(this.replaceAndQuoteString(attribute.getName())).append(",");
                sb.append(attribute.getObjectID()).append(",");
                sb.append(attribute.getNumID()).append(",");
                sb.append(attribute.getImportedId() != null ? attribute.getImportedId() : "").append(",");
                sb.append(attribute.getContainer().getObjectID()).append(",");
                sb.append(attribute.getContainer().getNumID()).append(",");
                sb.append(attribute.getNullsAllowed() ? "N" : "Y").append(",");
                switch (attribute.getUse()) {
                    case 0: {
                        sb.append("Domain").append(",");
                        break;
                    }
                    case 1: {
                        sb.append("Logical Type").append(",");
                        break;
                    }
                    case 2: {
                        sb.append("Distinct Type").append(",");
                        break;
                    }
                    case 3: {
                        if (attribute.isReference()) {
                            sb.append("Ref Struct Type").append(",");
                            break;
                        }
                        sb.append("Structured Type").append(",");
                        break;
                    }
                    case 4: {
                        sb.append("Collection Type").append(",");
                    }
                }
                sb.append(attribute.getSourceType()).append(",");
                sb.append(this.replaceAndQuoteString(attribute.getFormulaDesc())).append(",");
                if (attribute.getScope() != null) {
                    sb.append(attribute.getScope().getObjectID()).append(",");
                    sb.append(attribute.getScope().getNumID()).append(",");
                } else {
                    sb.append("").append(",");
                    sb.append("").append(",");
                }
                sb.append(attribute.getDomain().getObjectID()).append(",");
                sb.append(attribute.getDomain().getNumID()).append(",");
                sb.append(attribute.getLogicalDatatype().getObjectID()).append(",");
                sb.append(attribute.getLogicalDatatype().getNumID()).append(",");
                if (attribute.getDistinctType() != null) {
                    sb.append(attribute.getDistinctType().getObjectID()).append(",");
                    sb.append(attribute.getDistinctType().getNumID()).append(",");
                } else {
                    sb.append("").append(",");
                    sb.append("").append(",");
                }
                if (attribute.getStructuredType() != null) {
                    sb.append(attribute.getStructuredType().getObjectID()).append(",");
                    sb.append(attribute.getStructuredType().getNumID()).append(",");
                } else {
                    sb.append("").append(",");
                    sb.append("").append(",");
                }
                if (attribute.getCollectionType() != null) {
                    sb.append(attribute.getCollectionType().getObjectID()).append(",");
                    sb.append(attribute.getCollectionType().getNumID()).append(",");
                } else {
                    sb.append("").append(",");
                    sb.append("").append(",");
                }
                sb.append(attribute.getConstraintName()).append(",");
                sb.append(this.replaceAndQuoteString(attribute.getDefaultValue())).append(",");
                sb.append(attribute.getUseDomainConstraints() ? "Y" : "N").append(",");
                if (attribute.getUse() == 0) {
                    sb.append(this.replaceAndQuoteString(attribute.getDomain().getName())).append(",");
                    sb.append(attribute.getDomain().getLogicalDatatype().getName()).append(",");
                } else if (attribute.getUse() == 1) {
                    sb.append("").append(",");
                    sb.append(attribute.getLogicalDatatype().getName()).append(",");
                } else if (attribute.getUse() == 2) {
                    sb.append("").append(",");
                    sb.append(attribute.getDistinctType().getLogicalDataType().getName()).append(",");
                } else {
                    sb.append("").append(",");
                    sb.append("").append(",");
                }
                if (attribute.getStructuredType() != null) {
                    sb.append(this.replaceAndQuoteString(attribute.getStructuredType().getName())).append(",");
                } else {
                    sb.append("").append(",");
                }
                if (attribute.getDistinctType() != null) {
                    sb.append(this.replaceAndQuoteString(attribute.getDistinctType().getName())).append(",");
                } else {
                    sb.append("").append(",");
                }
                if (attribute.getCollectionType() != null) {
                    sb.append(this.replaceAndQuoteString(attribute.getCollectionType().getName())).append(",");
                } else {
                    sb.append("").append(",");
                }
                sb.append(this.quotedString(attribute.getSynonym())).append(",");
                sb.append(attribute.getPreferredAbbreviation()).append(",");
                if (attribute.isFKAttribute()) {
                    DesignObject gen = attribute.getGenerator();
                    sb.append(gen.getObjectID()).append(",");
                    sb.append(gen.getNumID()).append(",");
                } else {
                    sb.append("").append(",");
                    sb.append("").append(",");
                }
                sb.append(this.replaceAndQuoteString(attribute.getContainer().getName())).append(",");
                if (attribute.isPKElement()) {
                    sb.append("P").append(",");
                } else {
                    sb.append("").append(",");
                }
                if (attribute.isFKAttribute()) {
                    sb.append("F").append(",");
                } else {
                    sb.append("").append(",");
                }
                if (attribute.isFKAttribute()) {
                    sb.append(this.replaceAndQuoteString(attribute.getGenerator().getName())).append(",");
                } else {
                    sb.append("").append(",");
                }
                sb.append(attribute.getContainer().getIndexOf(attribute) + 1).append(",");
                if (attribute.getUse() == 0) {
                    sb.append(attribute.getDomain().getSize()).append(",");
                    sb.append(attribute.getDomain().getPrecision()).append(",");
                    sb.append(attribute.getDomain().getScale()).append(",");
                } else if (attribute.getUse() == 1) {
                    sb.append(attribute.getSize()).append(",");
                    sb.append(attribute.getPrecision()).append(",");
                    sb.append(attribute.getScale()).append(",");
                } else {
                    sb.append("").append(",");
                    sb.append("").append(",");
                    sb.append("").append(",");
                }
                sb.append(attribute.getSource()).append(",");
                lines.add(sb.toString());
                this.getCsvExporter().addNote(attribute.getObjectID(), attribute.getNumID(), "Attribute", attribute.getNotes());
                this.getCsvExporter().addComment(attribute.getObjectID(), attribute.getNumID(), "Attribute", attribute.getComment());
                this.getCsvExporter().addCommentRDBMS(attribute.getObjectID(), attribute.getNumID(), "Attribute", attribute.getCommentInRDBMS());
            }
        }
        this.saveToFile(lines);
    }

    @Override
    public String getFileName() {
        return "DM_Attributes.csv";
    }
}

