/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.uses;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.exports.classpath.ClassPathModel;
import oracle.javatools.exports.classpath.Member;
import oracle.javatools.exports.classpath.Package;
import oracle.javatools.exports.classpath.Type;
import oracle.javatools.exports.classpath.TypeKind;
import oracle.javatools.exports.command.CommandException;
import oracle.javatools.exports.file.NullBufferedWriter;
import oracle.javatools.exports.file.PathKey;
import oracle.javatools.exports.file.Paths;
import oracle.javatools.exports.message.Log;
import oracle.javatools.exports.message.Tag;
import oracle.javatools.exports.name.ElementKind;
import oracle.javatools.exports.name.IllegalNameException;
import oracle.javatools.exports.name.MemberName;
import oracle.javatools.exports.name.NameFormat;
import oracle.javatools.exports.name.NameSpace;
import oracle.javatools.exports.name.PackageName;
import oracle.javatools.exports.name.TypeName;
import oracle.javatools.exports.specification.ExportDomain;
import oracle.javatools.exports.uses.MemberUses;
import oracle.javatools.exports.uses.PackageUses;
import oracle.javatools.exports.uses.TypeUses;
import oracle.javatools.exports.uses.UsesModel;

public class UsesReaderWriter {
    public static void readUses(UsesModel model, Path path, NameSpace nameSpace, boolean failOnBadInput, Log log) throws CommandException {
        try {
            UsesReaderWriter.readUses(model, Paths.toUrl(path), Files.newInputStream(path, new OpenOption[0]), nameSpace, failOnBadInput, log.child(new Tag("scope", new PathKey(path))));
        }
        catch (IOException e) {
            throw new CommandException(e, "Uses file %s not read : %s", path, e);
        }
    }

    public static void readUses(UsesModel model, URL url, NameSpace nameSpace, boolean failOnBadInput, Log log) throws CommandException {
        try {
            UsesReaderWriter.readUses(model, url, URLFileSystem.openInputStream(url), nameSpace, failOnBadInput, log.child(new Tag("scope", url)));
        }
        catch (IOException e) {
            throw new CommandException(e, "Uses file %s not read : %s", URLFileSystem.getPlatformPathName(url), e);
        }
    }

    public static void readUses(UsesModel model, Object origin, InputStream stream, NameSpace nameSpace, boolean failOnBadInput, Log log) throws CommandException {
        int lineCount = 0;
        log.note("loading-uses", "loading client uses from %s", origin);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            String line = reader.readLine();
            while (line != null) {
                ++lineCount;
                if (!(line = line.trim()).isEmpty()) {
                    if (line.charAt(0) == '#') {
                        if (line.startsWith("# SOURCE ")) {
                            model.addSource(line.substring("# SOURCE ".length()).trim());
                        }
                    } else {
                        try {
                            String[] fields = line.split("\\s+");
                            switch (fields[0].toLowerCase()) {
                                case "type": {
                                    fields[0] = "class";
                                }
                                case "class": 
                                case "interface": {
                                    short concrete;
                                    short extensions;
                                    short references;
                                    TypeName typeName;
                                    UsesReaderWriter.validateMaximumIndex(fields, 3, lineCount, line);
                                    TypeKind typeKind = TypeKind.valueOfIgnoreCase(fields[0]);
                                    try {
                                        if (!"has".equals(fields[2])) {
                                            throw new InvalidLineException("uses-invalid-line", "expected \"has\" in line %d: %s", lineCount, line);
                                        }
                                        UsesReaderWriter.validateMaximumIndex(fields, 5, lineCount, line);
                                        typeName = nameSpace.typeNameHybrid(fields[1]);
                                        references = UsesReaderWriter.toShort(fields[3]);
                                        extensions = UsesReaderWriter.toShort(fields[5].substring(1));
                                        concrete = fields.length >= 9 ? UsesReaderWriter.toShort(fields[7]) : (short)0;
                                    }
                                    catch (IllegalNameException e) {
                                        throw new InvalidLineException("uses-malformed-name", "malformed %s name at line %d: %s", typeKind.toLowerCase(), lineCount, line);
                                    }
                                    catch (NumberFormatException e) {
                                        throw new InvalidLineException("uses-malformed-count", "malformed count at line %d: %s", lineCount, line);
                                    }
                                    model.addReferences(typeName, typeKind, references, extensions, concrete);
                                    break;
                                }
                                case "constructor": 
                                case "method": 
                                case "field": {
                                    UsesReaderWriter.validateMaximumIndex(fields, 4, lineCount, line);
                                    ElementKind memberKind = ElementKind.valueOfIgnoreCase(fields[0]);
                                    if (!"has".equals(fields[2])) {
                                        throw new InvalidLineException("uses-invalid-line", "expected \"has\" in line %d: %s", lineCount, line);
                                    }
                                    try {
                                        MemberName memberName;
                                        TypeKind typeKind = switch (memberKind) {
                                            case ElementKind.CONSTRUCTOR -> {
                                                memberName = nameSpace.constructorNameHybrid(fields[1]);
                                                yield TypeKind.CLASS;
                                            }
                                            case ElementKind.METHOD -> {
                                                UsesReaderWriter.validateMaximumIndex(fields, 5, lineCount, line);
                                                memberName = nameSpace.methodNameHybrid(fields[1]);
                                                yield TypeKind.valueOfIgnoreCase(fields[5].substring(1, fields[5].length() - 1));
                                            }
                                            case ElementKind.FIELD -> {
                                                UsesReaderWriter.validateMaximumIndex(fields, 5, lineCount, line);
                                                memberName = nameSpace.fieldNameHybrid(fields[1]);
                                                yield TypeKind.valueOfIgnoreCase(fields[5].substring(1, fields[5].length() - 1));
                                            }
                                            default -> throw new IllegalStateException("unexpected member kind " + memberKind);
                                        };
                                        short references = UsesReaderWriter.toShort(fields[3]);
                                        model.addReferences(memberName, typeKind, references, (short)0, (short)0);
                                        break;
                                    }
                                    catch (IllegalNameException e) {
                                        throw new InvalidLineException("uses-malformed-name", "malformed %s name at line %d: %s", memberKind.toLowerCase(), lineCount, line);
                                    }
                                    catch (NumberFormatException e) {
                                        throw new InvalidLineException("uses-malformed-count", "malformed count at line %d: %s", lineCount, line);
                                    }
                                    catch (IllegalArgumentException e) {
                                        throw new InvalidLineException("uses-unexpected-kind", "unexpected type kind \"%s\" at line %d: %s", fields[5], lineCount, line);
                                    }
                                }
                                case "library": {
                                    UsesReaderWriter.validateMaximumIndex(fields, 6, lineCount, line);
                                    int nameBegin = "library ".length();
                                    int nameEnd = line.lastIndexOf(" at ");
                                    if (nameEnd < 0) {
                                        throw new InvalidLineException("uses-invalid-line", "expected \" at \" in line %d: %s", lineCount, line);
                                    }
                                    try {
                                        if (nameEnd - nameBegin >= 3 && line.charAt(nameBegin) == '\"' && line.charAt(nameEnd - 1) == '\"') {
                                            ++nameBegin;
                                            --nameEnd;
                                        }
                                        String name = line.substring(nameBegin, nameEnd);
                                        String path = fields[fields.length - 4];
                                        short references = UsesReaderWriter.toShort(fields[fields.length - 2]);
                                        model.addReferences(name, path, references);
                                        break;
                                    }
                                    catch (NumberFormatException e) {
                                        throw new InvalidLineException("uses-malformed-count", "malformed count at line %d: %s", lineCount, line);
                                    }
                                }
                                default: {
                                    throw new InvalidLineException("uses-unrecognized-line", "unrecognized line at line %d: %s", lineCount, line);
                                }
                            }
                        }
                        catch (InvalidLineException e) {
                            if (failOnBadInput) {
                                throw e;
                            }
                            log.warning(e.getId(), e.getMessage(), new Object[0]);
                        }
                    }
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new CommandException(e, "Uses file %s not read after line %d: %s", origin, lineCount, e);
        }
    }

    private static void validateMaximumIndex(String[] fields, int limit, int lineCount, String line) throws InvalidLineException {
        if (fields.length <= limit) {
            throw new InvalidLineException("uses-incomplete-input", "incomplete input at line %d: %s", lineCount, line);
        }
    }

    private static short toShort(String field) {
        int i = Integer.parseInt(field);
        int references = i < Short.MAX_VALUE ? (int)i : Short.MAX_VALUE;
        return (short)references;
    }

    public static void writeUsedFiles(UsesModel uses, ClassPathModel model, ExportDomain domain, Map<String, String> comments, Path usedConcealed, Path unusedExported, Path annotated, Path unannotated, Path migrated, Path missing, Log log) throws CommandException {
        int usedConcealedTypes = 0;
        int usedCommentedTypes = 0;
        int usedConcealedMembers = 0;
        int usedCommentedMembers = 0;
        try (BufferedWriter usedConcealedWriter = NullBufferedWriter.writerOrNullWriter(usedConcealed, Charset.defaultCharset(), new OpenOption[0]);
             BufferedWriter unusedExportedWriter = NullBufferedWriter.writerOrNullWriter(unusedExported, Charset.defaultCharset(), new OpenOption[0]);
             BufferedWriter annotatedWriter = NullBufferedWriter.writerOrNullWriter(annotated, Charset.defaultCharset(), new OpenOption[0]);
             BufferedWriter unannotatedWriter = NullBufferedWriter.writerOrNullWriter(unannotated, Charset.defaultCharset(), new OpenOption[0]);
             BufferedWriter migratedWriter = NullBufferedWriter.writerOrNullWriter(migrated, Charset.defaultCharset(), new OpenOption[0]);
             BufferedWriter missingWriter = NullBufferedWriter.writerOrNullWriter(missing, Charset.defaultCharset(), new OpenOption[0]);){
            for (Package packag : model.getControlledPackages()) {
                Object subdomain;
                String string = packag.getQualifiedSourceName();
                String packageComment = comments.get(string);
                if (packageComment == null && (subdomain = domain.getSubdomain(string)) != null) {
                    String name = ((ExportDomain.Subdomain)subdomain).getName();
                    packageComment = comments.get(name.substring(0, name.length() - 1));
                }
                subdomain = packag.getDeclaredTypes().iterator();
                while (subdomain.hasNext()) {
                    boolean typeInternal;
                    Type type = (Type)subdomain.next();
                    if (!type.isControlled()) continue;
                    TypeUses typeUses = uses.getTypeUses(type.getName());
                    short typeReferences = 0;
                    short typeExtensions = 0;
                    short typeConcrete = 0;
                    short typeWorkspaces = 0;
                    boolean typeUsed = false;
                    if (typeUses != null) {
                        typeReferences = typeUses.getReferences();
                        typeExtensions = typeUses.getExtensions();
                        typeConcrete = typeUses.getConcrete();
                        typeWorkspaces = typeUses.getWorkspaces();
                        typeUsed = typeReferences + typeExtensions > 0;
                    }
                    boolean bl = typeInternal = !type.isExportedOrRestricted();
                    if (typeInternal == typeUsed) {
                        BufferedWriter writer = typeInternal ? usedConcealedWriter : unusedExportedWriter;
                        writer.write(type.getKind().toUpperCase());
                        writer.write(32);
                        type.getName().writeQualifiedSourceName(writer);
                        if (typeUsed) {
                            writer.write(", ");
                            writer.write(Short.toString(typeReferences));
                            writer.write(typeReferences != 1 ? " references, " : " reference, ");
                            if (typeExtensions >= 0) {
                                writer.write(Short.toString(typeExtensions));
                                writer.write(typeExtensions != 1 ? " extensions (" : " extension (");
                                writer.write(typeConcrete);
                                writer.write(" concrete), ");
                            }
                            writer.write(Short.toString(typeWorkspaces));
                            writer.write(typeWorkspaces != 1 ? " workspaces" : " workspace");
                        }
                        writer.newLine();
                    }
                    String typeComment = comments.get(type.getQualifiedSourceName());
                    Type outerType = type.getOuterType();
                    while (typeComment == null) {
                        if (outerType == null) {
                            typeComment = packageComment;
                            break;
                        }
                        typeComment = comments.get(outerType.getQualifiedSourceName());
                        outerType = outerType.getOuterType();
                    }
                    if (typeInternal && typeUsed) {
                        ++usedConcealedTypes;
                        if (typeComment != null) {
                            ++usedCommentedTypes;
                        }
                        BufferedWriter writer = typeComment != null ? annotatedWriter : unannotatedWriter;
                        writer.write(type.getKind().toUpperCase());
                        writer.write(32);
                        type.getName().writeQualifiedSourceName(writer);
                        writer.write(", ");
                        writer.write(Short.toString(typeReferences));
                        writer.write(typeReferences != 1 ? " references, " : " reference, ");
                        if (typeExtensions >= 0) {
                            writer.write(Short.toString(typeExtensions));
                            writer.write(typeExtensions != 1 ? " extensions, " : " extension, ");
                        }
                        writer.write(Short.toString(typeWorkspaces));
                        writer.write(typeWorkspaces != 1 ? " workspaces" : " workspace");
                        writer.newLine();
                    }
                    for (Member<?> member : type.getDeclaredMembers()) {
                        String memberComment;
                        MemberUses memberUses = typeUses != null ? typeUses.getMemberUses(member.getName()) : null;
                        boolean memberInternal = !member.isExportedOrRestricted();
                        if (memberInternal == (memberUses != null)) {
                            BufferedWriter writer = memberInternal ? usedConcealedWriter : unusedExportedWriter;
                            writer.write(member.getKind().toUpperCase());
                            writer.write(32);
                            member.getResolvedName().writeQualifiedSourceName(writer);
                            if (memberUses != null) {
                                writer.write(", ");
                                short references = memberUses.getReferences();
                                short workspaces = memberUses.getWorkspaces();
                                writer.write(Short.toString(references));
                                writer.write(references != 1 ? " references, " : " reference, ");
                                writer.write(Short.toString(workspaces));
                                writer.write(workspaces != 1 ? " workspaces" : " workspace");
                            }
                            writer.newLine();
                        }
                        if ((memberComment = comments.get(member.getQualifiedSourceName())) == null) {
                            memberComment = typeComment;
                        }
                        if (memberInternal && memberUses != null) {
                            ++usedConcealedMembers;
                            if (memberComment != null) {
                                ++usedCommentedMembers;
                            }
                            BufferedWriter writer = memberComment != null ? annotatedWriter : unannotatedWriter;
                            writer.write(member.getClass().getSimpleName().toUpperCase());
                            writer.write(32);
                            member.getResolvedName().writeQualifiedSourceName(writer);
                            if (memberUses != null) {
                                writer.write(", ");
                                short references = memberUses.getReferences();
                                short workspaces = memberUses.getWorkspaces();
                                writer.write(Short.toString(references));
                                writer.write(references != 1 ? " references, " : " reference, ");
                                writer.write(Short.toString(workspaces));
                                writer.write(workspaces != 1 ? " workspaces" : " workspace");
                            }
                            writer.newLine();
                        }
                        if (memberUses == null) continue;
                        for (TypeName forwardedFrom : memberUses.getMigratedFrom()) {
                            forwardedFrom.writeQualifiedHybridName(migratedWriter);
                            migratedWriter.write(47);
                            member.getResolvedName().writeHybridName(migratedWriter);
                            migratedWriter.write(32);
                            type.getName().writeQualifiedHybridName(migratedWriter);
                            migratedWriter.newLine();
                        }
                    }
                }
            }
            if (missing != null) {
                ArrayList<PackageName> packageNames = new ArrayList<PackageName>(uses.getPackageNames());
                Collections.sort(packageNames);
                for (PackageName packageName : packageNames) {
                    boolean controlled = domain.dominates(packageName);
                    PackageUses packageUses = uses.getPackageUses(packageName);
                    ArrayList<TypeName> typeNames = new ArrayList<TypeName>(packageUses.getTypeNames());
                    Collections.sort(typeNames);
                    for (TypeName typeName : typeNames) {
                        TypeUses typeUses = packageUses.getTypeUses(typeName);
                        if (!typeUses.isModelled()) {
                            int memberCount = typeUses.getMemberNames().size();
                            missingWriter.write(typeUses.getKind().toUpperCase());
                            missingWriter.write(32);
                            typeName.writeQualifiedSourceName(missingWriter);
                            missingWriter.write(" (");
                            missingWriter.write(Integer.toString(memberCount));
                            missingWriter.write(" used member");
                            if (memberCount != 1) {
                                missingWriter.write(115);
                            }
                            missingWriter.write(41);
                            if (!controlled) {
                                missingWriter.write(" uncontrolled");
                            }
                            missingWriter.newLine();
                            continue;
                        }
                        ArrayList<MemberName> memberNames = new ArrayList<MemberName>(typeUses.getMemberNames());
                        Collections.sort(memberNames);
                        for (MemberName memberName : memberNames) {
                            MemberUses memberUses = typeUses.getMemberUses(memberName);
                            if (memberUses.isModelled()) continue;
                            missingWriter.write(memberUses.getKind().toUpperCase());
                            missingWriter.write(32);
                            memberName.writeQualifiedSourceName(missingWriter);
                            if (!controlled) {
                                missingWriter.write(" uncontrolled");
                            }
                            if (memberUses.getMigratedTo() != null) {
                                missingWriter.write(" migrated to ");
                                memberUses.getMigratedTo().writeQualifiedSourceName(missingWriter);
                            }
                            missingWriter.newLine();
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            throw new CommandException(e, "Uses file %s or %s not created: %s", usedConcealed, unusedExported, e);
        }
        log.note("uses-comments-count", "comments found for %d of %d used concealed types, %d of %d used concealed members", usedCommentedTypes, usedConcealedTypes, usedCommentedMembers, usedConcealedMembers);
        int uncommentedTypes = usedConcealedTypes - usedCommentedTypes;
        int uncommentedMembers = usedConcealedMembers - usedCommentedMembers;
        if (uncommentedTypes > 0) {
            log.warning("uses-comment-types", "no remediation comment found for %d (of %d) used concealed types", uncommentedTypes, usedConcealedTypes);
        }
        if (uncommentedMembers > 0) {
            log.warning("uses-comments-members", "no remediation comment found for %d (of %d) used concealed members", uncommentedMembers, usedConcealedMembers);
        }
    }

    public static void writeSignatureFile(UsesModel uses, NameFormat format, Path listFile) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(listFile, new OpenOption[0]);){
            UsesReaderWriter.writeSignatureFile(uses, format, writer);
        }
    }

    private static void writeSignatureFile(UsesModel uses, NameFormat format, BufferedWriter writer) throws IOException {
        ArrayList<PackageName> packageNames = new ArrayList<PackageName>(uses.getPackageNames());
        Collections.sort(packageNames);
        for (PackageName packageName : packageNames) {
            PackageUses packageUses = uses.getPackageUses(packageName);
            ArrayList<TypeName> typeNames = new ArrayList<TypeName>(packageUses.getTypeNames());
            Collections.sort(typeNames);
            for (TypeName typeName : typeNames) {
                TypeUses typeUses = packageUses.getTypeUses(typeName);
                typeName.writeQualifiedName(writer, format);
                writer.newLine();
                ArrayList<MemberName> memberNames = new ArrayList<MemberName>(typeUses.getMemberNames());
                Collections.sort(memberNames);
                for (MemberName memberName : memberNames) {
                    memberName.writeQualifiedName(writer, format);
                    writer.newLine();
                }
            }
        }
    }

    public static class InvalidLineException
    extends IOException {
        private final String id;

        public InvalidLineException(String id, String format, Object ... parameters) {
            super(String.format(format, parameters));
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

