/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.name;

import java.io.IOException;
import java.io.Writer;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import oracle.javatools.exports.common.Arrays;
import oracle.javatools.exports.name.ArrayTypeName;
import oracle.javatools.exports.name.ElementKind;
import oracle.javatools.exports.name.ElementName;
import oracle.javatools.exports.name.MemberName;
import oracle.javatools.exports.name.NameFormat;
import oracle.javatools.exports.name.PackageName;
import oracle.javatools.exports.name.TypeOrMemberName;
import oracle.javatools.util.NullArgumentException;

public class TypeName
extends TypeOrMemberName {
    public static final TypeName JAVA_LANG_CLONEABLE = new TypeName(PackageName.JAVA_LANG, NameFormat.HYBRID, "Cloneable");
    public static final TypeName JAVA_LANG_OBJECT = new TypeName(PackageName.JAVA_LANG, NameFormat.HYBRID, "Object");
    public static final TypeName JAVA_LANG_STRING = new TypeName(PackageName.JAVA_LANG, NameFormat.HYBRID, "String");
    public static final TypeName JAVA_IO_SERIALIZABLE = new TypeName(PackageName.JAVA_IO, NameFormat.HYBRID, "Serializable");
    public static final TypeName JAVA_LANG_OBJECT_ARRAY = new ArrayTypeName(JAVA_LANG_OBJECT, "Object[]");
    public static final TypeName JAVA_LANG_STRING_ARRAY = new ArrayTypeName(JAVA_LANG_STRING, "String[]");
    public static final TypeName BOOLEAN = new TypeName(PackageName.DEFAULT_PACKAGE, NameFormat.HYBRID, "boolean");
    public static final TypeName BYTE = new TypeName(PackageName.DEFAULT_PACKAGE, NameFormat.HYBRID, "byte");
    public static final TypeName CHAR = new TypeName(PackageName.DEFAULT_PACKAGE, NameFormat.HYBRID, "char");
    public static final TypeName DOUBLE = new TypeName(PackageName.DEFAULT_PACKAGE, NameFormat.HYBRID, "double");
    public static final TypeName FLOAT = new TypeName(PackageName.DEFAULT_PACKAGE, NameFormat.HYBRID, "float");
    public static final TypeName INT = new TypeName(PackageName.DEFAULT_PACKAGE, NameFormat.HYBRID, "int");
    public static final TypeName LONG = new TypeName(PackageName.DEFAULT_PACKAGE, NameFormat.HYBRID, "long");
    public static final TypeName SHORT = new TypeName(PackageName.DEFAULT_PACKAGE, NameFormat.HYBRID, "short");
    public static final Set<TypeName> PRIMITIVES = new HashSet<TypeName>(Arrays.asList(BOOLEAN, BYTE, CHAR, DOUBLE, FLOAT, INT, LONG, SHORT));
    public static final TypeName[] EMPTY_ARRAY = new TypeName[0];
    public static final Comparator<TypeName> COMPARATOR = Comparator.naturalOrder();
    public static final Comparator<TypeName> UNQUALIFIED_COMPARATOR = TypeName::compareToUnqualified;
    public static final TypeName VOID = new TypeName(PackageName.DEFAULT_PACKAGE, NameFormat.HYBRID, "void");
    static final TypeName[] INITIAL_TYPES = new TypeName[]{BOOLEAN, BYTE, CHAR, DOUBLE, FLOAT, INT, LONG, SHORT, VOID, JAVA_LANG_OBJECT, JAVA_LANG_OBJECT_ARRAY, JAVA_LANG_CLONEABLE, JAVA_LANG_STRING, JAVA_LANG_STRING_ARRAY, JAVA_IO_SERIALIZABLE};
    private final PackageName packageName;
    private final String name;
    private final NameFormat format;
    private int hash;

    TypeName(PackageName packageName, NameFormat format, String name) {
        assert (name.indexOf(47) < 0) : packageName.getHybridName() + "/" + name;
        assert (name.indexOf(91) < 0 || this.isArray()) : packageName.getQualifiedHybridName() + "/" + name;
        if (packageName == null) {
            throw new NullArgumentException();
        }
        this.packageName = packageName;
        this.format = format;
        this.name = name;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.TYPE;
    }

    @Override
    public int getLevel() {
        return 1;
    }

    @Override
    public ElementName getParent() {
        return this.packageName;
    }

    @Override
    public PackageName getPackage() {
        return this.packageName;
    }

    @Override
    public String getSimpleName() {
        return this.name.substring(this.name.lastIndexOf(46) + 1);
    }

    @Override
    public String getSourceName() {
        return this.getName(NameFormat.SOURCE.getTypeSeparator());
    }

    @Override
    public String getQualifiedSourceName() {
        return this.isPrimitiveOrVoid() ? this.name : this.appendQualifiedSourceName(new StringBuilder(this.getQualifiedNameLength())).toString();
    }

    @Override
    public StringBuilder appendQualifiedSourceName(StringBuilder builder) {
        this.packageName.appendQualifiedSourceNamePrefix(builder);
        return this.appendName(builder, NameFormat.SOURCE.getTypeSeparator());
    }

    StringBuilder appendQualifiedSourceNamePrefix(StringBuilder builder) {
        return this.appendQualifiedSourceName(builder).append(NameFormat.SOURCE.getTypeSeparator());
    }

    @Override
    public void writeSourceName(Writer writer) throws IOException {
        this.writeName(writer, NameFormat.SOURCE.getTypeSeparator());
    }

    @Override
    public void writeQualifiedSourceName(Writer writer) throws IOException {
        this.packageName.writeQualifiedSourceNamePrefix(writer);
        this.writeSourceName(writer);
    }

    @Override
    public String getBinaryName() {
        return this.getName(NameFormat.BINARY.getTypeSeparator());
    }

    @Override
    public void writeBinaryName(Writer writer) throws IOException {
        this.writeName(writer, NameFormat.BINARY.getTypeSeparator());
    }

    @Override
    public String getQualifiedBinaryName() {
        return this.isPrimitiveOrVoid() ? this.name : this.appendQualifiedBinaryName(new StringBuilder(this.getQualifiedNameLength())).toString();
    }

    @Override
    public StringBuilder appendQualifiedBinaryName(StringBuilder builder) {
        this.packageName.appendQualifiedBinaryNamePrefix(builder);
        return this.appendName(builder, NameFormat.BINARY.getTypeSeparator());
    }

    StringBuilder appendQualifiedBinaryNamePrefix(StringBuilder builder) {
        return this.appendQualifiedBinaryName(builder).append(NameFormat.BINARY.getLevelSeparator());
    }

    @Override
    public void writeQualifiedBinaryName(Writer writer) throws IOException {
        this.packageName.writeQualifiedBinaryNamePrefix(writer);
        this.writeBinaryName(writer);
    }

    @Override
    public String getHybridName() {
        return this.getName(NameFormat.HYBRID.getTypeSeparator());
    }

    @Override
    public void writeHybridName(Writer writer) throws IOException {
        this.writeName(writer, NameFormat.HYBRID.getTypeSeparator());
    }

    @Override
    public String getQualifiedHybridName() {
        return this.isPrimitiveOrVoid() ? this.name : this.appendQualifiedHybridName(new StringBuilder(this.getQualifiedHybridNameLength())).toString();
    }

    public int getQualifiedHybridNameLength() {
        return this.isPrimitiveOrVoid() ? this.getNameLength() : this.packageName.getQualifiedHybridNamePrefixLength() + this.getNameLength();
    }

    public int getQualifiedHybridNamePrefixLength() {
        return this.getQualifiedHybridNameLength() + 1;
    }

    @Override
    public StringBuilder appendQualifiedHybridName(StringBuilder builder) {
        if (!this.isPrimitiveOrVoid()) {
            this.packageName.appendQualifiedHybridNamePrefix(builder);
        }
        return this.appendName(builder, NameFormat.HYBRID.getTypeSeparator());
    }

    StringBuilder appendQualifiedHybridNamePrefix(StringBuilder builder) {
        return this.appendQualifiedHybridName(builder).append(NameFormat.HYBRID.getLevelSeparator());
    }

    @Override
    public void writeQualifiedHybridName(Writer writer) throws IOException {
        if (!this.isPrimitiveOrVoid()) {
            this.packageName.writeQualifiedHybridNamePrefix(writer);
        }
        this.writeHybridName(writer);
    }

    @Override
    public TypeName getType() {
        return this;
    }

    @Override
    public boolean isType() {
        return true;
    }

    @Override
    public boolean isMember() {
        return false;
    }

    public NameFormat getFormat() {
        return this.format;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isInner() {
        return false;
    }

    public boolean isPrimitive() {
        return PRIMITIVES.contains(this);
    }

    public boolean isPrimitiveOrString() {
        return this.equals(JAVA_LANG_STRING) || PRIMITIVES.contains(this);
    }

    public boolean isPrimitiveOrVoid() {
        return this.equals(VOID) || PRIMITIVES.contains(this);
    }

    public TypeName getComponentType() {
        return null;
    }

    public TypeName getOuterType() {
        return null;
    }

    public int getNameLength() {
        return this.name.length();
    }

    String getName(char separator) {
        char formatSeparator = this.format.getTypeSeparator();
        return separator == formatSeparator ? this.name : this.name.replace(formatSeparator, separator);
    }

    StringBuilder appendName(StringBuilder builder, char separator) {
        char formatSeparator = this.format.getTypeSeparator();
        if (separator == formatSeparator) {
            return builder.append(this.name);
        }
        int last = this.name.length() - 1;
        builder.append(this.name.charAt(0));
        for (int i = 1; i < last; ++i) {
            char c = this.name.charAt(i);
            builder.append(c == formatSeparator ? separator : c);
        }
        if (last > 0) {
            builder.append(this.name.charAt(last));
        }
        return builder;
    }

    void writeName(Writer writer, char separator) throws IOException {
        char formatSeparator = this.format.getTypeSeparator();
        if (separator == formatSeparator) {
            writer.write(this.name);
            return;
        }
        int last = this.name.length() - 1;
        writer.write(this.name.charAt(0));
        for (int i = 1; i < last; ++i) {
            char c = this.name.charAt(i);
            writer.write(c == formatSeparator ? separator : c);
        }
        if (last > 0) {
            writer.write(this.name.charAt(last));
        }
    }

    public int getQualifiedNameLength() {
        return this.packageName.getQualifiedNamePrefixLength() + this.getNameLength();
    }

    public int getQualifiedNamePrefixLength() {
        return this.getQualifiedNameLength() + 1;
    }

    public String getClassName() {
        StringBuilder builder = new StringBuilder(this.name.length() + 6);
        return this.appendName(builder, '$').append(".class").toString();
    }

    public String getQualifiedClassName(char separator) {
        StringBuilder builder = new StringBuilder(this.packageName.getQualifiedNamePrefixLength() + this.name.length() + 6);
        this.packageName.appendDirectory(builder, separator);
        return this.appendName(builder, '$').append(".class").toString();
    }

    public void writeQualifiedClassName(Writer writer, char separator) throws IOException {
        this.packageName.writeDirectory(writer, separator);
        this.writeName(writer, '$');
        writer.write(".class");
    }

    public String getFamilyName() {
        int end = this.name.length();
        if (end < 4 || this.name.charAt(end - 3) != '_') {
            return null;
        }
        switch (this.name.substring(end - 2)) {
            case "ar": 
            case "ca": 
            case "cs": 
            case "da": 
            case "de": 
            case "el": 
            case "en": 
            case "es": 
            case "et": 
            case "fi": 
            case "fr": 
            case "he": 
            case "hr": 
            case "hu": 
            case "it": 
            case "iw": 
            case "ja": 
            case "ko": 
            case "lt": 
            case "lv": 
            case "nl": 
            case "no": 
            case "pl": 
            case "pt": 
            case "ro": 
            case "ru": 
            case "sk": 
            case "sv": 
            case "th": 
            case "tr": {
                return this.name.substring(0, this.name.length() - 3);
            }
            case "AU": 
            case "BR": 
            case "CA": 
            case "CN": 
            case "ES": 
            case "GB": 
            case "IE": 
            case "IN": 
            case "NZ": 
            case "TW": 
            case "US": 
            case "ZA": {
                if (end < 7 || this.name.charAt(end - 6) != '_') {
                    return null;
                }
                switch (this.name.substring(end - 5)) {
                    case "en_AU": 
                    case "en_CA": 
                    case "en_GB": 
                    case "en_IE": 
                    case "en_IN": 
                    case "en_NZ": 
                    case "en_ZA": 
                    case "en_US": 
                    case "es_ES": 
                    case "fr_CA": 
                    case "pt_BR": 
                    case "zh_CN": 
                    case "zh_TW": {
                        return this.name.substring(0, this.name.length() - 6);
                    }
                }
            }
        }
        return null;
    }

    public boolean matchesQualifiedBinaryName(String qualifiedBinaryName) {
        int head = this.packageName.getQualifiedNamePrefixLength();
        if (qualifiedBinaryName.length() != head + this.name.length()) {
            return false;
        }
        if (head > 0) {
            if (qualifiedBinaryName.charAt(head - 1) != '/') {
                return false;
            }
            if (!this.packageName.startsQualifiedName(qualifiedBinaryName)) {
                return false;
            }
        }
        int tail = this.name.length();
        for (int i = 0; i < tail; ++i) {
            char s;
            char k = this.name.charAt(i);
            if (k == (s = qualifiedBinaryName.charAt(head + i)) || k == '.' && s == '$') continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(ElementName that) {
        if (this == that) {
            return 0;
        }
        int comparison = this.getPackage().compareTo(that.getPackage());
        if (comparison != 0) {
            return comparison;
        }
        switch (that.getLevel()) {
            case 0: {
                return 1;
            }
            case 1: {
                return this.compareTo((TypeName)that);
            }
            case 2: {
                comparison = this.compareTo(((MemberName)that).getType());
                if (comparison != 0) {
                    return comparison;
                }
                return -1;
            }
        }
        throw new IllegalStateException("illegal level " + that.getLevel() + " in " + that);
    }

    @Override
    public int compareTo(TypeName that) {
        if (this == that) {
            return 0;
        }
        NameFormat thisFormat = this.format;
        NameFormat thatFormat = that.format;
        if (thisFormat == thatFormat) {
            int comparison = this.getPackage().compareTo(that.getPackage());
            return comparison != 0 ? comparison : this.name.compareTo(that.name);
        }
        if (thisFormat == NameFormat.SOURCE) {
            return this.compareSource(this, that);
        }
        if (thatFormat == NameFormat.SOURCE) {
            return -this.compareSource(that, this);
        }
        int comparison = this.getPackage().compareTo(that.getPackage());
        return comparison != 0 ? comparison : this.compareToUnqualified(that);
    }

    private int compareSource(TypeName source, TypeName other) {
        String s1 = source.getPackage().getSourceName();
        String x1 = other.getPackage().getSourceName();
        String s2 = source.name;
        String x2 = other.name;
        int s1size = s1.length();
        int s2size = s2.length();
        int x1size = x1.length();
        int x2size = x2.length();
        char sf = '.';
        char xf = other.format.getTypeSeparator();
        if (s1size == x1size) {
            int comparison = s1.compareTo(x1);
            return comparison != 0 ? comparison : this.compare(s2, sf, x2, xf);
        }
        int x2mark = s1size - x1size - 1;
        int comparison = this.compareRegion(s1, 0, x1, 0, x1size);
        if (comparison != 0) {
            return comparison;
        }
        comparison = s1.charAt(x1size) - 46;
        if (comparison != 0) {
            return comparison;
        }
        comparison = this.compareRegion(s1, x1size + 1, sf, x2, 0, xf, x2mark);
        if (comparison != 0) {
            return comparison;
        }
        comparison = 46 - x2.charAt(x2mark);
        if (comparison != 0) {
            return comparison;
        }
        comparison = this.compareRegion(s2, 0, sf, x2, x2mark + 1, xf, s2size);
        return comparison != 0 ? comparison : s1size + s2size - x1size - x2size;
    }

    public int compareToUnqualified(TypeName that) {
        String s1 = this.name;
        String s2 = that.name;
        if (this.format == that.format) {
            return s1.compareTo(s2);
        }
        return this.compare(s1, this.format.getTypeSeparator(), s2, that.format.getTypeSeparator());
    }

    protected int compare(String s1, char f1, String s2, char f2) {
        int n1 = s1.length();
        int n2 = s2.length();
        int min = Math.min(n1, n2);
        for (int i = 0; i < min; ++i) {
            char c2;
            char c1 = s1.charAt(i);
            int comparison = c1 - (c2 = s2.charAt(i));
            if (comparison == 0 || c1 == f1 && c2 == f2) continue;
            return comparison;
        }
        return n1 - n2;
    }

    private int compareRegion(String r1, int i1, String r2, int i2, int length) {
        for (int i = 0; i < length; ++i) {
            int comparison = r1.charAt(i1 + i) - r2.charAt(i2 + i);
            if (comparison == 0) continue;
            return comparison;
        }
        return 0;
    }

    private int compareRegion(String r1, int i1, char f1, String r2, int i2, char f2, int length) {
        for (int i = 0; i < length; ++i) {
            char c2;
            char c1 = r1.charAt(i1 + i);
            int comparison = c1 - (c2 = r2.charAt(i2 + i));
            if (comparison == 0 || c1 == f1 && c2 == f2) continue;
            return comparison;
        }
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TypeName)) {
            return false;
        }
        TypeName that = (TypeName)object;
        NameFormat thisFormat = this.format;
        NameFormat thatFormat = that.format;
        if (thisFormat == thatFormat) {
            return this.getPackage().equals(that.getPackage()) && this.name.equals(that.name);
        }
        if (thisFormat == NameFormat.SOURCE) {
            return TypeName.equalsSource(this, that);
        }
        if (thatFormat == NameFormat.SOURCE) {
            return TypeName.equalsSource(that, this);
        }
        return this.getPackage().equals(that.getPackage()) && TypeName.matches(this.name, thisFormat.getTypeSeparator(), that.name, thatFormat.getTypeSeparator());
    }

    private static boolean equalsSource(TypeName source, TypeName other) {
        String s1 = source.getPackage().getSourceName();
        String x1 = other.getPackage().getSourceName();
        String s2 = source.name;
        String x2 = other.name;
        int s1size = s1.length();
        int s2size = s2.length();
        int x1size = x1.length();
        int x2size = x2.length();
        char sf = '.';
        char xf = other.format.getTypeSeparator();
        if (x1size >= s1size) {
            return x1.equals(s1) && TypeName.matches(s2, sf, x2, xf);
        }
        if (x1size + x2size != s1size + s2size) {
            return false;
        }
        if (s1.charAt(x1size) != '.') {
            return false;
        }
        int x2mark = s1size - x1size - 1;
        char c = x2.charAt(x2mark);
        if (c != '.' && c != xf) {
            return false;
        }
        if (!s1.regionMatches(0, x1, 0, x1size)) {
            return false;
        }
        if (!TypeName.regionMatches(s1, x1size + 1, sf, x2, 0, xf, x2mark)) {
            return false;
        }
        return TypeName.regionMatches(s2, 0, sf, x2, x2mark + 1, xf, s2size);
    }

    private static boolean matches(String s1, char f1, String s2, char f2) {
        int length = s1.length();
        if (length != s2.length()) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            char c2;
            char c1 = s1.charAt(i);
            if (c1 == (c2 = s2.charAt(i)) || c1 == f1 && c2 == f2) continue;
            return false;
        }
        return true;
    }

    private static boolean regionMatches(String r1, int i1, char f1, String r2, int i2, char f2, int length) {
        for (int i = 0; i < length; ++i) {
            char c2;
            char c1 = r1.charAt(i1 + i);
            if (c1 == (c2 = r2.charAt(i2 + i)) || c1 == f1 && c2 == f2) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = this.hash;
        if (h != 0) {
            return h;
        }
        h = 31 * this.getPackage().hashCode() + 36;
        int length = this.name.length();
        switch (this.format) {
            case BINARY: {
                for (int i = 0; i < length; ++i) {
                    h = 31 * h + this.name.charAt(i);
                }
                break;
            }
            default: {
                for (int i = 0; i < length; ++i) {
                    int c = this.name.charAt(i);
                    if (c == 46) {
                        c = 36;
                    }
                    h = 31 * h + c;
                }
            }
        }
        this.hash = h;
        return this.hash;
    }
}

