/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.classpath;

import java.util.ArrayDeque;
import java.util.Deque;
import oracle.javatools.exports.name.TypeName;

public class ClassPool {
    private Deque<byte[]>[] classFileBufferPool = new Deque[32];
    private int[] classFileBuffersAcquired = new int[32];
    private int[] classFileBuffersReleased = new int[32];
    private int classFileTotalBufferCount;
    private int classFileTotalBufferSize;
    private int classFileMaxSize;
    private int classFileCount;
    private long classFileTotalSize;
    private Deque<TypeName[]> methodDescriptorBufferPool = new ArrayDeque<TypeName[]>(4);

    byte[] acquireClassFileBuffer(int size) {
        byte[] buffer;
        int power = 32 - Integer.numberOfLeadingZeros(size - 1);
        Deque<byte[]> bufferQueue = this.classFileBufferPool[power];
        if (bufferQueue == null) {
            this.classFileBufferPool[power] = new ArrayDeque<byte[]>(4);
            buffer = new byte[1 << power];
            ++this.classFileTotalBufferCount;
            this.classFileTotalBufferSize += buffer.length;
        } else if (bufferQueue.isEmpty()) {
            buffer = new byte[1 << power];
            ++this.classFileTotalBufferCount;
            this.classFileTotalBufferSize += buffer.length;
        } else {
            buffer = bufferQueue.pop();
        }
        int n = power;
        this.classFileBuffersAcquired[n] = this.classFileBuffersAcquired[n] + 1;
        if (size > this.classFileMaxSize) {
            this.classFileMaxSize = size;
        }
        this.classFileTotalSize += (long)size;
        ++this.classFileCount;
        return buffer;
    }

    void releaseClassFileBuffer(byte[] buffer) {
        if (buffer == null) {
            return;
        }
        int power = 32 - Integer.numberOfLeadingZeros(buffer.length - 1);
        Deque<byte[]> bufferQueue = this.classFileBufferPool[power];
        if (bufferQueue == null) {
            throw new IllegalStateException("null queue for released buffer");
        }
        bufferQueue.push(buffer);
        int n = power;
        this.classFileBuffersReleased[n] = this.classFileBuffersReleased[n] + 1;
    }

    public int getClassFileCount() {
        return this.classFileCount;
    }

    public long getClassFileTotalSize() {
        return this.classFileTotalSize;
    }

    public int getClassFileMaxSize() {
        return this.classFileMaxSize;
    }

    public long getClassFileAverageSize() {
        return this.classFileCount > 0 ? this.classFileTotalSize / (long)this.classFileCount : 0L;
    }

    TypeName[] acquireMethodDescriptorBuffer() {
        return this.methodDescriptorBufferPool.isEmpty() ? new TypeName[256] : this.methodDescriptorBufferPool.pop();
    }

    void releaseMethodDescriptorBuffer(TypeName[] buffer) {
        if (buffer == null) {
            return;
        }
        if (buffer.length != 256) {
            throw new IllegalStateException("unexpected buffer length " + buffer.length);
        }
        this.methodDescriptorBufferPool.push(buffer);
    }

    public Object summary() {
        return new Object(){
            private static final String SPACES = "                 ";

            public String toString() {
                StringBuilder builder = new StringBuilder();
                builder.append("Created ").append(ClassPool.this.classFileTotalBufferCount);
                builder.append(" buffers consuming ").append(ClassPool.this.classFileTotalBufferSize).append(" bytes");
                int sizeColumnWidth = String.valueOf(1 << 32 - Integer.numberOfLeadingZeros(ClassPool.this.classFileMaxSize - 1)).length();
                for (int i = 0; i < 32; ++i) {
                    Deque<byte[]> queue = ClassPool.this.classFileBufferPool[i];
                    if (queue == null) continue;
                    builder.append('\n');
                    this.append(builder, 1 << i, sizeColumnWidth, null).append(": ");
                    this.append(builder, queue.size(), 2, " buffer");
                    this.append(builder, ClassPool.this.classFileBuffersAcquired[i], 7, " take");
                    int lost = ClassPool.this.classFileBuffersAcquired[i] - ClassPool.this.classFileBuffersReleased[i];
                    if (lost <= 0) continue;
                    builder.append(" (").append(lost).append(" lost)");
                }
                return builder.toString();
            }

            StringBuilder append(StringBuilder builder, int n, int width, String stem) {
                String image = String.valueOf(n);
                builder.append(SPACES, 0, Math.min(width, SPACES.length()) - Math.min(image.length(), width));
                builder.append(image);
                if (stem != null) {
                    builder.append(stem).append(n != 1 ? (char)'s' : ' ');
                }
                return builder;
            }
        };
    }
}

