/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install.wizard;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.common.util.Passwords;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.install.InstallDBUtils;
import oracle.dbtools.rest.install.InstallUtils;
import oracle.dbtools.rest.install.RestInstallConstants;
import oracle.dbtools.rest.install.RestVersionObject;
import oracle.ide.controls.WaitCursor;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;

public class InstallWizCDBTablespacesPanel
extends DefaultTraversablePanel {
    private static final String FILTER_CDB_ROOT_TBS_SQL = "select a.name from v$tablespace a where (a.con_id=1) and a.name in (select y.name from  v$containers x, v$tablespace y  where (x.con_id != 1) and (y.name in (select t.name from v$tablespace t where t.con_id=1)) and (x.con_id = y.con_id)) order by 1";
    private static final String ALL_PDB_TBS_SQL = "select x.name, y.name from  v$containers x, v$tablespace y where (x.con_id != 1) and y.name in (select t.name from v$tablespace t where t.con_id=1) and (x.con_id = y.con_id) order by 1, 2";
    private static final String FILTER_PDBS_TBS_SQL = "select x.name, y.name from  v$containers x, v$tablespace y where (x.con_id in (##REPLACE##)) and y.name in (select t.name from v$tablespace t where t.con_id=1) and (x.con_id = y.con_id) order by 1, 2";
    private Logger logger = Logger.getLogger(InstallWizCDBTablespacesPanel.class.getName());
    private JComboBox<String> m_defTblSpace1 = new JComboBox();
    private JComboBox<String> m_tmpTblSpace1 = new JComboBox();
    private JComboBox<String> m_defTblSpace2 = new JComboBox();
    private JComboBox<String> m_tmpTblSpace2 = new JComboBox();
    private RestInstallConstants.InstallType m_installType;
    private String m_installer;
    private String m_prevConnInfo = "";
    private String m_PdbTablespaceQuery;
    private String m_defValue_defTbs1 = "SYSAUX";
    private String m_defValue_tmpTbs1 = "TEMP";
    private String m_defValue_defTbs2 = "SYSAUX";
    private String m_defValue_tmpTbs2 = "TEMP";
    private boolean m_canMigrateAPEXRest;
    private boolean m_init;

    public InstallWizCDBTablespacesPanel() {
        this.buildPanel();
    }

    private void buildPanel() {
        this.setLayout(new GridBagLayout());
        this.m_defTblSpace1.setModel(new DefaultComboBoxModel<String>(new String[]{this.m_defValue_defTbs1}));
        this.m_tmpTblSpace1.setModel(new DefaultComboBoxModel<String>(new String[]{this.m_defValue_tmpTbs1}));
        this.m_defTblSpace2.setModel(new DefaultComboBoxModel<String>(new String[]{this.m_defValue_defTbs2}));
        this.m_tmpTblSpace2.setModel(new DefaultComboBoxModel<String>(new String[]{this.m_defValue_tmpTbs2}));
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, this.m_defTblSpace1, (String)RestArb.getString("DEFAULT_TABLESPACE"));
        ResourceUtils.resLabel((JLabel)jLabel2, this.m_tmpTblSpace1, (String)RestArb.getString("TEMP_TABLESPACE"));
        ResourceUtils.resLabel((JLabel)jLabel3, this.m_defTblSpace2, (String)RestArb.getString("DEFAULT_TABLESPACE"));
        ResourceUtils.resLabel((JLabel)jLabel4, this.m_tmpTblSpace2, (String)RestArb.getString("TEMP_TABLESPACE"));
        JTextPane jTextPane = new JTextPane();
        jTextPane.setText(RestArb.getString("WIZ_NOT_EXIST_SCHEMA_DESCRIP"));
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        Font font = jTextPane.getFont();
        jTextPane.setFont(font.deriveFont(font.getStyle() | 1, font.getSize()));
        JTextPane jTextPane2 = new JTextPane();
        jTextPane2.setText(RestArb.getString("WIZ_CREATE_SCHEMA_DESCRIP"));
        jTextPane2.setEditable(false);
        jTextPane2.setOpaque(false);
        jTextPane2.setRequestFocusEnabled(false);
        jTextPane2.setFocusable(false);
        JTextPane jTextPane3 = new JTextPane();
        jTextPane3.setText(RestArb.format("WIZ_SELECT_TBS", RestArb.getString("WIZ_TBS_METADATA")));
        jTextPane3.setEditable(false);
        jTextPane3.setOpaque(false);
        jTextPane3.setRequestFocusEnabled(false);
        jTextPane3.setFocusable(false);
        int n = 0;
        JPanel jPanel = LayoutControl.GBC.createPanel();
        jPanel.add((Component)jTextPane3, LayoutControl.GBC.gbc((int)0, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add(this.m_defTblSpace1, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)jLabel2, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add(this.m_tmpTblSpace1, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        LayoutControl.GBC.addHSpring((JPanel)jPanel, (int)2);
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        JPanel jPanel2 = LayoutControl.GBC.createTitledSubPanel((String)RestArb.getString("TABLESPACE"), (Component)jPanel);
        JTextPane jTextPane4 = new JTextPane();
        jTextPane4.setText(RestArb.format("WIZ_SELECT_TBS", RestArb.getString("WIZ_TBS_USER")));
        jTextPane4.setEditable(false);
        jTextPane4.setOpaque(false);
        jTextPane4.setRequestFocusEnabled(false);
        jTextPane4.setFocusable(false);
        n = 0;
        JPanel jPanel3 = LayoutControl.GBC.createPanel();
        jPanel3.add((Component)jTextPane4, LayoutControl.GBC.gbc((int)0, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel3.add((Component)jLabel3, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel3.add(this.m_defTblSpace2, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel3.add((Component)jLabel4, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel3.add(this.m_tmpTblSpace2, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        LayoutControl.GBC.addHSpring((JPanel)jPanel3, (int)2);
        LayoutControl.GBC.addVSpring((JPanel)jPanel3, (int)(++n));
        JPanel jPanel4 = LayoutControl.GBC.createTitledSubPanel((String)RestArb.getString("TABLESPACE"), (Component)jPanel3);
        n = 0;
        this.add(jTextPane, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.add(jTextPane2, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.add(jPanel2, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.add(jPanel4, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)((Object)this), (int)(++n));
    }

    private void initTablespace(final String string, final String string2, final String string3, final String string4) {
        final WaitCursor waitCursor = new WaitCursor((Component)((Object)this));
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(RestArb.getString("LOAD_TABLESPACES"), true, IRaptorTaskRunMode.MODAL){

            protected Void doWork() throws TaskException {
                try {
                    if (InstallWizCDBTablespacesPanel.this.m_PdbTablespaceQuery == null) {
                        InstallWizCDBTablespacesPanel.this.m_PdbTablespaceQuery = InstallWizCDBTablespacesPanel.ALL_PDB_TBS_SQL;
                    }
                    Object object = string2;
                    String string5 = string3;
                    if (!((String)object).toUpperCase().equals("SYSTEM") && !((String)object).toUpperCase().contains(" AS SYSDBA")) {
                        object = (String)object + " AS SYSDBA";
                    }
                    if (string5 != null && string3.startsWith("@")) {
                        string5 = string5.substring(1);
                        string5 = Passwords.comingIn((String)string5);
                    }
                    String string22 = null;
                    String string32 = string4;
                    if (!(InstallUtils.nullOrEmpty(string32) || !InstallUtils.nullOrEmpty(string22 = System.getProperty("oracle.net.tns_admin")) && string32.equalsIgnoreCase(string22))) {
                        System.setProperty("oracle.net.tns_admin", string32);
                    }
                    Connection connection = null;
                    try {
                        connection = DriverManager.getConnection(string, (String)object, string5);
                        final List<String> list = InstallWizCDBTablespacesPanel.this.getTablespaceNames(connection, "select tablespace_name from dba_tablespaces order by 1");
                        final List<String> list2 = InstallWizCDBTablespacesPanel.this.getTablespaceNames(connection, "select distinct(tablespace_name) from dba_temp_files order by 1");
                        List<String> list3 = InstallWizCDBTablespacesPanel.this.getTablespaceNames(connection, InstallWizCDBTablespacesPanel.FILTER_CDB_ROOT_TBS_SQL);
                        Map<String, List<String>> map = InstallWizCDBTablespacesPanel.this.getPDBTablespaceNamesExistInCdb(connection, InstallWizCDBTablespacesPanel.this.m_PdbTablespaceQuery);
                        final List<String> list4 = InstallWizCDBTablespacesPanel.this.getFilteredTablespaceNames(list, list3, map);
                        final List<String> list5 = InstallWizCDBTablespacesPanel.this.getFilteredTablespaceNames(list2, list3, map);
                        InstallWizCDBTablespacesPanel.this.m_prevConnInfo = string + string2;
                        string5 = null;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                String[] stringArray = new String[list4.size()];
                                list4.toArray(stringArray);
                                String[] stringArray2 = new String[list5.size()];
                                list5.toArray(stringArray2);
                                InstallWizCDBTablespacesPanel.this.m_defTblSpace1.setModel(new DefaultComboBoxModel<String>(stringArray));
                                if (list.contains(InstallWizCDBTablespacesPanel.this.m_defValue_defTbs1)) {
                                    InstallWizCDBTablespacesPanel.this.m_defTblSpace1.setSelectedItem(InstallWizCDBTablespacesPanel.this.m_defValue_defTbs1);
                                }
                                InstallWizCDBTablespacesPanel.this.m_tmpTblSpace1.setModel(new DefaultComboBoxModel<String>(stringArray2));
                                if (list2.contains(InstallWizCDBTablespacesPanel.this.m_defValue_tmpTbs1)) {
                                    InstallWizCDBTablespacesPanel.this.m_tmpTblSpace1.setSelectedItem(InstallWizCDBTablespacesPanel.this.m_defValue_tmpTbs1);
                                }
                                InstallWizCDBTablespacesPanel.this.m_defTblSpace2.setModel(new DefaultComboBoxModel<String>(stringArray));
                                if (list.contains(InstallWizCDBTablespacesPanel.this.m_defValue_defTbs2)) {
                                    InstallWizCDBTablespacesPanel.this.m_defTblSpace2.setSelectedItem(InstallWizCDBTablespacesPanel.this.m_defValue_defTbs2);
                                }
                                InstallWizCDBTablespacesPanel.this.m_tmpTblSpace2.setModel(new DefaultComboBoxModel<String>(stringArray2));
                                if (list2.contains(InstallWizCDBTablespacesPanel.this.m_defValue_tmpTbs2)) {
                                    InstallWizCDBTablespacesPanel.this.m_tmpTblSpace2.setSelectedItem(InstallWizCDBTablespacesPanel.this.m_defValue_tmpTbs2);
                                }
                                InstallWizCDBTablespacesPanel.this.validate();
                                InstallWizCDBTablespacesPanel.this.repaint();
                            }
                        });
                    }
                    catch (SQLException sQLException) {
                        InstallWizCDBTablespacesPanel.this.logger.warning(sQLException.getMessage());
                        throw sQLException;
                    }
                    finally {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Exception exception) {}
                        }
                        string5 = null;
                        if (!InstallUtils.nullOrEmpty(string32)) {
                            if (InstallUtils.nullOrEmpty(string22)) {
                                System.clearProperty("oracle.net.tns_admin");
                            } else if (!string32.equalsIgnoreCase(string22)) {
                                System.setProperty("oracle.net.tns_admin", string22);
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    throw new TaskException((Throwable)exception);
                }
                return null;
            }
        };
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                this.cleanup();
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                Throwable throwable;
                Throwable throwable2 = raptorTaskEvent.getThrowable();
                while (throwable2 instanceof DBException && (throwable = throwable2.getCause()) instanceof Exception) {
                    throwable2 = throwable;
                }
                ExceptionHandler.handleException((Throwable)((Exception)throwable2));
                this.cleanup();
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                this.cleanup();
            }

            private void cleanup() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        waitCursor.hide();
                    }
                });
            }
        });
        waitCursor.show();
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    private List<String> getFilteredTablespaceNames(List<String> list, List<String> list2, Map<String, List<String>> map) {
        ArrayList<String> arrayList = new ArrayList<String>();
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        int n = map.size();
        for (String string : list) {
            if (!list2.contains(string)) continue;
            arrayList.add(string);
            linkedHashMap.put(string, 0);
        }
        for (String string : map.keySet()) {
            List<String> list3 = map.get(string);
            for (String string2 : arrayList) {
                if (!list3.contains(string2)) continue;
                int n2 = (Integer)linkedHashMap.get(string2) + 1;
                linkedHashMap.put(string2, n2);
            }
        }
        for (String string : linkedHashMap.keySet()) {
            int n3 = (Integer)linkedHashMap.get(string);
            if (n3 == n) continue;
            arrayList.remove(string);
        }
        return arrayList;
    }

    private List<String> getTablespaceNames(Connection connection, String string) {
        return InstallDBUtils.getNames(connection, string);
    }

    private Map<String, List<String>> getPDBTablespaceNamesExistInCdb(Connection connection, String string) {
        return InstallDBUtils.getPdbsTablespaces(connection, string);
    }

    private void validateValues() throws TraversalException {
    }

    private void setupPdbTablespaceQuery(Map<String, Object> map) {
        int n = (Integer)map.get("cdb.total.containers");
        List list = (List)map.get("cdb.pdb.list");
        if (list != null && !list.isEmpty()) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (RestVersionObject restVersionObject : list) {
                if (!restVersionObject.isSelected() || !restVersionObject.getInstallType().equals("INSTALL")) continue;
                arrayList.add(restVersionObject.getConId());
            }
            if (!arrayList.isEmpty()) {
                if (arrayList.size() == n) {
                    this.m_PdbTablespaceQuery = ALL_PDB_TBS_SQL;
                } else if (arrayList.size() < 25) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < arrayList.size(); ++i) {
                        if (i == 0) {
                            stringBuilder.append(arrayList.get(i));
                            continue;
                        }
                        stringBuilder.append(",").append(arrayList.get(i));
                    }
                    String string = stringBuilder.toString();
                    this.m_PdbTablespaceQuery = FILTER_PDBS_TBS_SQL;
                    this.m_PdbTablespaceQuery = this.m_PdbTablespaceQuery.replace("##REPLACE##", string);
                }
            }
        } else {
            this.logger.fine("installVerList is empty");
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        if (traversableContext.getDirection() == 1) {
            Map map = (Map)traversableContext.get("ORDS_PARAMS");
            Map map2 = (Map)map.get("INSTALL_KEY_PARAMS");
            String string = (String)map2.get("db.url");
            String string2 = (String)map2.get("sys.user");
            String string3 = (String)map2.get("sys.password");
            String string4 = string + string2;
            if (string4.equals(this.m_prevConnInfo) && this.m_defTblSpace1.getModel() != null && this.m_defTblSpace1.getModel().getSize() > 0) {
                this.m_init = false;
                return;
            }
            this.m_init = true;
            if (map2.get("schema.tablespace.default") != null) {
                this.m_defValue_defTbs1 = (String)map2.get("schema.tablespace.default");
            }
            if (map2.get("schema.tablespace.temp") != null) {
                this.m_defValue_tmpTbs1 = (String)map2.get("schema.tablespace.temp");
            }
            if (map2.get("user.tablespace.temp") != null) {
                this.m_defValue_tmpTbs2 = (String)map2.get("user.tablespace.temp");
            }
            this.setupPdbTablespaceQuery(map);
            String string5 = null;
            if ("tns".equals(map2.get("db.connectionType")) && !InstallUtils.nullOrEmpty((String)map2.get("db.tnsDirectory"))) {
                string5 = (String)map2.get("db.tnsDirectory");
            }
            this.initTablespace(string, string2, string3, string5);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            this.validateValues();
            Map map = (Map)traversableContext.get("ORDS_PARAMS");
            this.m_installType = (RestInstallConstants.InstallType)((Object)map.get("config.status"));
            Map map2 = (Map)map.get("INSTALL_KEY_PARAMS");
            this.m_installer = (String)map2.get("installer");
            map2.put("schema.tablespace.default", (String)this.m_defTblSpace1.getSelectedItem());
            map2.put("schema.tablespace.temp", (String)this.m_tmpTblSpace1.getSelectedItem());
            map2.put("user.tablespace.default", (String)this.m_defTblSpace2.getSelectedItem());
            map2.put("user.tablespace.temp", (String)this.m_tmpTblSpace2.getSelectedItem());
            if (this.m_init) {
                this.m_canMigrateAPEXRest = false;
                if (this.m_installer.equals("install") && (this.m_installType == RestInstallConstants.InstallType.MIGRATE_V2 || this.m_installType == RestInstallConstants.InstallType.VERIFY_SCHEMA)) {
                    String string;
                    String string2 = null;
                    if ("tns".equals(map2.get("db.connectionType")) && !InstallUtils.nullOrEmpty((String)map2.get("db.tnsDirectory"))) {
                        string2 = (String)map2.get("db.tnsDirectory");
                    }
                    String string3 = (String)map.get("product.version");
                    this.m_canMigrateAPEXRest = InstallDBUtils.canMigrateAPEXRest((String)map2.get("db.url"), string2, InstallDBUtils.getDBAUsername((String)map2.get("sys.user")), (String)map2.get("sys.password"), string3);
                    if (this.m_canMigrateAPEXRest && (string = InstallDBUtils.getAPEXVersion((String)map2.get("db.url"), InstallDBUtils.getDBAUsername((String)map2.get("sys.user")), string3)) != null) {
                        map.put("apex.version", string);
                    }
                }
            }
        }
    }

    public Object getExitTransition() {
        switch (this.m_installType) {
            case REQUIRES_CONFIG: {
                return "Transition.PLSQLGateway";
            }
            case MIGRATE_V2: {
                if (this.m_installer.equals("install") && this.m_canMigrateAPEXRest) {
                    return "Transition.Migrate";
                }
                return "Transition.Standalone";
            }
            case MIGRATE_V1: {
                break;
            }
            case VERIFY_SCHEMA: {
                if (this.m_installer.equals("install") && this.m_canMigrateAPEXRest) {
                    return "Transition.Migrate";
                }
                return "Transition.Standalone";
            }
        }
        return "Transition.Standalone";
    }
}

