/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install.wizard;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.install.InstallValidator;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class InstallDBAUserDialog
implements ActionListener {
    protected Properties m_connProps;
    protected JEWTDialog m_dialog;
    private StringBuffer m_errmsg;
    private String m_title;
    private String m_helpTopicId;
    private JTextField m_username = new JTextField();
    private JPasswordField m_password = new JPasswordField();
    private String m_descrip;

    public InstallDBAUserDialog(String string, String string2, String string3) {
        this.m_title = string;
        this.m_descrip = string2;
        this.m_helpTopicId = string3;
    }

    public String getUsername() {
        return this.m_username.getText();
    }

    public char[] getPassword() {
        return this.m_password.getPassword();
    }

    public void clear() {
        if (this.m_password != null) {
            this.m_password.setText(null);
        }
    }

    public StringBuffer getErrMsg() {
        return this.m_errmsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean runDialog(Component component) {
        boolean bl = false;
        this.m_dialog = null;
        try {
            this.initDialog(component);
            bl = WizardLauncher.runDialog((JDialog)this.m_dialog);
        }
        catch (Exception exception) {
        }
        finally {
            if (this.m_dialog != null) {
                this.m_dialog.dispose();
                this.m_dialog.removeActionListener((ActionListener)this);
                this.m_dialog = null;
            }
        }
        return bl;
    }

    protected boolean validInfo() {
        this.m_errmsg = new StringBuffer();
        if (this.m_username.getText() == null || this.m_username.getText().trim().length() == 0) {
            this.m_errmsg.append(RestArb.getString("ERROR_USERNAME_MISSING"));
            this.m_username.requestFocus();
        }
        try {
            InstallValidator.validatePassword(this.m_username.getText(), this.m_password);
        }
        catch (TraversalException traversalException) {
            if (this.m_errmsg.length() == 0) {
                this.m_password.requestFocus();
            } else {
                this.m_errmsg.append("\n");
            }
            this.m_errmsg.append(traversalException.getLocalizedMessage());
        }
        return this.m_errmsg.length() <= 0;
    }

    private JPanel getDbaUserPasswordPanel() {
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.m_username, (String)RestArb.getString("USERNAME"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.m_password, (String)RestArb.getString("PASSWORD"));
        JTextPane jTextPane = new JTextPane();
        jTextPane.setText(this.m_descrip);
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        int n = 0;
        JPanel jPanel = LayoutControl.GBC.createPanel();
        jPanel.add((Component)jTextPane, LayoutControl.GBC.gbc((int)0, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_username, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        jPanel.add((Component)jLabel2, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        jPanel.add((Component)this.m_password, LayoutControl.GBC.gbc((int)1, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)jPanel, (int)(++n));
        return jPanel;
    }

    private void initDialog(Component component) {
        JPanel jPanel = this.getDbaUserPasswordPanel();
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, this.m_helpTopicId);
        this.m_dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)component, (Component)jPanel, null, (String)this.m_title, (int)14);
        this.m_dialog.setDefaultButton(8);
        this.m_dialog.setModal(true);
        this.m_dialog.addActionListener((ActionListener)this);
    }

    private void showError() {
        MessageDialog.error((Component)this.m_dialog, (Object)this.m_errmsg, (String)this.m_title, null);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.validInfo()) {
            this.m_dialog.dispose();
        } else {
            this.showError();
        }
    }
}

