/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.autorest.actions;

import java.sql.Connection;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import oracle.dbtools.autorest.AutoRestArb;
import oracle.dbtools.autorest.generator.AutoRestCodeGenerator;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.actions.ActionDialog;
import oracle.dbtools.raptor.ui.controls.LabelActionControl;
import oracle.dbtools.raptor.ui.controls.TextBoxActionControl;

public class DropRestForSchemaAction
extends ActionDialog {
    private static final String SCHEMA_NAME = "name";
    private static final String DROP_MSG = "msg";
    private static final String COMMIT = "commit";
    String objectOwner;

    public DropRestForSchemaAction() {
        this.setScriptEditingEnabled(false);
    }

    protected String getHelpId() {
        return "f1_rest_schema_drop_html";
    }

    protected List<ActionControl> createControls(Connection connection) {
        try {
            this.objectOwner = this.getDBObjectSchemaName();
            if (this.objectOwner == null) {
                this.objectOwner = this.getDBObject().getSchemaName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        TextBoxActionControl textBoxActionControl = new TextBoxActionControl(SCHEMA_NAME, AutoRestArb.getString("SCHEMA_REST_DROP_NAME_LABEL"), this.objectOwner);
        LabelActionControl labelActionControl = new LabelActionControl(DROP_MSG, AutoRestArb.getString("SCHEMA_REST_DROP_LABEL"));
        Vector<ActionControl> vector = new Vector<ActionControl>();
        textBoxActionControl.setEditable(false);
        vector.add((ActionControl)textBoxActionControl);
        vector.add((ActionControl)labelActionControl);
        return vector;
    }

    protected String getScript(ActionDialog.Values values) {
        String string = this.getDBObject().getDBVersion();
        String string2 = values.get(COMMIT);
        AutoRestCodeGenerator autoRestCodeGenerator = AutoRestCodeGenerator.getInstance();
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put(SCHEMA_NAME, this.objectOwner);
        treeMap.put(COMMIT, string2 == null ? true : Boolean.valueOf(string2));
        TreeMap<String, Object> treeMap2 = new TreeMap<String, Object>();
        treeMap2.put("model", treeMap);
        String string3 = null;
        string3 = autoRestCodeGenerator.generate(string, "SCHEMA_DROP_REST_SERVICE", treeMap2);
        return string3;
    }

    protected String getTitle() {
        return AutoRestArb.getString("SCHEMA_REST_DROP_ACTION");
    }

    public static String checkNull(String string) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    public static String checkQuotes(String string) {
        if ((string = DropRestForSchemaAction.checkNull(string)) != null && string.length() > 0) {
            string = string.replace("'", "''");
        }
        return string;
    }
}

