/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView.managers;

import java.util.Date;
import java.util.Vector;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.ViewFormatHandle;
import oracle.dss.dataView.managers.RuleManager;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.gridView.GridViewCommon;
import oracle.dss.gridView.GridViewFormatManager;
import oracle.dss.rules.Mergeable;
import oracle.dss.rules.ResolutionService;
import oracle.dss.rules.RuleBundle;
import oracle.dss.rules.RuleContext;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.DataComponentInfo;
import oracle.dss.util.DataException;
import oracle.dss.util.QDR;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.WaitData;
import oracle.dss.util.format.BaseViewFormatHandle;
import oracle.dss.util.xml.ObjectNode;

public class GridViewRuleFormatter
extends RuleManager
implements GridViewFormatManager,
Cloneable {
    protected transient DataComponentInfo dinfo = new DataComponentInfo(0, 0);
    private static final String m_method_formatDataValue = "Object formatDataValue(DataviewCommon view, Object data, int column, int row, int[] pageHPos, ViewFormat vf)";
    private static final String m_method_getDataCellViewFormat = "ViewFormat getDataCellViewFormat(GridViewCommon view, int row, int column)";

    public void dataSourceChanged() {
        this.metadataFormatChanged();
        this.valueFormatChanged();
    }

    @Override
    public void valueFormatChanged() {
    }

    @Override
    public void metadataFormatChanged() {
    }

    public void setBundles(DataviewCommon view, Vector bundles) {
        super.setBundles(view, bundles);
        this.metadataFormatChanged();
        if (view != null) {
            view.dataFormatChanged();
        }
        this.valueFormatChanged();
        if (view != null) {
            view.repaint();
        }
    }

    @Override
    public ViewFormat getDataCellViewFormat(GridViewCommon view, int row, int column) {
        QDR valueQDR;
        String type;
        Object data = null;
        data = view.getWaitDataForRow(row);
        if (data != null) {
            return null;
        }
        ViewFormat initFormat = view.getViewFormat();
        if (view.isDataViewFormatSupported()) {
            Object obj = null;
            try {
                obj = view.getModel().getDataAccess().getValue(row, column, "dataViewFormat");
            }
            catch (ColumnOutOfRangeException coore) {
                view.getErrorHandler().log("column out of range", this.getClass().getName(), m_method_getDataCellViewFormat);
            }
            catch (RowOutOfRangeException roore) {
                view.getErrorHandler().log("row out of range", this.getClass().getName(), m_method_getDataCellViewFormat);
            }
            BaseViewFormatHandle baseViewFormatHandle = null;
            ViewFormat baseViewFormat = null;
            if (obj != null) {
                if (obj instanceof ViewFormatHandle) {
                    baseViewFormatHandle = (BaseViewFormatHandle)obj;
                    baseViewFormat = ((ViewFormatHandle)obj).getViewFormat();
                    if (baseViewFormat == null) {
                        baseViewFormat = ((ViewFormatHandle)obj).getBaseViewFormat();
                    }
                } else if (obj instanceof BaseViewFormatHandle) {
                    baseViewFormatHandle = (BaseViewFormatHandle)obj;
                    baseViewFormat = baseViewFormatHandle.getBaseViewFormat();
                } else {
                    if (obj instanceof WaitData) {
                        view.setWaitDataForRow(row, (WaitData)obj);
                        return null;
                    }
                    view.getErrorHandler().log("object not ViewFormatHandle type", this.getClass().getName(), m_method_getDataCellViewFormat);
                }
            }
            if (baseViewFormatHandle != null) {
                if (baseViewFormat != null) {
                    initFormat = (ViewFormat)initFormat.clone();
                    initFormat.merge((Mergeable)baseViewFormat);
                }
                if (baseViewFormatHandle.getRunRulesForViewFormat() == 0) {
                    return initFormat;
                }
            }
        }
        if (view.isDataUnformattedSupported()) {
            try {
                data = view.getModel().getDataAccess().getValue(row, column, "dataValue");
            }
            catch (DataException e) {
                view.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getDataCellViewFormat");
            }
            if (data == null) {
                return null;
            }
            if (data instanceof WaitData) {
                view.setWaitDataForRow(row, (WaitData)data);
                return null;
            }
        }
        this.dinfo.setRowCol(row, column);
        RuleContext location = new RuleContext();
        if (data instanceof Number) {
            type = "NUMBER_VALUE";
        } else if (data instanceof Date) {
            type = "DATE_VALUE";
        } else {
            return null;
        }
        location.put((Object)"POSITION", (Object)this.dinfo);
        location.put((Object)type, data);
        location.put((Object)"COMPONENT_TYPE", (Object)9);
        if (view.getModel().getDataAccess() != null) {
            location.put((Object)"DATA_ACCESS", (Object)view.getModel().getDataAccess());
        }
        if ((valueQDR = this.dinfo.getQDR(view.getModel().getDataAccess(), 1)) != null) {
            location.put((Object)"QDR", (Object)valueQDR);
        }
        if (view.isDataIsTotalSupported()) {
            try {
                Object isTotalObj = view.getModel().getDataAccess().getValue(row, column, "dataIsTotal");
                if (isTotalObj != null && isTotalObj instanceof Boolean) {
                    boolean bIsTotal = (Boolean)isTotalObj;
                    if (bIsTotal) {
                        location.put((Object)"TOTALS_RELATION", (Object)1);
                    } else {
                        location.put((Object)"TOTALS_RELATION", (Object)0);
                    }
                }
            }
            catch (ColumnOutOfRangeException coore) {
                view.getErrorHandler().log("column out of range: could not get ISTOTAL", this.getClass().getName(), m_method_getDataCellViewFormat);
            }
            catch (RowOutOfRangeException roore) {
                view.getErrorHandler().log("row out of range: could not get ISTOTAL", this.getClass().getName(), m_method_getDataCellViewFormat);
            }
        }
        ViewFormat format = initFormat;
        try {
            if (this.m_bundles != null) {
                initFormat = format = (ViewFormat)ResolutionService.resolveRules((RuleContext)location, (Mergeable)initFormat, (Vector)this.m_bundles);
            }
            if (this.m_uiBundle != null && initFormat != null) {
                format = (ViewFormat)ResolutionService.resolveRules((RuleContext)location, (Mergeable)initFormat, (RuleBundle)this.m_uiBundle);
            }
        }
        catch (ClassCastException e) {
            view.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getDataCellViewFormat");
        }
        if (format == null) {
            view.getErrorHandler().log("Error in resolving rules", this.getClass().getName(), "getDataCellViewFormat");
        }
        return format;
    }

    public Object formatDataValue(DataviewCommon view, Object data, int column, int row, int[] pageHPos, ViewFormat vf) {
        ViewFormat initFormat;
        QDR valueQDR;
        String type;
        if (data == null) {
            return null;
        }
        if (view.getWaitDataForRow(row) != null) {
            return data;
        }
        if (view.isDataViewFormatSupported()) {
            Object obj = null;
            try {
                obj = view.getModel().getDataAccess().getValue(row, column, "dataViewFormat");
            }
            catch (ColumnOutOfRangeException coore) {
                view.getErrorHandler().log("column out of range", this.getClass().getName(), m_method_formatDataValue);
            }
            catch (RowOutOfRangeException roore) {
                view.getErrorHandler().log("row out of range", this.getClass().getName(), m_method_formatDataValue);
            }
            BaseViewFormatHandle baseViewFormatHandle = null;
            ViewFormat baseViewFormat = null;
            if (obj != null) {
                if (obj instanceof ViewFormatHandle) {
                    baseViewFormatHandle = (BaseViewFormatHandle)obj;
                    baseViewFormat = ((ViewFormatHandle)obj).getViewFormat();
                    if (baseViewFormat == null) {
                        baseViewFormat = ((ViewFormatHandle)obj).getBaseViewFormat();
                    }
                } else if (obj instanceof BaseViewFormatHandle) {
                    baseViewFormatHandle = (BaseViewFormatHandle)obj;
                    baseViewFormat = baseViewFormatHandle.getBaseViewFormat();
                } else {
                    if (obj instanceof WaitData) {
                        view.setWaitDataForRow(row, (WaitData)obj);
                        return ((WaitData)data).getCellMessage();
                    }
                    view.getErrorHandler().log("object not ViewFormatHandle type", this.getClass().getName(), m_method_formatDataValue);
                }
            }
            if (data instanceof Boolean) {
                return vf.booleanToLocString((Boolean)data);
            }
            if (baseViewFormatHandle != null) {
                if (baseViewFormat != null) {
                    vf = (ViewFormat)vf.clone();
                    vf.merge((Mergeable)baseViewFormat);
                }
                if (baseViewFormatHandle.getRunRulesForViewFormat() == 0) {
                    return vf.ObjectToString(data);
                }
            }
        }
        if (data instanceof Boolean) {
            return vf.booleanToLocString((Boolean)data);
        }
        this.dinfo.setRowCol(row, column);
        RuleContext location = new RuleContext();
        if (data instanceof Number) {
            type = "NUMBER_VALUE";
        } else if (data instanceof Date) {
            type = "DATE_VALUE";
        } else {
            return data;
        }
        location.put((Object)"COMPONENT_TYPE", (Object)9);
        location.put((Object)"POSITION", (Object)this.dinfo);
        location.put((Object)type, data);
        if (view.getModel().getDataAccess() != null) {
            location.put((Object)"DATA_ACCESS", (Object)view.getModel().getDataAccess());
        }
        if ((valueQDR = this.dinfo.getQDR(view.getModel().getDataAccess(), 1)) != null) {
            location.put((Object)"QDR", (Object)valueQDR);
        }
        if (view instanceof GridViewCommon && ((GridViewCommon)view).isDataIsTotalSupported()) {
            try {
                Object isTotalObj = view.getModel().getDataAccess().getValue(row, column, "dataIsTotal");
                if (isTotalObj != null && isTotalObj instanceof Boolean) {
                    boolean bIsTotal = (Boolean)isTotalObj;
                    if (bIsTotal) {
                        location.put((Object)"TOTALS_RELATION", (Object)1);
                    } else {
                        location.put((Object)"TOTALS_RELATION", (Object)0);
                    }
                }
            }
            catch (ColumnOutOfRangeException coore) {
                view.getErrorHandler().log("column out of range: could not get ISTOTAL", this.getClass().getName(), m_method_formatDataValue);
            }
            catch (RowOutOfRangeException roore) {
                view.getErrorHandler().log("row out of range: could not get ISTOTAL", this.getClass().getName(), m_method_formatDataValue);
            }
        }
        ViewFormat format = initFormat = vf;
        try {
            if (this.m_bundles != null) {
                initFormat = format = (ViewFormat)ResolutionService.resolveRules((RuleContext)location, (Mergeable)initFormat, (Vector)this.m_bundles);
            }
            if (this.m_uiBundle != null && initFormat != null) {
                format = (ViewFormat)ResolutionService.resolveRules((RuleContext)location, (Mergeable)initFormat, (RuleBundle)this.m_uiBundle);
            }
        }
        catch (ClassCastException e) {
            return data;
        }
        if (format == null) {
            return data;
        }
        if (format == null) {
            return data;
        }
        return format.ObjectToString(data);
    }

    @Override
    public String formatMetadataValue(GridViewCommon view, Object data, int edge, int depth, int index, ViewFormat vf) {
        if (data != null) {
            return data.toString();
        }
        view.getErrorHandler().log("Metadata value is null", this.getClass().getName(), "formatMetadataValue");
        return "";
    }

    public ObjectNode getXML(boolean allProperties, DataviewCommon dataview) {
        return this.getXML(allProperties, "FormatManager", dataview);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        GridViewRuleFormatter newMgr = new GridViewRuleFormatter();
        newMgr.setBundles(null, this.m_bundles);
        if (this.getUIBundle() != null) {
            newMgr.setUIBundle(null, (RuleBundle)this.getUIBundle().clone());
        } else {
            newMgr.setUIBundle(null, null);
        }
        return newMgr;
    }

    public void setUIBundle(DataviewCommon view, RuleBundle bundle) {
        super.setUIBundle(view, bundle);
        this.metadataFormatChanged();
        if (view != null) {
            view.dataFormatChanged();
        }
        this.valueFormatChanged();
        if (view != null) {
            view.repaint();
        }
    }
}

