/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.ewt.spinBox.SpinBox;
import oracle.bali.ewt.spinBox.SpinBoxModel;
import oracle.bali.ewt.spinBox.SpinBuddy;
import oracle.bali.ewt.spinBox.SpinButtonEvent;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.UIViewPrinter;
import oracle.dss.dataView.ViewPrinter;
import oracle.dss.dataView.gui.PageSetupSheetPanel;
import oracle.dss.util.ErrorHandler;

public class PageSetupGridViewPanel
extends JPanel
implements ActionListener {
    protected UIViewPrinter[] m_viewPrinter;
    protected JPanel m_pageOrderPanel;
    protected JLabel m_pageOrderLabel;
    protected JPanel m_mainPanel;
    protected JCheckBox m_repeatHeaderCheckBox;
    protected JCheckBox m_repeatTitleCheckBox = null;
    protected JRadioButton m_downRadionButton;
    protected JRadioButton m_acrossRadionButton;
    protected JLabel m_downLabel;
    protected JLabel m_acrossLabel;
    protected JPanel m_scalePanel;
    protected JLabel m_scaleLabel;
    protected JRadioButton m_zoomRadioButton;
    protected JRadioButton m_fullFitRadioButton;
    protected MyNumericSpinBox m_zoomNumericSpinBox;
    protected JLabel m_zoomLabel;
    protected NumericSpinBox m_widthNumericSpinBox;
    protected JLabel m_widthLabel;
    protected NumericSpinBox m_heightNumericSpinBox;
    protected JLabel m_heightLabel;
    protected boolean m_bHelpEnabled;
    protected ErrorHandler m_eh = null;
    protected String m_strHelpContextID;
    private ResourceBundle rBundle = null;
    private boolean m_bSuperCalled = true;
    private int m_viewType;
    private boolean m_isCrosstab;

    public PageSetupGridViewPanel(ViewPrinter[] viewPrinter) {
        this((UIViewPrinter[])viewPrinter);
    }

    public PageSetupGridViewPanel(UIViewPrinter[] viewPrinter) {
        if (viewPrinter == null) {
            return;
        }
        this.m_viewPrinter = viewPrinter;
        this.updateResourceBundle(this.m_viewPrinter[0].getLocale());
        this.setLayout(new BoxLayout(this, 1));
        this.m_viewType = viewPrinter[0].getViewPrinterType();
        this.m_mainPanel = new JPanel();
        this.m_mainPanel.setLayout(new BoxLayout(this.m_mainPanel, 1));
        this.m_mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add(this.m_mainPanel);
        this._init();
    }

    private void _init() {
        this.m_mainPanel.removeAll();
        this.m_isCrosstab = this.m_viewType == 0 || this.m_viewType == 4 || this.m_viewType == 6;
        this.m_pageOrderPanel = new JPanel();
        this.m_pageOrderPanel.setAlignmentX(0.0f);
        this.m_pageOrderPanel.setLayout(new BoxLayout(this.m_pageOrderPanel, 1));
        String translatedText = this.m_isCrosstab ? this.rBundle.getString("Crosstab Page Order") : this.rBundle.getString("Table Page Order");
        this.m_pageOrderLabel = new JLabel(translatedText);
        this.m_pageOrderLabel.setAlignmentX(0.0f);
        this.m_pageOrderLabel.setMinimumSize(this.m_pageOrderLabel.getPreferredSize());
        this.m_pageOrderLabel.setMaximumSize(this.m_pageOrderLabel.getPreferredSize());
        this.m_pageOrderPanel.add(this.m_pageOrderLabel);
        JPanel tmpPanel = new JPanel();
        tmpPanel.setAlignmentX(0.0f);
        tmpPanel.setLayout(new BoxLayout(tmpPanel, 0));
        translatedText = this.rBundle.getString("Across, then Down");
        this.m_acrossRadionButton = new JRadioButton(StringUtils.stripMnemonic((String)translatedText));
        this.m_acrossRadionButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_acrossRadionButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("AcrossThenDownADA"));
        this.m_acrossRadionButton.setAlignmentX(0.0f);
        this.m_acrossLabel = new JLabel();
        this.m_acrossLabel.setAlignmentX(0.0f);
        this.m_acrossLabel.setIcon(new ImageIcon(ImageUtils.getImageResource(PageSetupSheetPanel.class, (String)"images/across_down.gif")));
        tmpPanel.add(this.m_acrossRadionButton);
        tmpPanel.add(this.m_acrossLabel);
        tmpPanel.setMinimumSize(tmpPanel.getPreferredSize());
        tmpPanel.setMaximumSize(tmpPanel.getPreferredSize());
        this.m_pageOrderPanel.add(tmpPanel);
        tmpPanel = new JPanel();
        tmpPanel.setAlignmentX(0.0f);
        tmpPanel.setLayout(new BoxLayout(tmpPanel, 0));
        translatedText = this.rBundle.getString("Down, then Across");
        this.m_downRadionButton = new JRadioButton(StringUtils.stripMnemonic((String)translatedText));
        this.m_downRadionButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_downRadionButton.setAlignmentX(0.0f);
        this.m_downRadionButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("DownThenAcrossADA"));
        this.m_downLabel = new JLabel();
        this.m_downLabel.setAlignmentX(0.0f);
        this.m_downLabel.setIcon(new ImageIcon(ImageUtils.getImageResource(PageSetupSheetPanel.class, (String)"images/down_across.gif")));
        tmpPanel.add(this.m_downRadionButton);
        tmpPanel.add(this.m_downLabel);
        tmpPanel.setMinimumSize(tmpPanel.getPreferredSize());
        tmpPanel.setMaximumSize(tmpPanel.getPreferredSize());
        this.m_pageOrderPanel.add(tmpPanel);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_downRadionButton);
        buttonGroup.add(this.m_acrossRadionButton);
        tmpPanel = new JPanel();
        tmpPanel.setLayout(new BoxLayout(tmpPanel, 1));
        translatedText = this.rBundle.getString("Repeat headers on every page");
        this.m_repeatHeaderCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)translatedText));
        this.m_repeatHeaderCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_repeatHeaderCheckBox.addActionListener(this);
        this.m_repeatHeaderCheckBox.setAlignmentX(0.0f);
        tmpPanel.add(this.m_repeatHeaderCheckBox);
        if (this.m_viewType == 0 || this.m_viewType == 1) {
            translatedText = this.m_isCrosstab ? this.rBundle.getString("Repeat crosstab title on every page") : this.rBundle.getString("Repeat table title on every page");
            this.m_repeatTitleCheckBox = new JCheckBox(StringUtils.stripMnemonic((String)translatedText));
            this.m_repeatTitleCheckBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            this.m_repeatTitleCheckBox.addActionListener(this);
            this.m_repeatTitleCheckBox.setAlignmentX(0.0f);
            tmpPanel.add(this.m_repeatTitleCheckBox);
        }
        tmpPanel.setMinimumSize(tmpPanel.getPreferredSize());
        tmpPanel.setMaximumSize(tmpPanel.getPreferredSize());
        this.m_pageOrderPanel.add(tmpPanel);
        this.m_pageOrderPanel.setMinimumSize(this.m_pageOrderPanel.getPreferredSize());
        this.m_pageOrderPanel.setMaximumSize(this.m_pageOrderPanel.getPreferredSize());
        this.m_mainPanel.add(this.m_pageOrderPanel);
        this.m_mainPanel.add(Box.createVerticalStrut(15));
        this.m_scalePanel = new JPanel();
        this.m_scalePanel.setAlignmentX(0.0f);
        this.m_scalePanel.setLayout(new BoxLayout(this.m_scalePanel, 1));
        translatedText = this.m_isCrosstab ? this.rBundle.getString("Crosstab Scaling") : this.rBundle.getString("Table Scaling");
        this.m_scaleLabel = new JLabel(translatedText);
        this.m_scaleLabel.setAlignmentX(0.0f);
        this.m_scaleLabel.setMinimumSize(this.m_scaleLabel.getPreferredSize());
        this.m_scaleLabel.setMaximumSize(this.m_scaleLabel.getPreferredSize());
        this.m_scalePanel.add(this.m_scaleLabel);
        this.m_scalePanel.add(Box.createVerticalStrut(5));
        tmpPanel = new JPanel();
        tmpPanel.setLayout(new BoxLayout(tmpPanel, 0));
        tmpPanel.setAlignmentX(0.0f);
        translatedText = this.rBundle.getString("Adjust to");
        this.m_zoomRadioButton = new JRadioButton(StringUtils.stripMnemonic((String)translatedText));
        this.m_zoomRadioButton.setMinimumSize(this.m_zoomRadioButton.getPreferredSize());
        this.m_zoomRadioButton.setMaximumSize(this.m_zoomRadioButton.getPreferredSize());
        this.m_zoomRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_zoomRadioButton.setSelected(true);
        this.m_zoomRadioButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("AdjustToADA"));
        this.m_zoomNumericSpinBox = new MyNumericSpinBox(1, 9999);
        this.m_zoomNumericSpinBox.setPreferredSize(new Dimension(50, 22));
        this.m_zoomNumericSpinBox.setMinimumSize(this.m_zoomNumericSpinBox.getPreferredSize());
        this.m_zoomNumericSpinBox.setMaximumSize(this.m_zoomNumericSpinBox.getPreferredSize());
        this.m_zoomNumericSpinBox.getAccessibleContext().setAccessibleName(this.rBundle.getString("AdjustToADA"));
        tmpPanel.add(this.m_zoomRadioButton);
        tmpPanel.add((Component)((Object)this.m_zoomNumericSpinBox));
        this.m_scalePanel.add(tmpPanel);
        translatedText = this.rBundle.getString("Fit to");
        this.m_fullFitRadioButton = new JRadioButton(StringUtils.stripMnemonic((String)translatedText));
        this.m_fullFitRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_fullFitRadioButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("Fit to"));
        this.m_fullFitRadioButton.setMinimumSize(this.m_fullFitRadioButton.getPreferredSize());
        this.m_fullFitRadioButton.setMaximumSize(this.m_fullFitRadioButton.getPreferredSize());
        this.m_scalePanel.add(this.m_fullFitRadioButton);
        tmpPanel = new JPanel();
        tmpPanel.setLayout(new BoxLayout(tmpPanel, 0));
        tmpPanel.setAlignmentX(0.0f);
        this.m_widthNumericSpinBox = new NumericSpinBox(1, 9999);
        this.m_widthNumericSpinBox.setPreferredSize(new Dimension(50, 22));
        this.m_widthNumericSpinBox.setMinimumSize(this.m_widthNumericSpinBox.getPreferredSize());
        this.m_widthNumericSpinBox.setMaximumSize(this.m_widthNumericSpinBox.getPreferredSize());
        this.m_widthNumericSpinBox.getAccessibleContext().setAccessibleName(this.rBundle.getString("FitToPagesWideADA"));
        this.m_widthNumericSpinBox.setEnabled(false);
        translatedText = this.rBundle.getString("Pages Wide");
        this.m_widthLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        this.m_widthLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_widthLabel.setAlignmentX(0.0f);
        this.m_widthLabel.setLabelFor((Component)this.m_widthNumericSpinBox);
        tmpPanel.add(Box.createHorizontalStrut(20));
        tmpPanel.add(this.m_widthLabel);
        tmpPanel.add((Component)this.m_widthNumericSpinBox);
        this.m_scalePanel.add(tmpPanel);
        this.m_scalePanel.add(Box.createVerticalStrut(3));
        tmpPanel = new JPanel();
        tmpPanel.setLayout(new BoxLayout(tmpPanel, 0));
        tmpPanel.setAlignmentX(0.0f);
        translatedText = this.rBundle.getString("Pages Tall");
        this.m_heightLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        this.m_heightLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_heightLabel.setAlignmentX(0.0f);
        this.m_heightNumericSpinBox = new NumericSpinBox(1, 9999);
        this.m_heightNumericSpinBox.setPreferredSize(new Dimension(50, 22));
        this.m_heightNumericSpinBox.setMinimumSize(this.m_heightNumericSpinBox.getPreferredSize());
        this.m_heightNumericSpinBox.setMaximumSize(this.m_heightNumericSpinBox.getPreferredSize());
        this.m_heightLabel.setLabelFor((Component)this.m_heightNumericSpinBox);
        this.m_heightNumericSpinBox.getAccessibleContext().setAccessibleName(this.rBundle.getString("ByPagesTallADA"));
        this.m_heightNumericSpinBox.setEnabled(false);
        tmpPanel.add(Box.createHorizontalStrut(20));
        tmpPanel.add(this.m_heightLabel);
        tmpPanel.add((Component)this.m_heightNumericSpinBox);
        this.m_scalePanel.add(tmpPanel);
        int width = Math.max(this.getToolkit().getFontMetrics(this.m_widthLabel.getFont()).stringWidth(this.m_widthLabel.getText()), this.getToolkit().getFontMetrics(this.m_heightLabel.getFont()).stringWidth(this.m_heightLabel.getText()));
        this.m_widthLabel.setPreferredSize(new Dimension(width, this.m_widthLabel.getPreferredSize().height));
        this.m_widthLabel.setMinimumSize(this.m_widthLabel.getPreferredSize());
        this.m_widthLabel.setMaximumSize(this.m_widthLabel.getPreferredSize());
        this.m_heightLabel.setPreferredSize(new Dimension(width, this.m_heightLabel.getPreferredSize().height));
        this.m_heightLabel.setMinimumSize(this.m_heightLabel.getPreferredSize());
        this.m_heightLabel.setMaximumSize(this.m_heightLabel.getPreferredSize());
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.m_zoomRadioButton);
        buttonGroup2.add(this.m_fullFitRadioButton);
        this.m_scalePanel.setMinimumSize(this.m_scalePanel.getPreferredSize());
        this.m_scalePanel.setMaximumSize(this.m_scalePanel.getPreferredSize());
        this.m_mainPanel.add(this.m_scalePanel);
        this.m_zoomRadioButton.addActionListener(this);
        this.m_fullFitRadioButton.addActionListener(this);
        this.setAlignmentX(0.0f);
        this.m_mainPanel.setAlignmentX(0.0f);
        this._initiate();
    }

    private void _initiate() {
        if (this.m_viewPrinter[0].isPrintByColumns()) {
            this.m_acrossRadionButton.setSelected(true);
        } else {
            this.m_downRadionButton.setSelected(true);
        }
        if (this.m_viewPrinter[0].isRepeatComponent(1) || this.m_isCrosstab) {
            this.m_repeatHeaderCheckBox.setSelected(true);
        } else {
            this.m_repeatHeaderCheckBox.setSelected(false);
        }
        if (this.m_repeatTitleCheckBox != null) {
            if (this.m_viewPrinter[0].isDataviewTitleVisible() && this.m_viewPrinter[0].isRepeatComponent(8) || this.m_viewPrinter[0].isDataviewSubtitleVisible() && this.m_viewPrinter[0].isRepeatComponent(16) || this.m_viewPrinter[0].isDataviewFootnoteVisible() && this.m_viewPrinter[0].isRepeatComponent(32) || this.m_viewPrinter[0].isRepeatComponent(8)) {
                this.m_repeatTitleCheckBox.setSelected(true);
            } else {
                this.m_repeatTitleCheckBox.setSelected(false);
            }
        }
        this.m_zoomNumericSpinBox.setIntValue(this.m_viewPrinter[0].getPrintZoomFactor());
        if (this.m_viewPrinter[0].getFitToNumPagesTall() > 0) {
            this.m_heightNumericSpinBox.setIntValue(this.m_viewPrinter[0].getFitToNumPagesTall());
        } else {
            this.m_heightNumericSpinBox.setIntValue(1);
        }
        if (this.m_viewPrinter[0].getFitToNumPagesWide() > 0) {
            this.m_widthNumericSpinBox.setIntValue(this.m_viewPrinter[0].getFitToNumPagesWide());
        } else {
            this.m_widthNumericSpinBox.setIntValue(1);
        }
        switch (this.m_viewPrinter[0].getGridViewPrintScaleType()) {
            case 0: {
                this.m_zoomRadioButton.setSelected(true);
                this.m_zoomNumericSpinBox.setEnabled(true);
                this.m_zoomNumericSpinBox.setIntValue(100);
                this.m_fullFitRadioButton.setSelected(false);
                break;
            }
            case 2: {
                this.m_zoomNumericSpinBox.setEnabled(false);
                this.m_fullFitRadioButton.setSelected(true);
                this.m_widthNumericSpinBox.setEnabled(true);
                this.m_heightNumericSpinBox.setEnabled(true);
                break;
            }
            case 1: {
                this.m_zoomRadioButton.setSelected(true);
                this.m_zoomNumericSpinBox.setEnabled(true);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_zoomRadioButton) {
            if (this.m_zoomRadioButton.isSelected()) {
                this.m_zoomNumericSpinBox.setEnabled(true);
                this.m_widthNumericSpinBox.setEnabled(false);
                this.m_heightNumericSpinBox.setEnabled(false);
            }
        } else if (e.getSource() == this.m_fullFitRadioButton && this.m_fullFitRadioButton.isSelected()) {
            this.m_widthNumericSpinBox.setEnabled(true);
            this.m_heightNumericSpinBox.setEnabled(true);
            this.m_zoomNumericSpinBox.setEnabled(false);
        }
    }

    public void apply() {
        for (int i = 0; i < this.m_viewPrinter.length; ++i) {
            this.m_viewPrinter[i].setPrintByColumns(this.m_acrossRadionButton.isSelected());
            this.m_viewPrinter[i].setRepeatComponent(1, this.m_repeatHeaderCheckBox.isSelected());
            this.m_viewPrinter[i].setRepeatComponent(2, this.m_repeatHeaderCheckBox.isSelected());
            this.m_viewPrinter[i].setRepeatComponent(4, this.m_repeatHeaderCheckBox.isSelected());
            if (this.m_repeatTitleCheckBox != null) {
                this.m_viewPrinter[i].setRepeatComponent(8, this.m_repeatTitleCheckBox.isSelected());
                this.m_viewPrinter[i].setRepeatComponent(16, this.m_repeatTitleCheckBox.isSelected());
                this.m_viewPrinter[i].setRepeatComponent(32, this.m_repeatTitleCheckBox.isSelected());
            }
            if (this.m_zoomRadioButton.isSelected()) {
                if (this.m_zoomNumericSpinBox.getIntValue() == 100) {
                    this.m_viewPrinter[i].setGridViewPrintScaleType(0);
                    continue;
                }
                this.m_viewPrinter[i].setGridViewPrintScaleType(1);
                int pzf = this.m_zoomNumericSpinBox.getIntValue();
                if (pzf < 10) {
                    pzf = 10;
                }
                this.m_viewPrinter[i].setPrintZoomFactor(pzf);
                continue;
            }
            if (!this.m_fullFitRadioButton.isSelected()) continue;
            this.m_viewPrinter[i].setGridViewPrintScaleType(2);
            this.m_viewPrinter[i].setFitToNumPagesTall(this.m_heightNumericSpinBox.getIntValue());
            this.m_viewPrinter[i].setFitToNumPagesWide(this.m_widthNumericSpinBox.getIntValue());
        }
    }

    public void cleanUp() {
        super.removeAll();
        this.removeAll();
        this.m_viewPrinter = null;
        this.m_pageOrderPanel = null;
        this.m_pageOrderLabel = null;
        this.m_mainPanel.removeAll();
        this.m_mainPanel = null;
        this.m_repeatHeaderCheckBox.removeActionListener(this);
        this.m_repeatHeaderCheckBox.removeAll();
        this.m_repeatHeaderCheckBox = null;
        if (this.m_repeatTitleCheckBox != null) {
            this.m_repeatTitleCheckBox.removeActionListener(this);
            this.m_repeatTitleCheckBox.removeAll();
            this.m_repeatTitleCheckBox = null;
        }
        this.m_downRadionButton.removeAll();
        this.m_downRadionButton = null;
        this.m_acrossRadionButton.removeAll();
        this.m_acrossRadionButton = null;
        this.m_downLabel = null;
        this.m_acrossLabel = null;
        this.m_scalePanel.removeAll();
        this.m_scalePanel = null;
        this.m_scaleLabel = null;
        this.m_zoomRadioButton.removeActionListener(this);
        this.m_zoomRadioButton.removeAll();
        this.m_zoomRadioButton = null;
        this.m_fullFitRadioButton.removeActionListener(this);
        this.m_fullFitRadioButton.removeAll();
        this.m_fullFitRadioButton = null;
        this.m_zoomNumericSpinBox.cleanUp();
        this.m_zoomNumericSpinBox = null;
        this.m_zoomLabel = null;
        this.m_widthNumericSpinBox = null;
        this.m_widthLabel = null;
        this.m_heightNumericSpinBox = null;
        this.m_heightLabel = null;
        this.m_eh = null;
        this.m_strHelpContextID = null;
        this.rBundle = null;
    }

    @Override
    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    public void setViewPrinter(ViewPrinter[] viewPrinter) {
        if (viewPrinter != null) {
            this.m_viewPrinter = viewPrinter;
        }
        this._init();
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle(loc);
        this._init();
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }

    class MyNumericSpinBox
    extends SpinBox {
        private MySpinBuddy mySpinBuddy = null;
        private MySpinBoxModel mySpinBoxModel = new MySpinBoxModel();

        MyNumericSpinBox(int par1, int par2) {
            this.mySpinBuddy = new MySpinBuddy(this);
            this.setSpinBuddy(this.mySpinBuddy);
            this.setModel(this.mySpinBoxModel);
        }

        public void cleanUp() {
            this.mySpinBuddy.cleanUp();
            this.mySpinBuddy = null;
            this.mySpinBoxModel = null;
        }

        public int getIntValue() {
            String str = this.mySpinBuddy.getText();
            if (str.endsWith("%")) {
                str = str.substring(0, str.length() - 1);
            }
            return Integer.parseInt(str);
        }

        public void setIntValue(int value) {
            if (this.mySpinBoxModel == null) {
                return;
            }
            if (this.getModel() instanceof MySpinBoxModel) {
                ((MySpinBoxModel)this.getModel()).setValue(value);
            } else {
                this.mySpinBoxModel.setValue(value);
            }
            super.spinButtonSpinning(new SpinButtonEvent((Object)this, 1, 2));
            super.spinButtonSpinning(new SpinButtonEvent((Object)this, 1, 1));
        }

        public void spinButtonSpinning(SpinButtonEvent event) {
            String str = this.mySpinBuddy.getText();
            if (str.endsWith("%")) {
                str = str.substring(0, str.length() - 1);
            }
            Integer tmpFloat = null;
            try {
                tmpFloat = Integer.valueOf(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tmpFloat != null) {
                this.setIntValue(tmpFloat);
            }
            super.spinButtonSpinning(event);
        }
    }

    class NumberLocaleDocument
    extends PlainDocument {
        private DecimalFormat m_format;
        private JTextField m_text;
        private char Minus;
        private char Dec;

        public NumberLocaleDocument(JTextField text, Locale loc) {
            this.m_text = text;
            this.m_format = (DecimalFormat)NumberFormat.getNumberInstance(loc);
            this.Minus = this.m_format.getDecimalFormatSymbols().getMinusSign();
            this.Dec = this.m_format.getDecimalFormatSymbols().getDecimalSeparator();
            this.m_format.setGroupingUsed(false);
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            try {
                StringBuffer oldText = new StringBuffer(this.m_text.getText());
                if (oldText.length() == 4 || oldText.length() == 3 && !this.m_text.getText().endsWith("%") && !str.equals("%")) {
                    return;
                }
                if (this.m_text.getText().endsWith("%")) {
                    oldText = new StringBuffer(this.m_text.getText().substring(0, this.m_text.getText().length() - 1));
                }
                if (!this.m_text.getText().endsWith("%") && str.equals("%")) {
                    super.insertString(offset, str, a);
                    return;
                }
                oldText.insert(offset, str);
                ParsePosition pos = new ParsePosition(0);
                Number result = this.m_format.parse(oldText.toString(), pos);
                if (pos.getIndex() != oldText.length() || str.equals(".") || str.equals("-")) {
                    return;
                }
                super.insertString(offset, str, a);
            }
            catch (Exception eNumber) {
                return;
            }
        }
    }

    class MySpinBuddy
    extends JTextField
    implements SpinBuddy {
        int p = 0;
        MyNumericSpinBox m_myNumericSpinBox = null;
        NumberLocaleDocument m_numberLocaleDocument = new NumberLocaleDocument(this, Locale.getDefault());
        KeyAdapter m_keyAdapter = null;

        MySpinBuddy(MyNumericSpinBox myNumericSpinBox) {
            this.setBorder(null);
            this.setDocument(this.m_numberLocaleDocument);
            this.m_myNumericSpinBox = myNumericSpinBox;
            this.m_keyAdapter = new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    if (e.getKeyChar() == '\n') {
                        try {
                            MySpinBuddy.this.m_numberLocaleDocument.insertString(MySpinBuddy.this.m_numberLocaleDocument.getLength(), "%", null);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                }
            };
            this.addKeyListener(this.m_keyAdapter);
        }

        public void cleanUp() {
            this.removeKeyListener(this.m_keyAdapter);
            this.m_numberLocaleDocument = null;
            this.m_keyAdapter = null;
        }

        public void setValue(Object val) {
            try {
                this.m_numberLocaleDocument.remove(0, this.m_numberLocaleDocument.getLength());
                this.m_numberLocaleDocument.insertString(0, val.toString(), null);
                this.m_numberLocaleDocument.insertString(this.m_numberLocaleDocument.getLength(), "%", null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    class MySpinBoxModel
    implements SpinBoxModel {
        int m_value = 0;
        boolean m_forward = true;

        MySpinBoxModel() {
        }

        public final Object nextElement() {
            if (this.m_forward) {
                ++this.m_value;
                if (this.m_value > 999) {
                    this.m_value = 999;
                }
            } else {
                --this.m_value;
                if (this.m_value < 0) {
                    this.m_value = 0;
                }
            }
            return this.m_value;
        }

        public boolean hasMoreElements() {
            return this.m_forward || this.m_value != 10;
        }

        public void setIteratingForward(boolean forward) {
            this.m_forward = forward;
        }

        public boolean isIteratingForward() {
            return this.m_forward;
        }

        public Object skip(int count) {
            if (this.m_forward) {
                this.m_value += 1 * count;
                return this.m_value;
            }
            this.m_value -= 1 * count;
            if (this.m_value < 0) {
                this.m_value = 0;
            }
            return this.m_value;
        }

        public int remainingElements(int desired) {
            return desired - this.m_value;
        }

        public void setValue(int value) {
            this.m_value = value;
        }

        public int getValue() {
            return this.m_value;
        }
    }
}

