/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.util.gui.component.comboBox;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import oracle.adfdtinternal.model.dvt.util.gui.component.comboBox.CustomPopupComboBox;
import oracle.adfdtinternal.model.dvt.util.gui.component.comboBox.TreeComboRenderer;
import oracle.adfdtinternal.model.dvt.util.gui.component.comboBox.TreeListComboBoxModel;
import oracle.adfdtinternal.model.dvt.util.gui.component.comboBox.TreeListComboModel;
import oracle.adfdtinternal.model.dvt.util.gui.component.tree.CheckTree;

public class TreeListCombo
extends CustomPopupComboBox {
    private TreeListComboBoxModel m_treeListComboBoxModel = null;
    private JScrollPane m_jScrollPane = null;
    private boolean m_blnShowDividers = true;
    private String m_strText = null;

    public TreeListCombo() {
        this(null, null);
    }

    public TreeListCombo(JTree jTree, JList[] jLists) {
        this.setModel(new TreeListComboBoxModel(jTree, jLists));
        this.setStayOpen(true);
    }

    public TreeListCombo(TreeListComboModel treeListComboModel) {
        this.setModel(treeListComboModel);
    }

    @Override
    public void setPopupVisible(boolean bVisible) {
        Object objRows = null;
        if (this.getTree() != null && this.getTree().getSelectionCount() != 0) {
            bVisible = true;
        }
        super.setPopupVisible(bVisible);
    }

    public void setModel(TreeListComboModel treeListComboModel) {
        JTree jTree = this.makeTree(false);
        JList[] jLists = null;
        ArrayList selectFilters = null;
        if (treeListComboModel != null) {
            jTree = this.makeTree(treeListComboModel.isMultiSelect());
            jTree.setModel(treeListComboModel.getTreeModel());
            ListModel[] jListModels = treeListComboModel.getListModels();
            if (jListModels != null) {
                jLists = new JList[jListModels.length];
                for (int nIndex = 0; nIndex < jLists.length; ++nIndex) {
                    jLists[nIndex] = new JList(jListModels[nIndex]);
                }
            }
            selectFilters = treeListComboModel.getSelectFilters();
        }
        this.setModel(new TreeListComboBoxModel(jTree, jLists, selectFilters));
        this.setStayOpen(treeListComboModel.isMultiSelect());
    }

    public void setModel(TreeListComboBoxModel treeListComboBoxModel) {
        super.setModel(treeListComboBoxModel);
        this.setTreeListComboBoxModel(treeListComboBoxModel);
        this.initialize();
    }

    public JTree getTree() {
        return this.getTreeListComboBoxModel() != null ? this.getTreeListComboBoxModel().getTree() : null;
    }

    public void setTree(JTree jTree) {
        if (this.getTreeListComboBoxModel() != null) {
            this.getTreeListComboBoxModel().setTree(jTree);
            this.initialize();
        }
    }

    public JList[] getLists() {
        return this.getTreeListComboBoxModel() != null ? this.getTreeListComboBoxModel().getLists() : null;
    }

    public void setLists(JList[] jLists) {
        if (this.getTreeListComboBoxModel() != null) {
            this.getTreeListComboBoxModel().setLists(jLists);
            this.initialize();
        }
    }

    public void setMultiSelect(boolean multiSelect) {
        this.setStayOpen(multiSelect);
    }

    public boolean isMultiSelect() {
        return this.isStayOpen();
    }

    public void setTreeComboRenderer(TreeComboRenderer renderer) {
        JTree jTree = this.getTree();
        if (jTree != null) {
            jTree.setCellRenderer(renderer);
        }
        this.setRenderer((ListCellRenderer)renderer);
    }

    public void setRenderer(ListCellRenderer aRenderer) {
        super.setRenderer(aRenderer);
        JList[] jLists = this.getLists();
        if (jLists != null) {
            for (int nIndex = 0; nIndex < jLists.length; ++nIndex) {
                jLists[nIndex].setCellRenderer(aRenderer);
            }
        }
    }

    @Override
    public void firePopupMenuWillBecomeVisible() {
        if (this.m_jScrollPane != null) {
            Dimension dimension = this.m_jScrollPane.getViewport().getPreferredSize();
            int intWidth = this.getWidth() - this.m_jScrollPane.getVerticalScrollBar().getWidth() - 6;
            JTree jTree = this.getTree();
            int intHeight = jTree != null ? Math.min(dimension.height, jTree.getRowHeight() * 8) : dimension.height;
            Dimension dimensionNew = new Dimension(intWidth, intHeight);
            this.m_jScrollPane.getViewport().setPreferredSize(dimensionNew);
            Object selObj = this.getSelectedItem();
            ComboBoxModel comboBoxModel = this.getModel();
            if (comboBoxModel != null) {
                comboBoxModel.setSelectedItem(selObj);
            }
            super.firePopupMenuWillBecomeVisible();
        }
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent != null && keyEvent.getID() == 401 && keyEvent.getKeyCode() == 32) {
            JTree jTree = this.getTree();
            if (jTree != null) {
                TreePath treePath = jTree.getSelectionPath();
            }
            if (this.isPopupVisible() && this.isStayOpen()) {
                return;
            }
        }
        super.processKeyEvent(keyEvent);
    }

    public void setText(String strText) {
        this.m_strText = strText;
    }

    public String getText() {
        return this.m_strText;
    }

    public void setTreeListComboBoxModel(TreeListComboBoxModel treeListComboBoxModel) {
        this.m_treeListComboBoxModel = treeListComboBoxModel;
    }

    public TreeListComboBoxModel getTreeListComboBoxModel() {
        return this.m_treeListComboBoxModel;
    }

    JTree makeTree(boolean bIsMultiSelect) {
        JTree jTree = bIsMultiSelect ? new CheckTree() : new JTree();
        jTree.setShowsRootHandles(true);
        jTree.setRootVisible(true);
        return jTree;
    }

    private void expandAll() {
        JTree jTree = this.getTree();
        if (jTree != null) {
            for (int nIndex = 0; nIndex < jTree.getRowCount(); ++nIndex) {
                jTree.expandRow(nIndex);
            }
        }
    }

    private void initialize() {
        this.setFocusable(false);
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        SingleSelectionListener singleSelectionListener = new SingleSelectionListener();
        JTree jTree = this.getTree();
        if (jTree != null) {
            jTree.addMouseListener(new TreeMouseListener());
            jTree.addMouseMotionListener(new TreeMouseMotionListener());
            jTree.addTreeSelectionListener(singleSelectionListener);
            jTree.setFocusable(false);
        }
        this.addKeyListener(new KeyExpandListener());
        this.m_jScrollPane = new JScrollPane(jTree, 20, 30);
        this.m_jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        gridBagLayout.setConstraints(this.m_jScrollPane, gridBagConstraints);
        jPanel.add(this.m_jScrollPane);
        JList[] jLists = this.getLists();
        if (jLists != null) {
            for (int nIndex = 0; nIndex < jLists.length; ++nIndex) {
                if (this.m_blnShowDividers) {
                    JSeparator jSeparator = new JSeparator();
                    gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
                    jPanel.add(jSeparator);
                }
                jLists[nIndex].addMouseListener(new ListMouseListener());
                jLists[nIndex].addMouseMotionListener(new ListMouseMotionListener());
                jLists[nIndex].addListSelectionListener(singleSelectionListener);
                jLists[nIndex].setFocusable(false);
                gridBagLayout.setConstraints(jLists[nIndex], gridBagConstraints);
                jPanel.add(jLists[nIndex]);
            }
        }
        this.setPopupComponent(jPanel);
    }

    private class SingleSelectionListener
    implements ListSelectionListener,
    TreeSelectionListener {
        private SingleSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent != null) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (this.isListItemSelected()) {
                    JTree jTree = TreeListCombo.this.getTree();
                    if (jTree != null) {
                        jTree.clearSelection();
                    }
                    this.clearListSelections((JList)listSelectionEvent.getSource());
                }
            }
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            JTree jTree = TreeListCombo.this.getTree();
            if (jTree != null && jTree.getSelectionPath() != null) {
                this.clearListSelections(null);
            }
        }

        private void clearListSelections(JList jList) {
            JList[] jLists = TreeListCombo.this.getLists();
            if (jLists != null) {
                for (int nIndex = 0; nIndex < jLists.length; ++nIndex) {
                    if (jLists[nIndex] == jList) continue;
                    jLists[nIndex].clearSelection();
                }
            }
        }

        private boolean isListItemSelected() {
            JList[] jLists = TreeListCombo.this.getLists();
            if (jLists != null) {
                for (int nIndex = 0; nIndex < jLists.length; ++nIndex) {
                    if (jLists[nIndex].getSelectedIndex() < 0) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class TreeMouseListener
    extends MouseAdapter {
        private TreeMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Object object;
            TreePath treePath;
            JTree jTree;
            if (mouseEvent != null && (jTree = TreeListCombo.this.getTree()) != null && (treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null && (object = treePath.getLastPathComponent()) != null) {
                TreeListCombo.this.setSelectedItem(object);
                if (!TreeListCombo.this.isStayOpen() && object.equals(TreeListCombo.this.getModel().getSelectedItem())) {
                    TreeListCombo.this.hidePopup();
                }
            }
        }
    }

    private class TreeMouseMotionListener
    extends MouseMotionAdapter {
        private TreeMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            JTree jTree;
            if (mouseEvent != null && (jTree = TreeListCombo.this.getTree()) != null) {
                TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                jTree.setSelectionPath(treePath);
            }
        }
    }

    private class KeyExpandListener
    extends KeyAdapter {
        private KeyExpandListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent != null) {
                JTree jTree;
                if (37 == keyEvent.getKeyCode()) {
                    JTree jTree2 = TreeListCombo.this.getTree();
                    if (jTree2 != null) {
                        TreePath treePath = jTree2.getSelectionPath();
                        jTree2.collapsePath(treePath);
                    }
                } else if (39 == keyEvent.getKeyCode() && (jTree = TreeListCombo.this.getTree()) != null) {
                    TreePath treePath = jTree.getSelectionPath();
                    jTree.expandPath(treePath);
                }
            }
        }
    }

    private class ListMouseListener
    extends MouseAdapter {
        private ListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent != null) {
                JList jList = (JList)mouseEvent.getSource();
                int index = jList.locationToIndex(mouseEvent.getPoint()) + this.getListOffset(jList);
                if (TreeListCombo.this.isPopupVisible()) {
                    TreeListCombo.this.setSelectedIndex(index);
                    TreeListCombo.this.hidePopup();
                }
            }
        }

        private int getListOffset(JList jList) {
            JTree jTree = TreeListCombo.this.getTree();
            int nOffset = jTree != null ? jTree.getRowCount() : 0;
            JList[] jLists = TreeListCombo.this.getLists();
            if (jLists != null) {
                for (int nIndex = 0; nIndex < jLists.length; ++nIndex) {
                    if (jLists[nIndex] == jList) {
                        return nOffset;
                    }
                    nOffset += jLists[nIndex].getModel().getSize();
                }
            }
            return nOffset;
        }
    }

    private class ListMouseMotionListener
    extends MouseMotionAdapter {
        private ListMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (mouseEvent != null) {
                JList jList = (JList)mouseEvent.getSource();
                int nIndex = jList.locationToIndex(mouseEvent.getPoint());
                jList.setSelectedIndex(nIndex);
            }
        }
    }
}

