/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.digsig;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cert.CRLReason;
import oracle.security.crypto.cert.RevokedCertificate;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cert.ext.CRLReasonExtension;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.digsig.CertificateMapper;
import oracle.security.digsig.DigitalSignatureException;
import oracle.security.digsig.KeyStoreWrapper;
import oracle.security.digsig.Utilities;
import oracle.security.digsig.Validator;
import oracle.security.digsig.ValidatorProperties;
import oracle.security.digsig.ValidatorStore;

public class CRLValidator
extends Validator {
    private static final int CRLVALIDATOR_OK = 1;
    private static final int CRLVALIDATOR_WAIT = 2;
    private static final int CRLVALIDATOR_NEXT = 3;
    private static final int CRLVALIDATOR_PREV = 4;
    private static final int CRLVALIDATOR_NOTOK = 5;
    public static final String CRLVALIDATOR_URL = "ORACLE.SECURITY.DIGSIG.VALIDATOR.CRL.URL";
    public static final String CRLVALIDATOR_FILE_URI_SCHEME = "FILE:";
    public static final String CRLVALIDATOR_HTTP_URI_SCHEME = "HTTP:";
    private HashMap validatorIDs = new HashMap();
    private HashMap validatorCRLs = new HashMap();
    private HashMap validatorURLs = new HashMap();
    private Hashtable validatorProperties = new Hashtable();

    CRLValidator(KeyStoreWrapper pKeyStore, CertificateMapper pCertificateMapper, ValidatorStore pValidatorStore, Properties pConfig) throws DigitalSignatureException {
        super(pKeyStore, pCertificateMapper, pValidatorStore, pConfig);
        if (pConfig != null) {
            ArrayList<String> crlUrls = new ArrayList<String>();
            Enumeration<?> e = pConfig.propertyNames();
            while (e.hasMoreElements()) {
                String p = (String)e.nextElement();
                if (!p.toUpperCase().startsWith(CRLVALIDATOR_URL)) continue;
                crlUrls.add(pConfig.getProperty(p));
            }
            if (crlUrls.size() != 0) {
                this.fetchAndVerifyCRLs(crlUrls);
            }
        }
        String ref = null;
        if (pValidatorStore != null) {
            for (X500Name issuer : this.validatorCRLs.keySet()) {
                CRL crl = (CRL)this.validatorCRLs.get(issuer);
                ref = pValidatorStore.store(1, issuer.toString(), crl.getDate(), crl.getNextDate(), Utilities.X509CRLtoBase64(crl));
                if (ref == null) continue;
                this.validatorIDs.put(issuer, ref);
            }
        }
    }

    private void fetchAndVerifyCRLs(ArrayList urls) throws DigitalSignatureException {
        for (String url : urls) {
            CRL crl = Utilities.getCRL(url);
            if (!this.verifyCRL(crl)) continue;
            this.validatorCRLs.put(crl.getIssuer(), crl);
            this.validatorURLs.put(crl.getIssuer(), url);
        }
    }

    private boolean verifyCRL(CRL crl) throws DigitalSignatureException {
        X509 tp = (X509)this.validatorTrustPoints.get(crl.getIssuer());
        if (tp == null) {
            throw new DigitalSignatureException("CRL cannot be verified");
        }
        try {
            crl.setPublicKey(tp.getPublicKey());
            return crl.verify();
        }
        catch (AuthenticationException e) {
            throw new DigitalSignatureException("CRL Verification exception" + (Object)((Object)e));
        }
    }

    private int isCRLRecent(CRL crl, Date tos) {
        Date toi = crl.getDate();
        Date ton = crl.getNextDate();
        if (tos.after(ton) && ton.after(Calendar.getInstance().getTime())) {
            return 2;
        }
        if (tos.after(ton) && ton.before(Calendar.getInstance().getTime())) {
            return 3;
        }
        if (tos.before(toi)) {
            return 4;
        }
        if (tos.after(toi) && tos.before(ton)) {
            return 1;
        }
        return 5;
    }

    @Override
    public ValidatorProperties getValidatorProperties() throws DigitalSignatureException {
        if (this.validatorProperties.isEmpty()) {
            throw new DigitalSignatureException("validateCert() needs to be called first - invalid state");
        }
        return new ValidatorProperties(this.validatorProperties);
    }

    @Override
    public int getValidationMode() {
        return 1;
    }

    @Override
    public int validateCert(String pCert, Date pSigningTime) throws DigitalSignatureException {
        if (pCert == null) {
            throw new DigitalSignatureException("validateCert - Invalid parameters");
        }
        X509 c = Utilities.Base64toX509(pCert);
        if (pSigningTime == null) {
            pSigningTime = Calendar.getInstance().getTime();
        }
        int cStatus = 5;
        int vStatus = -3;
        CRL crl = (CRL)this.validatorCRLs.get(c.getIssuer());
        String ref = (String)this.validatorIDs.get(c.getIssuer());
        cStatus = this.isCRLRecent(crl, pSigningTime);
        block0 : switch (cStatus) {
            case 2: {
                break;
            }
            case 3: {
                String url = (String)this.validatorURLs.get(c.getIssuer());
                if (url == null) {
                    url = Utilities.getCRLDistributionPoints(c);
                }
                crl = Utilities.getCRL(url);
                cStatus = this.isCRLRecent(crl, pSigningTime);
                switch (cStatus) {
                    case 2: {
                        break block0;
                    }
                    case 3: {
                        cStatus = 5;
                        break block0;
                    }
                    case 1: {
                        if (!this.verifyCRL(crl)) break block0;
                        if (this.validatorStore != null) {
                            ref = this.validatorStore.store(1, crl.getIssuer().toString(), crl.getDate(), crl.getNextDate(), Utilities.X509CRLtoBase64(crl));
                            this.validatorIDs.put(crl.getIssuer(), ref);
                        }
                        this.validatorCRLs.put(crl.getIssuer(), crl);
                        break block0;
                    }
                    case 4: {
                        throw new DigitalSignatureException("CRL Validator - Invalid State");
                    }
                }
                break;
            }
            case 4: {
                cStatus = 5;
                if (this.validatorStore == null) break;
                StringBuffer sb = new StringBuffer();
                ref = this.validatorStore.retreive(1, c.getIssuer().toString(), pSigningTime, sb);
                crl = Utilities.Base64toX509CRL(sb.toString());
                if (!this.verifyCRL(crl)) break;
                cStatus = 1;
            }
        }
        if (cStatus == 5) {
            vStatus = -3;
        } else {
            vStatus = cStatus == 2 ? -2 : (crl.isRevoked(c.getSerialNo()) ? -1 : 0);
            this.validatorProperties.clear();
            this.validatorProperties.put("IssuerName", crl.getIssuer().toString());
            this.validatorProperties.put("ValidatorRecord", Utilities.X509CRLtoBase64(crl));
            this.validatorProperties.put("IssueTime", crl.getDate());
            this.validatorProperties.put("NextUpdateTime", crl.getNextDate());
            if (this.validatorStore != null) {
                this.validatorProperties.put("ValidatorReference", ref);
            }
            if (vStatus == -1) {
                RevokedCertificate rCert = crl.getRevokedCertificate(c.getSerialNo());
                CRLReasonExtension crlReasonExt = new CRLReasonExtension();
                CRLReason reason = ((CRLReasonExtension)rCert.getExtension(crlReasonExt.getType())).getReason();
                this.validatorProperties.put("RevocationReason", reason.toString());
            }
        }
        return vStatus;
    }
}

