/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.samples;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class XmlPullCount {
    public static final String SAMPLE_XML = "<?xml version=\"1.0\"?>\n\n<poem xmlns=\"http://www.megginson.com/ns/exp/poetry\">\n<title>Roses are Red</title>\n<l>Roses are red,</l>\n<l>Violets are blue;</l>\n<l>Sugar is sweet,</l>\n<l>And I love you.</l>\n</poem>";
    int countChars;
    int countAttribs;
    int countSTags;
    boolean verbose;

    public static void main(String[] stringArray) throws XmlPullParserException, IOException {
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance(System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        xmlPullParserFactory.setNamespaceAware(false);
        System.err.println("using factory " + xmlPullParserFactory.getClass());
        XmlPullParser xmlPullParser = xmlPullParserFactory.newPullParser();
        System.err.println("using parser " + xmlPullParser.getClass());
        XmlPullCount xmlPullCount = new XmlPullCount();
        xmlPullCount.verbose = true;
        for (int i = 0; i < 2; ++i) {
            System.err.println("run#" + i);
            xmlPullCount.resetCounters();
            if (stringArray.length == 0) {
                System.err.println("Parsing simple sample XML length=" + SAMPLE_XML.length());
                xmlPullParser.setInput(new StringReader(SAMPLE_XML));
                xmlPullCount.countXml(xmlPullParser);
            } else {
                File file = new File(stringArray[0]);
                System.err.println("Parsing file: " + stringArray[0] + " length=" + file.length());
                xmlPullParser.setInput(new FileInputStream(stringArray[0]), "UTF8");
                xmlPullCount.countXml(xmlPullParser);
            }
            xmlPullCount.printReport();
        }
        System.err.println("finished");
    }

    public void resetCounters() {
        this.countAttribs = 0;
        this.countSTags = 0;
        this.countChars = 0;
    }

    public void printReport() {
        System.err.println("characters=" + this.countChars + " elements=" + this.countSTags + " attributes=" + this.countAttribs);
    }

    public void countXml(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        int[] nArray = new int[2];
        xmlPullParser.require(0, null, null);
        int n = xmlPullParser.next();
        xmlPullParser.require(2, null, null);
        while (n != 1) {
            if (n == 2) {
                ++this.countSTags;
                this.countAttribs += xmlPullParser.getAttributeCount();
                if (this.verbose) {
                    System.err.println("START_TAG " + xmlPullParser.getName());
                }
            } else if (n == 4) {
                xmlPullParser.getTextCharacters(nArray);
                int n2 = nArray[1];
                this.countChars += n2;
                if (this.verbose) {
                    System.err.println("TEXT '" + this.printable(xmlPullParser.getText()) + "'");
                }
            } else if (n == 3 && this.verbose) {
                System.err.println("END_TAG " + xmlPullParser.getName());
            }
            n = xmlPullParser.next();
        }
    }

    protected String printable(char c) {
        if (c == '\n') {
            return "\\n";
        }
        if (c == '\r') {
            return "\\r";
        }
        if (c == '\t') {
            return "\\t";
        }
        if (c > '\u007f' || c < ' ') {
            StringBuffer stringBuffer = new StringBuffer("\\u");
            String string = Integer.toHexString(c);
            for (int i = 0; i < 4 - string.length(); ++i) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            return stringBuffer.toString();
        }
        return "" + c;
    }

    protected String printable(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append(this.printable(string.charAt(i)));
        }
        string = stringBuffer.toString();
        return string;
    }
}

