/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.builder.xpath.jaxen;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.builder.xpath.jaxen.Context;
import org.xmlpull.v1.builder.xpath.jaxen.ContextSupport;
import org.xmlpull.v1.builder.xpath.jaxen.FunctionContext;
import org.xmlpull.v1.builder.xpath.jaxen.JaxenException;
import org.xmlpull.v1.builder.xpath.jaxen.JaxenHandler;
import org.xmlpull.v1.builder.xpath.jaxen.NamespaceContext;
import org.xmlpull.v1.builder.xpath.jaxen.Navigator;
import org.xmlpull.v1.builder.xpath.jaxen.SimpleNamespaceContext;
import org.xmlpull.v1.builder.xpath.jaxen.SimpleVariableContext;
import org.xmlpull.v1.builder.xpath.jaxen.VariableContext;
import org.xmlpull.v1.builder.xpath.jaxen.XPath;
import org.xmlpull.v1.builder.xpath.jaxen.XPathFunctionContext;
import org.xmlpull.v1.builder.xpath.jaxen.XPathSyntaxException;
import org.xmlpull.v1.builder.xpath.jaxen.expr.Expr;
import org.xmlpull.v1.builder.xpath.jaxen.expr.XPathExpr;
import org.xmlpull.v1.builder.xpath.jaxen.function.BooleanFunction;
import org.xmlpull.v1.builder.xpath.jaxen.function.NumberFunction;
import org.xmlpull.v1.builder.xpath.jaxen.function.StringFunction;
import org.xmlpull.v1.builder.xpath.saxpath.SAXPathException;
import org.xmlpull.v1.builder.xpath.saxpath.XPathReader;
import org.xmlpull.v1.builder.xpath.saxpath.helpers.XPathReaderFactory;

public class BaseXPath
implements XPath,
Serializable {
    private XPathExpr xpath;
    private ContextSupport support;
    private Navigator navigator;

    protected BaseXPath(String string) throws JaxenException {
        try {
            XPathReader xPathReader = XPathReaderFactory.createReader();
            JaxenHandler jaxenHandler = new JaxenHandler();
            xPathReader.setXPathHandler(jaxenHandler);
            xPathReader.parse(string);
            this.xpath = jaxenHandler.getXPathExpr();
        }
        catch (org.xmlpull.v1.builder.xpath.saxpath.XPathSyntaxException xPathSyntaxException) {
            throw new XPathSyntaxException(xPathSyntaxException.getXPath(), xPathSyntaxException.getPosition(), xPathSyntaxException.getMessage());
        }
        catch (SAXPathException sAXPathException) {
            throw new JaxenException(sAXPathException);
        }
    }

    public BaseXPath(String string, Navigator navigator) throws JaxenException {
        this(string);
        this.navigator = navigator;
    }

    @Override
    public Object evaluate(Object object) throws JaxenException {
        Object e;
        List list = this.selectNodes(object);
        if (list != null && list.size() == 1 && ((e = list.get(0)) instanceof String || e instanceof Number || e instanceof Boolean)) {
            return e;
        }
        return list;
    }

    @Override
    public List selectNodes(Object object) throws JaxenException {
        Context context = this.getContext(object);
        return this.selectNodesForContext(context);
    }

    @Override
    public Object selectSingleNode(Object object) throws JaxenException {
        List list = this.selectNodes(object);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public String valueOf(Object object) throws JaxenException {
        return this.stringValueOf(object);
    }

    @Override
    public String stringValueOf(Object object) throws JaxenException {
        Context context = this.getContext(object);
        Object object2 = this.selectSingleNodeForContext(context);
        if (object2 == null) {
            return "";
        }
        return StringFunction.evaluate(object2, context.getNavigator());
    }

    @Override
    public boolean booleanValueOf(Object object) throws JaxenException {
        Context context = this.getContext(object);
        List list = this.selectNodesForContext(context);
        if (list == null) {
            return false;
        }
        return BooleanFunction.evaluate(list, context.getNavigator());
    }

    @Override
    public Number numberValueOf(Object object) throws JaxenException {
        Context context = this.getContext(object);
        Object object2 = this.selectSingleNodeForContext(context);
        if (object2 == null) {
            return null;
        }
        return NumberFunction.evaluate(object2, context.getNavigator());
    }

    @Override
    public void addNamespace(String string, String string2) throws JaxenException {
        NamespaceContext namespaceContext = this.getNamespaceContext();
        if (namespaceContext instanceof SimpleNamespaceContext) {
            ((SimpleNamespaceContext)namespaceContext).addNamespace(string, string2);
            return;
        }
        throw new JaxenException("Operation not permitted while using a custom namespace context.");
    }

    @Override
    public void setNamespaceContext(NamespaceContext namespaceContext) {
        this.getContextSupport().setNamespaceContext(namespaceContext);
    }

    @Override
    public void setFunctionContext(FunctionContext functionContext) {
        this.getContextSupport().setFunctionContext(functionContext);
    }

    @Override
    public void setVariableContext(VariableContext variableContext) {
        this.getContextSupport().setVariableContext(variableContext);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        NamespaceContext namespaceContext = this.getContextSupport().getNamespaceContext();
        if (namespaceContext == null) {
            namespaceContext = this.createNamespaceContext();
            this.getContextSupport().setNamespaceContext(namespaceContext);
        }
        return namespaceContext;
    }

    @Override
    public FunctionContext getFunctionContext() {
        FunctionContext functionContext = this.getContextSupport().getFunctionContext();
        if (functionContext == null) {
            functionContext = this.createFunctionContext();
            this.getContextSupport().setFunctionContext(functionContext);
        }
        return functionContext;
    }

    @Override
    public VariableContext getVariableContext() {
        VariableContext variableContext = this.getContextSupport().getVariableContext();
        if (variableContext == null) {
            variableContext = this.createVariableContext();
            this.getContextSupport().setVariableContext(variableContext);
        }
        return variableContext;
    }

    public Expr getRootExpr() {
        return this.xpath.getRootExpr();
    }

    public String toString() {
        return this.xpath.getText();
    }

    public String debug() {
        return this.xpath.toString();
    }

    protected Context getContext(Object object) {
        if (object instanceof Context) {
            return (Context)object;
        }
        Context context = new Context(this.getContextSupport());
        if (object instanceof List) {
            context.setNodeSet((List)object);
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>(1);
            arrayList.add(object);
            context.setNodeSet(arrayList);
        }
        return context;
    }

    protected ContextSupport getContextSupport() {
        if (this.support == null) {
            this.support = new ContextSupport(this.createNamespaceContext(), this.createFunctionContext(), this.createVariableContext(), this.getNavigator());
        }
        return this.support;
    }

    @Override
    public Navigator getNavigator() {
        return this.navigator;
    }

    protected FunctionContext createFunctionContext() {
        return XPathFunctionContext.getInstance();
    }

    protected NamespaceContext createNamespaceContext() {
        return new SimpleNamespaceContext();
    }

    protected VariableContext createVariableContext() {
        return new SimpleVariableContext();
    }

    protected List selectNodesForContext(Context context) throws JaxenException {
        return this.xpath.asList(context);
    }

    protected Object selectSingleNodeForContext(Context context) throws JaxenException {
        List list = this.selectNodesForContext(context);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }
}

