/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.engine;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.URL;
import oracle.help.common.SimpleTopic;
import oracle.help.common.SimpleURLTarget;
import oracle.help.common.TopicTree;
import oracle.help.common.TopicTreeNode;
import oracle.help.common.View;
import oracle.help.engine.DataEngine;
import oracle.help.library.Book;

public class HHCEngine
extends DataEngine {
    protected StreamTokenizer _st = null;
    protected View _view;
    protected Book _book;
    protected static final String HHC_TOKEN_START = "<";
    protected static final String HHC_TOKEN_END = ">";
    protected static final String HHC_TOKEN_OBJECT = "object";
    protected static final String HHC_TOKEN_ENDOBJECT = "/object";
    protected static final String HHC_TOKEN_SUBTREE = "ul";
    protected static final String HHC_TOKEN_ENDSUBTREE = "/ul";
    protected static final String HHC_TOKEN_SITEMAP = "text/sitemap";
    protected static final String HHC_TOKEN_PARAM = "param";
    protected static final String HHC_TOKEN_PARAMNAME = "name=";
    protected static final String HHC_TOKEN_PARAMVALUE = "value=";
    protected static final String HHC_TOKEN_OBJTYPE = "type=";
    protected static final String HHC_PARAM_NAME = "name";
    protected static final String HHC_PARAM_LOCAL = "local";
    protected static final String HHC_PARAM_KEYWORD = "keyword";
    protected static final String HHC_PARAM_SECTION = "section title";
    protected static final String HHC_PARAM_TYPE = "type";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object createDataObject(View view, String basePath, URL url, String encoding) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("Null parameter passed to DataEngine constructor");
        }
        BufferedReader r = this._getBufferedReader(url, encoding);
        Object dataObject = null;
        try {
            dataObject = this.createDataObject(view, basePath, r);
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (Exception exception) {}
        }
        return dataObject;
    }

    public Object createDataObject(View view, String basePath, BufferedReader reader) throws IOException {
        String token;
        this._view = view;
        if (this._view != null) {
            this._book = this._view.getBook();
        }
        HHCReader hhcRead = new HHCReader(reader);
        this._st = new StreamTokenizer(hhcRead);
        this._st.wordChars(47, 47);
        this._st.wordChars(61, 61);
        this._st.wordChars(48, 57);
        this._st.quoteChar(34);
        this._st.ordinaryChar(39);
        TopicTree tree = new TopicTree(this._book, basePath);
        TopicTreeNode parent = tree.getRoot();
        while ((token = this.readToken()) != null) {
            if (!token.equals(HHC_TOKEN_START)) continue;
            token = this.readToken();
            if (token.equalsIgnoreCase(HHC_TOKEN_OBJECT)) {
                this.readObject(this._view, parent);
                continue;
            }
            if (token.equalsIgnoreCase(HHC_TOKEN_SUBTREE)) {
                if (parent.getNumChildren() <= 0) continue;
                parent = parent.getChildByIndex(parent.getNumChildren() - 1);
                continue;
            }
            if (!token.equalsIgnoreCase(HHC_TOKEN_ENDSUBTREE) || parent.getParent() == null) continue;
            parent = parent.getParent();
        }
        return tree;
    }

    protected void readObject(View view, TopicTreeNode parent) throws IOException {
        String token;
        String paramName = null;
        String paramValue = null;
        SimpleTopic objectTopic = null;
        TopicTreeNode node = null;
        while (!(token = this.readToken()).equals(HHC_TOKEN_END)) {
            if (!token.equals(HHC_TOKEN_OBJTYPE) || (token = this.readToken()).equalsIgnoreCase(HHC_TOKEN_SITEMAP)) continue;
            return;
        }
        while (true) {
            if (!(token = this.readToken()).equals(HHC_TOKEN_START)) {
                continue;
            }
            token = this.readToken();
            if (token.equalsIgnoreCase(HHC_TOKEN_ENDOBJECT)) break;
            if (!token.equalsIgnoreCase(HHC_TOKEN_PARAM)) continue;
            paramName = null;
            paramValue = null;
            token = this.readToken();
            while (!token.equals(HHC_TOKEN_END)) {
                if (token.equalsIgnoreCase(HHC_TOKEN_PARAMNAME)) {
                    paramName = this.readToken();
                } else if (token.equalsIgnoreCase(HHC_TOKEN_PARAMVALUE)) {
                    paramValue = this.readToken();
                }
                token = this.readToken();
            }
            if (paramName == null || paramValue == null) continue;
            if (paramName.equalsIgnoreCase(HHC_PARAM_NAME)) {
                objectTopic = new SimpleTopic(paramValue);
                node = new TopicTreeNode(this._view, objectTopic);
                continue;
            }
            if (!paramName.equalsIgnoreCase(HHC_PARAM_LOCAL)) continue;
            SimpleURLTarget currentTarget = new SimpleURLTarget(this._view, paramValue);
            if (objectTopic == null) continue;
            objectTopic.setTarget(currentTarget);
        }
        if (node != null) {
            parent.addChild(node);
        }
    }

    protected String readToken() throws IOException {
        int tokenType = this._st.nextToken();
        switch (tokenType) {
            case -3: 
            case 34: {
                return this._st.sval;
            }
            case -1: {
                return null;
            }
        }
        return new StringBuffer().append((char)tokenType).toString();
    }

    private class HHCReader
    extends Reader {
        Reader _realReader;
        boolean _wasBackSlash = false;

        public HHCReader(Reader realReader) {
            this._realReader = realReader;
        }

        @Override
        public int read() throws IOException {
            int returnChar;
            if (this._wasBackSlash) {
                returnChar = 92;
                this._wasBackSlash = false;
            } else {
                returnChar = this._realReader.read();
                if ((char)returnChar == '\\') {
                    this._wasBackSlash = true;
                }
            }
            return returnChar;
        }

        @Override
        public int read(char[] cbuf) throws IOException {
            return this.read(cbuf, 0, cbuf.length);
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int numRead;
            int offset = off;
            int aChar = 0;
            for (numRead = 0; numRead < len && numRead + offset < cbuf.length && (aChar = this.read()) != -1; ++numRead) {
                cbuf[offset + numRead] = (char)aChar;
            }
            if (numRead == 0 && aChar == -1) {
                return -1;
            }
            return numRead;
        }

        @Override
        public long skip(long n) throws IOException {
            return super.skip(n);
        }

        @Override
        public boolean ready() throws IOException {
            return this._realReader.ready();
        }

        @Override
        public boolean markSupported() {
            return this._realReader.markSupported();
        }

        @Override
        public void mark(int readAheadLimit) throws IOException {
            this._realReader.mark(readAheadLimit);
        }

        @Override
        public void reset() throws IOException {
            this._wasBackSlash = false;
            this._realReader.reset();
        }

        @Override
        public void close() throws IOException {
            this._realReader.close();
        }
    }
}

