/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.xml;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.help.common.xml.Parser;
import oracle.help.common.xml.XMLNode;
import oracle.help.common.xml.XMLParseException;
import oracle.help.common.xml.XMLToken;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class HelpXmlPullParser
implements Parser {
    private static final Logger _LOGGER = Logger.getLogger(HelpXmlPullParser.class.getName(), "oracle.help.share.resource.LoggerBundle");
    private XMLNode _root;

    public HelpXmlPullParser(Reader reader, String location) {
        try {
            LaxParser xpp = new LaxParser();
            xpp.setInput(reader);
            this._processDocument(xpp);
        }
        catch (XmlPullParserException xppe) {
            if (location != null) {
                _LOGGER.log(Level.WARNING, "HELP-00001", location);
            }
            _LOGGER.log(Level.WARNING, xppe.getLocalizedMessage(), xppe);
        }
        catch (IOException ioe) {
            if (location != null) {
                _LOGGER.log(Level.WARNING, "HELP-00002", location);
            }
            _LOGGER.log(Level.WARNING, ioe.getLocalizedMessage(), ioe);
        }
    }

    public HelpXmlPullParser(InputStream in, String location) {
        try {
            LaxParser xpp = new LaxParser();
            String encoding = null;
            if (!xpp.getFeature("http://xmlpull.org/v1/doc/features.html#detect-encoding")) {
                encoding = "UTF-8";
            }
            xpp.setInput(in, encoding);
            this._processDocument(xpp);
        }
        catch (XmlPullParserException xppe) {
            if (location != null) {
                _LOGGER.log(Level.WARNING, "HELP-00001", location);
            }
            _LOGGER.log(Level.WARNING, xppe.getLocalizedMessage(), xppe);
        }
        catch (IOException ioe) {
            if (location != null) {
                _LOGGER.log(Level.WARNING, "HELP-00002", location);
            }
            _LOGGER.log(Level.WARNING, ioe.getLocalizedMessage(), ioe);
        }
    }

    private void _processDocument(XmlPullParser xpp) throws XmlPullParserException, IOException {
        String rootElementName = null;
        XMLNode parent = new XMLNode();
        XMLNode realNode = new XMLNode();
        int eventType = xpp.getEventType();
        do {
            String name = xpp.getName();
            if (eventType == 0) {
                this._root = new XMLNode();
                this._root.setLineNumber(xpp.getLineNumber());
                parent = this._root;
                realNode = null;
            } else if (eventType != 1) {
                if (eventType == 2) {
                    if (rootElementName == null) {
                        rootElementName = name;
                    }
                    try {
                        HashMap<String, String> properties = new HashMap<String, String>(11);
                        for (int i = 0; i < xpp.getAttributeCount(); ++i) {
                            properties.put(xpp.getAttributeName(i), xpp.getAttributeValue(i));
                        }
                        XMLToken token = new XMLToken(name, 1, properties);
                        realNode = new XMLNode(token, parent);
                        realNode.setLineNumber(xpp.getLineNumber());
                        parent = realNode;
                    }
                    catch (XMLParseException xpe) {
                        _LOGGER.log(Level.WARNING, "", xpe);
                    }
                } else if (eventType == 3) {
                    parent = parent.getParent();
                    if (name.equals(rootElementName)) {
                        eventType = 1;
                        continue;
                    }
                } else if (eventType == 4) {
                    String text = xpp.getText();
                    if (realNode != null && !text.trim().equals("")) {
                        realNode.setString(text);
                    }
                }
            }
            eventType = xpp.next();
        } while (eventType != 1);
    }

    @Override
    public XMLNode getRoot() {
        return this._root;
    }

    private void _printRoot() {
        this.getRoot()._printTree("");
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Usage: java HelpXmlPullParser <filename>");
            System.exit(1);
        }
        try {
            FileReader reader = new FileReader(args[0]);
            HelpXmlPullParser parser = new HelpXmlPullParser(reader, args[0]);
            parser._printRoot();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
    }

    private class LaxParser
    extends MXParser {
        private LaxParser() {
        }

        @Override
        protected void parseXmlDecl(char ch) throws XmlPullParserException, IOException {
            while ((ch = this.more()) != '>') {
            }
        }

        @Override
        protected char parseAttribute() throws XmlPullParserException, IOException {
            int returnValue;
            block6: {
                returnValue = 34;
                int prevPosStart = this.posStart + this.bufAbsoluteStart;
                try {
                    returnValue = super.parseAttribute();
                }
                catch (XmlPullParserException xpe) {
                    boolean handledBadDefaultAttr = false;
                    try {
                        String name = this.attributeName[this.attributeCount];
                        if ("default".equals(name)) {
                            char ch;
                            while ('e' != (ch = this.more())) {
                            }
                            this.attributeValue[this.attributeCount] = "false";
                            ++this.attributeCount;
                            this.posStart = prevPosStart - this.bufAbsoluteStart;
                            returnValue = 34;
                            handledBadDefaultAttr = true;
                        }
                    }
                    catch (Exception e) {
                        handledBadDefaultAttr = false;
                    }
                    if (handledBadDefaultAttr) break block6;
                    throw xpe;
                }
            }
            return (char)returnValue;
        }
    }
}

