/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.editor;

import java.awt.Component;
import javax.swing.JTextField;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.editor.EditorComponentFactory;
import oracle.bali.inspector.editor.EditorComponentInfo;
import oracle.bali.inspector.editor.TextFieldEditor;

public class TextFieldEditorFactory
extends EditorComponentFactory {
    @Override
    public boolean canCreateEditorFrom(Object creationInfo) {
        if (creationInfo instanceof EditorComponentInfo) {
            Object initialValue = ((EditorComponentInfo)creationInfo).initialValue();
            return this.isNullOrString(initialValue);
        }
        return this.isNullOrString(creationInfo);
    }

    protected final boolean isNullOrString(Object o) {
        return o == null || o instanceof String;
    }

    @Override
    public JTextField createInlineEditor(PropertyEditorFactory2 propertyEditor) {
        Object initialValue = this.initialValueFrom(propertyEditor);
        if (!this.canCreateEditorFrom(initialValue)) {
            return null;
        }
        return this.textField((String)initialValue);
    }

    @Override
    public JTextField updateInlineEditor(Component current, PropertyEditorFactory2 propertyEditor) {
        Object initialValue = this.initialValueFrom(propertyEditor);
        if (!this.canCreateEditorFrom(initialValue)) {
            return null;
        }
        JTextField editor = this.textField(current, (String)initialValue, propertyEditor);
        return editor;
    }

    protected JTextField textField(Component c, String initialValue, PropertyEditorFactory2 propertyEditor) {
        if (c instanceof JTextField) {
            JTextField textField = (JTextField)c;
            String currentValue = textField.getText();
            if (currentValue == null) {
                currentValue = "";
            }
            if (!currentValue.equals(initialValue)) {
                textField.setText(initialValue);
            }
            return textField;
        }
        return this.textField(initialValue);
    }

    protected JTextField textField(String initialValue) {
        return new TextFieldEditor(initialValue);
    }
}

