/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.beans;

class BeansPropertyID {
    private static final int _NO_HASHCODE = -1;
    private String _propertyName;
    private Class _propertyType;
    private boolean _isIndexed;
    private transient int _hashCode;

    public BeansPropertyID(String propertyName, Class propertyType, boolean isIndexed) {
        if (propertyName == null || propertyType == null && !isIndexed) {
            throw new IllegalArgumentException();
        }
        this._hashCode = -1;
        this._propertyName = propertyName;
        this._propertyType = propertyType;
        this._isIndexed = isIndexed;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    public int hashCode() {
        if (this._hashCode == -1) {
            int hashCode = this._propertyName.hashCode();
            if (this._propertyType != null) {
                hashCode ^= this._propertyType.hashCode();
            }
            if (this._isIndexed) {
                ++hashCode;
            }
            this._hashCode = hashCode;
        }
        return this._hashCode;
    }

    public boolean equals(Object compareTo) {
        if (compareTo == this) {
            return true;
        }
        if (compareTo instanceof BeansPropertyID) {
            BeansPropertyID comparedPropertyID = (BeansPropertyID)compareTo;
            return comparedPropertyID._isIndexed == this._isIndexed && comparedPropertyID._propertyType == this._propertyType && comparedPropertyID._propertyName.equals(this._propertyName);
        }
        return false;
    }

    public String toString() {
        String debugString = this.getClass().getName() + " [name=" + this._propertyName + ", type=" + this._propertyType;
        if (this._isIndexed) {
            debugString = debugString + ", indexed";
        }
        debugString = debugString + "]";
        return debugString;
    }
}

