/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.inspector.PropertyInspector;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;

public class PropertyInspectorContainer
extends JComponent
implements Accessible {
    public static final String PROPERTY_SELECTED_COMPONENT = "selectedComponent";
    private static final String __RESOURCE_BUNDLE = "oracle.bali.inspector.resource.InspectorBundle";
    private static final String _KEY_PROPERTIES = "PROPERTIES";
    private boolean _nameDefaulted;
    private UIListener _listener;
    private JTabbedPane _tabPane;

    public PropertyInspectorContainer() {
        this(null);
    }

    public PropertyInspectorContainer(PropertyInspector inspector) {
        if (inspector == null) {
            inspector = new PropertyInspector();
        }
        this._listener = new UIListener();
        this.setLayout(new BorderLayout(0, 0));
        this.setBackground(UIManager.getColor(LookAndFeel.DARK_INTENSITY));
        this.setOpaque(true);
        this._tabPane = new JTabbedPane(3);
        this._tabPane.addChangeListener(this._listener);
        JPanel border = new JPanel(new BorderLayout());
        border.setBorder(new EmptyBorder(0, 0, 3, 0));
        border.add("Center", this._tabPane);
        this.add("Center", border);
        String translatedString = this._getTranslatedString(_KEY_PROPERTIES);
        this._nameDefaulted = true;
        this.addInspector(inspector, StringUtils.stripMnemonic((String)translatedString));
    }

    public final void addInspector(Component component, String title) {
        this.addInspector(component, title, this.getInspectorCount());
    }

    public void addInspector(Component component, String title, int index) {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (index < 0 || index >= this.getInspectorCount()) {
            index = this.getInspectorCount();
        }
        this._tabPane.insertTab(title, null, component, null, index);
        this.invalidate();
        this.repaint();
    }

    public void removeInspector(Component component) {
        int index = this._tabPane.indexOfComponent(component);
        if (index != -1) {
            if (component instanceof PropertyInspector) {
                this._commitEdit((PropertyInspector)component);
            }
            this._tabPane.removeTabAt(index);
            this.invalidate();
            this.repaint();
        }
    }

    public void removeAllInspectors() {
        int count = this.getInspectorCount();
        for (int i = count - 1; i >= 0; --i) {
            this.removeInspector(this.getInspector(i));
        }
    }

    public int getInspectorCount() {
        return this._tabPane.getTabCount();
    }

    public Component getInspector(int index) {
        if (index < 0 || index >= this.getInspectorCount()) {
            return null;
        }
        return this._tabPane.getComponentAt(index);
    }

    public Component getSelectedComponent() {
        return this._tabPane.getSelectedComponent();
    }

    public void setSelectedComponent(Component component) {
        int index;
        Component old = this._tabPane.getSelectedComponent();
        if (old instanceof PropertyInspector) {
            this._commitEdit((PropertyInspector)old);
        }
        if ((index = this._tabPane.indexOfComponent(component)) != -1) {
            this._tabPane.setSelectedIndex(index);
        }
    }

    public final PropertyInspector getSelectedInspector() {
        Component c = this.getSelectedComponent();
        return c instanceof PropertyInspector ? (PropertyInspector)c : null;
    }

    public String getComponentTitle(Component component) {
        int index = this._tabPane.indexOfComponent(component);
        if (index != -1) {
            return this._tabPane.getTitleAt(index);
        }
        return null;
    }

    public void setComponentTitle(Component component, String title) {
        int index = this._tabPane.indexOfComponent(component);
        if (index != -1) {
            this._tabPane.setTitleAt(index, title);
            this._nameDefaulted = false;
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._tabPane.setEnabled(enabled);
        for (int i = 0; i < this._tabPane.getTabCount(); ++i) {
            this._tabPane.setEnabledAt(i, enabled);
            this._tabPane.getComponentAt(i).setEnabled(enabled);
        }
    }

    @Override
    public void setLocale(Locale newLocale) {
        super.setLocale(newLocale);
        this._updateLabels();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._updateLabels();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                @Override
                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PANEL;
                }
            };
        }
        return this.accessibleContext;
    }

    private void _updateLabels() {
        if (this._nameDefaulted) {
            String translatedString = this._getTranslatedString(_KEY_PROPERTIES);
            this._tabPane.setTitleAt(0, StringUtils.stripMnemonic((String)translatedString));
        }
    }

    private String _getTranslatedString(String key) {
        ResourceBundle b = ResourceBundle.getBundle(__RESOURCE_BUNDLE, LocaleUtils.getDefaultableLocale((Component)this));
        return b.getString(key);
    }

    @Override
    protected void firePropertyChange(String name, Object old, Object newValue) {
        super.firePropertyChange(name, old, newValue);
    }

    private void _commitEdit(PropertyInspector pi) {
        pi.__commitEdit();
    }

    private class UIListener
    implements ChangeListener {
        private UIListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Component content = PropertyInspectorContainer.this._tabPane.getSelectedComponent();
            PropertyInspectorContainer.this.firePropertyChange(PropertyInspectorContainer.PROPERTY_SELECTED_COMPONENT, null, PropertyInspectorContainer.this.getSelectedComponent());
        }
    }
}

