/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.ref;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import oracle.jdbc.OracleResultSet;
import sqlj.runtime.ForUpdate;
import sqlj.runtime.ResultSetIterator;
import sqlj.runtime.error.RuntimeRefErrors;
import sqlj.runtime.profile.RTResultSet;

public class ResultSetIterImpl
implements ResultSetIterator {
    protected OracleResultSet m_ors;
    protected RTResultSet resultSet;
    protected boolean resultSetWentOut = false;

    public ResultSetIterImpl(RTResultSet rTResultSet) {
        this.resultSet = rTResultSet;
    }

    public ResultSetIterImpl(ResultSet resultSet, RTResultSet rTResultSet) {
        this.resultSet = rTResultSet;
        this.m_ors = (OracleResultSet)resultSet;
    }

    public ResultSetIterImpl(RTResultSet rTResultSet, int n) throws SQLException {
        this(rTResultSet);
        try {
            ResultSetIterImpl.checkColumns(rTResultSet, n);
        }
        catch (SQLException sQLException) {
            if (this instanceof ForUpdate) {
                try {
                    ResultSetIterImpl.checkColumns(rTResultSet, n - 1);
                }
                catch (SQLException sQLException2) {
                    this.close();
                    throw sQLException2;
                }
            }
            this.close();
            throw sQLException;
        }
    }

    public static void checkColumns(RTResultSet rTResultSet, int n) throws SQLException {
        int n2 = rTResultSet.getColumnCount();
        if (n2 != n) {
            RuntimeRefErrors.raise_WRONG_NUM_COLS(n, n2);
        }
    }

    protected int findColumn(String string) throws SQLException {
        try {
            return this.resultSet.findColumn(string);
        }
        catch (SQLException sQLException) {
            if (this instanceof ForUpdate && string.equals("sjT_rowid")) {
                return 0;
            }
            this.close();
            throw sQLException;
        }
    }

    public ResultSet getResultSet() throws SQLException {
        this.resultSetWentOut = true;
        return this.resultSet.getJDBCResultSet();
    }

    public void close() throws SQLException {
        this.resultSet.close();
    }

    public boolean isClosed() throws SQLException {
        return this.resultSet.isClosed();
    }

    public String getCursorName() throws SQLException {
        return this.resultSet.getCursorName();
    }

    public boolean endFetch() throws SQLException {
        return !this.resultSet.isValidRow();
    }

    public boolean next() throws SQLException {
        return this.resultSet.next();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.resultSet.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this.resultSet.clearWarnings();
    }

    public int getFetchSize() throws SQLException {
        if (this.m_ors != null) {
            return this.m_ors.getFetchSize();
        }
        return this.resultSet.getFetchSize();
    }

    public void setFetchSize(int n) throws SQLException {
        if (this.m_ors != null) {
            this.m_ors.setFetchSize(n);
        } else {
            this.resultSet.setFetchSize(n);
        }
    }

    public int getSensitivity() throws SQLException {
        if (this.m_ors != null) {
            int n = this.m_ors.getType();
            return n == 1005 || n == 1004 ? n : 1006;
        }
        return this.resultSet.getSensitivity();
    }

    public Object getImplicitRowid() throws SQLException {
        try {
            int n = this.findColumn("sjT_rowid");
            return this.resultSet.getJDBCResultSet().getObject(n);
        }
        catch (SQLException sQLException) {
            throw new SQLException("Can not use this iterator with 'where current of'");
        }
    }
}

