/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xml;

import oracle.dss.util.persistence.ObjectScope;
import oracle.dss.util.xml.BaseNode;
import oracle.javatools.annotations.Concealed;
import oracle.xml.parser.v2.XMLText;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

@Concealed
public class PropertyNode
extends BaseNode {
    private static final long serialVersionUID = 1L;
    protected Object m_value;

    PropertyNode(ObjectScope scope, Node node) {
        super(scope, node);
        if (node instanceof Attr) {
            this.m_name = ((Attr)node).getName();
            this.m_value = ((Attr)node).getValue();
        } else if (node instanceof Element) {
            this.m_name = ((Element)node).getTagName();
            Element elem = (Element)node;
            Node value = elem.getFirstChild();
            if (value instanceof Text) {
                this.m_value = ((XMLText)value).getNodeValue();
            }
        }
    }

    public PropertyNode(String name, String value) {
        super(name);
        if (value == null) {
            value = "";
        }
        this.m_value = value;
        this.initBuffer();
        this.m_buffer.append("<");
        this.m_buffer.append(name);
        this.m_buffer.append(">");
        this.m_buffer.append(PropertyNode.createEscapes(value));
        this.m_buffer.append("</");
        this.m_buffer.append(name);
        this.m_buffer.append(">");
    }

    public PropertyNode(String name, boolean value) {
        this(name, Boolean.toString(value));
    }

    public PropertyNode(String name, int value) {
        this(name, Integer.toString(value));
    }

    public PropertyNode(String name, long value) {
        this(name, Long.toString(value));
    }

    public PropertyNode(String name, double value) {
        this(name, Double.toString(value));
    }

    public PropertyNode(String name, char value) {
        this(name, Character.toString(value));
    }

    public String getValueAsString() {
        if (this.m_value == null) {
            this.m_value = "";
        }
        return (String)this.m_value;
    }

    public boolean getValueAsBoolean() {
        return Boolean.valueOf((String)this.m_value);
    }

    public int getValueAsInteger() {
        return Integer.valueOf((String)this.m_value);
    }

    public double getValueAsDouble() {
        return Double.valueOf((String)this.m_value);
    }

    public long getValueAsLong() {
        return Long.valueOf((String)this.m_value);
    }

    public char getValueAsCharacter() {
        if (((String)this.m_value).length() == 0) {
            return '\u0000';
        }
        return ((String)this.m_value).charAt(0);
    }
}

