/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.transform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.LayerSortInfo;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.Utility;
import oracle.dss.util.transform.CommonComparator;
import oracle.dss.util.transform.ComparatorInterface;
import oracle.dss.util.transform.DataAccessLong;
import oracle.dss.util.transform.EdgeTree;
import oracle.dss.util.transform.EdgeTreeNode;
import oracle.dss.util.transform.MemberInterface;
import oracle.dss.util.transform.TransformException;
import oracle.dss.util.transform.TransformRuntimeException;
import oracle.dss.util.transform.TreeNode;
import oracle.dss.util.transform.TreeNodeWrapperMemberInterface;
import oracle.javatools.annotations.Concealed;

@Deprecated
@Concealed
public class EdgeTreeChildren
extends ArrayList<EdgeTreeNode>
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private List<EdgeTreeNode> m_unreplacedNodes = new ArrayList<EdgeTreeNode>();
    private Hashtable<String, EdgeTreeNode[]> m_lookupTable = new Hashtable();

    public Object clone(EdgeTree tree, EdgeTreeNode parent, boolean caching) throws CloneNotSupportedException {
        EdgeTreeNode node;
        EdgeTreeChildren children = (EdgeTreeChildren)super.clone();
        children.m_unreplacedNodes = new ArrayList<EdgeTreeNode>();
        children.clear();
        Iterator<Object> nodes = super.iterator();
        EdgeTreeNode newNode = null;
        while (nodes.hasNext()) {
            node = (EdgeTreeNode)nodes.next();
            if (node != null) {
                newNode = (EdgeTreeNode)node.clone(tree, parent, caching);
                children.add(newNode);
                continue;
            }
            children.add(null);
        }
        children.m_lookupTable = null;
        children.m_unreplacedNodes.clear();
        nodes = this.m_unreplacedNodes.iterator();
        newNode = null;
        while (nodes.hasNext()) {
            node = (EdgeTreeNode)nodes.next();
            if (node != null) {
                newNode = (EdgeTreeNode)node.clone(tree, parent, caching);
                children.m_unreplacedNodes.add(newNode);
                continue;
            }
            children.m_unreplacedNodes.add(null);
        }
        return children;
    }

    @Override
    public boolean add(EdgeTreeNode node) {
        if (this.duplicate(super.size() - 1, node)) {
            return false;
        }
        boolean retVal = super.add(node);
        this.m_unreplacedNodes.add(node);
        try {
            if (node != null) {
                String value = node.getMember().getValue();
                this._updateLookupTable(value, node);
            }
        }
        catch (TransformException e) {
            throw new TransformRuntimeException(e.getMessage(), e);
        }
        return retVal;
    }

    private void _updateLookupTable(String value, EdgeTreeNode location) {
        if (this.m_lookupTable == null) {
            return;
        }
        EdgeTreeNode[] locs = value != null ? this.m_lookupTable.get(value) : null;
        EdgeTreeNode[] newLocs = null;
        if (locs == null) {
            locs = new EdgeTreeNode[]{location};
            newLocs = locs;
        } else {
            newLocs = new EdgeTreeNode[locs.length + 1];
            System.arraycopy(locs, 0, newLocs, 0, locs.length);
            newLocs[locs.length] = location;
        }
        if (value != null) {
            this.m_lookupTable.put(value, newLocs);
        }
    }

    private boolean duplicate(int pos, EdgeTreeNode node) {
        if (pos != -1 && pos < super.size()) {
            EdgeTreeNode existingNode = (EdgeTreeNode)super.get(pos);
            if (node != null && node.equals(existingNode)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void add(int pos, EdgeTreeNode node) {
        if (this.duplicate(pos, node)) {
            return;
        }
        super.add(pos, node);
        this.m_unreplacedNodes.add(pos, node);
        if (node != null) {
            try {
                String value = node.getMember().getValue();
                this._updateLookupTable(value, node);
            }
            catch (TransformException e) {
                throw new TransformRuntimeException(e.getMessage(), e);
            }
        }
    }

    public void release() {
        for (EdgeTreeNode node : this) {
            node.release();
        }
        this.clear();
        this.m_unreplacedNodes.clear();
    }

    protected EdgeTreeNode getChild(long pos) {
        if (pos > -1L && pos < (long)this.size()) {
            return (EdgeTreeNode)this.get((int)pos);
        }
        return null;
    }

    public EdgeTreeNode addChild(EdgeTreeNode childNode, TreeNode treeNode, String insertLocation, boolean above, boolean alwaysAdd, boolean replace, LayerSortInfo sortInfo) throws TransformException {
        EdgeTreeNode alreadyThereNode = this.findChild(childNode);
        if (alreadyThereNode != null && !alwaysAdd) {
            return alreadyThereNode;
        }
        if (insertLocation != null) {
            EdgeTreeNode node = this.findChild(insertLocation);
            if (node != null) {
                long index = node.getPosition();
                if (above) {
                    this._addChild(childNode, treeNode, (int)index, replace);
                } else {
                    this._addChild(childNode, treeNode, (int)index + 1, replace);
                }
            }
        } else {
            this._simpleAddChild(childNode, treeNode, above, replace, sortInfo);
        }
        return childNode;
    }

    private void _simpleAddChild(EdgeTreeNode node, TreeNode treeNode, boolean above, boolean replace, LayerSortInfo sortInfo) throws TransformException {
        if (node.isTotalNode()) {
            if (above) {
                this._addChild(node, treeNode, 0, replace);
            } else {
                this._addChild(node, treeNode, -1, replace);
            }
        } else {
            int locToInsert = this._getLocationToInsert(above, node, sortInfo);
            this._addChild(node, treeNode, locToInsert, replace);
        }
    }

    private void _addChild(EdgeTreeNode nodeToAdd, TreeNode node, int pos, boolean replace) throws TransformException {
        if (replace) {
            this.clear();
            pos = -1;
        }
        if (pos != -1) {
            this.add(pos, nodeToAdd);
        } else {
            this.add(nodeToAdd);
        }
        if (nodeToAdd.needAggregateSibling()) {
            boolean before;
            EdgeTreeNode aggSiblingNode = nodeToAdd.m_tree.getEdgeTreeNode(true, nodeToAdd.getParent(), nodeToAdd.m_value, node, nodeToAdd.getLayerName());
            boolean bl = before = nodeToAdd.getAggregatePosition() == MemberInterface.AggregatePosition.BEFORE;
            if (pos != -1) {
                if (before) {
                    this.add(pos, aggSiblingNode);
                } else {
                    this.add(pos + 1, aggSiblingNode);
                }
            } else if (before) {
                this.add(this.size() - 1, aggSiblingNode);
            } else {
                this.add(aggSiblingNode);
            }
        }
    }

    private int _getLocationToInsert(boolean above, EdgeTreeNode nodeToInsert, LayerSortInfo sortInfo) throws TransformException {
        int size;
        int pos = 0;
        if (above) {
            for (EdgeTreeNode node : this) {
                if (!node.isTotalNode()) {
                    return this._sortedPosition(pos, -1, nodeToInsert, sortInfo);
                }
                ++pos;
            }
            return pos;
        }
        pos = size = this.size();
        for (int i = size - 1; i >= 0; --i) {
            if (!((EdgeTreeNode)this.get(i)).isTotalNode()) {
                return this._sortedPosition(-1, pos, nodeToInsert, sortInfo);
            }
            --pos;
        }
        return 0;
    }

    private int _sortedPosition(int start, int end, EdgeTreeNode node, LayerSortInfo sortInfo) throws TransformException {
        int i;
        if (sortInfo == null || sortInfo.getLayer() == -1 || sortInfo.getDirection() == null || sortInfo.getDirection().length == 0) {
            if (start == -1) {
                return end;
            }
            return start;
        }
        int size = this.size();
        if (size == 0) {
            return 0;
        }
        if (end == -1) {
            start = 0;
            for (i = size - 1; i >= 0; --i) {
                if (((EdgeTreeNode)this.get(i)).isTotalNode()) continue;
                end = i;
                break;
            }
        }
        if (start == -1) {
            for (i = 0; i < size; ++i) {
                if (((EdgeTreeNode)this.get(i)).isTotalNode()) continue;
                start = i;
                break;
            }
        }
        int sortDirection = sortInfo.getDirection()[0];
        Object value = node.getMember().getMetadata("sortAttribute");
        return this._insert(start, end, value, new CommonComparator(sortDirection, sortInfo.isNullsFirst()));
    }

    private int _insert(int start, int end, Object value, Comparator comp) throws TransformException {
        Object currListValue = null;
        if (end <= start) {
            return start;
        }
        int m = start + (end - start) / 2;
        EdgeTreeNode node = (EdgeTreeNode)super.get(m);
        currListValue = node.getMember().getMetadata("sortAttribute");
        int compare = comp.compare(value, currListValue);
        if (compare > 0) {
            return this._insert(m + 1, end, value, comp);
        }
        if (compare < 0) {
            return this._insert(start, m - 1, value, comp);
        }
        return m;
    }

    protected void addAggregateSibling(EdgeTreeNode node, TreeNode treeNode, int pos) throws TransformException {
        if (node.needAggregateSibling()) {
            boolean before;
            EdgeTreeNode aggSiblingNode = node.m_tree.getEdgeTreeNode(true, node.getParent(), node.m_value, treeNode, node.getLayerName());
            node.setAllSibling(aggSiblingNode);
            boolean bl = before = node.getAggregatePosition() == MemberInterface.AggregatePosition.BEFORE;
            if (pos != -1) {
                if (before) {
                    this.add(pos, aggSiblingNode);
                } else {
                    this.add(pos + 1, aggSiblingNode);
                }
            } else if (before) {
                this.add(this.size() - 1, aggSiblingNode);
            } else {
                this.add(aggSiblingNode);
            }
        }
    }

    public EdgeTreeNode findFirstChild(boolean nonAggregate) throws TransformException {
        Iterator<EdgeTreeNode> children = this.m_unreplacedNodes.iterator();
        EdgeTreeNode currNode = null;
        while (children.hasNext()) {
            currNode = children.next();
            if (!nonAggregate) {
                return currNode;
            }
            if (nonAggregate && currNode.isTotalNode()) continue;
            return currNode;
        }
        return null;
    }

    public EdgeTreeNode findLastChild(boolean nonAggregate) throws TransformException {
        int size = this.m_unreplacedNodes.size();
        EdgeTreeNode currNode = null;
        for (int i = size - 1; i >= 0; --i) {
            currNode = this.m_unreplacedNodes.get(i);
            if (nonAggregate && currNode.isTotalNode()) continue;
            return currNode;
        }
        return null;
    }

    public EdgeTreeNode findChild(String value) throws TransformException {
        if (this.m_lookupTable == null) {
            Iterator children = this.iterator();
            EdgeTreeNode currNode = null;
            while (children.hasNext()) {
                currNode = (EdgeTreeNode)children.next();
                if (!Utility.compareObj(value, currNode.getMember().getValue())) continue;
                return currNode;
            }
            return null;
        }
        EdgeTreeNode[] locs = this.m_lookupTable.get(value);
        if (locs != null) {
            for (int i = 0; i < locs.length; ++i) {
                if (!value.equals(locs[i].getMember().getValue())) continue;
                return locs[i];
            }
        }
        return null;
    }

    public EdgeTreeNode findChild(EdgeTreeNode value) throws TransformException {
        if (this.m_lookupTable == null || value.getMember() == null || value.getMember().getValue() == null) {
            Iterator children = this.iterator();
            EdgeTreeNode currNode = null;
            while (children.hasNext()) {
                currNode = (EdgeTreeNode)children.next();
                if (!Utility.compareObj(value, currNode)) continue;
                return currNode;
            }
            return null;
        }
        EdgeTreeNode[] locs = this.m_lookupTable.get(value.getMember().getValue());
        if (locs != null) {
            for (int i = 0; i < locs.length; ++i) {
                if (!value.equals(locs[i])) continue;
                return locs[i];
            }
        }
        return null;
    }

    public EdgeTreeNode[] findAllChildren(String value, boolean nonAggregateOnly, boolean treatNullAsAll) throws TransformException {
        if (this.m_lookupTable != null && !this.m_lookupTable.isEmpty() && value != null) {
            EdgeTreeNode[] locs = this.m_lookupTable.get(value);
            if (locs != null) {
                if (nonAggregateOnly) {
                    ArrayList<EdgeTreeNode> nonAggNodes = new ArrayList<EdgeTreeNode>();
                    for (int i = 0; i < locs.length; ++i) {
                        if (locs[i].isAggregateNodeType()) continue;
                        nonAggNodes.add(locs[i]);
                    }
                    return nonAggNodes.toArray(new EdgeTreeNode[0]);
                }
                return locs;
            }
        } else {
            Iterator children = this.iterator();
            EdgeTreeNode currNode = null;
            ArrayList<EdgeTreeNode> nodes = new ArrayList<EdgeTreeNode>();
            while (children.hasNext()) {
                currNode = (EdgeTreeNode)children.next();
                if (value == null && treatNullAsAll) {
                    nodes.add(currNode);
                    continue;
                }
                if (!Utility.compareObj(value, currNode.getMember().getValue())) continue;
                if (nonAggregateOnly) {
                    if (currNode.isAggregateNodeType()) continue;
                    nodes.add(currNode);
                    continue;
                }
                nodes.add(currNode);
            }
            return nodes.toArray(new EdgeTreeNode[0]);
        }
        return null;
    }

    public EdgeTreeNode findChild(String value, boolean nonAggregateOnly, boolean treatNullAsAll) throws TransformException {
        EdgeTreeNode[] nodes = this.findAllChildren(value, nonAggregateOnly, treatNullAsAll);
        if (nodes != null && nodes.length > 0) {
            return nodes[0];
        }
        return null;
    }

    public EdgeTreeNode findChild(long slice, EdgeTreeNode.GetSlice get) throws TransformException {
        long m = 0L;
        long lower = 0L;
        long upper = this.size() - 1;
        FoundState foundState = FoundState.FOUND;
        while (upper >= 0L) {
            m = (lower + upper) / 2L;
            foundState = this._foundChild(m, slice, get);
            if (foundState == FoundState.FOUND) {
                EdgeTreeNode child = this.getChild(m);
                if (child != null && slice < child.getStart(EdgeTreeNode.GetSlice.GET_NO_SLICES, slice) + child.getSpan()) {
                    return child;
                }
                return null;
            }
            if (foundState == FoundState.HIGH) {
                lower = m + 1L;
                continue;
            }
            upper = m - 1L;
        }
        return null;
    }

    private FoundState _foundChild(long childLoc, long slice, EdgeTreeNode.GetSlice get) throws TransformException {
        EdgeTreeNode childNode = this.getChild(childLoc);
        long childStart = childNode.getStart(get, -1L);
        if (slice == childStart) {
            return FoundState.FOUND;
        }
        if (slice < childStart) {
            return FoundState.LOW;
        }
        EdgeTreeNode nextChild = this.getChild(childLoc + 1L);
        if (nextChild == null) {
            return FoundState.FOUND;
        }
        long nextChildStart = nextChild.getStart(get, -1L);
        return slice < nextChildStart ? FoundState.FOUND : FoundState.HIGH;
    }

    private boolean isTotal(EdgeTreeNode node) {
        if (node.isAggregateNodeType()) {
            return true;
        }
        TreeNodeWrapperMemberInterface mi = node.getMember();
        return mi != null ? mi.isTotal() : false;
    }

    private Object getSortDataValue(DataAccessLong da, int edge, int layer, long slice, long otherSlice) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException, RowOutOfRangeException, ColumnOutOfRangeException {
        if (layer > -1) {
            return da.getMemberMetadata(edge, layer, otherSlice, "sortAttribute");
        }
        return edge == 0 ? da.getValue(slice, otherSlice, "dataValue") : da.getValue(otherSlice, slice, "dataValue");
    }

    public void sort(int sortDir, boolean nullsFirst, DataAccessLong da, int edge, int sortLayer, long slice) throws TransformException {
        EdgeNodeSortElement[] children = new EdgeNodeSortElement[super.size()];
        int childCount = 0;
        Iterator iter = super.iterator();
        EdgeTreeNode node = null;
        long otherSlice = -1L;
        boolean aggsFirst = false;
        ArrayList<EdgeTreeNode> removeList = new ArrayList<EdgeTreeNode>();
        try {
            while (iter.hasNext()) {
                node = (EdgeTreeNode)iter.next();
                if (!this.isTotal(node)) {
                    otherSlice = node.getStart(EdgeTreeNode.GetSlice.GET_ALL_SLICES, -1L);
                    Object dataVal = this.getSortDataValue(da, edge, sortLayer, slice, otherSlice);
                    children[childCount++] = new EdgeNodeSortElement(node, dataVal);
                    removeList.add(node);
                    continue;
                }
                aggsFirst = childCount == 0;
            }
        }
        catch (Exception e) {
            throw new TransformException(e.getMessage(), e);
        }
        iter = removeList.iterator();
        EdgeTreeNode removeNode = null;
        while (iter.hasNext()) {
            removeNode = (EdgeTreeNode)iter.next();
            super.remove(removeNode);
            this.m_unreplacedNodes.remove(removeNode);
        }
        if (childCount != children.length) {
            EdgeNodeSortElement[] newChildren = new EdgeNodeSortElement[childCount];
            System.arraycopy(children, 0, newChildren, 0, newChildren.length);
            children = newChildren;
        }
        Arrays.sort(children, new CommonComparator(sortDir, nullsFirst));
        if (aggsFirst) {
            for (int i = 0; i < children.length; ++i) {
                super.add(children[i].m_node);
                this.m_unreplacedNodes.add(children[i].m_node);
            }
        } else {
            for (int i = children.length - 1; i >= 0; --i) {
                super.add(0, children[i].m_node);
                this.m_unreplacedNodes.add(0, children[i].m_node);
            }
        }
        if (this.m_lookupTable != null) {
            this.m_lookupTable.clear();
        }
    }

    public EdgeTreeNode getLastChild() {
        return this.getChild(this.size() - 1);
    }

    public void deleteChild(EdgeTreeNode node) throws TransformException {
        String value;
        EdgeTreeNode[] locs;
        super.remove(node);
        this.m_unreplacedNodes.remove(node);
        if (this.m_lookupTable != null && node != null && node.getMember() != null && node.getMember().getValue() != null && (locs = this.m_lookupTable.get(value = node.getMember().getValue())) != null) {
            for (int i = 0; i < locs.length; ++i) {
                if (!node.equals(locs[i])) continue;
                locs[i] = null;
                EdgeTreeNode[] newLocs = new EdgeTreeNode[locs.length - 1];
                int newLocLocation = 0;
                for (int j = 0; j < locs.length; ++j) {
                    if (locs[j] == null) continue;
                    newLocs[newLocLocation++] = locs[j];
                }
                this.m_lookupTable.remove(value);
                this.m_lookupTable.put(value, newLocs);
                return;
            }
        }
    }

    public void invalidate() throws TransformException {
        Iterator children = this.iterator();
        EdgeTreeNode currNode = null;
        while (children.hasNext()) {
            currNode = (EdgeTreeNode)children.next();
            currNode.invalidate();
        }
    }

    public void clearStart() throws TransformException {
        Iterator children = this.iterator();
        EdgeTreeNode currNode = null;
        while (children.hasNext()) {
            currNode = (EdgeTreeNode)children.next();
            currNode.clearStart();
        }
    }

    public void unlock() throws TransformException {
        Iterator children = this.iterator();
        EdgeTreeNode currNode = null;
        while (children.hasNext()) {
            currNode = (EdgeTreeNode)children.next();
            currNode.unlock();
        }
    }

    private static enum FoundState {
        FOUND,
        LOW,
        HIGH;

    }

    protected class EdgeNodeSortElement
    implements ComparatorInterface {
        protected EdgeTreeNode m_node = null;
        protected Object m_data = null;

        public EdgeNodeSortElement(EdgeTreeNode node, Object data) {
            this.m_node = node;
            this.m_data = data;
        }

        @Override
        public Object getValue() {
            return this.m_data;
        }
    }
}

