/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.parser.plsql.TabCol;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.controls.IActionUpdater;
import oracle.dbtools.raptor.controls.grid.EditableResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.GridFilterField;
import oracle.dbtools.raptor.controls.grid.GridFilterInsightProvider;
import oracle.dbtools.raptor.controls.grid.RSTMSql;
import oracle.dbtools.raptor.controls.grid.RaptorEditableGridTaskWrapper;
import oracle.dbtools.raptor.controls.grid.RaptorGridTable;
import oracle.dbtools.raptor.controls.grid.RaptorGridTaskWrapper;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.javatools.controls.completionfield.FieldInsightProvider;
import oracle.javatools.icons.OracleIcons;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.CHAR;

public class IMEditableResultSetTable
extends ResultSetTable {
    private DBObject m_dbObject = null;
    private IActionUpdater m_actionUpdater = null;
    private IMFetchTaskListener m_fetchTaskLsnr = null;
    private String m_table_alias = "T";
    private String m_view_alias = "V";
    public final String TABLE_ALIAS = "T.";
    public final String VIEW_ALIAS = "V.";
    private final Integer QUALIFIEDNAME = 0;
    private final Integer SRC_TYPE = 1;
    private final Integer ORIGINAL_IDENTIFIER = 2;
    private final Integer NEW_IDENTIFIER = 3;
    private final Integer TRANSFORMED = 4;
    private final String TRANSFORMED_VALUE = "Y";
    private List<String> m_uneditCols = new ArrayList<String>();
    protected static IMContextMenu m_imcm = null;
    protected IMController m_controller = null;

    public IMEditableResultSetTable(DBObject dBObject, IActionUpdater iActionUpdater) {
        this.m_dbObject = dBObject;
        this._editable = true;
        this.m_actionUpdater = iActionUpdater;
        this.m_controller = new IMController();
        this.m_controller.setGrid(this);
        this.init();
    }

    void init() {
        try {
            String string = this.buildSql();
            this.m_fetchTaskLsnr = new IMFetchTaskListener();
            ArrayList<IMFetchTaskListener> arrayList = new ArrayList<IMFetchTaskListener>();
            arrayList.add(this.m_fetchTaskLsnr);
            DBUtil dBUtil = DBUtil.getInstance((Connection)this.m_dbObject.getConnection());
            this.setQuery(this.m_dbObject.getConnectionName(), string, null, null);
            this.open((RaptorGridTaskWrapper)new RaptorEditableGridTaskWrapper(string, IRaptorTaskRunMode.MODAL, false, arrayList, null, null, null));
            this.addMouseListener(new IMMouseAdaptor());
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    private final String buildSql() throws Exception {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(this.QUALIFIEDNAME, "QUALIFIEDNAME");
        hashMap.put(this.SRC_TYPE, "SRC_TYPE");
        hashMap.put(this.ORIGINAL_IDENTIFIER, "ORIGINAL_IDENTIFIER");
        hashMap.put(this.NEW_IDENTIFIER, "NEW_IDENTIFIER");
        hashMap.put(this.TRANSFORMED, "TRANSFORMED");
        String string = this.getCaptureId(this.m_dbObject);
        Object object = "/* + INDEX_COMBINE ";
        object = (String)object + "(" + this.m_table_alias + " MD_DERIVATIVES_PERF_IDX MD_DERIVATIVES_PERF_IDX1 MD_DERIVATIVES_PERF_IDX2 MD_DERIVATIVES_PERF_IDX3) */";
        String string2 = "SELECT " + (String)object + " ";
        string2 = string2 + "V." + (String)hashMap.get(this.QUALIFIEDNAME) + ", ";
        string2 = string2 + "T." + (String)hashMap.get(this.SRC_TYPE) + ", ";
        string2 = string2 + "T." + (String)hashMap.get(this.ORIGINAL_IDENTIFIER) + ", ";
        string2 = string2 + "T." + (String)hashMap.get(this.NEW_IDENTIFIER) + ", ";
        string2 = string2 + "T." + (String)hashMap.get(this.TRANSFORMED) + " FROM MD_DERIVATIVES " + this.m_table_alias + ", MGV_ALL_DETAILS " + this.m_view_alias;
        string2 = string2 + " WHERE V.CONNID = " + string + " AND T.DERIVED_CONNECTION_ID_FK = " + string;
        string2 = string2 + " AND V.CAPTUREDORCONVERTED = 'CAPTURED' AND V.OBJTYPE = ";
        string2 = string2 + "T.SRC_TYPE AND V.OBJID = T.SRC_ID AND ";
        string2 = string2 + "T.DERIVATIVE_REASON = 'SCRATCH'";
        this.m_uneditCols.add((String)hashMap.get(this.QUALIFIEDNAME));
        this.m_uneditCols.add((String)hashMap.get(this.SRC_TYPE));
        this.m_uneditCols.add((String)hashMap.get(this.ORIGINAL_IDENTIFIER));
        this.m_uneditCols.add((String)hashMap.get(this.TRANSFORMED));
        return string2;
    }

    public void setQuery(String string, String string2, List<?> list, Map<String, ?> map) {
        IMResultSetTableModel iMResultSetTableModel = new IMResultSetTableModel(this.m_dbObject);
        iMResultSetTableModel.init(string2, string, list, map);
        iMResultSetTableModel.setVerticalDisplay(this.isVerticalDisplay());
        this.setModel((TableModel)((Object)iMResultSetTableModel));
    }

    public void setQuery(String string, String string2, List<?> list, Map<String, ?> map, DBObject dBObject) {
        this.setQuery(string, string2, list, map);
    }

    public IMResultSetTableModel getGridModel() {
        if (this.getModel() instanceof IMResultSetTableModel) {
            return (IMResultSetTableModel)((Object)this.getModel());
        }
        return null;
    }

    private String getCaptureId(DBObject dBObject) throws Exception {
        String string = null;
        String string2 = null;
        String string3 = dBObject.getObjectName();
        Connection connection = dBObject.getConnection();
        String string4 = "select distinct CONNNAME, CONNID from MGV_ALL_DETAILS";
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string4);
        boolean bl = false;
        while (resultSet.next()) {
            string = resultSet.getString(1);
            string2 = resultSet.getString(2);
            if (!string.equals(string3)) continue;
            bl = true;
            break;
        }
        statement.close();
        return string2;
    }

    public void setValueAt(Object object, int n, int n2) {
        String string = null;
        try {
            if (n2 == this.NEW_IDENTIFIER) {
                string = object instanceof CHAR ? ((CHAR)object).stringValue() : (String)object;
                String string2 = ((CHAR)this.getValueAt(n, this.ORIGINAL_IDENTIFIER)).getString();
                CHAR cHAR = (CHAR)this.getValueAt(n, this.TRANSFORMED);
                if (!string.equals(string2)) {
                    CHAR cHAR2 = new CHAR("Y", CHAR.DEFAULT_CHARSET);
                    if (cHAR == null || !cHAR.equals((Object)cHAR2)) {
                        this.getModel().setValueAt(cHAR2, this.convertRowIndexToModel(n), this.convertColumnIndexToModel(this.TRANSFORMED));
                    }
                } else {
                    CHAR cHAR3 = new CHAR("", CHAR.DEFAULT_CHARSET);
                    this.getModel().setValueAt(cHAR3, this.convertRowIndexToModel(n), this.convertColumnIndexToModel(this.TRANSFORMED));
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        super.setValueAt(object, n, n2);
    }

    public int getNewIdentifierColumn() {
        return this.NEW_IDENTIFIER;
    }

    public void generateDefaultNewIdentifiers() {
        try {
            ((IMResultSetTableModel)((Object)this.getModel())).fetchAllRows(true);
            int n = this.getModel().getRowCount();
            for (int i = 0; i < n; ++i) {
                String string;
                String string2 = ((CHAR)this.getValueAt(i, this.ORIGINAL_IDENTIFIER)).getString();
                String string3 = ((CHAR)this.getValueAt(i, this.NEW_IDENTIFIER)).getString();
                if (string3.equals(string = this.getDerivedIdentifier(string2))) continue;
                CHAR cHAR = new CHAR(string, CHAR.DEFAULT_CHARSET);
                this.setValueAt(cHAR, i, this.NEW_IDENTIFIER);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    public void generateDefaultSingleNewIdentifier() {
        int n = this.getSelectedRow();
        if (n >= 0) {
            try {
                if (this.isCellSelected(n, this.NEW_IDENTIFIER)) {
                    String string;
                    String string2 = ((CHAR)this.getValueAt(n, this.ORIGINAL_IDENTIFIER)).stringValue();
                    String string3 = ((CHAR)this.getValueAt(n, this.NEW_IDENTIFIER)).stringValue();
                    if (!string3.equals(string = this.getDerivedIdentifier(string2))) {
                        CHAR cHAR = new CHAR(string, CHAR.DEFAULT_CHARSET);
                        this.setValueAt(cHAR, n, this.NEW_IDENTIFIER);
                    }
                }
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
    }

    private String getDerivedIdentifier(String string) throws Exception {
        Connection connection;
        String string2 = null;
        if (this.m_dbObject != null && (connection = this.m_dbObject.getConnection()) != null) {
            OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("{call ?:= MIGRATION_TRANSFORMER.TRANSFORM_IDENTIFIER(?)}");
            oracleCallableStatement.registerOutParameter(1, 12);
            oracleCallableStatement.setString(2, string);
            oracleCallableStatement.execute();
            string2 = oracleCallableStatement.getString(1);
            oracleCallableStatement.close();
        }
        return string2;
    }

    public IMController getIMController() {
        return this.m_controller;
    }

    class IMFetchTaskListener
    extends RaptorTaskAdapter {
        IMFetchTaskListener() {
        }

        public void taskCancelled(final RaptorTaskEvent raptorTaskEvent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    IMFetchTaskListener.this.updateLog(raptorTaskEvent);
                    IMEditableResultSetTable.this.m_actionUpdater.updateActions();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    IMFetchTaskListener.this.updateLog(raptorTaskEvent);
                    IMEditableResultSetTable.this.m_actionUpdater.updateActions();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    IMEditableResultSetTable.this.m_actionUpdater.updateActions();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }

        void updateLog(RaptorTaskEvent raptorTaskEvent) {
        }
    }

    class IMController
    implements Controller {
        protected String ROLLBACK_CHANGES_CMD = "impanel.rollback";
        protected String COMMIT_CHANGES_CMD = "impanel.commit";
        protected String DEFAULT_ALL_CHANGES_CMD = "impanel.all.default";
        protected String DEFAULT_SELECT_CHANGES_CMD = "impanel.select.default";
        int COMMIT_CHANGES_ID = Ide.findOrCreateCmdID((String)this.COMMIT_CHANGES_CMD);
        int ROLLBACK_CHANGES_ID = Ide.findOrCreateCmdID((String)this.ROLLBACK_CHANGES_CMD);
        int DEFAULT_ALL_CHANGES_ID = Ide.findOrCreateCmdID((String)this.DEFAULT_ALL_CHANGES_CMD);
        int DEFAULT_SELECT_CHANGES_ID = Ide.findOrCreateCmdID((String)this.DEFAULT_SELECT_CHANGES_CMD);
        IdeAction COMMIT_ACTION = IdeAction.get((int)this.COMMIT_CHANGES_ID, null, (String)ConnectionArb.getString((String)"RDEP_COMMIT"), null, null, (Icon)OracleIcons.getIcon((String)"commit.png"), null, (boolean)false);
        IdeAction ROLLBACK_ACTION = IdeAction.get((int)this.ROLLBACK_CHANGES_ID, null, (String)ConnectionArb.getString((String)"RDEP_ROLLBACK"), null, null, (Icon)OracleIcons.getIcon((String)"rollback.png"), null, (boolean)false);
        IdeAction DEFAULT_ALL_ACTION = IdeAction.get((int)this.DEFAULT_ALL_CHANGES_ID, null, (String)MigrationAddinArb.getString("IDENT_ALL_DEFAULT"), null, null, (Icon)OracleIcons.getIcon((String)"default_activity.png"), null, (boolean)false);
        IdeAction DEFAULT_SELECT_ACTION = IdeAction.get((int)this.DEFAULT_SELECT_CHANGES_ID, null, (String)MigrationAddinArb.getString("IDENT_SEL_DEFAULT"), null, null, (Icon)OracleIcons.getIcon((String)"redo.png"), null, (boolean)false);
        private JLabel m_filterLabel = null;
        protected GridFilterField m_filter;
        protected IMEditableResultSetTable m_grid = null;
        protected Controller m_superController = null;

        public IMController() {
            this.DEFAULT_ALL_ACTION.addController((Controller)this);
            this.DEFAULT_SELECT_ACTION.addController((Controller)this);
            this.COMMIT_ACTION.addController((Controller)this);
            this.ROLLBACK_ACTION.addController((Controller)this);
            m_imcm = new IMContextMenu();
        }

        public void addToolBarActions(Toolbar toolbar) {
            toolbar.add((ToggleAction)this.DEFAULT_ALL_ACTION);
            this.DEFAULT_ALL_ACTION.addController((Controller)this);
            toolbar.add((ToggleAction)this.DEFAULT_SELECT_ACTION);
            this.DEFAULT_SELECT_ACTION.addController((Controller)this);
            toolbar.add((ToggleAction)this.COMMIT_ACTION);
            this.COMMIT_ACTION.addController((Controller)this);
            toolbar.add((ToggleAction)this.ROLLBACK_ACTION);
            this.ROLLBACK_ACTION.addController((Controller)this);
            this.m_filterLabel = new JLabel(MigrationAddinArb.getString("FILTER"));
            this.m_filter.getPopupHandler().registerInsightProvider((FieldInsightProvider)new GridFilterInsightProvider(this.m_filter));
            this.m_filter.getAccessibleContext().setAccessibleName(this.m_filterLabel.getText());
            this.m_filter.getAccessibleContext().setAccessibleName("Filter");
            this.m_filter.setEditable(true);
            toolbar.addSeparator();
            toolbar.add((Component)this.m_filterLabel);
            toolbar.add((Component)this.m_filter);
        }

        public void addContextMenuActions(ContextMenu contextMenu) {
            Context context = contextMenu.getContext();
            JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)this.DEFAULT_ALL_ACTION);
            contextMenu.add((Component)jMenuItem);
            jMenuItem = contextMenu.createMenuItem((ToggleAction)this.DEFAULT_SELECT_ACTION);
            contextMenu.add((Component)jMenuItem);
            jMenuItem = contextMenu.createMenuItem((ToggleAction)this.COMMIT_ACTION);
            contextMenu.add((Component)jMenuItem);
            jMenuItem = contextMenu.createMenuItem((ToggleAction)this.ROLLBACK_ACTION);
            contextMenu.add((Component)jMenuItem);
        }

        void setGrid(IMEditableResultSetTable iMEditableResultSetTable) {
            this.m_grid = iMEditableResultSetTable;
            this.m_filter = new GridFilterField((RaptorGridTable)this.m_grid);
            IMEditableResultSetTable.addGridContextMenu((GridContextMenuItem)m_imcm);
        }

        public void updateActions() {
            if (this.m_grid instanceof IMEditableResultSetTable) {
                IMEditableResultSetTable iMEditableResultSetTable = this.m_grid;
                this.DEFAULT_SELECT_ACTION.setEnabled(iMEditableResultSetTable.isCellSelected(iMEditableResultSetTable.getSelectedRow(), iMEditableResultSetTable.getNewIdentifierColumn()));
                if (!this.COMMIT_ACTION.isEnabled() && !this.ROLLBACK_ACTION.isEnabled()) {
                    this.m_filter.persistFilters();
                }
            }
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (!this.isCommitCommand(n) && !this.isRollbackCommand(n)) {
                if (this.isDefaultCommand(n)) {
                    this.m_grid.generateDefaultNewIdentifiers();
                } else if (this.isDefaultSingleCommand(n)) {
                    this.m_grid.generateDefaultSingleNewIdentifier();
                } else {
                    return this.m_superController.handleEvent(ideAction, context);
                }
            }
            return true;
        }

        public boolean update(IdeAction ideAction, Context context) {
            if (this.m_grid.getGridModel() == null) {
                return false;
            }
            if (this.m_grid.getGridModel().isBusy()) {
                return false;
            }
            int n = ideAction.getCommandId();
            if (!this.isCommitCommand(n) && !this.isRollbackCommand(n) && this.m_superController != null) {
                return this.m_superController.update(ideAction, context);
            }
            return true;
        }

        boolean isDefaultCommand(int n) {
            return n == this.DEFAULT_ALL_CHANGES_ID;
        }

        boolean isDefaultSingleCommand(int n) {
            return n == this.DEFAULT_SELECT_CHANGES_ID;
        }

        protected boolean isCommitCommand(int n) {
            return n == this.COMMIT_CHANGES_ID;
        }

        protected boolean isRollbackCommand(int n) {
            return n == this.ROLLBACK_CHANGES_ID;
        }
    }

    class IMMouseAdaptor
    extends MouseAdapter {
        IMMouseAdaptor() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            super.mouseClicked(mouseEvent);
            IMEditableResultSetTable.this.m_actionUpdater.updateActions();
        }
    }

    class IMResultSetTableModel
    extends EditableResultSetTableModel {
        boolean m_isCommited = true;
        DBObject m_dbObject = null;

        public IMResultSetTableModel(DBObject dBObject) {
            this.m_dbObject = dBObject;
        }

        public void setFilterClause(String string) {
            this._rstmsql.setWhereClauseFilter(string);
        }

        protected void init(String string, String string2, List<?> list, Map<String, ?> map) {
            super.init(string, string2, list, map);
            this._sql = string;
            this._rstmsql = new IMRSTMSql(this._sql);
            this._connName = string2;
            this._bindList = list;
            this._bindMap = map;
        }

        protected void fecthTableName() {
            if (this.m_dbObject != null && this._dbObject == null) {
                DBObject dBObject;
                DBUtil dBUtil = DBUtil.getInstance((String)this.m_dbObject.getConnectionName());
                this._dbObject = dBObject = DBObject.getDBObjectForName((String)"MD_DERIVATIVES", (String)this.m_dbObject.getConnectionName());
                this._tablename = dBUtil.addDbQuotes(dBObject.getObjectName());
                this._schemaName = dBUtil.addDbQuotes(dBObject.getSchemaName());
            }
        }

        public String getModifiedSql() {
            StringBuilder stringBuilder;
            block12: {
                stringBuilder = new StringBuilder();
                if (this._expandedSql == null) {
                    try {
                        if (!Connections.getInstance().isOracle(this.getConnectionName())) break block12;
                        TabCol tabCol = new TabCol(this.getConnectionName());
                        this._rstmsql.setTableName(this._tablename);
                        ArrayList arrayList = tabCol.fetchColumns(this._rstmsql.getModifiedSql());
                        String[] stringArray = null;
                        if (this._addRowIdColumn && this._addRowScnColumn) {
                            stringArray = new String[]{"T.ROWID", "T.ORA_ROWSCN"};
                        } else if (this._addRowIdColumn) {
                            stringArray = new String[]{"T.ROWID"};
                        } else if (this._addRowIdColumn) {
                            stringArray = new String[]{"T.ORA_ROWSCN"};
                        }
                        if (stringArray != null) {
                            stringBuilder = new StringBuilder(tabCol.disambiguate(arrayList, stringArray));
                            this._expandedSql = stringBuilder.toString();
                            break block12;
                        }
                        stringBuilder.append(this._rstmsql.getModifiedSql());
                    }
                    catch (Exception exception) {
                        stringBuilder.append(this._rstmsql.getModifiedSql());
                    }
                } else if (this._expandedSql != null) {
                    stringBuilder.append(this._rstmsql.getModifiedSql(this._expandedSql));
                } else {
                    stringBuilder.append(this._rstmsql.getModifiedSql());
                }
            }
            return RSTMSql.sanitizeSql((String)stringBuilder.toString());
        }
    }

    private class IMContextMenu
    extends GridContextMenuItem {
        private IMContextMenu() {
        }

        protected boolean canShow(ContextMenu contextMenu) {
            return true;
        }

        protected void createAndShowMenu(ContextMenu contextMenu) {
            IMEditableResultSetTable.this.m_controller.addContextMenuActions(contextMenu);
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            return this.handleEvent(ideAction, context);
        }

        public boolean update(IdeAction ideAction, Context context) {
            return this.update(ideAction, context);
        }
    }

    class IMRSTMSql
    extends RSTMSql {
        public IMRSTMSql(String string) {
            super(string);
        }

        public String getModifiedSql(String string) {
            StringBuilder stringBuilder = new StringBuilder(string);
            if (this._whereClauseFilter != null && this._whereClauseFilter.length() > 0) {
                stringBuilder.append(" AND " + this._whereClauseFilter);
            }
            String string2 = IMRSTMSql.sanitizeSql((String)stringBuilder.toString());
            return string2;
        }
    }
}

