/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.generate;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Pattern;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.generate.GenerateException;
import oracle.dbtools.migration.generate.GenerateWorker;
import oracle.dbtools.migration.generate.GenerationOutputStream;
import oracle.dbtools.migration.generate.Messages;
import oracle.dbtools.migration.generate.SimpleGenerationOutputStream;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;

public abstract class BaseGeneration {
    private static GenerationOutputStream m_MainMasterOutputStream = null;
    private File m_outputDir;
    private ArrayList<String> m_allSchemaNames;
    private HashMap<String, ArrayList<String>> m_SchemaMasterSql = new HashMap();
    private HashMap<String, ArrayList<String>> m_dropObjects = new HashMap();
    private HashMap<String, Boolean> m_isViewObjects = new HashMap();
    private HashMap<String, ArrayList<String>> m_recompileViews = new HashMap();
    private StringTemplateGroup m_templateGroup;
    private GenerationOutputStream m_outputStream;
    private String m_projectName;
    private String m_roleName = null;
    private String m_currentDirectory;
    private GenerateWorker m_generateWorker;
    private GenerationType m_generationType;
    private GenerationOutputStream m_outputStreamForMaster;
    private GenerationOutputStream m_outputStreamForObjectTypes;
    private GenerationOutputStream m_outputStreamForObjects;
    protected String m_baseDirectory;

    public BaseGeneration(GenerateWorker generateWorker) {
        this.m_generateWorker = generateWorker;
        this.setTemplateGroup(generateWorker.getTemplateGroup());
        this.setMainMasterOutputStream(generateWorker.getOutputMainMasterStream());
    }

    public void getMasterFileHeaderStatements() {
        StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("createHeaderStatements");
        this.getOutputStream().println(stringTemplate.toString());
        this.getOutputStream().endObject();
        stringTemplate.reset();
    }

    public void generateLogFileStatement() {
        StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("createLogFile");
        stringTemplate.setAttribute("projectName", (Object)this.getProjectName());
        this.getOutputStream().println(stringTemplate.toString());
        this.getOutputStream().endObject();
        stringTemplate.reset();
    }

    protected boolean generateRolesFile() throws GenerateException {
        try {
            this.setOutputStream(this.createGenerationOutputStream(this.getBaseDirectory(), "role", false));
            this.generateRoles();
            this.getOutputStream().close();
        }
        catch (Exception exception) {
            throw new GenerateException(exception);
        }
        return true;
    }

    protected void generateRoles() {
        StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("createRole");
        stringTemplate.setAttribute("roleName", (Object)this.getRoleName());
        this.getOutputStream().println(stringTemplate.toString());
        this.getOutputStream().endObject();
        stringTemplate.reset();
    }

    private void setRoleName() {
        Object object = "ROLE_" + this.getProjectName().replaceAll("\\s", "_");
        int n = MigrationUtils.getMaxOracleIdentifierLength();
        if (((String)object).trim().length() > n) {
            object = ((String)object).trim();
            object = ((String)object).substring(0, n - 1);
        }
        this.m_roleName = object;
    }

    private String getRoleName() {
        if (this.m_roleName == null) {
            this.setRoleName();
        }
        return this.m_roleName;
    }

    protected boolean generatePasswordDefinitionSqlFile() throws GenerateException {
        try {
            this.setOutputStream(this.createGenerationOutputStream(this.getBaseDirectory(), "passworddefinition", false));
            StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("blindDump");
            stringTemplate.setAttribute("text", (Object)Messages.getString("PasswordDefinitionHeader"));
            this.getOutputStream().println(stringTemplate.toString());
            stringTemplate.reset();
            for (int i = 0; i < this.m_allSchemaNames.size(); ++i) {
                stringTemplate = this.getTemplateGroup().getInstanceOf("passwordDefinitionSql");
                stringTemplate.setAttribute("schemaName", (Object)this.m_allSchemaNames.get(i));
                this.getOutputStream().println(stringTemplate.toString());
                stringTemplate.reset();
            }
            this.getOutputStream().endObject();
            stringTemplate.reset();
            this.getOutputStream().close();
        }
        catch (Exception exception) {
            throw new GenerateException(exception);
        }
        return true;
    }

    public void startWritingMainMasterFile() {
        this.getMainMasterOutputStream().println(this.getTemplateGroup().getInstanceOf("createHeaderStatements").toString());
        StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("createLogFile");
        stringTemplate.setAttribute("projectName", (Object)this.getProjectName());
        this.getMainMasterOutputStream().println(stringTemplate.toString());
        stringTemplate.reset();
        if (this.getGenerateWorker().getOnlineGenerationMode()) {
            stringTemplate = this.getTemplateGroup().getInstanceOf("addCommentedPasswordDefinition");
            this.getMainMasterOutputStream().println(stringTemplate.toString());
            stringTemplate.reset();
        } else {
            stringTemplate = this.getTemplateGroup().getInstanceOf("addPasswordDefinition");
            this.getMainMasterOutputStream().println(stringTemplate.toString());
            stringTemplate.reset();
        }
        if (this.getGenerationType().equals((Object)GenerationType.SINGLE)) {
            stringTemplate = this.getTemplateGroup().getInstanceOf("createRole");
            stringTemplate.setAttribute("roleName", (Object)this.getRoleName());
            this.getMainMasterOutputStream().println(stringTemplate.toString());
        } else {
            stringTemplate = this.getTemplateGroup().getInstanceOf("addRoleFile");
            this.getMainMasterOutputStream().println(stringTemplate.toString());
        }
        stringTemplate.reset();
    }

    public void endWritingMainMasterFile() {
        this.getMainMasterOutputStream().println(this.getTemplateGroup().getInstanceOf("setSpoolOff").toString());
        this.getMainMasterOutputStream().println(this.generateDisconnectSql(true));
        this.getMainMasterOutputStream().close();
    }

    protected void generateDropAllSchemasFile() throws GenerateException {
        try {
            this.setOutputStream(this.createGenerationOutputStream(this.getBaseDirectory(), "dropallschemas", false));
            for (int i = 0; i < this.m_allSchemaNames.size(); ++i) {
                StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("dropAllSchemas");
                stringTemplate.setAttribute("schemaName", (Object)this.m_allSchemaNames.get(i));
                this.getOutputStream().println(stringTemplate.toString());
                stringTemplate.reset();
            }
            this.getOutputStream().endObject();
            this.getOutputStream().close();
        }
        catch (Exception exception) {
            throw new GenerateException(exception);
        }
    }

    protected void generateReportAllStatusFileinMain() throws GenerateException {
        try {
            this.setOutputStream(this.createGenerationOutputStream(this.getBaseDirectory(), "reportallstatus", false));
            for (int i = 0; i < this.m_allSchemaNames.size(); ++i) {
                StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("reportAllStatusMain");
                stringTemplate.setAttribute("schemaName", (Object)this.m_allSchemaNames.get(i));
                stringTemplate.setAttribute("separator", (Object)File.separator);
                this.getOutputStream().println(stringTemplate.toString());
                stringTemplate.reset();
            }
            this.getOutputStream().endObject();
            this.getOutputStream().close();
        }
        catch (Exception exception) {
            throw new GenerateException(exception);
        }
    }

    protected void generateWrapperFile() throws GenerateException {
        try {
            boolean bl = this.getGenerateWorker().getOnlineGenerationMode();
            if (!bl) {
                return;
            }
            this.setOutputStream(this.createGenerationOutputStream(this.getBaseDirectory(), ".wrapper", bl));
            for (int i = 0; i < this.m_allSchemaNames.size(); ++i) {
                String string = this.m_allSchemaNames.get(i);
                StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("wrapper");
                stringTemplate.setAttribute("schemaName", (Object)string);
                String string2 = this.getRandomPasswd();
                stringTemplate.setAttribute("password", this.doubleQuote(string2));
                this.getOutputStream().println(stringTemplate.toString());
                stringTemplate.reset();
            }
            StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("wrapper_master");
            stringTemplate.setAttribute("dir_path", (Object)this.getBaseDirectory());
            stringTemplate.setAttribute("separator", (Object)File.separator);
            this.getOutputStream().println(stringTemplate.toString());
            stringTemplate.reset();
            this.getOutputStream().endObject();
            this.getOutputStream().close();
        }
        catch (Exception exception) {
            throw new GenerateException(exception);
        }
    }

    private Object doubleQuote(String string) {
        if (string.startsWith("\"")) {
            return string;
        }
        return "\"" + string + "\"";
    }

    protected void generatePostFile() throws GenerateException {
        try {
            for (int i = 0; i < this.m_allSchemaNames.size(); ++i) {
                String string = this.getBaseDirectory() + File.separator + this.m_allSchemaNames.get(i);
                this.setOutputStream(this.createGenerationOutputStream(string, "post", false));
                this.createDirectory(string, "post");
                StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("post");
                stringTemplate.setAttribute("schemaName", (Object)this.m_allSchemaNames.get(i));
                stringTemplate.setAttribute("password", (Object)(this.m_allSchemaNames.get(i) + "_password"));
                stringTemplate.setAttribute("currentDir", (Object)(this.m_allSchemaNames.get(i) + File.separator + "post"));
                stringTemplate.setAttribute("separator", (Object)File.separator);
                if (this.m_isViewObjects.containsKey(this.m_allSchemaNames.get(i))) {
                    Boolean bl = this.m_isViewObjects.get(this.m_allSchemaNames.get(i));
                    stringTemplate.setAttribute("recompileFlag", (Object)bl);
                }
                this.getOutputStream().println(stringTemplate.toString());
                stringTemplate.reset();
                this.getOutputStream().endObject();
                this.getOutputStream().close();
            }
        }
        catch (Exception exception) {
            throw new GenerateException(exception);
        }
    }

    protected void generateUserFile() throws GenerateException {
        try {
            for (int i = 0; i < this.m_allSchemaNames.size(); ++i) {
                String string = this.getBaseDirectory() + File.separator + this.m_allSchemaNames.get(i);
                this.setOutputStream(this.createGenerationOutputStream(string, "user", false));
                StringTemplate stringTemplate = null;
                stringTemplate = MigrationConfig.getInstance((PropertyStorage)Preferences.getPreferences()).getTarget12c() ? this.getTemplateGroup().getInstanceOf("user12c") : this.getTemplateGroup().getInstanceOf("user");
                stringTemplate.setAttribute("schemaName", (Object)this.m_allSchemaNames.get(i));
                stringTemplate.setAttribute("password", (Object)(this.m_allSchemaNames.get(i) + "_password"));
                this.getOutputStream().println(stringTemplate.toString());
                stringTemplate.reset();
                this.getOutputStream().endObject();
                this.getOutputStream().close();
            }
        }
        catch (Exception exception) {
            throw new GenerateException(exception);
        }
    }

    protected void generateEnableFile() throws GenerateException {
        try {
            for (int i = 0; i < this.m_allSchemaNames.size(); ++i) {
                String string = this.getBaseDirectory() + File.separator + this.m_allSchemaNames.get(i);
                this.setOutputStream(this.createGenerationOutputStream(string, "enable", false));
                StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("enable");
                stringTemplate.setAttribute("schemaName", (Object)this.m_allSchemaNames.get(i));
                stringTemplate.setAttribute("password", (Object)(this.m_allSchemaNames.get(i) + "_password"));
                this.getOutputStream().println(stringTemplate.toString());
                stringTemplate.reset();
                this.getOutputStream().endObject();
                this.getOutputStream().close();
            }
        }
        catch (Exception exception) {
            throw new GenerateException(exception);
        }
    }

    protected void generateDisableFile() throws GenerateException {
        try {
            for (int i = 0; i < this.m_allSchemaNames.size(); ++i) {
                String string = this.getBaseDirectory() + File.separator + this.m_allSchemaNames.get(i);
                this.setOutputStream(this.createGenerationOutputStream(string, "disable", false));
                StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("disable");
                stringTemplate.setAttribute("schemaName", (Object)this.m_allSchemaNames.get(i));
                stringTemplate.setAttribute("password", (Object)(this.m_allSchemaNames.get(i) + "_password"));
                this.getOutputStream().println(stringTemplate.toString());
                stringTemplate.reset();
                this.getOutputStream().endObject();
                this.getOutputStream().close();
            }
        }
        catch (Exception exception) {
            throw new GenerateException(exception);
        }
    }

    protected void generateDropObjectTypeFile() throws GenerateException {
        try {
            for (int i = 0; i < this.m_allSchemaNames.size(); ++i) {
                String string = this.getBaseDirectory() + File.separator + this.m_allSchemaNames.get(i);
                this.setOutputStream(this.createGenerationOutputStream(string, "dropobjecttypes", false));
                StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("dropObjectTypes");
                this.getOutputStream().println(stringTemplate.toString());
                stringTemplate.reset();
                this.getOutputStream().endObject();
                this.getOutputStream().close();
            }
        }
        catch (Exception exception) {
            throw new GenerateException(exception);
        }
    }

    protected void generateReportInvalidStatusFile() throws GenerateException {
        try {
            for (int i = 0; i < this.m_allSchemaNames.size(); ++i) {
                String string = this.getBaseDirectory() + File.separator + this.m_allSchemaNames.get(i);
                this.setOutputStream(this.createGenerationOutputStream(string, "reportinvalidstatus", false));
                StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("reportInvalidStatus");
                stringTemplate.setAttribute("schemaName", (Object)this.m_allSchemaNames.get(i).toUpperCase());
                stringTemplate.setAttribute("password", (Object)(this.m_allSchemaNames.get(i) + "_password"));
                this.getOutputStream().println(stringTemplate.toString());
                stringTemplate.reset();
                this.getOutputStream().endObject();
                this.getOutputStream().close();
            }
        }
        catch (Exception exception) {
            throw new GenerateException(exception);
        }
    }

    protected void generateReportAllStatusFile() throws GenerateException {
        try {
            for (int i = 0; i < this.m_allSchemaNames.size(); ++i) {
                String string = this.getBaseDirectory() + File.separator + this.m_allSchemaNames.get(i);
                this.setOutputStream(this.createGenerationOutputStream(string, "reportallstatus", false));
                StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("reportAllStatus");
                stringTemplate.setAttribute("schemaName", (Object)this.m_allSchemaNames.get(i).toUpperCase());
                stringTemplate.setAttribute("password", (Object)(this.m_allSchemaNames.get(i) + "_password"));
                this.getOutputStream().println(stringTemplate.toString());
                stringTemplate.reset();
                this.getOutputStream().endObject();
                this.getOutputStream().close();
            }
        }
        catch (Exception exception) {
            throw new GenerateException(exception);
        }
    }

    protected void generateUserEntryInMainMaster(String string) {
        StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("createMasterUser");
        stringTemplate.setAttribute("schemaName", (Object)string);
        stringTemplate.setAttribute("separator", (Object)File.separator);
        this.getMainMasterOutputStream().println(stringTemplate.toString());
        stringTemplate.reset();
    }

    protected void generateMasterEntryInMainMaster(String string) {
        StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("createSchemaMaster");
        stringTemplate.setAttribute("schemaName", (Object)string);
        stringTemplate.setAttribute("separator", (Object)File.separator);
        this.getMainMasterOutputStream().println(stringTemplate.toString());
        stringTemplate.reset();
    }

    protected void generateForignKeyEntryInMainMaster(String string) {
        StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("createForeignKeyMaster");
        stringTemplate.setAttribute("schemaName", (Object)string);
        stringTemplate.setAttribute("separator", (Object)File.separator);
        this.getMainMasterOutputStream().println(stringTemplate.toString());
        stringTemplate.reset();
    }

    protected void generatePostEntryInMainMaster() {
        for (int i = 0; i < this.m_allSchemaNames.size(); ++i) {
            StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("createPostMaster");
            stringTemplate.setAttribute("schemaName", (Object)this.m_allSchemaNames.get(i));
            stringTemplate.setAttribute("separator", (Object)File.separator);
            this.getMainMasterOutputStream().println(stringTemplate.toString());
            stringTemplate.reset();
        }
    }

    protected void generateConnectionInSchemaMaster(String string) {
        StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("alterSessionSetCurrentSchema");
        stringTemplate.setAttribute("schemaName", (Object)string);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(stringTemplate.toString());
        this.m_SchemaMasterSql.put(string, arrayList);
        stringTemplate.reset();
    }

    protected void generatePromptDropObjectsInSchema(String string) {
        StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("dropObjectsPrompt");
        stringTemplate.setAttribute("schemaName", (Object)string);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(stringTemplate.toString());
        this.m_dropObjects.put(string, arrayList);
        stringTemplate.reset();
    }

    protected void setRecompileViewsFlag(String string, boolean bl) {
        this.m_isViewObjects.put(string, new Boolean(bl));
    }

    protected void storeRecompileViews(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        if (this.m_recompileViews.get(string) == null) {
            this.m_recompileViews.put(string, arrayList);
        } else {
            this.m_recompileViews.get(string).add(string2);
        }
    }

    protected void generateDropObjectsInSchema(String string, String string2, String string3) {
        StringTemplate stringTemplate;
        if (string2 == "TABLE") {
            stringTemplate = this.getTemplateGroup().getInstanceOf("dropTableObject");
            stringTemplate.setAttribute("objectName", (Object)string3);
        } else {
            stringTemplate = this.getTemplateGroup().getInstanceOf("dropObject");
            stringTemplate.setAttribute("objectType", (Object)string2);
            stringTemplate.setAttribute("objectName", (Object)string3);
        }
        this.m_dropObjects.get(string).add(stringTemplate.toString());
        stringTemplate.reset();
    }

    protected void writeDropObjectsInSchemaFile() throws GenerateException {
        try {
            for (String string : this.m_dropObjects.keySet()) {
                String string2 = this.getBaseDirectory() + File.separator + string;
                GenerationOutputStream generationOutputStream = this.createGenerationOutputStream(string2, "dropobjects", false);
                ArrayList<String> arrayList = this.m_dropObjects.get(string);
                generationOutputStream.println(arrayList.get(0));
                for (int i = arrayList.size() - 1; i > 0; --i) {
                    generationOutputStream.println(arrayList.get(i));
                }
                generationOutputStream.close();
            }
        }
        catch (Exception exception) {
            throw new GenerateException(exception);
        }
    }

    protected void generateRebuildSqlFile() throws GenerateException {
        try {
            for (int i = 0; i < this.m_allSchemaNames.size(); ++i) {
                String string = this.getBaseDirectory() + File.separator + this.m_allSchemaNames.get(i) + File.separator + "post";
                GenerationOutputStream generationOutputStream = this.createGenerationOutputStream(string, "rebuild", false);
                StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("rebuildSql");
                stringTemplate.setAttribute("schemaName", (Object)this.m_allSchemaNames.get(i));
                generationOutputStream.println(stringTemplate.toString());
                stringTemplate.reset();
                generationOutputStream.endObject();
                generationOutputStream.close();
            }
        }
        catch (Exception exception) {
            throw new GenerateException(exception);
        }
    }

    protected void generateRecompileViewsSqlFile() throws GenerateException {
        try {
            for (String string : this.m_recompileViews.keySet()) {
                String string2 = this.getBaseDirectory() + File.separator + string + File.separator + "post";
                GenerationOutputStream generationOutputStream = this.createGenerationOutputStream(string2, "recompileviews", false);
                ArrayList<String> arrayList = this.m_recompileViews.get(string);
                for (int i = 0; i < arrayList.size(); ++i) {
                    StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("recompileViewsSql");
                    stringTemplate.setAttribute("viewName", (Object)arrayList.get(i));
                    generationOutputStream.println(stringTemplate.toString());
                    stringTemplate.reset();
                }
                generationOutputStream.endObject();
                generationOutputStream.close();
            }
        }
        catch (Exception exception) {
            throw new GenerateException(exception);
        }
    }

    protected void generateObjectTypesInSchemaMaster(String string, String string2) {
        StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("createObjectTypeMasterConnection");
        stringTemplate.setAttribute("schemaName", (Object)string);
        stringTemplate.setAttribute("objectType", (Object)string2);
        this.m_SchemaMasterSql.get(string).add(stringTemplate.toString());
        stringTemplate.reset();
    }

    protected void writeSchemaMasterFile() throws GenerateException {
        try {
            for (String string : this.m_SchemaMasterSql.keySet()) {
                GenerationOutputStream generationOutputStream = this.createGenerationOutputStream(this.getBaseDirectory() + File.separator + string, "master", false);
                ArrayList<String> arrayList = this.m_SchemaMasterSql.get(string);
                for (int i = 0; i < arrayList.size(); ++i) {
                    generationOutputStream.println(arrayList.get(i));
                }
                generationOutputStream.println(this.getTemplateGroup().getInstanceOf("setDefineOn").toString());
                generationOutputStream.println(this.getTemplateGroup().getInstanceOf("disconnect").toString());
                generationOutputStream.close();
            }
        }
        catch (Exception exception) {
            throw new GenerateException(exception);
        }
    }

    protected String generateStartPromptInObjectTypes(String string, String string2) {
        StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("createStartPromptForObjectTypes");
        stringTemplate.setAttribute("schemaName", (Object)string);
        stringTemplate.setAttribute("objectType", (Object)string2.toLowerCase());
        stringTemplate.setAttribute("separator", (Object)File.separator);
        return stringTemplate.toString();
    }

    protected String generateConnectString(String string) {
        StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("createConnectStringConnection");
        stringTemplate.setAttribute("schemaName", (Object)string);
        return stringTemplate.toString();
    }

    protected String generateObjectsInObjectTypes(String string, String string2, String string3) {
        StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("createObjectTypes");
        stringTemplate.setAttribute("schemaName", (Object)string);
        stringTemplate.setAttribute("objectType", (Object)string2.toLowerCase());
        stringTemplate.setAttribute("objectName", (Object)string3);
        stringTemplate.setAttribute("separator", (Object)File.separator);
        return stringTemplate.toString();
    }

    protected String generateEndPromptInObjectTypes(String string, String string2) {
        StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("createEndPromptForObjectTypes");
        stringTemplate.setAttribute("schemaName", (Object)string);
        stringTemplate.setAttribute("objectType", (Object)string2.toLowerCase());
        stringTemplate.setAttribute("separator", (Object)File.separator);
        return stringTemplate.toString();
    }

    protected String generateGrantAllRoleToObjects(String string, String string2) {
        StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("addAllRoleToObjects");
        stringTemplate.setAttribute("objectName", (Object)string);
        stringTemplate.setAttribute("targetName", (Object)this.getRoleName());
        for (String string3 : this.getAllSchemaNames()) {
            if (string3.equalsIgnoreCase("EMULATION") || string3.equalsIgnoreCase(string2)) continue;
            stringTemplate.setAttribute("targetName", (Object)string3);
        }
        return stringTemplate.toString();
    }

    protected String generateGrantExecuteOnUtilsPkgToAllSchemas(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_allSchemaNames.size(); ++i) {
            if (this.m_allSchemaNames.get(i).equalsIgnoreCase("Emulation")) continue;
            StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("grantExecuteOnUtilsToSchemas");
            stringTemplate.setAttribute("packageName", (Object)string);
            stringTemplate.setAttribute("schemaName", (Object)this.m_allSchemaNames.get(i));
            stringBuffer.append(stringTemplate.toString());
            stringTemplate.reset();
        }
        return stringBuffer.toString();
    }

    protected String createSynonymOnUtilsPkg(String string, String string2) {
        StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("createSynonymOnUtilsToSchemas");
        stringTemplate.setAttribute("packageName", (Object)string);
        stringTemplate.setAttribute("schemaName", (Object)string2);
        return stringTemplate.toString();
    }

    protected String generateDisconnectSql(boolean bl) {
        return "";
    }

    public String getBaseDirectory() {
        return this.m_baseDirectory;
    }

    public void setBaseDirectory(String string) {
        this.m_baseDirectory = string;
    }

    public String getProjectName() {
        return this.m_projectName;
    }

    public void setProjectName(String string) {
        this.m_projectName = string;
    }

    public void setAllSchemaNames() {
        this.m_allSchemaNames = this.getGenerateWorker().getAllSchemaNames();
        this.m_allSchemaNames.add("Emulation");
    }

    public ArrayList<String> getAllSchemaNames() {
        return this.m_allSchemaNames;
    }

    protected void createDirectory(String string, String string2) throws GenerateException {
        try {
            File file = new File(string, string2);
            file.mkdir();
        }
        catch (Exception exception) {
            throw new GenerateException(exception);
        }
    }

    protected void createSchemaDirectories() throws GenerateException {
        try {
            for (int i = 0; i < this.m_allSchemaNames.size(); ++i) {
                File file = new File(this.getBaseDirectory(), this.m_allSchemaNames.get(i));
                file.mkdir();
            }
        }
        catch (Exception exception) {
            throw new GenerateException(exception);
        }
    }

    public String generateCreatePrompt(String string, String string2, String string3) {
        return string + " " + string2 + " " + string3;
    }

    protected StringTemplateGroup getTemplateGroup() {
        return this.m_templateGroup;
    }

    protected void setTemplateGroup(StringTemplateGroup stringTemplateGroup) {
        this.m_templateGroup = stringTemplateGroup;
    }

    protected GenerateWorker getGenerateWorker() {
        return this.m_generateWorker;
    }

    protected GenerationOutputStream getOutputStream() {
        return this.m_outputStream;
    }

    protected void setOutputStream(GenerationOutputStream generationOutputStream) {
        this.m_outputStream = generationOutputStream;
    }

    protected GenerationOutputStream createGenerationOutputStream(String string, String string2, boolean bl) throws Exception {
        try {
            File file = new File(string);
            if (!file.exists()) {
                file.mkdirs();
            }
            String string3 = string + File.separator + string2;
            File file2 = new File(string3 + ".sql");
            if (bl) {
                this.getGenerateWorker().setOnlineGenerationFile(file2);
            }
            SimpleGenerationOutputStream simpleGenerationOutputStream = null;
            String string4 = Ide.getEnvironOptions().getEncoding();
            simpleGenerationOutputStream = string4 == null ? new SimpleGenerationOutputStream(new PrintStream(file2)) : new SimpleGenerationOutputStream(new PrintStream(file2, string4));
            return simpleGenerationOutputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new GenerateException(fileNotFoundException);
        }
        catch (Exception exception) {
            throw new GenerateException(exception);
        }
    }

    public void editMainMasterFile() throws Exception {
        try {
            String string = this.getBaseDirectory() + File.separator + "master.sql";
            File file = new File(string);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            File file2 = File.createTempFile("master", ".sql", null);
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.contains("passworddefinition") && string2.startsWith("--")) {
                    string2 = string2.substring(string2.indexOf("@"), string2.length());
                }
                bufferedWriter.write(string2 + "\n");
            }
            if (bufferedReader != null) {
                bufferedReader.close();
                file.delete();
                bufferedWriter.close();
                this.moveFile(file2.getCanonicalPath(), string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new GenerateException(fileNotFoundException);
        }
        catch (Exception exception) {
            throw new GenerateException(exception);
        }
    }

    private void moveFile(String string, String string2) throws GenerateException {
        try {
            File file = new File(string);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            File file2 = new File(string2);
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
            String string3 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                bufferedWriter.write(string3 + "\n");
            }
            if (bufferedReader != null) {
                bufferedReader.close();
                file.delete();
                bufferedWriter.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new GenerateException(fileNotFoundException);
        }
        catch (Exception exception) {
            throw new GenerateException(exception);
        }
    }

    public GenerationType getGenerationType() {
        return this.m_generationType;
    }

    public void setGenerationType(GenerationType generationType) {
        this.m_generationType = generationType;
    }

    private File getDirectory() {
        return this.getOutputDir();
    }

    protected GenerationOutputStream getGenerationOutputStreamForMaster() {
        return this.m_outputStreamForMaster;
    }

    protected void setGenerationOutputStreamForMaster(GenerationOutputStream generationOutputStream) throws FileNotFoundException, UnsupportedEncodingException {
        this.m_outputStreamForMaster = generationOutputStream;
    }

    protected GenerationOutputStream getGenerationOutputStreamForObjectTypes() {
        return this.m_outputStreamForObjectTypes;
    }

    protected void setGenerationOutputStreamForObjectTypes(GenerationOutputStream generationOutputStream) throws FileNotFoundException, UnsupportedEncodingException {
        this.m_outputStreamForObjectTypes = generationOutputStream;
    }

    protected GenerationOutputStream getGenerationOutputStreamForObjects() {
        return this.m_outputStreamForObjects;
    }

    protected void setGenerationOutputStreamForObjects(GenerationOutputStream generationOutputStream) throws FileNotFoundException, UnsupportedEncodingException {
        this.m_outputStreamForObjects = generationOutputStream;
    }

    public File getOutputDir() {
        return this.m_outputDir;
    }

    public void setOutputDir(String string) {
        this.m_outputDir = new File(string);
        if (!this.m_outputDir.exists()) {
            this.m_outputDir.mkdirs();
        }
    }

    protected void setMainMasterOutputStream(GenerationOutputStream generationOutputStream) {
        m_MainMasterOutputStream = generationOutputStream;
    }

    protected GenerationOutputStream getMainMasterOutputStream() {
        return m_MainMasterOutputStream;
    }

    public String getRandomPasswd() {
        String string = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String string2 = string.toLowerCase(Locale.ROOT);
        String string3 = "#$";
        String string4 = "0123456789";
        String string5 = string + string2 + string3 + string4;
        SecureRandom secureRandom = new SecureRandom();
        int n = 16;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            int n2 = secureRandom.nextInt(string5.length());
            stringBuffer.append(string5.substring(n2, n2 + 1));
        }
        if (Pattern.matches(".*(#|\\$).*[0-9][a-z]", stringBuffer)) {
            return stringBuffer.toString();
        }
        return this.getRandomPasswd();
    }

    protected abstract boolean startGeneration() throws GenerateException;

    protected abstract boolean setGenerationOutputStream(GenerationType var1, String var2);

    protected abstract boolean startFileWriting(String var1, String var2, String var3, GenerationType var4);

    protected abstract void endFileWriting(GenerationType var1);

    protected abstract void endFileWriting(GenerationType var1, boolean var2);

    protected abstract void processFileWriting(String var1, GenerationType var2);

    protected abstract boolean endGeneration() throws GenerateException;

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    protected static enum GenerationType {
        OBJECTTYPE{

            @Override
            public File getFileLocation(File file, String string) {
                File file2 = new File(file, string);
                if (file2.exists() && file2.isFile()) {
                    this.setIsFileExists(true);
                    return file2;
                }
                try {
                    file2.createNewFile();
                    this.setObjectTypeFileLocation(file2);
                }
                catch (IOException iOException) {
                    Logger.severe(((Object)((Object)this)).getClass(), (Throwable)iOException);
                }
                return file2;
            }
        }
        ,
        OBJECT{

            @Override
            public File getFileLocation(File file, String string) {
                File file2 = new File(file, string);
                if (file2.exists() && file2.isFile()) {
                    this.setIsFileExists(true);
                    return file2;
                }
                try {
                    file2.createNewFile();
                    this.setObjectFileLocation(file2);
                }
                catch (IOException iOException) {
                    Logger.severe(((Object)((Object)this)).getClass(), (Throwable)iOException);
                }
                return file2;
            }
        }
        ,
        SINGLE{};

        private File m_ObjectFile;
        private File m_ObjectTypeFile;
        private boolean m_fileExists = false;

        public File getFileLocation(File file, String string) {
            return null;
        }

        public File getObjectFileLocation() {
            return this.m_ObjectFile;
        }

        public void setObjectFileLocation(File file) {
            this.m_ObjectFile = file;
        }

        public File getObjectTypeFileLocation() {
            return this.m_ObjectTypeFile;
        }

        public void setObjectTypeFileLocation(File file) {
            this.m_ObjectTypeFile = file;
        }

        public boolean isFileExists() {
            return this.m_fileExists;
        }

        public void setIsFileExists(boolean bl) {
            this.m_fileExists = bl;
        }
    }
}

