/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove;

import java.util.Collection;
import java.util.LinkedHashMap;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdTable;

public class DataMoveDescriptor {
    private MdSchema m_sourceSchema;
    private MdTable m_srcTable;
    private MdSchema m_targetSchema;
    private MdTable m_targetTable;
    private String m_srcDB;
    private LinkedHashMap<MdColumn, MdColumn> m_columnMap;

    public DataMoveDescriptor(MdSchema mdSchema, MdTable mdTable, MdSchema mdSchema2, MdTable mdTable2) {
        this.setSourceSchema(mdSchema);
        this.setSourceTable(mdTable);
        this.setTargetTable(mdTable2);
        this.setTargetSchema(mdSchema2);
        this.m_columnMap = new LinkedHashMap();
    }

    public void setTargetTable(MdTable mdTable) {
        this.m_targetTable = mdTable;
    }

    public MdTable getTargetTable() {
        return this.m_targetTable;
    }

    public String getTargetTableName(boolean bl) {
        if (bl) {
            return this.getTargetQualifiedTableName();
        }
        return this.getTargetUnqualifiedTableName();
    }

    public void setSourceTable(MdTable mdTable) {
        this.m_srcTable = mdTable;
    }

    public String getSourceTableName() {
        if (this.m_srcTable.getQualifiedNativeName() != null) {
            return this.m_srcTable.getQualifiedNativeName();
        }
        return this.m_srcTable.getTableName();
    }

    private String getTargetQualifiedTableName() {
        return this.m_targetSchema.getName() + "." + this.getTargetUnqualifiedTableName();
    }

    private String getTargetUnqualifiedTableName() {
        return this.m_targetTable.getTableName();
    }

    public void setSourceDatabaseName(String string) {
        this.m_srcDB = string;
    }

    public String getSourceDatabaseName() {
        return this.m_srcDB;
    }

    public void addColumnMap(MdColumn mdColumn, MdColumn mdColumn2) {
        this.m_columnMap.put(mdColumn2, mdColumn);
    }

    public void setColumnMap(LinkedHashMap<MdColumn, MdColumn> linkedHashMap) {
        this.m_columnMap = linkedHashMap;
    }

    public MdColumn[] getSourceColumns() {
        Collection<MdColumn> collection = this.m_columnMap.values();
        return collection.toArray(new MdColumn[collection.size()]);
    }

    public String[] getSourceColumnNames() {
        MdColumn[] mdColumnArray = this.getSourceColumns();
        String[] stringArray = new String[mdColumnArray.length];
        for (int i = 0; i < mdColumnArray.length; ++i) {
            stringArray[i] = mdColumnArray[i].getColumnName();
        }
        return stringArray;
    }

    public MdColumn[] getTargetColumns() {
        MdColumn[] mdColumnArray = this.m_columnMap.keySet().toArray(new MdColumn[this.m_columnMap.size()]);
        return mdColumnArray;
    }

    public String[] getTargetColumnNames() {
        MdColumn[] mdColumnArray = this.getTargetColumns();
        String[] stringArray = new String[mdColumnArray.length];
        for (int i = 0; i < mdColumnArray.length; ++i) {
            stringArray[i] = mdColumnArray[i].getColumnName();
        }
        return stringArray;
    }

    public String getOriginalColumnName(String string) {
        MdColumn[] mdColumnArray;
        for (MdColumn mdColumn : mdColumnArray = this.getTargetColumns()) {
            if (!mdColumn.getColumnName().equals(string)) continue;
            MdColumn mdColumn2 = this.m_columnMap.get(mdColumn);
            return mdColumn2.getColumnName();
        }
        return null;
    }

    public MdColumn getSourceColumnByName(String string) {
        for (MdColumn mdColumn : this.m_columnMap.values()) {
            if (!mdColumn.getColumnName().equals(string)) continue;
            return mdColumn;
        }
        return null;
    }

    protected void setTargetSchema(MdSchema mdSchema) {
        this.m_targetSchema = mdSchema;
    }

    public MdSchema getTargetSchema() {
        return this.m_targetSchema;
    }

    protected void setSourceSchema(MdSchema mdSchema) {
        this.m_sourceSchema = mdSchema;
    }

    public MdTable getSourceTable() {
        return this.m_srcTable;
    }

    public MdSchema getSourceSchema() {
        return this.m_sourceSchema;
    }
}

