/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.ceditor.text;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Map;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import oracle.bali.ewt.graphics.GraphicUtils;
import oracle.ide.ceditor.text.SourceColorizer;

final class CodeRendererUtils {
    private CodeRendererUtils() {
    }

    static void configureRenderer(JComponent rendererComponent, AttributedString aString) {
        AccessibleContext ac;
        if (EventQueue.isDispatchThread()) {
            Icon icon;
            AttributedCharacterIterator iterator = CodeRendererUtils.getIterator(aString);
            FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
            TextLayout textLayout = new TextLayout(iterator, fontRenderContext);
            Rectangle2D bounds = textLayout.getBounds();
            int prefWidth = (int)(bounds.getX() + bounds.getWidth());
            int prefHeight = (int)(bounds.getHeight() - bounds.getY());
            if (rendererComponent instanceof JLabel && (icon = ((JLabel)rendererComponent).getIcon()) != null) {
                int iconGap = ((JLabel)rendererComponent).getIconTextGap();
                prefHeight = Math.max(prefHeight, icon.getIconHeight());
                prefWidth += icon.getIconWidth() + iconGap;
            }
            Insets insets = rendererComponent.getInsets();
            rendererComponent.setPreferredSize(new Dimension(prefWidth += insets.left + insets.right, prefHeight += insets.top + insets.bottom));
        }
        if ((ac = rendererComponent.getAccessibleContext()) != null) {
            AttributedCharacterIterator aci = CodeRendererUtils.getIterator(aString);
            StringBuffer strBuffer = new StringBuffer();
            char c = aci.first();
            while (c != '\uffff') {
                strBuffer.append(c);
                c = aci.next();
            }
            ac.setAccessibleName(strBuffer.toString());
        }
    }

    static void paint(Graphics g, PaintContext paintContext) {
        JComponent comp = paintContext.component;
        AttributedString aString = paintContext.aString;
        Icon icon = null;
        Insets insets = null;
        int iconWidthAddition = 0;
        if (comp instanceof JLabel) {
            icon = ((JLabel)comp).getIcon();
            insets = comp.getInsets();
            iconWidthAddition += icon == null ? 0 : insets.left + icon.getIconWidth() + ((JLabel)comp).getIconTextGap();
        }
        g.setColor(paintContext.background);
        g.fillRect(iconWidthAddition, 0, comp.getWidth() - iconWidthAddition, comp.getHeight());
        if (aString != SourceColorizer.EMPTY_ATTRIBUTE_STRING) {
            aString = new AttributedString(aString.getIterator());
            if (paintContext.isSelected && paintContext.hasFocus) {
                aString.addAttribute(TextAttribute.BACKGROUND, paintContext.background);
                aString.addAttribute(TextAttribute.FOREGROUND, paintContext.foreground);
            }
            g.setColor(Color.BLACK);
            g.setFont(comp.getFont());
            FontMetrics fontMetrics = g.getFontMetrics();
            AttributedCharacterIterator iterator = CodeRendererUtils.getIterator(aString);
            int y = (int)fontMetrics.getLineMetrics(iterator, 0, iterator.getEndIndex(), g).getHeight();
            int heightWithoutInsets = comp.getHeight() - y - insets.top - insets.bottom;
            int pad = heightWithoutInsets / 2 + (heightWithoutInsets % 2 == 1 ? 1 : 0);
            GraphicUtils.drawString((Graphics)g, (AttributedCharacterIterator)iterator, (int)(0 + iconWidthAddition), (int)(y + pad + insets.top - fontMetrics.getDescent()));
        }
        if (paintContext.hasFocus && paintContext.borderColor != null) {
            g.setColor(paintContext.borderColor);
            g.drawRect(iconWidthAddition, 0, comp.getWidth() - 1 - iconWidthAddition, comp.getHeight() - 1);
        }
        if (icon != null) {
            int heightWithoutInsets = comp.getHeight() - insets.top - insets.bottom - icon.getIconHeight();
            int top = heightWithoutInsets / 2 + insets.top + (heightWithoutInsets % 2 == 1 ? 1 : 0);
            icon.paintIcon(comp, g, insets.left, top);
        }
    }

    static AttributedCharacterIterator getIterator(AttributedString string) {
        return new TabConvertingCharacterIterator(string.getIterator());
    }

    static class PaintContext {
        AttributedString aString;
        JComponent component;
        boolean isSelected;
        boolean hasFocus;
        Color borderColor;
        Color background;
        Color foreground;

        PaintContext() {
        }
    }

    private static final class TabConvertingCharacterIterator
    implements AttributedCharacterIterator {
        private AttributedCharacterIterator wrapped;

        public TabConvertingCharacterIterator(AttributedCharacterIterator wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public int getRunStart() {
            return this.wrapped.getRunStart();
        }

        @Override
        public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
            return this.wrapped.getRunStart(attribute);
        }

        @Override
        public int getRunStart(Set<? extends AttributedCharacterIterator.Attribute> attributes) {
            return this.wrapped.getRunStart(attributes);
        }

        @Override
        public int getRunLimit() {
            return this.wrapped.getRunLimit();
        }

        @Override
        public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
            return this.wrapped.getRunLimit(attribute);
        }

        @Override
        public int getRunLimit(Set<? extends AttributedCharacterIterator.Attribute> attributes) {
            return this.wrapped.getRunLimit(attributes);
        }

        @Override
        public Map<AttributedCharacterIterator.Attribute, Object> getAttributes() {
            return this.wrapped.getAttributes();
        }

        @Override
        public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
            return this.wrapped.getAttribute(attribute);
        }

        @Override
        public Set<AttributedCharacterIterator.Attribute> getAllAttributeKeys() {
            return this.wrapped.getAllAttributeKeys();
        }

        @Override
        public char first() {
            return this.convertTab(this.wrapped.first());
        }

        @Override
        public char last() {
            return this.convertTab(this.wrapped.last());
        }

        @Override
        public char current() {
            return this.convertTab(this.wrapped.current());
        }

        @Override
        public char next() {
            return this.convertTab(this.wrapped.next());
        }

        @Override
        public char previous() {
            return this.convertTab(this.wrapped.previous());
        }

        @Override
        public char setIndex(int position) {
            return this.convertTab(this.wrapped.setIndex(position));
        }

        @Override
        public int getBeginIndex() {
            return this.wrapped.getBeginIndex();
        }

        @Override
        public int getEndIndex() {
            return this.wrapped.getEndIndex();
        }

        @Override
        public int getIndex() {
            return this.wrapped.getIndex();
        }

        public boolean equals(Object obj) {
            return this.wrapped.equals(obj);
        }

        @Override
        public Object clone() {
            return new TabConvertingCharacterIterator((AttributedCharacterIterator)this.wrapped.clone());
        }

        private char convertTab(char c) {
            return c == '\t' ? (char)' ' : (char)c;
        }
    }
}

