/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.text;

import java.awt.FontMetrics;
import oracle.bali.ewt.text.TextWrapper;
import oracle.bali.ewt.text.WrapInfo;

public final class CharacterWrapper
implements TextWrapper {
    private static CharacterWrapper _sCharacterWrapper;

    public static TextWrapper getTextWrapper() {
        if (_sCharacterWrapper == null) {
            _sCharacterWrapper = new CharacterWrapper();
        }
        return _sCharacterWrapper;
    }

    @Override
    public void wrapParagraph(WrapInfo geometry, String text) {
        int wrapWidth = geometry.getWrapWidth();
        char[] textChars = text.toCharArray();
        int numChars = textChars.length;
        FontMetrics metrics = geometry.getFontMetrics();
        int averageWidth = metrics.charWidth('e');
        int guessChars = wrapWidth / averageWidth;
        int currIndex = 0;
        int rewrapWidth = -1;
        while (currIndex < numChars) {
            int wrapIndex = CharacterWrapper.__getNextIndex(textChars, metrics, wrapWidth, currIndex, guessChars);
            if (!geometry.addLine(text, currIndex, wrapIndex)) {
                return;
            }
            guessChars = wrapIndex - currIndex;
            currIndex = wrapIndex;
        }
    }

    static int __getNextIndex(char[] textChars, FontMetrics metrics, int wrapWidth, int currIndex, int guessChars) {
        int wrapIndex;
        block5: {
            int guessWidth;
            block7: {
                block6: {
                    wrapIndex = currIndex + guessChars;
                    int numChars = textChars.length;
                    if (wrapIndex > numChars) {
                        wrapIndex = numChars;
                        guessChars = wrapIndex - currIndex;
                    }
                    if ((guessWidth = metrics.charsWidth(textChars, currIndex, guessChars)) >= wrapWidth) break block6;
                    while (wrapIndex < numChars) {
                        int charWidth;
                        char ch = textChars[wrapIndex];
                        if ((guessWidth += (charWidth = ch == '\t' ? metrics.charsWidth(textChars, 0, wrapIndex + 1) - guessWidth : metrics.charWidth(ch))) > wrapWidth && wrapIndex > currIndex) {
                            guessWidth -= charWidth;
                            break block5;
                        }
                        ++wrapIndex;
                    }
                    break block5;
                }
                if (guessWidth != wrapWidth) break block7;
                if (wrapIndex != currIndex) break block5;
                wrapWidth = metrics.charWidth(textChars[wrapIndex]);
                ++wrapIndex;
                break block5;
            }
            while (guessWidth > wrapWidth && wrapIndex > currIndex + 1) {
                char ch;
                if ((ch = textChars[--wrapIndex]) == '\t') {
                    guessWidth = metrics.charsWidth(textChars, 0, wrapIndex + 1);
                    continue;
                }
                guessWidth -= metrics.charWidth(textChars[wrapIndex]);
            }
        }
        return wrapIndex;
    }
}

