/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.commands;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Table;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import net.ucanaccess.commands.AbstractCursorCommand;
import net.ucanaccess.commands.CompositeCommand;
import net.ucanaccess.commands.ICommand;
import net.ucanaccess.commands.IFeedbackAction;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.jdbc.UcanaccessConnection;

public class AutoNumberAction
implements IFeedbackAction {
    private final Map<String, Object> newAutoValues = new HashMap<String, Object>();
    private final Map<String, Object> oldAutoValues = new HashMap<String, Object>();
    private final Table table;

    public AutoNumberAction(Table _table, Object[] memento, Object[] byAccess) throws SQLException {
        this.table = _table;
        int i = 0;
        for (Column col : _table.getColumns()) {
            if (col.isAutoNumber()) {
                UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
                Connection connHsqldb = conn.getHSQLDBConnection();
                String cn = SQLConverter.escapeIdentifier(col.getName(), connHsqldb);
                Object cnOld = memento[i];
                Object cnNew = byAccess[i];
                if (cnNew instanceof String) {
                    cnNew = ((String)cnNew).toUpperCase();
                }
                this.oldAutoValues.put(col.getName(), cnOld);
                this.newAutoValues.put(col.getName(), cnNew);
                conn.setFeedbackState(true);
                String stmt = "UPDATE " + SQLConverter.escapeIdentifier(_table.getName(), connHsqldb) + " SET " + cn + "=? WHERE " + cn + "=?";
                Throwable throwable = null;
                Object var14_15 = null;
                try (PreparedStatement ps = connHsqldb.prepareStatement(stmt);){
                    ps.setObject(1, cnNew);
                    ps.setObject(2, cnOld);
                    ps.executeUpdate();
                    conn.setGeneratedKey(cnNew);
                    conn.setFeedbackState(false);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            ++i;
        }
    }

    @Override
    public void doAction(ICommand toChange) {
        if (!this.table.getName().equalsIgnoreCase(toChange.getTableName())) {
            return;
        }
        switch (toChange.getType()) {
            case DELETE: 
            case UPDATE: {
                AbstractCursorCommand acm = (AbstractCursorCommand)toChange;
                Map<String, Object> old = acm.getRowPattern();
                for (Map.Entry<String, Object> entry : this.oldAutoValues.entrySet()) {
                    if (!old.containsKey(entry.getKey()) || !old.get(entry.getKey()).equals(entry.getValue())) continue;
                    old.put(entry.getKey(), this.newAutoValues.get(entry.getKey()));
                }
                break;
            }
            case COMPOSITE: {
                CompositeCommand cc = (CompositeCommand)toChange;
                for (ICommand iCommand : cc.getComposite()) {
                    this.doAction(iCommand);
                }
                break;
            }
        }
    }
}

