/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.presutil;

import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.presutil.GradientStopObj;
import oracle.javatools.annotations.Concealed;

@Concealed
public class GradientObj
implements Cloneable {
    public static final double DEFAULT_ANGLE = 270.0;
    public static final int LEFT = 2;
    public static final int UP = 4;
    public static final int UP_LEFT = 6;
    public static final int UP_RIGHT = 8;
    private List<GradientStopObj> m_stopList = new ArrayList<GradientStopObj>();
    private GradientType m_type;
    private int m_directionConstant;
    private double m_angle = 270.0;
    private Point2D m_startPoint;
    private Point2D m_endPoint;
    private Point2D m_center;
    private double m_radius = -1.0;
    private Point2D m_focus;
    private MultipleGradientPaint.CycleMethod cycleMethod = MultipleGradientPaint.CycleMethod.NO_CYCLE;
    private AffineTransform transform;

    public GradientObj() {
        this.m_type = GradientType.LINEAR;
    }

    public GradientObj(int directionConstant) {
        this.setDirectionConstant(directionConstant);
    }

    public GradientObj(double angle) {
        this.m_type = GradientType.LINEAR;
        this.m_angle = angle;
    }

    public GradientObj(Point2D center, double radius) {
        this.m_type = GradientType.RADIAL;
        this.m_center = center;
        this.m_radius = radius;
        this.m_focus = center;
    }

    public void setFocus(Point2D point) {
        this.m_focus = point;
    }

    public List<GradientStopObj> getStopList() {
        return this.m_stopList;
    }

    public void setDirectionConstant(int dir) {
        this.m_directionConstant = dir;
        switch (dir) {
            case 1: {
                this.m_type = GradientType.LINEAR;
                this.m_angle = 0.0;
                break;
            }
            case 2: {
                this.m_type = GradientType.LINEAR;
                this.m_angle = 180.0;
                break;
            }
            case 3: {
                this.m_type = GradientType.LINEAR;
                this.m_angle = 270.0;
                break;
            }
            case 4: {
                this.m_type = GradientType.LINEAR;
                this.m_angle = 90.0;
                break;
            }
            case 6: {
                this.m_type = GradientType.LINEAR;
                this.m_angle = 135.0;
                break;
            }
            case 5: {
                this.m_type = GradientType.LINEAR;
                this.m_angle = 225.0;
                break;
            }
            case 8: {
                this.m_type = GradientType.LINEAR;
                this.m_angle = 45.0;
                break;
            }
            case 7: {
                this.m_type = GradientType.LINEAR;
                this.m_angle = 315.0;
                break;
            }
            case 20: {
                this.m_type = GradientType.LINEAR;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 21: {
                this.m_type = GradientType.RADIAL;
            }
        }
    }

    public int getDirectionConstant() {
        return this.m_directionConstant;
    }

    public void setType(GradientType type) {
        this.m_type = type;
    }

    public GradientType getType() {
        return this.m_type;
    }

    public void setAngle(double angle) {
        this.m_angle = angle;
    }

    public double getAngle() {
        return this.m_angle;
    }

    public void setStartPoint(Point2D startPoint) {
        this.m_startPoint = startPoint;
    }

    public Point2D getStartPoint() {
        return this.m_startPoint;
    }

    public void setEndPoint(Point2D endPoint) {
        this.m_endPoint = endPoint;
    }

    public Point2D getEndPoint() {
        return this.m_endPoint;
    }

    public void setCenter(Point2D center) {
        this.m_center = center;
    }

    public Point2D getCenter() {
        return this.m_center;
    }

    public void setRadius(double radius) {
        this.m_radius = radius;
    }

    public double getRadius() {
        return this.m_radius;
    }

    public void setCycleMethod(MultipleGradientPaint.CycleMethod cycleMethod) {
        this.cycleMethod = cycleMethod;
    }

    public void setTransform(AffineTransform at) {
        this.transform = at;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public void insertPin(double fValue, Color color) {
        this.insertPin(fValue, color, color);
    }

    public void insertPin(double fValue, Color leftColor, Color rightColor) {
        if (fValue < 0.0 || fValue > 1.0) {
            throw new AssertionException(0.0, 1.0, fValue);
        }
        GradientStopObj pin = new GradientStopObj(fValue, leftColor, rightColor);
        int nClosestPin = this.findClosestPin(fValue);
        if (this.m_stopList.isEmpty()) {
            this.m_stopList.add(pin);
            return;
        }
        GradientStopObj closestPin = this.m_stopList.get(nClosestPin);
        if (Math.abs(closestPin.getPosition() - fValue) < 0.001) {
            this.m_stopList.set(nClosestPin, pin);
        } else if (closestPin.getPosition() > fValue) {
            this.m_stopList.add(nClosestPin, pin);
        } else {
            this.m_stopList.add(nClosestPin + 1, pin);
        }
    }

    public void reverseDirection() {
        this.m_angle = (this.m_angle + 180.0) % 360.0;
    }

    public Paint getPaint(Shape shape) {
        if (this.m_stopList.isEmpty()) {
            return null;
        }
        float[] positions = new float[this.m_stopList.size()];
        Color[] colors = new Color[this.m_stopList.size()];
        for (int i = 0; i < this.m_stopList.size(); ++i) {
            GradientStopObj stop = this.m_stopList.get(i);
            positions[i] = (float)stop.getPosition();
            colors[i] = stop.getColor();
        }
        if (colors.length == 1) {
            return colors[0];
        }
        if (this.m_type == GradientType.LINEAR) {
            LinearGradientDef linear = this.getLinearGradientDef(shape);
            if (linear.x1 != linear.x2 || linear.y1 != linear.y2) {
                if (this.transform != null) {
                    Point2D.Float start = new Point2D.Float((float)linear.x1, (float)linear.y1);
                    Point2D.Float end = new Point2D.Float((float)linear.x2, (float)linear.y2);
                    return new LinearGradientPaint(start, end, positions, colors, this.cycleMethod, MultipleGradientPaint.ColorSpaceType.SRGB, this.transform);
                }
                return new LinearGradientPaint((float)linear.x1, (float)linear.y1, (float)linear.x2, (float)linear.y2, positions, colors, this.cycleMethod);
            }
            return null;
        }
        RadialGradientDef radial = this.getRadialGradientDef(shape);
        if (this.transform == null) {
            return new RadialGradientPaint((float)radial.cx, (float)radial.cy, (float)radial.radius, (float)radial.fx, (float)radial.fy, positions, colors, this.cycleMethod);
        }
        Point2D.Double center = new Point2D.Double(radial.cx, radial.cy);
        Point2D.Double focus = new Point2D.Double(radial.fx, radial.fy);
        return new RadialGradientPaint(center, (float)radial.radius, focus, positions, colors, this.cycleMethod, MultipleGradientPaint.ColorSpaceType.SRGB, this.transform);
    }

    public RadialGradientDef getRadialGradientDef(Shape shape) {
        if (this.m_type != GradientType.RADIAL) {
            return null;
        }
        Rectangle bounds = shape.getBounds();
        Point2D center = this.m_center;
        Point2D focus = this.m_focus;
        double radius = this.m_radius;
        if (this.m_center == null) {
            double x = 0.0;
            double y = 0.0;
            switch (this.m_directionConstant) {
                case 9: 
                case 21: {
                    x = bounds.getCenterX();
                    y = bounds.getCenterY();
                    radius = (double)Math.max(bounds.width, bounds.height) * 0.75;
                    break;
                }
                case 14: {
                    x = bounds.getX() + bounds.getWidth() / 4.0;
                    y = bounds.getY() + bounds.getHeight() / 4.0;
                    radius = (double)Math.max(bounds.width, bounds.height) * 0.75;
                    break;
                }
                case 10: {
                    x = bounds.getX();
                    y = bounds.getY();
                    radius = (double)Math.max(bounds.width, bounds.height) * 1.5;
                    break;
                }
                case 11: {
                    x = bounds.getMaxX();
                    y = bounds.getY();
                    radius = (double)Math.max(bounds.width, bounds.height) * 1.5;
                    break;
                }
                case 12: {
                    x = bounds.getX();
                    y = bounds.getMaxY();
                    radius = (double)Math.max(bounds.width, bounds.height) * 1.5;
                    break;
                }
                case 13: {
                    x = bounds.getMaxX();
                    y = bounds.getMaxY();
                    radius = (double)Math.max(bounds.width, bounds.height) * 1.5;
                }
            }
            center = new Point2D.Double(x, y);
        }
        if (focus == null) {
            focus = center;
        }
        if (radius < 0.0) {
            radius = (double)Math.max(bounds.width, bounds.height) * 0.75;
        }
        return new RadialGradientDef(center, focus, radius);
    }

    public LinearGradientDef getLinearGradientDef(Shape shape) {
        double y2;
        double y1;
        double x2;
        double x1;
        if (this.m_type != GradientType.LINEAR) {
            return null;
        }
        if (this.m_directionConstant == 20 && this.m_startPoint != null && this.m_endPoint != null) {
            return new LinearGradientDef(this.m_startPoint, this.m_endPoint);
        }
        Rectangle bounds = shape.getBounds2D().getBounds();
        double xMin = bounds.getMinX();
        double xMax = bounds.getMaxX();
        double xMid = (xMin + xMax) / 2.0;
        double yMin = bounds.getMinY();
        double yMax = bounds.getMaxY();
        double yMid = (yMin + yMax) / 2.0;
        double angle = this.m_angle % 360.0;
        if (angle <= 45.0 || angle >= 315.0) {
            x1 = xMin;
            x2 = xMax;
            double diff = Math.tan(Math.toRadians(angle)) * (double)bounds.width / 2.0;
            y1 = yMid + diff;
            y2 = yMid - diff;
        } else if (angle <= 135.0) {
            y1 = yMax;
            y2 = yMin;
            double diff = Math.tan(Math.toRadians(angle - 90.0)) * (double)bounds.width / 2.0;
            x1 = xMid + diff;
            x2 = xMid - diff;
        } else if (angle <= 225.0) {
            x1 = xMax;
            x2 = xMin;
            double diff = Math.tan(Math.toRadians(angle - 180.0)) * (double)bounds.width / 2.0;
            y1 = yMid - diff;
            y2 = yMid + diff;
        } else {
            y1 = yMin;
            y2 = yMax;
            double diff = Math.tan(Math.toRadians(angle - 270.0)) * (double)bounds.width / 2.0;
            x1 = xMid - diff;
            x2 = xMid + diff;
        }
        return new LinearGradientDef(x1, y1, x2, y2);
    }

    private int findClosestPin(double fValue) {
        if (fValue < 0.0 || fValue > 1.0) {
            throw new AssertionException(0.0, 1.0, fValue);
        }
        double fDist = 1.0;
        int nClosest = 0;
        for (int nPin = 0; nPin < this.m_stopList.size(); ++nPin) {
            GradientStopObj pin = this.m_stopList.get(nPin);
            if (!(Math.abs(pin.getPosition() - fValue) < fDist)) continue;
            fDist = Math.abs(pin.getPosition() - fValue);
            nClosest = nPin;
        }
        return nClosest;
    }

    public Color getColorAt(double fValue) {
        if (fValue < 0.0 || fValue > 1.0) {
            throw new AssertionException(0.0, 1.0, fValue);
        }
        fValue = 100.0 * fValue / 100.0;
        int nSize = this.m_stopList.size();
        for (int i = 0; i < nSize - 1; ++i) {
            GradientStopObj leftPin = this.m_stopList.get(i);
            GradientStopObj rightPin = this.m_stopList.get(i + 1);
            if (!(fValue >= leftPin.getPosition()) || !(fValue <= rightPin.getPosition())) continue;
            double fraction = (fValue - leftPin.getPosition()) / (rightPin.getPosition() - leftPin.getPosition());
            int r = (int)((double)leftPin.getRightColor().getRed() + fraction * (double)(rightPin.getLeftColor().getRed() - leftPin.getRightColor().getRed()));
            int g = (int)((double)leftPin.getRightColor().getGreen() + fraction * (double)(rightPin.getLeftColor().getGreen() - leftPin.getRightColor().getGreen()));
            int b = (int)((double)leftPin.getRightColor().getBlue() + fraction * (double)(rightPin.getLeftColor().getBlue() - leftPin.getRightColor().getBlue()));
            int a = (int)((double)leftPin.getRightColor().getAlpha() + fraction * (double)(rightPin.getLeftColor().getAlpha() - leftPin.getRightColor().getAlpha()));
            return new Color(r, g, b, a);
        }
        return null;
    }

    public void copy(GradientObj grad) {
        this.m_stopList = new ArrayList<GradientStopObj>();
        for (GradientStopObj stop : grad.m_stopList) {
            this.m_stopList.add((GradientStopObj)stop.clone());
        }
        this.m_directionConstant = grad.m_directionConstant;
        this.m_angle = grad.m_angle;
        this.m_center = grad.m_center;
        this.m_focus = grad.m_focus;
        this.m_radius = grad.m_radius;
        this.m_type = grad.m_type;
        this.m_startPoint = grad.m_startPoint;
        this.m_endPoint = grad.m_endPoint;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GradientObj)) {
            return false;
        }
        GradientObj gradient = (GradientObj)obj;
        if (this.m_angle != gradient.m_angle) {
            return false;
        }
        if (this.m_directionConstant != gradient.m_directionConstant) {
            return false;
        }
        if (this.m_radius != gradient.m_radius) {
            return false;
        }
        if (this.m_type != gradient.m_type) {
            return false;
        }
        if (this.m_center == null && gradient.m_center != null || !this.m_center.equals(gradient.m_center)) {
            return false;
        }
        if (this.m_focus == null && gradient.m_focus != null || !this.m_focus.equals(gradient.m_focus)) {
            return false;
        }
        if (this.m_startPoint == null && gradient.m_startPoint != null || !this.m_startPoint.equals(gradient.m_startPoint)) {
            return false;
        }
        if (this.m_endPoint == null && gradient.m_endPoint != null || !this.m_center.equals(gradient.m_endPoint)) {
            return false;
        }
        return (this.m_stopList != null || gradient.m_stopList == null) && this.m_stopList.equals(gradient.m_stopList);
    }

    protected Object clone() {
        GradientObj gradient = new GradientObj();
        gradient.copy(this);
        return gradient;
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode = 31 * hashCode + (int)this.m_angle;
        hashCode = 31 * hashCode + this.m_directionConstant;
        hashCode = 31 * hashCode + (int)this.m_radius;
        for (GradientStopObj stop : this.m_stopList) {
            hashCode = 31 * hashCode + stop.hashCode();
        }
        return hashCode;
    }

    public static enum GradientType {
        LINEAR,
        RADIAL;

    }

    public static class LinearGradientDef {
        public final double x1;
        public final double y1;
        public final double x2;
        public final double y2;

        private LinearGradientDef(double x1, double y1, double x2, double y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        private LinearGradientDef(Point2D start, Point2D end) {
            this.x1 = start.getX();
            this.y1 = start.getY();
            this.x2 = end.getX();
            this.y2 = end.getY();
        }
    }

    public static class RadialGradientDef {
        public final double cx;
        public final double cy;
        public final double fx;
        public final double fy;
        public final double radius;

        private RadialGradientDef(Point2D center, Point2D focus, double radius) {
            this.cx = center.getX();
            this.cy = center.getY();
            this.radius = radius;
            this.fx = focus.getX();
            this.fy = focus.getY();
        }
    }
}

