/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.HashMap;
import oracle.dss.graph.pfj.Access;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.DataFormat;
import oracle.dss.graph.pfj.DataItem;
import oracle.dss.graph.pfj.DataStorage;
import oracle.dss.graph.pfj.DatumObj;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JGraphType;
import oracle.dss.graph.pfj.LegendObj;
import oracle.dss.graph.pfj.MinMaxObj;
import oracle.dss.graph.pfj.MissingData;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.RelativeAxisObj;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.SmartChartBase;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.Detectiv;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.SimpleBlackBoxObj;
import oracle.dss.graph.pfj.event.TDGEventManager;

public abstract class JChart_Base
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int CM_AUTOMATIC = 0;
    public static final int CM_SERIES = 1;
    public static final int CM_GROUP = 2;
    public static final int CM_HEIGHT = 3;
    public static final int CM_THRESHOLD = 4;
    public static final int LARGE_DATASET = 899;
    public static final int SCROLLER_THICKNESS = 8;
    public static final int SCROLLER_THICKNESS_HORZ = 12;
    public static final int MIN_GRADIENT_WIDTH = 3;
    public static final int MIN_GRADIENT_HEIGHT = 3;
    public static final int MIN_GRADIENT_MARKER_SIZE = 8;
    public static final int MIN_GRADIENT_SLICE_SIZE = 10;
    protected Perspective m_Perspective;
    Access m_Access;
    JGraphType m_gt;
    LegendObj m_Legend;
    Detectiv m_Detectiv;
    int m_nTotalSeries;
    int m_nTotalGroups;
    int m_nSeries;
    int m_nGroups;
    boolean m_bAbsolute;
    boolean m_bStacked;
    boolean m_bWantRiserBorder;
    boolean m_bSmallDataSet;
    protected boolean m_bColorAutoshadeRisers;
    int m_nEffColorMode;
    int m_nSeriesLooping;
    IdentObj m_idColorByHeight;
    private boolean[] m_bSeriesHasSFX;
    boolean m_bDisplayOffScaleY1;
    boolean m_bDisplayOffScaleY2;
    boolean m_bDisplayOffScaleY3;
    boolean m_bDisplayOffScaleY4;
    boolean m_bDisplayOffScaleY5;
    int m_nFillMissingData;
    boolean m_autoGradient;
    boolean m_smallMarker;
    boolean m_bShowingZeroLabels = false;
    private HashMap<IdentObj, BlackBoxIF> m_assignSeriesColorMap = new HashMap();
    SeriesEnumerator m_sEnumForward;
    SeriesEnumerator m_sEnumReverse;
    GroupsEnumerator m_gEnumForward;
    GroupsEnumerator m_gEnumReverse;
    MissingData m_missData = null;
    private SimpleBlackBoxObj[] m_sbb;
    SmartChartBase m_SmartChart;
    boolean m_bFoundNullData;
    boolean m_positiveVal;
    boolean m_negativeVal;
    boolean m_zeroVal;
    boolean m_nullVal;
    boolean m_positiveValY1;
    boolean m_negativeValY1;
    boolean m_zeroValY1;
    boolean m_nullValY1;
    boolean m_positiveValY2;
    boolean m_negativeValY2;
    boolean m_zeroValY2;
    boolean m_nullValY2;
    boolean m_positiveValX1;
    boolean m_negativeValX1;
    boolean m_zeroValX1;
    boolean m_nullValX1;
    boolean m_dualY;
    boolean m_XY;
    boolean m_dualYX;
    boolean m_bDisplayX1Scroller;
    boolean m_bDisplayO1Scroller;
    boolean m_bDisplayY1Scroller;
    boolean m_bDisplayY2Scroller;

    public BlackBoxIF assignSeriesColor(int s, int g, boolean useCache) {
        try {
            boolean isPattern;
            boolean bl = isPattern = this.m_Perspective.getIntegerProp(Attr.SeriesEffect) == 3;
            if (this.m_autoGradient && this.m_smallMarker || !this.m_bColorAutoshadeRisers && this.m_nEffColorMode == 1 && !this.m_bSeriesHasSFX[s] && !isPattern) {
                boolean zoomable;
                boolean bl2 = zoomable = this.m_bDisplayX1Scroller || this.m_bDisplayO1Scroller || this.m_bDisplayY1Scroller || this.m_bDisplayY2Scroller;
                if (!zoomable) {
                    int index;
                    SimpleBlackBoxObj bb;
                    int effectiveSeries = this.m_Perspective.getEffectiveSeriesIndex(s);
                    if (effectiveSeries >= this.m_nSeriesLooping) {
                        this.m_Perspective.m_getDefault = false;
                        IdentObj idSeries = new IdentObj(-3, s);
                        Color c = this.m_Perspective.getFillColor(idSeries);
                        this.m_Perspective.m_getDefault = true;
                        if (c != null) {
                            return new SimpleBlackBoxObj(this.m_Perspective, idSeries, this.m_bWantRiserBorder);
                        }
                    }
                    if ((bb = this.m_sbb[index = effectiveSeries % this.m_nSeriesLooping]) != null) {
                        return bb;
                    }
                }
            }
        }
        catch (Exception isPattern) {
            // empty catch block
        }
        IdentObj idSeries = this.assignSeriesIdent(s, g);
        BlackBoxIF bb = this.assignSeriesColor(idSeries, useCache);
        return bb;
    }

    public BlackBoxIF assignSeriesColor(int s, int g) {
        return this.assignSeriesColor(s, g, true);
    }

    public BlackBoxIF assignSeriesColor(int s) {
        return this.assignSeriesColor(s, true);
    }

    public BlackBoxIF assignSeriesColor(int s, boolean useCache) {
        try {
            boolean isPattern;
            boolean bl = isPattern = this.m_Perspective.getIntegerProp(Attr.SeriesEffect) == 3;
            if (!(this.m_bColorAutoshadeRisers || this.m_nEffColorMode != 1 || this.m_bSeriesHasSFX[s] || isPattern)) {
                IdentObj idSeries;
                if (this.m_Perspective.getEffectiveSeriesIndex(s) >= this.m_nSeriesLooping) {
                    this.m_Perspective.m_getDefault = false;
                    idSeries = new IdentObj(-3, s);
                    Color c = this.m_Perspective.getFillColor(idSeries);
                    this.m_Perspective.m_getDefault = true;
                    if (c != null) {
                        SimpleBlackBoxObj sbb = new SimpleBlackBoxObj(this.m_Perspective, idSeries, this.m_bWantRiserBorder);
                        return sbb;
                    }
                }
                idSeries = new IdentObj(-3, s);
                idSeries.setUseSeriesLooping(true);
                SimpleBlackBoxObj bb = new SimpleBlackBoxObj(this.m_Perspective, idSeries, this.m_bWantRiserBorder);
                if (bb != null) {
                    return bb;
                }
            }
        }
        catch (Exception e) {
            System.out.println("exception in chartbase");
        }
        IdentObj idSeries = this.assignSeriesIdent(s, 0);
        return this.assignSeriesColor(idSeries, useCache);
    }

    public BlackBoxIF assignSeriesColor(IdentObj idSeries, boolean useCache) {
        if (useCache) {
            BlackBoxIF blackBox = this.m_assignSeriesColorMap.get(idSeries);
            if (blackBox == null) {
                blackBox = new BlackBoxObj(this.m_Perspective, idSeries);
                this.m_assignSeriesColorMap.put(idSeries, blackBox);
            }
            return blackBox;
        }
        return new BlackBoxObj(this.m_Perspective, idSeries);
    }

    public BlackBoxIF assignSeriesColor(IdentObj idSeries) {
        return this.assignSeriesColor(idSeries, true);
    }

    protected void clearSeriesBlackBoxCache() {
        this.m_smallMarker = false;
        this.m_assignSeriesColorMap.clear();
    }

    public IdentObj assignSeriesIdent(int s, int g) {
        int effectiveIndex;
        int index;
        if (this.m_Perspective.isColorByGroup()) {
            effectiveIndex = index = g;
        } else {
            index = s;
            effectiveIndex = this.m_Perspective.getEffectiveSeriesIndex(index);
        }
        if (effectiveIndex >= this.m_nSeriesLooping) {
            int sID = effectiveIndex % this.m_nSeriesLooping;
            IdentObj loopedSeries = new IdentObj(-3, sID);
            IdentObj idSeries = new IdentObj(-3, index);
            if (this.m_Perspective.getFillTypeObj(idSeries, false) == null) {
                int fillType = this.m_Perspective.getFillType(loopedSeries);
                this.m_Perspective.setFillType(idSeries, fillType);
                if (fillType == 2 && this.m_Perspective.getSeriesGradientEffect(loopedSeries.getSeriesID()) > 0) {
                    this.m_Perspective.setSeriesGradientEffect(idSeries.getSeriesID(), this.m_Perspective.getSeriesGradientEffect(loopedSeries.getSeriesID()));
                } else if (fillType == 4) {
                    this.m_Perspective.setSeriesPatternEffect(idSeries.getSeriesID(), 3);
                }
                return idSeries;
            }
            return idSeries;
        }
        IdentObj idSeries = new IdentObj(-3, index);
        idSeries.setUseSeriesLooping(true);
        return idSeries;
    }

    public void calc() {
        this.clearSeriesBlackBoxCache();
        this.m_bDisplayX1Scroller = this.m_Perspective.isX1AxisPresent() && (this.m_Perspective.isDataAxisScrollerPresent(2003) || this.m_Perspective.getIntegerProp(Attr.DataScrollerPresenceX1) != 0);
        this.m_bDisplayO1Scroller = this.m_Perspective.getJGraphType().getAxisDescriptor().hasO1() && (this.m_Perspective.isGroupScrollerPresent() || this.m_Perspective.getIntegerProp(Attr.DataScrollerPresenceGroups) != 0);
        this.m_bDisplayY1Scroller = this.m_Perspective.getJGraphType().getAxisDescriptor().hasY1() && (this.m_Perspective.isDataAxisScrollerPresent(2004) || this.m_Perspective.getIntegerProp(Attr.DataScrollerPresenceY1) != 0);
        this.m_bDisplayY2Scroller = this.m_Perspective.getJGraphType().getAxisDescriptor().hasY2() && (this.m_Perspective.isDataAxisScrollerPresent(2005) || this.m_Perspective.getIntegerProp(Attr.DataScrollerPresenceY2) != 0);
        this.m_positiveVal = false;
        this.m_negativeVal = false;
        this.m_zeroVal = false;
        this.m_nullVal = false;
        this.copyParams();
        this.calcAllMissingData();
        this.m_SmartChart = new SmartChartBase();
        this.m_SmartChart.init(this.m_Perspective);
        this.m_bFoundNullData = false;
        this.m_bShowingZeroLabels = this.m_Perspective.getZeroLabelDisplay();
    }

    private void calcAllMissingData() {
        JGraphType gt = this.m_Perspective.getJGraphType();
        if (this.m_nFillMissingData != 0 && gt.isBLAType()) {
            boolean bFirstTime = false;
            if (this.m_missData == null) {
                bFirstTime = true;
            }
            SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
            this.m_missData = new MissingData(this, this.m_Perspective, this.m_Access, this.m_Perspective.m_DataStorage);
            this.m_missData.calcMissingData(sEnum, bFirstTime);
        }
    }

    public void calcLegend() {
        if (this.m_Legend != null) {
            this.m_Legend.calc();
        }
    }

    protected void copyParams() {
        this.m_Detectiv = this.m_Perspective.getDetectiv();
        this.m_nSeries = this.m_Access.getNumNonIgnoredSeries();
        this.m_nGroups = this.m_Access.getNumGroups();
        this.m_bSmallDataSet = this.m_nSeries * this.m_nGroups < 899;
        this.m_nTotalSeries = this.m_Access.getNumTotalSeries();
        this.m_nTotalGroups = this.m_Access.getNumTotalGroups();
        this.m_bAbsolute = this.m_gt.isScalingAbs();
        this.m_bStacked = this.m_gt.isScalingStacked();
        this.m_nEffColorMode = this.m_Perspective.getEffectiveColorMode();
        this.m_bColorAutoshadeRisers = this.m_Perspective.getAutoshading() && this.m_bSmallDataSet;
        this.m_bDisplayOffScaleY1 = this.m_Perspective.getDisplayOffScale(2004);
        this.m_bDisplayOffScaleY2 = this.m_Perspective.getDisplayOffScale(2005);
        this.m_bDisplayOffScaleY3 = this.m_Perspective.getDisplayOffScale(2012);
        this.m_bDisplayOffScaleY4 = this.m_Perspective.getDisplayOffScale(2013);
        this.m_bDisplayOffScaleY5 = this.m_Perspective.getDisplayOffScale(2014);
        this.m_nFillMissingData = this.m_Perspective.getFillMissingData();
        switch (this.m_Perspective.getRiserBorderMode()) {
            case 0: {
                this.m_bWantRiserBorder = this.m_bSmallDataSet;
                break;
            }
            case 1: {
                this.m_bWantRiserBorder = false;
                break;
            }
            case 2: {
                this.m_bWantRiserBorder = true;
                break;
            }
            default: {
                throw new AssertionException("RiserBorderMode", 0, 2, this.m_Perspective.getRiserBorderMode());
            }
        }
        this.m_idColorByHeight = this.m_Perspective.getColorByHeight();
        this.m_Perspective.setFillType(this.m_idColorByHeight, 2);
        this.m_bSeriesHasSFX = new boolean[this.m_nTotalSeries];
        for (int s = 0; s < this.m_nTotalSeries; ++s) {
            IdentObj idSeries = this.m_Perspective.getSeries(s);
            idSeries.setUseSeriesLooping(true);
            this.m_bSeriesHasSFX[s] = this.m_Perspective.getFillType(idSeries) != 1 || this.m_Perspective.getShadowDisplay(idSeries);
        }
        this.m_sEnumForward = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        this.m_sEnumReverse = new SeriesEnumerator(this.m_Perspective, this.m_Access, false);
        this.m_gEnumForward = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        this.m_gEnumReverse = new GroupsEnumerator(this.m_Perspective, this.m_Access, false);
        boolean temp = this.m_Perspective.m_bUseEffectiveSeriesIndex;
        this.m_Perspective.m_bUseEffectiveSeriesIndex = false;
        this.m_nSeriesLooping = this.m_Perspective.getSeriesLooping();
        this.m_sbb = new SimpleBlackBoxObj[this.m_nSeriesLooping];
        for (int s = 0; s < this.m_nSeriesLooping; ++s) {
            IdentObj idSeries = new IdentObj(-3, s);
            this.m_sbb[s] = new SimpleBlackBoxObj(this.m_Perspective, idSeries, this.m_bWantRiserBorder);
        }
        this.m_Perspective.m_bUseEffectiveSeriesIndex = temp;
        this.m_autoGradient = this.m_Perspective.getSeriesGradientEffect(0) == 2;
    }

    public void createLegend() {
        this.m_Legend = new LegendObj(this.m_Perspective, this.m_Access, this, false);
    }

    public MinMaxObj findPreScaledLimits(int nAxis, int nScaling, boolean bMustIncludeZero) {
        MinMaxObj preScaleMinMax = null;
        return preScaleMinMax;
    }

    protected BlackBoxIF getBlackBox(IdentObj id) {
        int s = id.getSeriesID();
        int g = id.getGroupID();
        BlackBoxIF bb = s != -3 ? this.assignSeriesColor(s, g) : new BlackBoxObj(this.m_Perspective, id);
        return bb;
    }

    public BlackBoxIF getBlackBox(IdentObj id, double fRatio) {
        PfjAssert.pfjAssert(fRatio >= 0.0 && fRatio <= 1.0);
        if (fRatio < 0.0) {
            fRatio = 0.0;
        } else if (fRatio > 1.0) {
            fRatio = 1.0;
        }
        BlackBoxObj bbGradient = new BlackBoxObj(this.m_Perspective, this.m_idColorByHeight);
        BlackBoxIF bb = this.getBlackBox(id);
        bb.setFillColor(bbGradient.getGradientColorAt(fRatio));
        return bb;
    }

    public DatumObj getDataValue(int s, int g) {
        if (this.m_Perspective.isIrregularTimeAxis()) {
            return this.getDataValue(s, g, DataItem.DI_XY_Y, false);
        }
        return this.getDataValue(s, g, DataItem.DI_GENERAL, false);
    }

    public DatumObj getDataValue(int s, int g, DataItem item) {
        return this.getDataValue(s, g, item, false);
    }

    public DatumObj getDataValue(int s, int g, DataItem item, boolean ignoreDataRange) {
        double fValue;
        boolean bStatus = true;
        try {
            fValue = this.m_Access.getDataAsDouble(s, g, item, ignoreDataRange);
            if (!Double.isNaN(fValue)) {
                if (this.m_nFillMissingData != 0 && this.m_Access.m_DataStorage.isMissingDataFilledIn(s, g)) {
                    bStatus = true;
                }
            } else {
                this.m_nullVal = true;
                fValue = 0.0;
                bStatus = false;
            }
        }
        catch (Exception e) {
            this.m_nullVal = true;
            fValue = 0.0;
            bStatus = false;
        }
        DatumObj dObj = new DatumObj(fValue, bStatus);
        return dObj;
    }

    public String getStringDataValue(int series, int group, DataItem item, boolean ignoreDataRange) {
        String str = "";
        try {
            str = this.m_Access.getDataAsString(series, group, item);
        }
        catch (AssertionException assertionException) {
            // empty catch block
        }
        return str;
    }

    public String getStringDataValue(int series, int group, DataItem item) {
        return this.getStringDataValue(series, group, item, false);
    }

    public void setDataAsDouble(int series, int group, DataItem item, double d, boolean ignoreDataRange) {
        this.m_Access.setDataAsDouble(series, group, item, d, ignoreDataRange);
    }

    public void setDataAsDouble(int series, int group, DataItem item, double d) {
        this.setDataAsDouble(series, group, item, d, false);
    }

    public void setDataAsString(int series, int group, DataItem item, String str, boolean ignoreDataRange) {
        this.m_Access.setDataAsString(series, group, item, str, ignoreDataRange);
    }

    public void setDataAsString(int series, int group, DataItem item, String str) {
        this.setDataAsString(series, group, item, str, false);
    }

    public Point2D getDataValuesXY(int s, int g) throws AssertionException {
        if (this.m_Perspective.isMixedFreqTimeAxis()) {
            DataItem item = DataItem.DI_XY_X;
            DatumObj dObj = this.getDataValue(s, g, item);
            double x = 0.0;
            double y = 0.0;
            if (dObj.m_bOK) {
                x = dObj.m_fValue;
            }
            item = DataItem.DI_XY_Y;
            dObj = this.getDataValue(s, g, item);
            if (dObj.m_bOK) {
                y = dObj.m_fValue;
            }
            return new Point2D.Double(x, y);
        }
        DatumObj dObj = this.getDataValue(s, g);
        if (!dObj.m_bOK) {
            throw new AssertionException();
        }
        return new Point2D.Double(g, dObj.m_fValue);
    }

    protected Point getVCPositionsXY(int s, double x, double y) throws AssertionException {
        throw new AssertionException("getVCPositionsXY not implemented for chart type " + this.m_gt.getChartName());
    }

    public Detectiv getDetectiv() {
        return this.m_Detectiv;
    }

    public double getAutoLowerSplitValue(IdentObj id) {
        return Double.NaN;
    }

    public double getAutoHigherSplitValue(IdentObj id) {
        return Double.NaN;
    }

    public double getQuantizedDataValue(int nSeries, int nGroup) {
        return this.getQuantizedDataValue(nSeries, nGroup, DataItem.DI_GENERAL);
    }

    public double getQuantizedDataValue(int nSeries, int nGroup, DataItem item) {
        throw new AssertionException("Data quantization by the spectral legend not supported by chart type " + this.m_gt.getChartName());
    }

    public GroupsEnumerator getResetGroupsEnumerator() {
        GroupsEnumerator gEnum = this.m_gEnumForward;
        PfjAssert.pfjAssert(gEnum != null);
        gEnum.reset();
        return gEnum;
    }

    public GroupsEnumerator getResetGroupsEnumerator(boolean bForward) {
        GroupsEnumerator gEnum = bForward ? this.m_gEnumForward : this.m_gEnumReverse;
        PfjAssert.pfjAssert(gEnum != null);
        gEnum.reset();
        return gEnum;
    }

    public SeriesEnumerator getResetSeriesEnumerator() {
        SeriesEnumerator sEnum = this.m_sEnumForward;
        PfjAssert.pfjAssert(sEnum != null);
        sEnum.reset();
        return sEnum;
    }

    public SeriesEnumerator getResetSeriesEnumerator(boolean bForward) {
        SeriesEnumerator sEnum = bForward ? this.m_sEnumForward : this.m_sEnumReverse;
        PfjAssert.pfjAssert(sEnum != null);
        sEnum.reset();
        return sEnum;
    }

    public void init(Perspective perspective) {
        this.m_Perspective = perspective;
        this.m_gt = this.m_Perspective.getJGraphType();
        this.updateAccess();
        this.m_Legend = null;
    }

    public boolean isIgnoredOffScale(RelativeAxisObj axisObj, double fValue) {
        boolean bIsOffScale = axisObj.isValueOffscale(fValue);
        return bIsOffScale && !this.allowDisplayOffScale(axisObj);
    }

    public boolean allowDisplayOffScale(RelativeAxisObj axisObj) {
        boolean bDisplayOffScale;
        if (this.m_gt.isScatter() || this.m_gt.isBubble()) {
            bDisplayOffScale = false;
        } else {
            int nID = axisObj.getAxisObjID();
            switch (nID) {
                case 0: {
                    bDisplayOffScale = this.m_bDisplayOffScaleY1;
                    break;
                }
                case 1: {
                    bDisplayOffScale = this.m_bDisplayOffScaleY2;
                    break;
                }
                case 2: {
                    bDisplayOffScale = this.m_bDisplayOffScaleY3;
                    break;
                }
                case 3: {
                    bDisplayOffScale = this.m_bDisplayOffScaleY4;
                    break;
                }
                case 4: {
                    bDisplayOffScale = this.m_bDisplayOffScaleY5;
                    break;
                }
                default: {
                    bDisplayOffScale = false;
                }
            }
        }
        return bDisplayOffScale;
    }

    public boolean isBadValueInLogscale(RelativeAxisObj axisObj, double fValue) {
        boolean bIsBad = fValue <= 0.0;
        boolean bIsLog = axisObj.isLogScale();
        return bIsBad && bIsLog;
    }

    public boolean isBadValueInLogscale(int axis, double fValue) {
        boolean bIsBad = fValue <= 0.0;
        return bIsBad && (switch (axis) {
            case 7 -> this.m_Perspective.getX1LogScale();
            case 0 -> this.m_Perspective.getY1LogScale();
            case 1 -> this.m_Perspective.getY2LogScale();
            case 2 -> this.m_Perspective.getY3LogScale();
            case 3 -> this.m_Perspective.getY4LogScale();
            case 4 -> this.m_Perspective.getY5LogScale();
            case 8 -> false;
            default -> {
                this.m_Perspective.getErrorHandler().log("isBadValueInLogscale: axis = " + axis + ". bIsLog = true.", this.getClass().getName(), "isBadValueInLogscale()");
                yield true;
            }
        });
    }

    public boolean isGroupScrollerPresent() {
        return false;
    }

    public boolean isSeriesScrollerPresent() {
        return false;
    }

    public boolean isDataAxisScrollerPresent(int axis) {
        return false;
    }

    public boolean optimizeData() {
        return false;
    }

    public void reloadOriginalData() {
    }

    public void releaseReferences() {
        this.m_Access.releaseReferences();
        if (this.m_Legend != null) {
            this.m_Legend.releaseReferences();
        }
        for (int s = 0; s < this.m_nSeriesLooping; ++s) {
            this.m_sbb[s].releaseReferences();
        }
        this.m_Perspective = null;
    }

    public void updateAccess() {
        this.m_Access = this.m_Perspective.isContinuousTimeAxis() && this.m_gt.isBLAType() ? new Access(this.m_Perspective, this.m_Perspective.m_DataStorage, this.m_Perspective.m_DataRange, DataFormat.DF_XY) : new Access(this.m_Perspective, this.m_Perspective.m_DataStorage, this.m_Perspective.m_DataRange, this.m_gt.getDataFormat());
        this.m_nSeries = this.m_Access.getNumNonIgnoredSeries();
        this.m_nGroups = this.m_Access.getNumGroups();
    }

    public void updateDataSet(DataStorage ds) {
    }

    public boolean wantLegend() {
        boolean bWantLegend = !this.m_Perspective.isColorByGroup();
        return bWantLegend;
    }

    protected BlackBoxIF getMissingDataBlackBox(int s, int g) {
        boolean bFilledMissingData;
        SimpleBlackBoxObj bbTransp = null;
        if (this.m_nFillMissingData != 0 && (bFilledMissingData = this.m_Access.m_DataStorage.isMissingDataFilledIn(s, g))) {
            IdentObj idSeries = this.m_Perspective.getSeries(s);
            bbTransp = new SimpleBlackBoxObj(this.m_Perspective, idSeries, this.m_bWantRiserBorder);
            bbTransp.setTransparentFillColor(true);
        }
        return bbTransp;
    }

    protected void fireInapropriateDataEvent() {
        int bitSet = 0;
        boolean axis = false;
        if (!(this.m_dualY || this.m_XY || this.m_dualYX)) {
            this.m_negativeVal = this.m_negativeValY1 || this.m_negativeVal;
            this.m_zeroVal = this.m_zeroValY1 || this.m_zeroVal;
            this.m_nullVal = this.m_nullValY1 || this.m_nullVal;
            this.m_positiveVal = this.m_positiveValY1 || this.m_positiveVal;
        } else if (this.m_XY && !this.m_positiveValY1 && this.m_positiveValX1) {
            axis = true;
            this.m_negativeVal = this.m_negativeValY1;
            this.m_zeroVal = this.m_zeroValY1;
            this.m_nullVal = this.m_nullValY1;
            this.m_positiveVal = this.m_positiveValY1;
        } else if (this.m_XY && this.m_positiveValY1 && !this.m_positiveValX1) {
            axis = true;
            this.m_negativeVal = this.m_negativeValX1;
            this.m_zeroVal = this.m_zeroValX1;
            this.m_nullVal = this.m_nullValX1;
            this.m_positiveVal = this.m_positiveValX1;
        } else if (this.m_XY) {
            this.m_negativeVal = this.m_negativeValY1 || this.m_negativeValX1;
            this.m_zeroVal = this.m_zeroValY1 || this.m_zeroValX1;
            this.m_nullVal = this.m_nullValY1 || this.m_nullValX1;
            this.m_positiveVal = this.m_positiveValY1 || this.m_positiveValX1;
        } else if (this.m_dualY && !this.m_positiveValY1 && this.m_positiveValY2) {
            axis = true;
            this.m_negativeVal = this.m_negativeValY1;
            this.m_zeroVal = this.m_zeroValY1;
            this.m_nullVal = this.m_nullValY1;
            this.m_positiveVal = this.m_positiveValY1;
        } else if (this.m_dualY && this.m_positiveValY1 && !this.m_positiveValY2) {
            axis = true;
            this.m_negativeVal = this.m_negativeValY2;
            this.m_zeroVal = this.m_zeroValY2;
            this.m_nullVal = this.m_nullValY2;
            this.m_positiveVal = this.m_positiveValY2;
        } else if (this.m_dualY) {
            this.m_negativeVal = this.m_negativeValY1 || this.m_negativeValY2;
            this.m_zeroVal = this.m_zeroValY1 || this.m_zeroValY2;
            this.m_nullVal = this.m_nullValY1 || this.m_nullValY2;
            this.m_positiveVal = this.m_positiveValY1 || this.m_positiveValY2;
        } else if (this.m_dualYX && !this.m_positiveValY1 && this.m_positiveValY2 && this.m_positiveValX1) {
            axis = true;
            this.m_negativeVal = this.m_negativeValY1;
            this.m_zeroVal = this.m_zeroValY1;
            this.m_nullVal = this.m_nullValY1;
            this.m_positiveVal = this.m_positiveValY1;
        } else if (this.m_dualYX && this.m_positiveValY1 && !this.m_positiveValY2 && this.m_positiveValX1) {
            axis = true;
            this.m_negativeVal = this.m_negativeValY2;
            this.m_zeroVal = this.m_zeroValY2;
            this.m_nullVal = this.m_nullValY2;
            this.m_positiveVal = this.m_positiveValY2;
        } else if (this.m_dualYX && this.m_positiveValY1 && this.m_positiveValY2 && !this.m_positiveValX1) {
            axis = true;
            this.m_negativeVal = this.m_negativeValX1;
            this.m_zeroVal = this.m_zeroValX1;
            this.m_nullVal = this.m_nullValX1;
            this.m_positiveVal = this.m_positiveValX1;
        } else if (this.m_dualYX) {
            this.m_negativeVal = this.m_negativeValY1 || this.m_negativeValY2 || this.m_negativeValX1;
            this.m_zeroVal = this.m_zeroValY1 || this.m_zeroValY2 || this.m_zeroValX1;
            this.m_nullVal = this.m_nullValY1 || this.m_nullValY2 || this.m_nullValX1;
            boolean bl = this.m_positiveVal = this.m_positiveValY1 || this.m_positiveValY2 || this.m_positiveValX1;
        }
        if (this.m_negativeVal) {
            bitSet |= 2;
        }
        if (this.m_zeroVal) {
            bitSet |= 1;
        }
        if (this.m_nullVal) {
            bitSet |= 4;
        }
        TDGEventManager evtMgr = this.m_Perspective.getEventManager();
        if (!axis) {
            if (bitSet == 4) {
                if (this.m_positiveVal) {
                    evtMgr.notifyPerspectiveListener((Object)this.m_Perspective, 3995, bitSet);
                } else {
                    evtMgr.notifyPerspectiveListener((Object)this.m_Perspective, 3993, bitSet);
                }
            } else if (bitSet != 0) {
                if (this.m_positiveVal) {
                    evtMgr.notifyPerspectiveListener((Object)this.m_Perspective, 3994, bitSet);
                } else {
                    evtMgr.notifyPerspectiveListener((Object)this.m_Perspective, 3992, bitSet);
                }
            }
        } else if (bitSet == 4) {
            evtMgr.notifyPerspectiveListener((Object)this.m_Perspective, 3997, bitSet);
        } else if (bitSet != 0) {
            evtMgr.notifyPerspectiveListener((Object)this.m_Perspective, 3996, bitSet);
        }
    }

    public boolean isSingleSeriesOnly() {
        return false;
    }

    public void setShowZeroSeries(boolean show) {
        this.m_bShowingZeroLabels = show;
    }

    public abstract void calcDataScrollers();
}

