/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.dss.graph.DataStyleType;
import oracle.dss.graph.GraphConstants;
import oracle.dss.graph.managers.GraphStyle;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.Axis2DObj;
import oracle.dss.graph.pfj.AxisDescriptor;
import oracle.dss.graph.pfj.AxisSplits;
import oracle.dss.graph.pfj.AxisTemplate;
import oracle.dss.graph.pfj.DataFormat;
import oracle.dss.graph.pfj.DataItem;
import oracle.dss.graph.pfj.DataTextPosition;
import oracle.dss.graph.pfj.DatumObj;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_2D;
import oracle.dss.graph.pfj.JChart_2D_Pie;
import oracle.dss.graph.pfj.JGraphType;
import oracle.dss.graph.pfj.Line;
import oracle.dss.graph.pfj.MarkerObj;
import oracle.dss.graph.pfj.MarkerTemplate;
import oracle.dss.graph.pfj.MarkerTemplateArray;
import oracle.dss.graph.pfj.MinMaxObj;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.RangeSlider;
import oracle.dss.graph.pfj.RelativeAxisObj;
import oracle.dss.graph.pfj.ScatterGraphDataStyle;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.TDGNumberFormat;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.ZoomState;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetArea;
import oracle.dss.graph.pfj.draw.DetLabel;
import oracle.dss.graph.pfj.draw.DetLine;
import oracle.dss.graph.pfj.draw.DetMarker;
import oracle.dss.graph.pfj.draw.DetMetadata;
import oracle.dss.graph.pfj.draw.DetPolygon;
import oracle.dss.graph.pfj.draw.DetPolyline;
import oracle.dss.graph.pfj.draw.DetShape;
import oracle.dss.graph.pfj.draw.Detectiv;
import oracle.dss.graph.pfj.draw.FillGradientObj;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.Polyline;
import oracle.dss.graph.pfj.draw.SimpleBlackBoxObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;
import oracle.dss.graph.pfj.math.CurveFitIF;
import oracle.dss.graph.pfj.math.SVD;
import oracle.dss.presutil.PresUtils;
import oracle.javatools.annotations.Concealed;
import oracle.javatools.mt.annotation.CodeSharingSafe;

public abstract class JChart_2D_Standard
extends JChart_2D {
    private static final long serialVersionUID = 1L;
    public static final int NO_PREVIOUS_SERIES = -2;
    static final int TWOD_MARKER_FIXUP = 3;
    RelativeAxisObj m_O1Axis;
    RelativeAxisObj m_X1Axis;
    RelativeAxisObj m_Y1Axis;
    RelativeAxisObj m_Y2Axis;
    RelativeAxisObj m_Z1Axis;
    RelativeAxisObj m_Y3Axis;
    RelativeAxisObj m_Y4Axis;
    RelativeAxisObj m_Y5Axis;
    int m_scaling;
    int[][] m_ordCoords;
    int m_barThickCoord;
    int[][] m_numXCoords;
    int[][] m_numYCoords;
    boolean[][] m_dataOK;
    String[][] m_DataLabel;
    boolean m_bDataTextDisplay;
    boolean m_bHorz;
    boolean m_bExtendToFrameEdge;
    boolean m_bIsThisAComboWithBar;
    boolean m_bSquareMarkers;
    boolean m_bMarkerDisplay;
    boolean m_bAllMarkersSameSize;
    int m_nMarkerSizeDefault;
    double[][] m_fStackedCumulativeValues;
    double[][] m_fPercentCumulativeValues;
    double[][] m_fPercentValues;
    SeriesEnumerator m_sEnumReverseForPrev;
    int[][] m_nParetoYCoordsVC;
    int[][] m_nParetoCoordsVC;
    int[] m_nMaxParetoYCoords;
    int[] m_nPercentParetoValues;
    double[] m_fMaxParetoActuals;
    double[] m_fMinParetoActuals;
    double[][] m_fParetoYCoords;
    int m_minValueGroupIndex = -1;
    int m_maxValueGroupIndex = -1;
    public static final double UNSHADED = 1.0;
    public static final double SHADING_FRONT = 1.0;
    public static final double SHADING_TOP = 0.8;
    public static final double SHADING_SIDE = 0.6;
    public static final double SHADING_BOTTOM = 0.4;
    protected Point[] m_seriesBackOffsets;
    protected Point[] m_seriesFrontOffsets;
    ArrayList<Object[]> m_bubbleMarkerInfo;
    @CodeSharingSafe(value="StaticField")
    private static Comparator<Object[]> m_bubbleComparator = new Comparator<Object[]>(){

        @Override
        public int compare(Object[] obj1, Object[] obj2) {
            int ySize2;
            int xSize2;
            int area2;
            int ySize1;
            int xSize1 = (Integer)obj1[4];
            int area1 = xSize1 * (ySize1 = ((Integer)obj1[5]).intValue());
            if (area1 > (area2 = (xSize2 = ((Integer)obj2[4]).intValue()) * (ySize2 = ((Integer)obj2[5]).intValue()))) {
                return -1;
            }
            if (area1 == area2) {
                return 0;
            }
            return 1;
        }

        @Override
        public boolean equals(Object obj) {
            return false;
        }
    };
    private int m_Width = 0;
    private int m_Style = 0;
    private boolean m_is3D = false;
    private BlackBoxIF m_blackBox = null;

    @Override
    public void calc() {
        super.calc();
        this.m_positiveValY1 = false;
        this.m_negativeValY1 = false;
        this.m_zeroValY1 = false;
        this.m_nullValY1 = false;
        this.m_positiveValY2 = false;
        this.m_negativeValY2 = false;
        this.m_zeroValY2 = false;
        this.m_nullValY2 = false;
        this.m_positiveValX1 = false;
        this.m_negativeValX1 = false;
        this.m_zeroValX1 = false;
        this.m_nullValX1 = false;
        this.m_dualY = false;
        this.m_XY = false;
        this.m_dualYX = false;
        this.createAxes();
        this.createRangeSlider();
        int nBorderWidth = this.m_Perspective.getLineWidth(this.m_Perspective.getFrame());
        if (this.m_Frame != null && this.m_Perspective.getFrameDisplay()) {
            this.m_Frame.drawFrameBorders(nBorderWidth);
        }
        this.drawAxisBody();
        if (this.m_bAbsolute) {
            this.calcDataAbsolute();
        } else if (this.m_bStacked) {
            this.calcDataStacked();
        } else if (this.m_gt.isScalingPercent()) {
            this.calcDataPercent();
        }
        if (this.m_Perspective.isContinuousTimeAxis() && this.m_gt.isBLAType()) {
            SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
            GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
            int numSeries = sEnum.getNumSeries();
            int numGroups = gEnum.getNumGroups();
            int[][] adjustedAxisCoordinates = new int[numSeries][numGroups];
            for (int sRel = 0; sRel < numSeries; ++sRel) {
                int s = sEnum.seriesAt(sRel);
                for (int gRel = 0; gRel < numGroups; ++gRel) {
                    int g = gEnum.groupAt(gRel);
                    if (s >= this.m_numXCoords.length || g >= this.m_numXCoords[s].length) continue;
                    adjustedAxisCoordinates[sRel][gRel] = this.m_numXCoords[s][g];
                }
            }
            this.m_O1Axis.setXCordinates(adjustedAxisCoordinates);
        }
        if (this.m_Perspective.getGraphType() != 96) {
            this.fireInapropriateDataEvent();
        }
    }

    protected void calcBarOrdinalCoords() {
        SeriesEnumerator sEnum = this.m_sEnumForward;
        GroupsEnumerator gEnum = this.m_gEnumForward;
        int axisOffset = 0;
        this.m_ordCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_barThickCoord = (int)(this.m_O1Axis.getHighCoord(0, 0) - this.m_O1Axis.getLowCoord(0, 0));
        boolean isOrientHorz = this.m_Perspective.isChartOrientHorz();
        this.m_smallMarker = !isOrientHorz && this.m_Perspective.m_VC.virtToDestWidth(this.m_barThickCoord) <= 3 || isOrientHorz && this.m_Perspective.m_VC.virtToDestHeight(this.m_barThickCoord) <= 3;
        for (int sRel = 0; sRel < this.m_nSeries; ++sRel) {
            int s = sEnum.seriesAt(sRel);
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            int axis = this.getAxisAssignment(s);
            axisOffset = 0;
            if (this.m_gt.isDualY() && this.m_bStacked && axis == 1) {
                axisOffset = 1;
            }
            for (int gRel = 0; gRel < this.m_nGroups; ++gRel) {
                int g = gEnum.groupAt(gRel);
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                this.m_ordCoords[s][g] = this.m_bAbsolute ? (int)this.m_O1Axis.getLowCoord(sRel, gRel) : (this.m_nTotalSeries > 1 ? (int)this.m_O1Axis.getLowCoord(axisOffset, gRel) : (int)this.m_O1Axis.getLowCoord(sRel, gRel));
            }
        }
    }

    protected void calcDataAbsolute() {
        int s;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        AxisDescriptor axisDescriptor = null;
        axisDescriptor = this.m_Perspective.isContinuousTimeAxis() && this.m_gt.isBLAType() ? AxisDescriptor.AD_XY : this.m_gt.getAxisDescriptor();
        RelativeAxisObj axisObj = null;
        double fValue = 0.0;
        boolean bUseXAxis = axisDescriptor.hasX1();
        DataFormat df = this.m_Access.getDataFormat();
        int nItems = df.getNumDataItems();
        boolean bScatter = this.m_gt.isScatter();
        boolean bBubble = this.m_gt.isBubble();
        boolean bScatterLabels = this.m_gt.isScatterWithLabel();
        int nDataFormat = this.m_Perspective.getDataTextFormat();
        String szFormatPattern = this.m_Perspective.getDataTextFormatPattern();
        String sDataTextTemplate = "";
        String[] dataItemStringArray = new String[nItems];
        boolean bNumberFormatCallBackActive = this.m_Perspective.isNumberFormatCallBack();
        this.m_numYCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        if (bUseXAxis) {
            this.m_numXCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        }
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        if (bScatterLabels || this.m_bDataTextDisplay) {
            this.m_DataLabel = new String[this.m_nTotalSeries][this.m_nTotalGroups];
        }
        if ((bScatter || bBubble) && !bScatterLabels && this.m_bDataTextDisplay) {
            sDataTextTemplate = bBubble ? this.m_Perspective.getDataTextTemplateBubble() : this.m_Perspective.getDataTextTemplateScatter();
        }
        while (sEnum.hasMoreElements() && (s = sEnum.nextSeries()) < this.m_nTotalSeries) {
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                DataItem item;
                int i;
                int g = gEnum.nextGroup();
                this.m_dataOK[s][g] = true;
                boolean bDataLabelDecided = false;
                if ((bScatter || bBubble) && !bScatterLabels && this.m_bDataTextDisplay) {
                    for (i = 0; i < nItems; ++i) {
                        item = df.getDataItem(i);
                        DatumObj dObj = this.getDataValue(s, g, item);
                        fValue = dObj.m_fValue;
                        if (bNumberFormatCallBackActive) {
                            int nAxisID = this.axisAssignedToSeries(s, item);
                            this.m_Perspective.getNumberFormatCallBack().setState(3, s, g, nAxisID, -3);
                            dataItemStringArray[i] = this.m_Perspective.getNumberFormatCallBack().toString(fValue);
                            continue;
                        }
                        dataItemStringArray[i] = TDGNumberFormat.toString(this.m_Perspective, nDataFormat, fValue, szFormatPattern);
                    }
                    this.m_DataLabel[s][g] = this.processDataTextTemplate(dataItemStringArray, sDataTextTemplate);
                    bDataLabelDecided = true;
                }
                for (i = 0; i < nItems; ++i) {
                    block25: {
                        item = df.getDataItem(i);
                        try {
                            if (item.isLabel()) {
                                if (this.m_Access.isCellNumeric(s, g, item)) {
                                    fValue = this.getDataValue((int)s, (int)g, (DataItem)item).m_fValue;
                                    if (bNumberFormatCallBackActive) {
                                        int nAxisID = this.axisAssignedToSeries(s, item);
                                        this.m_Perspective.getNumberFormatCallBack().setState(3, s, g, nAxisID, -3);
                                        this.m_DataLabel[s][g] = this.m_Perspective.getNumberFormatCallBack().toString(fValue);
                                    } else {
                                        this.m_DataLabel[s][g] = TDGNumberFormat.toString(this.m_Perspective, nDataFormat, fValue, szFormatPattern);
                                    }
                                } else {
                                    this.m_DataLabel[s][g] = this.m_Access.getDataAsString(s, g, item);
                                }
                            } else {
                                axisObj = this.whichAxisForSeries(s, item);
                                if (axisObj != null) {
                                    DatumObj dObj = this.getDataValue(s, g, item);
                                    fValue = dObj.m_fValue;
                                    if (!dObj.m_bOK) {
                                        this.m_dataOK[s][g] = dObj.m_bOK;
                                    }
                                    if (fValue <= 0.0 && this.isBadValueInLogscale(axisObj, fValue)) {
                                        this.m_dataOK[s][g] = false;
                                        fValue = 0.0;
                                    }
                                    if (this.isIgnoredOffScale(axisObj, fValue)) {
                                        this.m_dataOK[s][g] = false;
                                        fValue = 0.0;
                                    }
                                }
                            }
                        }
                        catch (AssertionException e) {
                            if (!item.isRequired()) break block25;
                            this.m_dataOK[s][g] = false;
                            fValue = 0.0;
                        }
                    }
                    if (item.isLabel() || axisObj == null) continue;
                    if (item.getAssocAxis() == 0) {
                        this.m_numYCoords[s][g] = (int)axisObj.getValueCoord(fValue);
                    } else if (item.getAssocAxis() == 7) {
                        this.m_numXCoords[s][g] = (int)axisObj.getValueCoord(fValue);
                    }
                    if (!this.m_bDataTextDisplay || bDataLabelDecided) continue;
                    if (bNumberFormatCallBackActive) {
                        int nAxisID = this.axisAssignedToSeries(s, item);
                        this.m_Perspective.getNumberFormatCallBack().setState(3, s, g, nAxisID, -3);
                        this.m_DataLabel[s][g] = this.m_Perspective.getNumberFormatCallBack().toString(fValue);
                        continue;
                    }
                    this.m_DataLabel[s][g] = TDGNumberFormat.toString(this.m_Perspective, nDataFormat, fValue, szFormatPattern);
                }
            }
        }
    }

    protected void calcDataPercent() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        int nDataFormat = 2;
        boolean bNumberFormatCallBackActive = this.m_Perspective.isNumberFormatCallBack();
        this.m_numYCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_fPercentCumulativeValues = new double[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_fPercentValues = new double[this.m_nTotalSeries][this.m_nTotalGroups];
        if (this.m_bDataTextDisplay) {
            this.m_DataLabel = new String[this.m_nTotalSeries][this.m_nTotalGroups];
        }
        while (gEnum.hasMoreElements()) {
            double fValue;
            int s;
            int g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            double fPosTotal = 0.0;
            double fNegTotal = 0.0;
            sEnum.reset();
            while (sEnum.hasMoreElements()) {
                s = sEnum.nextSeries();
                PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                DatumObj dObj = this.getDataValue(s, g);
                fValue = dObj.m_fValue;
                this.m_dataOK[s][g] = dObj.m_bOK;
                if (fValue >= 0.0) {
                    fPosTotal += fValue;
                    continue;
                }
                fNegTotal += fValue;
            }
            fNegTotal = -fNegTotal;
            double fTotTotal = fPosTotal + fNegTotal;
            double fPosRatio = fPosTotal / fTotTotal;
            double fNegRatio = fNegTotal / fTotTotal;
            double fPosSum = 0.0;
            double fNegSum = 0.0;
            sEnum.reset();
            while (sEnum.hasMoreElements()) {
                int nAxisID;
                s = sEnum.nextSeries();
                PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                RelativeAxisObj yAxisObj = this.whichAxisForSeries(s, DataItem.DI_GENERAL);
                if (yAxisObj == null) continue;
                fValue = this.getDataValue((int)s, (int)g).m_fValue;
                if (fValue >= 0.0 && fPosTotal > 0.0) {
                    this.m_fPercentCumulativeValues[s][g] = fPosRatio * (fPosSum += fValue) / fPosTotal;
                    this.m_fPercentValues[s][g] = fValue / fPosTotal;
                    this.m_numYCoords[s][g] = (int)yAxisObj.getValueCoord(fPosRatio * fPosSum / fPosTotal);
                    if (!this.m_bDataTextDisplay) continue;
                    if (bNumberFormatCallBackActive) {
                        nAxisID = this.axisAssignedToSeries(s, DataItem.DI_GENERAL);
                        this.m_Perspective.getNumberFormatCallBack().setState(3, s, g, nAxisID, -3);
                        this.m_DataLabel[s][g] = this.m_Perspective.getNumberFormatCallBack().toString(fPosRatio * fValue / fPosTotal);
                        continue;
                    }
                    this.m_DataLabel[s][g] = TDGNumberFormat.toString(this.m_Perspective, nDataFormat, fPosRatio * fValue / fPosTotal, "");
                    continue;
                }
                if (fValue < 0.0 && fNegTotal < 0.0) {
                    this.m_fPercentCumulativeValues[s][g] = fNegRatio * (fNegSum += fValue) / fNegTotal;
                    this.m_fPercentValues[s][g] = fValue / fNegTotal;
                    this.m_numYCoords[s][g] = (int)yAxisObj.getValueCoord(fNegRatio * fNegSum / fNegTotal);
                    if (!this.m_bDataTextDisplay) continue;
                    if (bNumberFormatCallBackActive) {
                        nAxisID = this.axisAssignedToSeries(s, DataItem.DI_GENERAL);
                        this.m_Perspective.getNumberFormatCallBack().setState(3, s, g, nAxisID, -3);
                        this.m_DataLabel[s][g] = this.m_Perspective.getNumberFormatCallBack().toString(fNegRatio * fValue / fNegTotal);
                        continue;
                    }
                    this.m_DataLabel[s][g] = TDGNumberFormat.toString(this.m_Perspective, nDataFormat, fNegRatio * fValue / fNegTotal, "");
                    continue;
                }
                this.m_dataOK[s][g] = false;
            }
        }
    }

    protected void calcParetoData() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        double fAccum = 0.0;
        double fValue = 0.0;
        int nTotalZeroCount = 0;
        this.m_nParetoYCoordsVC = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_nParetoCoordsVC = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_nMaxParetoYCoords = new int[this.m_nTotalSeries];
        this.m_fParetoYCoords = new double[this.m_nTotalSeries][this.m_nTotalGroups];
        sEnum.reset();
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            this.m_nMaxParetoYCoords[s] = 0;
            fAccum = 0.0;
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
                if (axisObj == null) continue;
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                DatumObj dObj = this.getDataValue(s, g, DataItem.DI_GENERAL);
                fValue = dObj.m_fValue;
                fAccum += Math.abs(fValue);
                if (fValue <= 0.0) {
                    ++nTotalZeroCount;
                    fValue = 0.0;
                }
                this.m_nParetoYCoordsVC[s][g] = (int)axisObj.getValueCoord(fAccum);
                this.m_fParetoYCoords[s][g] = fAccum;
                this.m_nParetoCoordsVC[s][g] = (int)this.m_O1Axis.getLowCoord(s, g);
                int n = s;
                this.m_nMaxParetoYCoords[n] = this.m_nMaxParetoYCoords[n] + this.m_nParetoYCoordsVC[s][g];
            }
        }
    }

    public double getParetoValue(int nSeries, int nGroup) {
        return this.m_fParetoYCoords[nSeries][nGroup];
    }

    public double getPercentCumulativeValue(int nSeries, int nGroup) {
        double fValue = 0.0;
        if (this.m_fPercentCumulativeValues != null) {
            fValue = this.m_fPercentCumulativeValues[nSeries][nGroup];
        }
        return fValue;
    }

    @Concealed
    public double getPercentValue(int nSeries, int nGroup) {
        double fValue = 0.0;
        if (this.m_fPercentValues != null) {
            fValue = this.m_fPercentValues[nSeries][nGroup];
        }
        return fValue;
    }

    private boolean isPercentGraph(int graphType) {
        return graphType == 23 || graphType == 30 || graphType == 47 || graphType == 35;
    }

    protected void calcDataStacked() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        this.m_numYCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_fStackedCumulativeValues = new double[this.m_nTotalSeries][this.m_nTotalGroups];
        if (this.m_bDataTextDisplay) {
            this.m_DataLabel = new String[this.m_nTotalSeries][this.m_nTotalGroups];
        }
        while (gEnum.hasMoreElements()) {
            int g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            SumObj sumObj = new SumObj();
            SumObj totalObj = this.getGroupTotals(g);
            sEnum.reset();
            while (sEnum.hasMoreElements()) {
                int s = sEnum.nextSeries();
                PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                RelativeAxisObj yAxisObj = this.whichAxisForSeries(s, DataItem.DI_GENERAL);
                if (yAxisObj == null) continue;
                DatumObj dObj = this.getDataValue(s, g);
                double fValue = dObj.m_fValue;
                this.m_dataOK[s][g] = dObj.m_bOK;
                if (fValue <= 0.0 && this.isBadValueInLogscale(yAxisObj, fValue)) {
                    fValue = 0.0;
                    this.m_dataOK[s][g] = false;
                }
                double fNewSum = this.processOneStackedValue(s, g, yAxisObj, fValue, sumObj);
                int nRiser = this.m_seriesTypes[s];
                int nAxis = this.getAxisAssignment(s);
                boolean bY2 = nAxis == 1;
                boolean bPos = fValue >= 0.0;
                double accValue = fNewSum;
                if (this.m_gt.isWaterfall() && nRiser != 1 || !this.m_gt.isWaterfall() && !this.m_Perspective.isMarkerTypeStacked(nRiser)) {
                    accValue = fValue;
                }
                this.m_fStackedCumulativeValues[s][g] = accValue;
                if (!this.m_bDataTextDisplay) continue;
                this.calcDataLabel(bPos, bY2, s, g, nRiser, fValue, sumObj, totalObj);
            }
        }
    }

    protected SumObj getGroupTotals(int g) {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        SumObj totalObj = new SumObj();
        sEnum.reset();
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            RelativeAxisObj yAxisObj = this.whichAxisForSeries(s, DataItem.DI_GENERAL);
            if (yAxisObj == null) continue;
            DatumObj dObj = this.getDataValue(s, g);
            double fValue = dObj.m_fValue;
            this.m_dataOK[s][g] = dObj.m_bOK;
            if (fValue <= 0.0 && this.isBadValueInLogscale(yAxisObj, fValue)) {
                fValue = 0.0;
                this.m_dataOK[s][g] = false;
            }
            this.processOneStackedValue(s, g, yAxisObj, fValue, totalObj);
        }
        return totalObj;
    }

    private void calcDataLabel(boolean bPos, boolean bY2, int s, int g, int nRiser, double fValue, SumObj sumObj, SumObj totalObj) {
        String szDataFormatPattern = this.m_Perspective.getDataTextFormatPattern();
        int nDataFormat = this.m_Perspective.getDataTextFormat();
        boolean bNumberFormatCallBackActive = this.m_Perspective.isNumberFormatCallBack();
        double fNewSum = sumObj.getSum(bPos, bY2, nRiser);
        if (this.m_Perspective.getStackedDataValueSum()) {
            if (TDGNumberFormat.isPercentFormat(nDataFormat)) {
                double fTotal = totalObj.getSum(bPos, bY2, nRiser);
                fNewSum /= fTotal;
            }
            if (this.m_gt.isWaterfall()) {
                fNewSum = this.m_fStackedCumulativeValues[s][g];
            }
        } else {
            fNewSum = fValue;
        }
        if (bNumberFormatCallBackActive) {
            int nAxisID = this.axisAssignedToSeries(s, DataItem.DI_GENERAL);
            this.m_Perspective.getNumberFormatCallBack().setState(3, s, g, nAxisID, -3);
            this.m_DataLabel[s][g] = this.m_Perspective.getNumberFormatCallBack().toString(fNewSum);
        } else {
            this.m_DataLabel[s][g] = TDGNumberFormat.toString(this.m_Perspective, nDataFormat, fNewSum, szDataFormatPattern);
        }
    }

    public double getStackedCumulativeValue(int nSeries, int nGroup) {
        double fValue = 0.0;
        if (this.m_fStackedCumulativeValues != null) {
            fValue = this.m_fStackedCumulativeValues[nSeries][nGroup];
        }
        return fValue;
    }

    protected void calcOrdinalCoords() {
        PfjAssert.pfjAssert(this.m_O1Axis != null);
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.m_gEnumForward;
        this.m_ordCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_barThickCoord = (int)(this.m_O1Axis.getHighCoord(0, 0) - this.m_O1Axis.getLowCoord(0, 0));
        for (int gRel = 0; gRel < this.m_nGroups; ++gRel) {
            int g = gEnum.groupAt(gRel);
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            int nOrdCoord = (int)this.m_O1Axis.getCenterCoord(gRel);
            sEnum.reset();
            while (sEnum.hasMoreElements()) {
                int s = sEnum.nextSeries();
                PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                this.m_ordCoords[s][g] = nOrdCoord;
            }
        }
    }

    protected int calcRisersPerPixel() {
        int nRisersPerPixel;
        if (this.m_gt.getIntegerGraphType() != 17) {
            if (this.m_gt.getIntegerGraphType() != 24) {
                if (this.m_gt.getIntegerGraphType() != 97) {
                    return 1;
                }
            }
        }
        if (this.isComboWithNonBar() || this.m_Frame == null) {
            return 1;
        }
        Rectangle rFrame = this.m_Frame.getBackWallBounds();
        int nPixels = this.m_bHorz ? this.m_Perspective.m_VC.virtToDestHeight(rFrame.height) : this.m_Perspective.m_VC.virtToDestWidth(rFrame.width);
        if (nPixels == 0) {
            nRisersPerPixel = 1;
        } else {
            nRisersPerPixel = this.m_nSeries * this.m_nGroups / nPixels;
            if (nRisersPerPixel < 1) {
                nRisersPerPixel = 1;
            }
        }
        return nRisersPerPixel;
    }

    @Override
    protected void copyParams() {
        super.copyParams();
        this.m_bHorz = this.m_gt.isOrientHorz();
        this.m_bDataTextDisplay = this.m_Perspective.getDataTextDisplay();
        this.m_sEnumReverseForPrev = new SeriesEnumerator(this.m_Perspective, this.m_Access, false);
        this.m_bExtendToFrameEdge = this.m_gt.isParetoType() ? false : this.m_Perspective.getExtendToFrameEdge();
        this.m_bIsThisAComboWithBar = this.isComboWithBar();
        this.m_bSquareMarkers = this.m_Perspective.getSquareMarkers();
        this.m_bMarkerDisplay = this.m_Perspective.getMarkerDisplay();
        this.m_nMarkerSizeDefault = this.m_Perspective.getMarkerSizeDefault();
    }

    protected void createAxes() {
        boolean bVerticalChart;
        AxisDescriptor axisDescriptor = this.m_gt.getAxisDescriptor();
        AxisSplits axisSplits = new AxisSplits(this.m_Perspective);
        axisSplits.calc();
        int[] offsetArray = axisSplits.getAxisOffsets();
        int[] sizeArray = axisSplits.getAxisSizes();
        axisSplits.releaseReferences();
        axisSplits = null;
        this.m_scaling = this.m_gt.getScalingMethod();
        int ordType = this.whichOrdType();
        this.m_Perspective.setMinimumAxisTextSizeVC(16000);
        int nSaveMode = this.m_Perspective.getAxisTextAutofitMode();
        this.m_Perspective.setAxisTextAutofitMode(0);
        if (nSaveMode != 0) {
            this.m_Perspective.setTestLabelCalc(true);
        } else {
            this.m_Perspective.setTestLabelCalc(false);
        }
        boolean bl = bVerticalChart = this.m_gt.getOrientation() == 2;
        if (axisDescriptor.hasZ1()) {
            this.createZ1Axis(!bVerticalChart, true);
            this.calcAxis(this.m_Z1Axis);
        }
        if (axisDescriptor.hasO1()) {
            if (this.m_Perspective.isContinuousTimeAxis()) {
                this.createTimeAxis(!bVerticalChart, !this.m_Perspective.getX1AxisDescending());
                this.calcAxis(this.m_O1Axis);
            } else {
                this.createOrdinalAxis(ordType, !bVerticalChart, bVerticalChart);
                this.calcAxis(this.m_O1Axis);
            }
        } else if (axisDescriptor.hasX1()) {
            if (this.m_Perspective.isContinuousTimeAxis()) {
                this.createTimeAxis(!bVerticalChart, !this.m_Perspective.getX1AxisDescending());
                this.calcAxis(this.m_O1Axis);
            } else {
                this.createX1Axis(!bVerticalChart, !this.m_Perspective.getX1AxisDescending());
                this.calcAxis(this.m_X1Axis);
            }
        }
        if (axisDescriptor.hasY2()) {
            int y1Auto = 0;
            if (this.m_Perspective.getScaleMaxAuto(AxisTemplate.Y1_AXIS.getAxis())) {
                ++y1Auto;
            }
            if (this.m_Perspective.getScaleMinAuto(AxisTemplate.Y1_AXIS.getAxis())) {
                ++y1Auto;
            }
            if (!this.m_Perspective.getLogScale(AxisTemplate.Y1_AXIS.getAxis()) && this.m_Perspective.getGridStepAuto(AxisTemplate.Y1_AXIS.getMajor())) {
                ++y1Auto;
            }
            int y2Auto = 0;
            if (this.m_Perspective.getScaleMaxAuto(AxisTemplate.Y2_AXIS.getAxis())) {
                ++y2Auto;
            }
            if (this.m_Perspective.getScaleMinAuto(AxisTemplate.Y2_AXIS.getAxis())) {
                ++y2Auto;
            }
            if (!this.m_Perspective.getLogScale(AxisTemplate.Y2_AXIS.getAxis()) && this.m_Perspective.getGridStepAuto(AxisTemplate.Y2_AXIS.getMajor())) {
                ++y2Auto;
            }
            if (y1Auto <= y2Auto || this.m_gt.isParetoType() || this.m_gt.isStockType() || this.m_gt.isBipolar()) {
                this.createY1Axis(bVerticalChart, !this.m_Perspective.getY1AxisDescending(), offsetArray[0], sizeArray[0]);
                if (this.m_Y1Axis != null) {
                    this.calcAxis(this.m_Y1Axis);
                }
                this.createY2Axis(bVerticalChart, !this.m_Perspective.getY2AxisDescending(), offsetArray[1], sizeArray[1]);
                this.m_Y2Axis.m_requiredSteps = this.m_Y1Axis.m_numberOfSteps;
                this.calcAxis(this.m_Y2Axis);
            } else {
                this.createY2Axis(bVerticalChart, !this.m_Perspective.getY2AxisDescending(), offsetArray[1], sizeArray[1]);
                this.calcAxis(this.m_Y2Axis);
                this.createY1Axis(bVerticalChart, !this.m_Perspective.getY1AxisDescending(), offsetArray[0], sizeArray[0]);
                if (this.m_Y1Axis != null) {
                    this.m_Y1Axis.m_requiredSteps = this.m_Y2Axis.m_numberOfSteps;
                    this.calcAxis(this.m_Y1Axis);
                }
            }
        } else {
            this.createY1Axis(bVerticalChart, !this.m_Perspective.getY1AxisDescending(), offsetArray[0], sizeArray[0]);
            if (this.m_Y1Axis != null) {
                this.calcAxis(this.m_Y1Axis);
            }
        }
        if (axisDescriptor.hasY3()) {
            this.createY3Axis(bVerticalChart, !this.m_Perspective.getY3AxisDescending(), offsetArray[2], sizeArray[2]);
            this.calcAxis(this.m_Y3Axis);
        }
        if (axisDescriptor.hasY4()) {
            this.createY4Axis(bVerticalChart, !this.m_Perspective.getY4AxisDescending(), offsetArray[3], sizeArray[3]);
            this.calcAxis(this.m_Y4Axis);
        }
        if (axisDescriptor.hasY5()) {
            this.createY5Axis(bVerticalChart, !this.m_Perspective.getY5AxisDescending(), offsetArray[4], sizeArray[4]);
            this.calcAxis(this.m_Y5Axis);
        }
        this.m_Perspective.setAxisTextAutofitMode(nSaveMode);
        this.m_Perspective.setTestLabelCalc(false);
        if (this.m_Perspective.getAxisTextAutofitMode() != 0) {
            if (axisDescriptor.hasO1()) {
                if (this.m_O1Axis != null) {
                    this.m_O1Axis.calc();
                }
            } else if (axisDescriptor.hasX1() && this.m_X1Axis != null) {
                this.m_X1Axis.calc();
            }
            if (this.m_Y1Axis != null) {
                this.m_Y1Axis.calc();
            }
            if (axisDescriptor.hasY2() && this.m_Y2Axis != null) {
                this.m_Y2Axis.calc();
            }
            if (axisDescriptor.hasZ1() && this.m_Z1Axis != null) {
                this.m_Z1Axis.calc();
            }
        }
    }

    protected void calcAxis(RelativeAxisObj relAxis) {
        if (relAxis != null) {
            relAxis.calc();
            if (relAxis.getAxisTextLabelSizeVC() < this.m_Perspective.getMinimumAxisTextSizeVC()) {
                this.m_Perspective.setMinimumAxisTextSizeVC(relAxis.getAxisTextLabelSizeVC());
            }
        }
    }

    protected void applyTriangularBarsGradientEffect(BlackBoxIF bb) {
        IdentObj identObj = bb.getIdentObj();
        int direction = 1;
        Color c = this.m_Perspective.getFillColor(identObj);
        Color c1 = PresUtils.getPastel(c, 0.2);
        Color c2 = PresUtils.getPastel(c, 0.3);
        Color c3 = PresUtils.getPastel(c, 0.45);
        Color darkerColor = this.m_Perspective.getDarker(c);
        FillGradientObj fillGradient = new FillGradientObj(this.m_Perspective, direction);
        fillGradient.insertPin(0.0, c, c);
        fillGradient.insertPin(0.25, c1, c1);
        fillGradient.insertPin(0.35, c2, c2);
        fillGradient.insertPin(0.5, c3, c3);
        fillGradient.insertPin(0.501, darkerColor, darkerColor);
        fillGradient.insertPin(1.0, darkerColor, darkerColor);
        bb.setFillGradientObj(fillGradient);
    }

    protected void applyCylinderBarsGradientEffect(BlackBoxIF bb) {
        JGraphType gt = this.m_Perspective.getJGraphType();
        IdentObj identObj = bb.getIdentObj();
        int direction = 1;
        if (gt.isOrientHorz()) {
            direction = 4;
        }
        Color c = bb.getFillColor();
        Color darkerColor = this.m_Perspective.getDarker(c);
        Color brighterColor = this.m_Perspective.getBrighter(c);
        FillGradientObj fillGradient = new FillGradientObj(this.m_Perspective, direction);
        double midPinPos = 0.5;
        if (this.wantDepthEffect()) {
            midPinPos = 0.3 + 0.4 * ((double)this.m_Perspective.getDepthAngle() / 180.0);
        }
        fillGradient.insertPin(0.0, darkerColor, darkerColor);
        fillGradient.insertPin(midPinPos, brighterColor, brighterColor);
        fillGradient.insertPin(1.0, darkerColor, darkerColor);
        bb.setFillGradientObj(fillGradient);
    }

    protected boolean wantDepthEffect() {
        return this.m_nDepthRadius > 0 && this.m_gt.wantDepthEffect();
    }

    protected MinMaxObj createMinMaxZoom(RelativeAxisObj axis) {
        MinMaxObj minMaxZoom = null;
        if (axis == null) {
            return null;
        }
        PfjAssert.pfjAssert(this.isZoomingArmed());
        PfjAssert.pfjAssert(axis.isNumericAxis());
        ZoomState z = this.m_Perspective.getZoomList().getZoomState();
        if (z == null || !z.isZoomed()) {
            return null;
        }
        if (axis.isNumericAxis()) {
            minMaxZoom = z.getScaleMinMax(axis.getAxisObjID());
        }
        return minMaxZoom;
    }

    protected void createOrdinalAxis(int ordType, boolean bVerticalAxis, boolean bAscending) {
        this.m_O1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.O1_AXIS, ordType, bVerticalAxis, bAscending);
        this.m_O1Axis.setRangeSlider(this.m_Perspective.getHorzRangeSlider());
    }

    protected void createX1Axis(boolean bVerticalAxis, boolean bAscending) {
        MinMaxObj x1MinMaxZoom;
        boolean bMustIncludeZero = this.m_Perspective.getX1MustIncludeZero() && !this.m_Perspective.getX1LogScale();
        MinMaxObj x1MinMaxObj = this.findLimits(7, this.m_scaling, bMustIncludeZero, null);
        this.m_X1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.X1_AXIS, x1MinMaxObj, bVerticalAxis, bAscending, 0, 100);
        if (this.isZoomingArmed() && (x1MinMaxZoom = this.createMinMaxZoom(this.m_X1Axis)) != null) {
            this.m_X1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.X1_AXIS, x1MinMaxZoom, bVerticalAxis, bAscending, 0, 100);
        }
        this.m_X1Axis.setRangeSlider(this.m_Perspective.getHorzRangeSlider());
    }

    protected void createTimeAxis(boolean bVerticalAxis, boolean bAscending) {
        MinMaxObj x1MinMaxZoom;
        MinMaxObj x1MinMaxObj = this.findLimits(7, this.m_scaling, false, null);
        this.m_O1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.X1_AXIS, x1MinMaxObj, bVerticalAxis, bAscending, 0, 100);
        if (this.isZoomingArmed() && (x1MinMaxZoom = this.createMinMaxZoom(this.m_O1Axis)) != null) {
            this.m_O1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.X1_AXIS, x1MinMaxZoom, bVerticalAxis, bAscending, 0, 100);
        }
        this.m_O1Axis.setContinuousTimeAxis(true);
        this.m_O1Axis.setRangeSlider(this.m_Perspective.getHorzRangeSlider());
    }

    protected void createY1Axis(boolean bVerticalAxis, boolean bAscending, int nOffset, int nSize) {
        MinMaxObj y1MinMaxZoom;
        boolean bMustIncludeZero = this.m_Perspective.getY1MustIncludeZero() && !this.m_Perspective.getY1LogScale();
        MinMaxObj y1MinMaxObj = this.findLimits(0, this.m_scaling, bMustIncludeZero, null);
        this.m_Y1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Y1_AXIS, y1MinMaxObj, bVerticalAxis, bAscending, nOffset, nSize);
        if (this.isZoomingArmed() && (y1MinMaxZoom = this.createMinMaxZoom(this.m_Y1Axis)) != null) {
            this.m_Y1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Y1_AXIS, y1MinMaxZoom, bVerticalAxis, bAscending, nOffset, nSize);
        }
        this.m_Y1Axis.setRangeSlider(this.m_Perspective.getY1RangeSlider());
    }

    protected void createY2Axis(boolean bVerticalAxis, boolean bAscending, int nOffset, int nSize) {
        MinMaxObj y2MinMaxZoom;
        boolean bMustIncludeZero = this.m_Perspective.getY2MustIncludeZero() && !this.m_Perspective.getY2LogScale();
        MinMaxObj y2MinMaxObj = this.findLimits(1, this.m_scaling, bMustIncludeZero, null);
        if (this.m_nDepthRadius > 0 && this.m_nDepthAngle > 90 && !bVerticalAxis) {
            bAscending = !bAscending;
        }
        this.m_Y2Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Y2_AXIS, y2MinMaxObj, bVerticalAxis, bAscending, nOffset, nSize);
        if (this.isZoomingArmed() && (y2MinMaxZoom = this.createMinMaxZoom(this.m_Y2Axis)) != null) {
            this.m_Y2Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Y2_AXIS, y2MinMaxZoom, bVerticalAxis, bAscending, nOffset, nSize);
        }
        this.m_Y2Axis.setRangeSlider(this.m_Perspective.getY2RangeSlider());
    }

    protected void createZ1Axis(boolean bVerticalAxis, boolean bAscending) {
        boolean bZ1LogScale = false;
        boolean bZ1MustIncludeZero = false;
        boolean bDisplayOnCalc = false;
        boolean bMustIncludeZero = bZ1MustIncludeZero && !bZ1LogScale;
        MinMaxObj z1MinMaxObj = this.findLimits(8, this.m_scaling, bMustIncludeZero, null);
        this.m_Z1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Z1_AXIS, z1MinMaxObj, bVerticalAxis, bAscending, 0, 100, bDisplayOnCalc);
    }

    protected void createY3Axis(boolean bVerticalAxis, boolean bAscending, int nOffset, int nSize) {
        MinMaxObj y1MinMaxZoom;
        AxisTemplate template = AxisTemplate.Y3_AXIS;
        IdentObj id = template.getAxis();
        boolean bMustIncludeZero = this.m_Perspective.getScaleMustIncludeZero(id) && !this.m_Perspective.getLogScale(id);
        MinMaxObj y1MinMaxObj = this.findLimits(template.getAxisObjID(), this.m_scaling, bMustIncludeZero, null);
        this.m_Y3Axis = new Axis2DObj(this.m_Perspective, this.m_Access, template, y1MinMaxObj, bVerticalAxis, bAscending, nOffset, nSize);
        if (this.isZoomingArmed() && (y1MinMaxZoom = this.createMinMaxZoom(this.m_Y3Axis)) != null) {
            this.m_Y3Axis = new Axis2DObj(this.m_Perspective, this.m_Access, template, y1MinMaxZoom, bVerticalAxis, bAscending, nOffset, nSize);
        }
    }

    protected void createY4Axis(boolean bVerticalAxis, boolean bAscending, int nOffset, int nSize) {
        MinMaxObj y1MinMaxZoom;
        AxisTemplate template = AxisTemplate.Y4_AXIS;
        IdentObj id = template.getAxis();
        boolean bMustIncludeZero = this.m_Perspective.getScaleMustIncludeZero(id) && !this.m_Perspective.getLogScale(id);
        MinMaxObj y1MinMaxObj = this.findLimits(template.getAxisObjID(), this.m_scaling, bMustIncludeZero, null);
        this.m_Y4Axis = new Axis2DObj(this.m_Perspective, this.m_Access, template, y1MinMaxObj, bVerticalAxis, bAscending, nOffset, nSize);
        if (this.isZoomingArmed() && (y1MinMaxZoom = this.createMinMaxZoom(this.m_Y4Axis)) != null) {
            this.m_Y4Axis = new Axis2DObj(this.m_Perspective, this.m_Access, template, y1MinMaxZoom, bVerticalAxis, bAscending, nOffset, nSize);
        }
    }

    protected void createY5Axis(boolean bVerticalAxis, boolean bAscending, int nOffset, int nSize) {
        MinMaxObj y1MinMaxZoom;
        AxisTemplate template = AxisTemplate.Y5_AXIS;
        IdentObj id = template.getAxis();
        boolean bMustIncludeZero = this.m_Perspective.getScaleMustIncludeZero(id) && !this.m_Perspective.getLogScale(id);
        MinMaxObj y1MinMaxObj = this.findLimits(template.getAxisObjID(), this.m_scaling, bMustIncludeZero, null);
        this.m_Y5Axis = new Axis2DObj(this.m_Perspective, this.m_Access, template, y1MinMaxObj, bVerticalAxis, bAscending, nOffset, nSize);
        if (this.isZoomingArmed() && (y1MinMaxZoom = this.createMinMaxZoom(this.m_Y4Axis)) != null) {
            this.m_Y5Axis = new Axis2DObj(this.m_Perspective, this.m_Access, template, y1MinMaxZoom, bVerticalAxis, bAscending, nOffset, nSize);
        }
    }

    private void drawAxisBody() {
        if (this.m_O1Axis != null) {
            this.m_O1Axis.calcAxisBody();
        }
        if (this.m_X1Axis != null) {
            this.m_X1Axis.calcAxisBody();
        }
        if (this.m_Y1Axis != null) {
            this.m_Y1Axis.calcAxisBody();
        }
        if (this.m_Y2Axis != null) {
            this.m_Y2Axis.calcAxisBody();
        }
        if (this.m_Y3Axis != null) {
            this.m_Y3Axis.calcAxisBody();
        }
        if (this.m_Y4Axis != null) {
            this.m_Y4Axis.calcAxisBody();
        }
        if (this.m_Y5Axis != null) {
            this.m_Y5Axis.calcAxisBody();
        }
    }

    protected void drawDataValues() {
        double fValue;
        int s;
        int g;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        Graphics gx = this.m_Perspective.getGraphicsContext();
        IdentObj id = this.m_Perspective.getDataText();
        ArrayList<String> szLabels = new ArrayList<String>(this.m_nSeries * this.m_nGroups);
        Dimension labelDim = new Dimension(8000, 1600);
        boolean bDataValueFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(id);
        TextStyleObj textStyle = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(id), this.m_Perspective.getFontStyle(id), bDataValueFontSizeAbsolute, this.m_Perspective.getFontSize(id), this.m_Perspective.getFontSizeVC(id), this.m_Perspective.getTextRotation(id), this.m_Perspective.getTextJustHoriz(id), this.m_Perspective.getTextJustVert(id), false, false, this.m_Perspective.getTextWrap(id), this.m_Perspective.getLocale());
        while (gEnum.hasMoreElements()) {
            g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            sEnum.reset();
            while (sEnum.hasMoreElements()) {
                s = sEnum.nextSeries();
                PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                fValue = this.getDataValue((int)s, (int)g).m_fValue;
                this.m_DataLabel[s][g] = this.m_Perspective.getCustomDataText(this.m_DataLabel[s][g], new IdentObj(id.getObjectID(), s, g));
                if (fValue == 0.0 && this.m_bShowingZeroLabels && this.m_Perspective.isEnvironmentAdf()) {
                    this.m_DataLabel[s][g] = this.m_dataOK[s][g] ? this.m_Perspective.getIntlString("af_dvt_graph.ZERO_TEXT", null) : this.m_Perspective.getIntlString("af_dvt_graph.NULL_TEXT", null);
                }
                szLabels.add(this.m_DataLabel[s][g]);
            }
        }
        int nFontSizeVC = bDataValueFontSizeAbsolute ? this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(id)) : this.m_Perspective.getFontSizeVC(id);
        textStyle.formatAndAutofit(gx, this.m_Perspective, this.m_Perspective.getAutofit(id), this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), nFontSizeVC, szLabels, labelDim, this.m_Perspective.m_VC);
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, id);
        sEnum.reset();
        while (sEnum.hasMoreElements()) {
            s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            if (s == 0 && this.m_Perspective.getGraphType() == 95 || !this.m_Perspective.isExportingToXML() && this.m_Perspective.isNoRescaleHiddenSeries(s)) continue;
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                Rectangle rLabel;
                g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                fValue = this.isPercentGraph(this.m_Perspective.getGraphType()) ? this.getPercentValue(s, g) : this.getDataValue((int)s, (int)g).m_fValue;
                double riserHeight = this.getAxisAssignment(s) == 0 ? Math.abs(this.getY1Axis().getValueCoord(fValue) - (double)this.getBaseCoord(s)) : Math.abs(this.getY2Axis().getValueCoord(fValue) - (double)this.getBaseCoord(s));
                if (this.m_gt.isBarType() && !this.m_gt.isOrientHorz() && this.m_Perspective.getDataTextPosition() >= 3 && this.m_Perspective.getDataTextPosition() <= 5 && fValue != 0.0 && riserHeight < (double)labelDim.height * 1.5 || this.m_DataLabel[s][g] == null || (!this.m_dataOK[s][g] || fValue == 0.0) && (fValue != 0.0 || !this.m_bShowingZeroLabels && this.m_Perspective.isEnvironmentAdf()) || !this.m_Perspective.isEnvironmentAdf() && fValue == 0.0 && this.m_DataLabel[s][g].startsWith("0.00") || (rLabel = this.calcDataValuePosition(s, g, labelDim)) == null) continue;
                IdentObj newID = new IdentObj(id.getObjectID(), s, g);
                String fullText = this.m_DataLabel[s][g];
                String newLabel = this.getTruncatedLabel(textStyle, labelDim.width, fullText);
                new DetLabel(this.m_Detectiv, newID, newLabel, fullText, rLabel, textStyle, blackBox, false, null);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Rectangle calcDataValuePosition(int s, int g, Dimension dimLabel) {
        int adjustedBaseCoord;
        double dataPosition;
        Point ptTwoHalfDOffset;
        Rectangle rDataTextPos = null;
        int nValueCoord = this.m_numYCoords[s][g];
        Axis2DObj yAxisObj = (Axis2DObj)this.whichAxisForSeries(s, null);
        if (yAxisObj == null) return rDataTextPos;
        int nZeroCoord = (int)yAxisObj.getValueCoord(0.0);
        boolean bDescending = yAxisObj.isDescending();
        boolean bNegValue = bDescending ? nValueCoord > nZeroCoord : nValueCoord < nZeroCoord;
        int sPrev = this.prevSeriesForAxis(s, g, yAxisObj, bNegValue);
        int nPrevCoord = 0;
        boolean bPrevCoordValid = false;
        if (sPrev != -2) {
            bPrevCoordValid = true;
            nPrevCoord = this.m_numYCoords[sPrev][g];
        }
        boolean nonZeroBaseline = this.m_Perspective.getNonZeroBaseline(yAxisObj.getAxisIdentObj());
        double fBaseLine = this.m_Perspective.getNonZeroBaselineValue(yAxisObj.getAxisIdentObj());
        if (nonZeroBaseline && this.m_bAbsolute && !this.m_gt.isStockType() && !this.m_gt.isParetoType() && yAxisObj.isLogScale() && fBaseLine <= 0.0) {
            nonZeroBaseline = false;
        }
        int baseLineYCoord = 0;
        if (nonZeroBaseline) {
            baseLineYCoord = fBaseLine <= yAxisObj.getMaxValue() ? (int)yAxisObj.getValueCoord(fBaseLine) : (int)yAxisObj.getValueCoord(yAxisObj.getBaseMax());
        }
        int nDataTextPosition = this.m_Perspective.getDataTextPosition();
        int nGraphType = this.m_Perspective.getGraphType();
        Point ptCenterTop = this.getCoords(s, g);
        if (this.m_nDepthRadius > 0 && this.m_gt.wantDepthEffect()) {
            double fFrontOffset = this.calcFrontOffset(this.m_seriesPlanes[s], this.m_nDepthPlanes);
            ptTwoHalfDOffset = this.m_Frame.getDepthOffset(fFrontOffset);
            if (this.m_gt.isBLAType() && this.m_seriesTypes[s] == 2) {
                Rectangle rFrame = this.m_Frame.getBackWallBounds();
                if (rFrame == null) {
                    String expStr = "Can't draw data labels for 2.5D lines when m_Frame has no bounding rect";
                    throw new AssertionException(expStr);
                }
                double DEPTH_FACTOR = 12.0;
                int m_nLineThick = this.m_Perspective.getDataLineThickness();
                double fThickMax = this.m_bHorz ? (double)rFrame.width / DEPTH_FACTOR : (double)rFrame.height / DEPTH_FACTOR;
                int nOffset = (int)(fThickMax * (double)m_nLineThick / 100.0);
                if (this.m_bHorz) {
                    ptCenterTop.x = bNegValue ? (ptCenterTop.x -= nOffset / 2) : (ptCenterTop.x += nOffset / 2);
                } else {
                    ptCenterTop.y = bNegValue ? (ptCenterTop.y -= nOffset / 2) : (ptCenterTop.y += nOffset / 2);
                }
            }
        } else {
            ptTwoHalfDOffset = this.m_Frame.getDepthOffset(1.0);
        }
        double fDataValue = this.getDataValue((int)s, (int)g).m_fValue;
        int nBaseCoord = this.getBaseCoord(s);
        double baseValue = yAxisObj.getValueFromCoord(nBaseCoord);
        double fStackedCumVal = this.getStackedCumulativeValue(s, g);
        boolean stacked = false;
        double maxVal = yAxisObj.getMaxValue();
        double minVal = yAxisObj.getMinValue();
        int centerTop = this.m_bHorz ? ptCenterTop.x : ptCenterTop.y;
        int maxCoord = bNegValue ? (int)yAxisObj.getValueCoord(minVal) : (int)yAxisObj.getValueCoord(maxVal);
        if (this.m_gt.isLAType() && (bNegValue ? ptCenterTop.y < maxCoord : ptCenterTop.y > maxCoord)) {
            return null;
        }
        if (nGraphType == 25 || nGraphType == 27 || nGraphType == 29 || nGraphType == 37 || nGraphType == 18 || nGraphType == 20 || nGraphType == 22 || nGraphType == 32 || nGraphType == 95) {
            stacked = true;
        } else if (this.isPercentGraph(nGraphType)) {
            fDataValue = this.getPercentCumulativeValue(s, g);
        }
        double d = dataPosition = stacked ? fStackedCumVal : fDataValue;
        if (bNegValue) {
            if (dataPosition < minVal) {
                if (this.m_gt.isBLAType()) {
                    if (this.m_seriesTypes[s] == 2) return null;
                    if (this.m_seriesTypes[s] == 3) {
                        return null;
                    }
                    if (stacked) {
                        if (sPrev != -2 && nPrevCoord <= maxCoord) {
                            return null;
                        }
                        if (maxVal < 0.0) {
                            fDataValue = maxVal < fStackedCumVal - fDataValue ? minVal - maxVal : (fDataValue -= fStackedCumVal - minVal);
                            fStackedCumVal = minVal - maxVal;
                        } else {
                            fDataValue -= fStackedCumVal - minVal;
                            fStackedCumVal = minVal;
                        }
                    }
                }
                if (minVal >= 0.0) {
                    return null;
                }
                if (this.m_bHorz) {
                    ptCenterTop.x = maxCoord;
                } else {
                    ptCenterTop.y = maxCoord;
                }
            } else if (stacked && maxVal < 0.0) {
                if (fDataValue < fStackedCumVal - maxVal) {
                    fDataValue = fStackedCumVal - maxVal;
                }
                fStackedCumVal -= maxVal;
            }
        } else if (dataPosition > maxVal) {
            if (this.m_gt.isBLAType()) {
                if (this.m_seriesTypes[s] == 2) return null;
                if (this.m_seriesTypes[s] == 3) {
                    return null;
                }
                if (stacked) {
                    if (sPrev != -2 && nPrevCoord >= maxCoord) {
                        return null;
                    }
                    if (minVal > 0.0) {
                        fDataValue = minVal > fStackedCumVal - fDataValue ? maxVal - minVal : (fDataValue -= fStackedCumVal - maxVal);
                        fStackedCumVal = maxVal - minVal;
                    } else {
                        fDataValue -= fStackedCumVal - maxVal;
                        fStackedCumVal = maxVal;
                    }
                }
            }
            if (maxVal <= 0.0) {
                return null;
            }
            if (this.m_bHorz) {
                ptCenterTop.x = maxCoord;
            } else {
                ptCenterTop.y = maxCoord;
            }
        } else if (stacked && minVal > 0.0) {
            if (fDataValue > fStackedCumVal - minVal) {
                fDataValue = fStackedCumVal - minVal;
            }
            fStackedCumVal -= minVal;
        }
        if (bNegValue) {
            adjustedBaseCoord = (int)yAxisObj.getValueCoord(maxVal);
            if (nBaseCoord > adjustedBaseCoord) {
                nBaseCoord = adjustedBaseCoord;
                baseValue = maxVal;
            }
        } else {
            adjustedBaseCoord = (int)yAxisObj.getValueCoord(minVal);
            if (nBaseCoord < adjustedBaseCoord) {
                nBaseCoord = adjustedBaseCoord;
                baseValue = minVal;
            }
        }
        if (this.m_gt.isLAType() && nBaseCoord == adjustedBaseCoord && (bNegValue ? ptCenterTop.y > nBaseCoord : ptCenterTop.y < nBaseCoord)) {
            return null;
        }
        if (bNegValue) {
            if (dataPosition >= baseValue && this.m_gt.isBLAType()) {
                if (this.m_seriesTypes[s] != 2) {
                    if (this.m_seriesTypes[s] != 3) return null;
                }
                if (centerTop > nBaseCoord) {
                    return null;
                }
            }
        } else if (dataPosition < baseValue && this.m_gt.isBLAType()) {
            if (this.m_seriesTypes[s] != 2) {
                if (this.m_seriesTypes[s] != 3) return null;
            }
            if (centerTop < nBaseCoord) {
                return null;
            }
        }
        double fPercentCumVal = this.getPercentCumulativeValue(s, g);
        double fAngle = this.m_Perspective.getDataTextAngle(s, g);
        double fDist = this.m_Perspective.getDataTextRadius(s, g);
        boolean bIsCombo = this.isComboWithNonBar();
        DataTextPosition dataTextPos = new DataTextPosition(nDataTextPosition, nGraphType, ptTwoHalfDOffset, nBaseCoord, ptCenterTop, dimLabel, fDataValue, fStackedCumVal, fPercentCumVal, this.m_bHorz, this.isAxisAscending(s), fAngle, fDist, bIsCombo, nPrevCoord, bPrevCoordValid, nonZeroBaseline, baseLineYCoord, fBaseLine, this.m_Perspective);
        return dataTextPos.calcPosition();
    }

    protected Point getVCPositionsXY(int s, double x, double y, boolean bConstrainCoords) throws AssertionException {
        return this.getVCPositionsXY(s, x, y);
    }

    protected void drawEquationText(CurveFitIF curve, double[] a, int s, double dCorr) {
        Graphics gx = this.m_Perspective.getGraphicsContext();
        IdentObj id = this.m_Perspective.getCurveFitEquationText();
        IdentObj idSeries = this.m_Perspective.getCurveFitEquationText(s);
        Dimension labelDim = new Dimension(5000, 1600);
        int nCoeffs = curve.numCoeffs();
        String[] strCoeffs = new String[nCoeffs + 1];
        boolean bNumberFormatCallBackActive = this.m_Perspective.isNumberFormatCallBack();
        int nDataTextFormat = this.m_Perspective.getDataTextFormat();
        String sDataTextFormatPattern = this.m_Perspective.getDataTextFormatPattern();
        boolean bDrawCorrelation = false;
        for (int i = 1; i <= nCoeffs; ++i) {
            if (bNumberFormatCallBackActive) {
                this.m_Perspective.getNumberFormatCallBack().setState(3, s, -3, -1, -3);
                strCoeffs[i] = this.m_Perspective.getNumberFormatCallBack().toString(a[i]);
                continue;
            }
            strCoeffs[i] = TDGNumberFormat.toString(this.m_Perspective, nDataTextFormat, a[i], sDataTextFormatPattern);
        }
        TextStyleObj tsEquation = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(id), this.m_Perspective.getFontStyle(id), this.m_Perspective.getFontSizeAbsolute(), this.m_Perspective.getFontSize(id), this.m_Perspective.getFontSizeVC(id), this.m_Perspective.getTextRotation(id), this.m_Perspective.getTextJustHoriz(id), this.m_Perspective.getTextJustVert(id), false, false, this.m_Perspective.getTextWrap(id), this.m_Perspective.getLocale());
        int nFontSizeVC = this.m_Perspective.getFontSizeAbsolute() ? this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(id)) : this.m_Perspective.getFontSizeVC(id);
        BlackBoxObj bbEquation = new BlackBoxObj(this.m_Perspective, idSeries);
        Rectangle rEquation = this.m_Perspective.getRect(idSeries);
        IdentObj newID = new IdentObj(idSeries);
        Object strEquation = curve.createEquation(strCoeffs, this.m_Perspective.getCurveFitHighOrderFirst());
        if (bDrawCorrelation) {
            String strCorr;
            if (bNumberFormatCallBackActive) {
                this.m_Perspective.getNumberFormatCallBack().setState(3, s, -3, -1, -3);
                strCorr = this.m_Perspective.getNumberFormatCallBack().toString(dCorr);
            } else {
                strCorr = TDGNumberFormat.toString(this.m_Perspective, nDataTextFormat, dCorr, sDataTextFormatPattern);
            }
            strEquation = (String)strEquation + ", " + strCorr;
        }
        new DetLabel(this.m_Detectiv, newID, (String)strEquation, rEquation, tsEquation, (BlackBoxIF)bbEquation, true, null);
    }

    protected void drawFitLines() {
        if (this.m_bHorz) {
            return;
        }
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            CurveFitIF curveObj = this.m_Perspective.getCurveObj(s);
            if (curveObj == null) continue;
            this.drawOneFitLine(s, curveObj);
        }
    }

    protected void drawOneFitLine(int s, CurveFitIF curveObj) {
        int g;
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        int nCoeffs = curveObj.numCoeffs();
        int nPoints = 0;
        int gFirst = gEnum.getFirstGroup();
        double[] chisq = new double[1];
        double[] xPoints = new double[this.m_nTotalGroups + 1];
        double[] yPoints = new double[this.m_nTotalGroups + 1];
        for (g = 0; g < this.m_nTotalGroups; ++g) {
            try {
                Point2D ptData = this.getDataValuesXY(s, g);
                xPoints[++nPoints] = ptData.getX();
                yPoints[nPoints] = ptData.getY();
                continue;
            }
            catch (Exception ptData) {
                // empty catch block
            }
        }
        if (nPoints < nCoeffs) {
            return;
        }
        double[] a = new double[nCoeffs + 1];
        try {
            SVD.fit(curveObj, xPoints, yPoints, null, nPoints, a, chisq);
        }
        catch (Exception e) {
            return;
        }
        IdentObj id = this.m_Perspective.getCurveFitLineRiser(s);
        int nPixelWidth = this.m_Perspective.getLineWidth(id);
        if (nPixelWidth < 1) {
            nPixelWidth = 1;
        }
        int nWidth = this.m_Perspective.m_VC.destToVirtHeight(nPixelWidth);
        int nPlottedPoints = this.m_Perspective.getCurveFitNumSegments();
        if (nPlottedPoints > this.m_nTotalGroups) {
            switch (this.m_Perspective.getCurveFitType(s)) {
                case 4: 
                case 5: 
                case 9: {
                    nPlottedPoints = this.m_nTotalGroups + 1;
                    break;
                }
                default: {
                    nPlottedPoints = this.m_nTotalGroups;
                }
            }
        }
        double xMin = Double.MAX_VALUE;
        double xMax = -1.7976931348623157E308;
        int nViewablePoints = 0;
        while (gEnum.hasMoreElements()) {
            g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            try {
                Point2D ptData = this.getDataValuesXY(s, g);
                if (ptData.getX() < xMin) {
                    xMin = ptData.getX();
                }
                if (ptData.getX() > xMax) {
                    xMax = ptData.getX();
                }
                ++nViewablePoints;
            }
            catch (Exception ptData) {}
        }
        if (nViewablePoints < 2) {
            return;
        }
        double xIncr = (xMax - xMin) / (double)(nPlottedPoints - 1);
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, id);
        Polygon plottedPoly = new Polygon();
        for (int i = 0; i < nPlottedPoints; ++i) {
            try {
                double x = xMin + (double)i * xIncr;
                double y = curveObj.compute(x, a);
                Point pt0 = this.getVCPositionsXY(s, x - (double)gFirst, y, false);
                if (pt0 == null) continue;
                plottedPoly.addPoint(pt0.x, pt0.y);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (plottedPoly.npoints >= 2) {
            Polyline polyline = new Polyline(plottedPoly.xpoints, plottedPoly.ypoints, plottedPoly.npoints, nWidth);
            Polygon fitline = polyline.m_polygon;
            Rectangle frame = this.getFrameObj().getFrontWallBounds();
            if (this.m_rClip == null || this.m_rClip.contains(fitline.getBounds())) {
                new DetPolygon(this.m_Detectiv, id, fitline, (BlackBoxIF)blackBox, null);
            } else {
                Area fitlineArea = new Area(this.m_Perspective.m_VC.virtToDest(fitline));
                fitlineArea.intersect(new Area(this.m_Perspective.m_VC.virtToDest(this.m_rClip)));
                new DetShape(this.m_Detectiv, id, (BlackBoxIF)blackBox, fitlineArea);
            }
            if (this.m_Perspective.getCurveFitEquationDisplay()) {
                this.drawEquationText(curveObj, a, s, chisq[0]);
            }
        }
    }

    protected void drawCenteredSteppedLine(int s, boolean is3D) {
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        int g = 0;
        int gNext = 0;
        Point pt1 = null;
        Point pt2 = null;
        int halfWidth = 0;
        int previousHalfWidth = 0;
        boolean lastGroup = false;
        boolean firstGroup = true;
        boolean continuousAxis = this.m_Perspective.isContinuousTimeAxis();
        boolean bAutoMax = false;
        boolean bAutoMin = false;
        IdentObj idSeries = new IdentObj(-3, s);
        this.m_Width = this.m_Perspective.getLineWidth(idSeries);
        if (this.m_Width == (Integer)Attr.SeriesLineWidthDefault.getDefault()) {
            this.m_Width = this.m_Perspective.updateMargin(this.m_Width, true);
        }
        ArrayList<Point> points = new ArrayList<Point>(16);
        this.m_is3D = is3D;
        this.m_Style = this.m_Perspective.getLineStyle(idSeries);
        boolean lastOutOfBound = false;
        while (gEnum.hasMoreElements()) {
            g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            if (gEnum.hasMoreElements()) {
                gNext = gEnum.peekAtNextGroup();
                if (this.m_Perspective.isTimeAxis()) {
                    if (this.m_Perspective.getDateFrequency() == 3 && !this.m_dataOK[s][gNext]) {
                        while (gEnum.hasMoreElements() && !this.m_dataOK[s][gNext]) {
                            gNext = gEnum.nextGroup();
                            if (!gEnum.hasMoreElements()) continue;
                            gNext = gEnum.peekAtNextGroup();
                        }
                    }
                }
                PfjAssert.pfjAssert(gNext >= 0 && gNext < this.m_nTotalGroups);
            }
            lastGroup = g >= this.m_dataOK[s].length - 1 || !this.m_dataOK[s][g + 1];
            this.m_blackBox = this.assignSeriesColor(s, g);
            this.m_blackBox = this.m_blackBox.runRules(s, -3);
            this.m_blackBox.setTransparentBorderColor(false);
            if (this.m_blackBox.getFillColor() != null) {
                this.m_blackBox.setBorderColor(this.m_blackBox.getFillColor());
            }
            pt1 = this.getCoords(s, g);
            pt2 = !lastGroup ? this.getCoords(s, gNext) : this.getCoords(s, g);
            halfWidth = this.m_bHorz ? (pt1.y - pt2.y) / 2 : (pt2.x - pt1.x) / 2;
            if (firstGroup) {
                previousHalfWidth = continuousAxis ? 0 : halfWidth;
                firstGroup = false;
            }
            if (lastGroup) {
                halfWidth = continuousAxis ? 0 : previousHalfWidth;
            }
            if (!this.m_dataOK[s][g]) {
                previousHalfWidth = halfWidth;
                continue;
            }
            RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
            IdentObj AxisId = axisObj.getAxisIdentObj();
            bAutoMax = this.m_Perspective.getScaleMaxAuto(AxisId);
            bAutoMin = this.m_Perspective.getScaleMinAuto(AxisId);
            double fValue = this.getDataValue((int)s, (int)g, (DataItem)DataItem.DI_GENERAL).m_fValue;
            double max = axisObj.getMaxValue();
            double min = axisObj.getMinValue();
            int maxCoord = (int)axisObj.getValueCoord(max);
            int minCoord = (int)axisObj.getValueCoord(min);
            boolean nextOutOfBound = false;
            lastOutOfBound = false;
            if (axisObj.isDescending()) {
                int temp = minCoord;
                minCoord = maxCoord;
                maxCoord = temp;
                boolean temp1 = bAutoMin;
                bAutoMin = bAutoMax;
                bAutoMax = temp1;
            }
            if (this.m_numYCoords[s][g] > maxCoord) {
                if (this.m_bHorz) {
                    pt1.x = maxCoord;
                } else {
                    pt1.y = maxCoord;
                }
                nextOutOfBound = true;
            } else if (this.m_numYCoords[s][g] < minCoord) {
                if (this.m_bHorz) {
                    pt1.x = minCoord;
                } else {
                    pt1.y = minCoord;
                }
                nextOutOfBound = true;
            }
            boolean bDrawNormal = true;
            if (this.m_nFillMissingData != 0) {
                boolean bFilledMissingData = this.m_Access.m_DataStorage.isMissingDataFilledIn(s, g);
                int nNumSegments = this.m_Perspective.getNumMissingDataSegments();
                if (bFilledMissingData && nNumSegments != 0) {
                    Line theLine = new Line(pt1, pt2);
                    Point ptTwo = null;
                    int nDenominator = nNumSegments * 2 + 1;
                    for (int nIdx = 1; nIdx < nDenominator; ++nIdx) {
                        Point ptOne = theLine.fractionalPoint(nIdx, nDenominator);
                        ptTwo = theLine.fractionalPoint(nIdx + 1, nDenominator);
                        if (this.m_bHorz) {
                            if (points.size() <= 0) {
                                points.add(new Point(ptOne.x, ptOne.y + halfWidth));
                            }
                            points.add(new Point(ptOne.x, ptOne.y - halfWidth));
                            points.add(new Point(ptTwo.x, ptTwo.y + halfWidth));
                        } else {
                            if (points.size() <= 0) {
                                points.add(new Point(ptOne.x - halfWidth, ptOne.y));
                            }
                            points.add(new Point(ptOne.x + halfWidth, ptOne.y));
                            points.add(new Point(ptTwo.x - halfWidth, ptTwo.y));
                        }
                        ++nIdx;
                    }
                    if (this.m_bHorz) {
                        points.add(new Point(ptTwo.x, ptTwo.y - halfWidth));
                    } else {
                        points.add(new Point(ptTwo.x + halfWidth, ptTwo.y));
                    }
                    bDrawNormal = false;
                }
            }
            if (bDrawNormal && !this.m_blackBox.getTransparentFillColor()) {
                if (this.m_bHorz) {
                    points.add(new Point(pt1.x, pt1.y - previousHalfWidth));
                } else {
                    points.add(new Point(pt1.x - previousHalfWidth, pt1.y));
                }
                if (nextOutOfBound) {
                    this.drawNewLine(s, g, points);
                    points = new ArrayList(16);
                }
                if (this.m_bHorz) {
                    points.add(new Point(pt1.x, pt1.y + halfWidth));
                } else {
                    points.add(new Point(pt1.x + halfWidth, pt1.y));
                }
                if (!this.m_dataOK[s][gNext] || lastGroup) {
                    this.drawNewLine(s, g, points);
                    points = new ArrayList(16);
                }
            }
            previousHalfWidth = halfWidth;
        }
        if (points.size() > 0) {
            this.drawNewLine(s, g, points);
            points = new ArrayList(16);
        }
        if (is3D) {
            if (!this.m_bMarkerDisplay && this.m_Perspective.getTransparentMarkers()) {
                this.drawTransparentMarkersWithDepth(s, 2);
            } else {
                this.drawMarkersWithDepth(s, this.m_Perspective.getConnectLineMarkers());
            }
        }
    }

    protected void drawSteppedLine(int s, boolean is3D) {
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        int g = 0;
        Point pt1 = null;
        Point pt2 = null;
        boolean bAutoMax = false;
        boolean bAutoMin = false;
        IdentObj idSeries = new IdentObj(-3, s);
        this.m_Width = this.m_Perspective.getLineWidth(idSeries);
        if (this.m_Width == (Integer)Attr.SeriesLineWidthDefault.getDefault()) {
            this.m_Width = this.m_Perspective.updateMargin(this.m_Width, true);
        }
        ArrayList<Point> points = new ArrayList<Point>(16);
        this.m_is3D = is3D;
        this.m_Style = this.m_Perspective.getLineStyle(idSeries);
        while (gEnum.hasMoreElements()) {
            int xMax;
            int xMin;
            g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            if (!gEnum.hasMoreElements()) continue;
            int gNext = gEnum.peekAtNextGroup();
            if (this.m_Perspective.isTimeAxis()) {
                if (this.m_Perspective.getDateFrequency() == 3 && !this.m_dataOK[s][gNext]) {
                    while (gEnum.hasMoreElements() && !this.m_dataOK[s][gNext]) {
                        gNext = gEnum.nextGroup();
                        if (!gEnum.hasMoreElements()) continue;
                        gNext = gEnum.peekAtNextGroup();
                    }
                }
            }
            PfjAssert.pfjAssert(gNext >= 0 && gNext < this.m_nTotalGroups);
            if (!this.m_dataOK[s][g]) continue;
            this.m_blackBox = this.assignSeriesColor(s, g);
            this.m_blackBox = this.m_blackBox.runRules(s, -3);
            this.m_blackBox.setTransparentBorderColor(false);
            if (this.m_blackBox.getFillColor() != null) {
                this.m_blackBox.setBorderColor(this.m_blackBox.getFillColor());
            }
            pt1 = this.getCoords(s, g);
            pt2 = !this.m_dataOK[s][gNext] ? this.getCoords(s, g) : this.getCoords(s, gNext);
            RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
            IdentObj AxisId = axisObj.getAxisIdentObj();
            bAutoMax = this.m_Perspective.getScaleMaxAuto(AxisId);
            bAutoMin = this.m_Perspective.getScaleMinAuto(AxisId);
            double fValue = this.getDataValue((int)s, (int)g, (DataItem)DataItem.DI_GENERAL).m_fValue;
            double fValue1 = this.getDataValue((int)s, (int)gNext, (DataItem)DataItem.DI_GENERAL).m_fValue;
            double max = axisObj.getMaxValue();
            double min = axisObj.getMinValue();
            boolean nextOutOfBound = false;
            if (this.m_bHorz) {
                xMin = (int)this.m_Frame.getBackWallBounds().getMinY();
                xMax = (int)this.m_Frame.getBackWallBounds().getMaxY();
            } else {
                xMin = (int)this.m_Frame.getBackWallBounds().getMinX();
                xMax = (int)this.m_Frame.getBackWallBounds().getMaxX();
            }
            int maxCoord = (int)axisObj.getValueCoord(max);
            int minCoord = (int)axisObj.getValueCoord(min);
            if (axisObj.isDescending()) {
                int temp = minCoord;
                minCoord = maxCoord;
                maxCoord = temp;
                boolean temp1 = bAutoMin;
                bAutoMin = bAutoMax;
                bAutoMax = temp1;
            }
            if (this.m_bHorz) {
                if (pt1.y < xMin && pt2.y < xMin || pt1.y > xMax && pt2.y > xMax) continue;
                if (pt1.y < xMin) {
                    pt1.y = xMin;
                } else if (pt1.y > xMax) {
                    pt1.y = xMax;
                }
                if (pt2.y < xMin) {
                    pt2.y = xMin;
                } else if (pt2.y > xMax) {
                    pt2.y = xMax;
                }
            } else {
                if (pt1.x < xMin && pt2.x < xMin || pt1.x > xMax && pt2.x > xMax) continue;
                if (pt1.x < xMin) {
                    pt1.x = xMin;
                } else if (pt1.x > xMax) {
                    pt1.x = xMax;
                }
                if (pt2.x < xMin) {
                    pt2.x = xMin;
                } else if (pt2.x > xMax) {
                    pt2.x = xMax;
                }
            }
            if (this.m_numYCoords[s][g] > maxCoord) {
                if (this.m_bHorz) {
                    pt1.x = maxCoord;
                } else {
                    pt1.y = maxCoord;
                }
                nextOutOfBound = true;
            } else if (this.m_numYCoords[s][g] < minCoord) {
                if (this.m_bHorz) {
                    pt1.x = minCoord;
                } else {
                    pt1.y = minCoord;
                }
                nextOutOfBound = true;
            }
            if (this.m_numYCoords[s][gNext] > maxCoord) {
                if (this.m_bHorz) {
                    pt2.x = maxCoord;
                } else {
                    pt2.y = maxCoord;
                }
            } else if (this.m_numYCoords[s][gNext] < minCoord) {
                if (this.m_bHorz) {
                    pt2.x = minCoord;
                } else {
                    pt2.y = minCoord;
                }
            }
            boolean bDrawNormal = true;
            if (this.m_nFillMissingData != 0) {
                boolean bFilledMissingData = this.m_Access.m_DataStorage.isMissingDataFilledIn(s, g);
                int nNumSegments = this.m_Perspective.getNumMissingDataSegments();
                if (bFilledMissingData && nNumSegments != 0) {
                    Line theLine = new Line(pt1, pt2);
                    Point ptTwo = null;
                    int nDenominator = nNumSegments * 2 + 1;
                    for (int nIdx = 1; nIdx < nDenominator; ++nIdx) {
                        Point ptOne = theLine.fractionalPoint(nIdx, nDenominator);
                        ptTwo = theLine.fractionalPoint(nIdx + 1, nDenominator);
                        points.add(ptOne);
                        if (this.m_bHorz) {
                            points.add(new Point(ptOne.x, ptTwo.y));
                        } else {
                            points.add(new Point(ptTwo.x, ptOne.y));
                        }
                        ++nIdx;
                    }
                    points.add(ptTwo);
                    bDrawNormal = false;
                }
            }
            if (!bDrawNormal || this.m_blackBox.getTransparentFillColor()) continue;
            if (this.m_dataOK[s][g]) {
                points.add(pt1);
            }
            if (nextOutOfBound) {
                this.drawNewLine(s, g, points);
                points = new ArrayList(16);
            }
            if (this.m_dataOK[s][gNext]) {
                if (this.m_bHorz) {
                    points.add(new Point(pt1.x, pt2.y));
                    continue;
                }
                points.add(new Point(pt2.x, pt1.y));
                continue;
            }
            this.drawNewLine(s, g, points);
            points = new ArrayList(16);
        }
        if (points.size() > 0) {
            points.add(pt2);
            this.drawNewLine(s, g, points);
            points = new ArrayList(16);
        }
        if (is3D) {
            if (!this.m_bMarkerDisplay && this.m_Perspective.getTransparentMarkers()) {
                this.drawTransparentMarkersWithDepth(s, 2);
            } else {
                this.drawMarkersWithDepth(s, this.m_Perspective.getConnectLineMarkers());
            }
        }
    }

    private void drawNewLine(int s, int g, List points) {
        if (this.m_is3D) {
            this.draw3DLine(s, points);
        } else {
            new DetPolyline(this.m_Detectiv, new IdentObj(258, s, g), points, this.m_blackBox, null, this.m_Width, this.m_Style, false);
        }
    }

    private void solveTridiag(float[] sub, float[] diag, float[] sup, float[] b, int n) {
        int i;
        for (i = 2; i <= n; ++i) {
            sub[i] = sub[i] / diag[i - 1];
            diag[i] = diag[i] - sub[i] * sup[i - 1];
            b[i] = b[i] - sub[i] * b[i - 1];
        }
        b[n] = b[n] / diag[n];
        for (i = n - 1; i >= 1; --i) {
            b[i] = (b[i] - sup[i] * b[i + 1]) / diag[i];
        }
    }

    protected List calcCurveLinePoints(List points) {
        int np = points.size();
        if (np == 0) {
            return null;
        }
        float[] d = new float[np];
        float[] x = new float[np];
        float oldy = 0.0f;
        float oldt = 0.0f;
        int precision = 10;
        ArrayList<Point> newPoints = new ArrayList<Point>(16);
        for (int i = 0; i < np; ++i) {
            Point p = (Point)points.get(i);
            x[i] = p.x;
            d[i] = p.y;
        }
        if (np > 1) {
            int i;
            float[] a = new float[np];
            float[] h = new float[np];
            for (i = 1; i <= np - 1; ++i) {
                h[i] = x[i] - x[i - 1];
            }
            if (np > 2) {
                float[] sub = new float[np - 1];
                float[] diag = new float[np - 1];
                float[] sup = new float[np - 1];
                for (int i2 = 1; i2 <= np - 2; ++i2) {
                    diag[i2] = (h[i2] + h[i2 + 1]) / 3.0f;
                    sup[i2] = h[i2 + 1] / 6.0f;
                    sub[i2] = h[i2] / 6.0f;
                    a[i2] = (d[i2 + 1] - d[i2]) / h[i2 + 1] - (d[i2] - d[i2 - 1]) / h[i2];
                }
                this.solveTridiag(sub, diag, sup, a, np - 2);
            }
            oldt = x[0];
            oldy = d[0];
            newPoints.add(new Point((int)oldt, (int)oldy));
            for (i = 1; i <= np - 1; ++i) {
                for (int j = 1; j <= precision; ++j) {
                    float t1 = h[i] * (float)j / (float)precision;
                    float t2 = h[i] - t1;
                    float y = ((-a[i - 1] / 6.0f * (t2 + h[i]) * t1 + d[i - 1]) * t2 + (-a[i] / 6.0f * (t1 + h[i]) * t2 + d[i]) * t1) / h[i];
                    float t = x[i - 1] + t1;
                    newPoints.add(new Point((int)oldt, (int)oldy));
                    oldt = t;
                    oldy = y;
                    if (j != precision) continue;
                    newPoints.add(new Point((int)oldt, (int)oldy));
                }
            }
        }
        return newPoints;
    }

    public void draw3DLine(int s, List points) {
        boolean bDrawUnderside = false;
        int dx = 0;
        int dy = 0;
        Point pt1 = null;
        Point pt2 = null;
        int g = 0;
        Object blackBox = null;
        Color seriesColor = this.m_Perspective.getFillColor(this.m_Perspective.getSeries(s));
        Color c = this.m_Perspective.getBrighter(seriesColor);
        IdentObj identObjTop = new IdentObj(318, s, g, -3, 1);
        if (this.m_autoGradient) {
            this.m_Perspective.setFillColor(identObjTop, c);
            this.m_Perspective.setGradientEffect(identObjTop, 4);
        } else {
            this.m_Perspective.setFillColor(identObjTop, c);
            this.m_Perspective.setFillType(identObjTop, 1);
        }
        BlackBoxIF blackBoxTop = new BlackBoxObj(this.m_Perspective, identObjTop);
        blackBoxTop = blackBoxTop.runRules(s, -3);
        blackBoxTop.setBorderColor(seriesColor);
        this.m_Perspective.setColorFactor(0.9);
        c = this.m_Perspective.getDarker(seriesColor);
        IdentObj identObjBottom = new IdentObj(318, s, g, -3, 2);
        if (this.m_autoGradient) {
            this.m_Perspective.setFillColor(identObjBottom, c);
            this.m_Perspective.setColorFactor(0.85);
            this.m_Perspective.setGradientEffect(identObjBottom, 2);
        } else {
            this.m_Perspective.setFillColor(identObjBottom, c);
            this.m_Perspective.setFillType(identObjBottom, 1);
        }
        BlackBoxIF blackBoxBottom = new BlackBoxObj(this.m_Perspective, identObjBottom);
        blackBoxBottom = blackBoxBottom.runRules(s, -3);
        blackBoxBottom.setBorderColor(seriesColor);
        double fFrontOffset = this.calcFrontOffset(this.m_seriesPlanes[s], this.m_nDepthPlanes);
        double fBackOffset = this.calcBackOffset(this.m_seriesPlanes[s], this.m_nDepthPlanes);
        if (fBackOffset > 0.0) {
            fBackOffset -= 1.0 / (double)this.m_nDepthPlanes / 2.0;
        } else {
            fFrontOffset = 1.0 / (double)this.m_nDepthPlanes / 2.0 + fFrontOffset;
        }
        Point ptFrontOffset = this.m_Frame.getDepthOffset(fFrontOffset);
        Point ptBackOffset = this.m_Frame.getDepthOffset(fBackOffset);
        dx = ptFrontOffset.x - ptBackOffset.x;
        dy = ptFrontOffset.y - ptBackOffset.y;
        for (int i = 0; i < points.size(); ++i) {
            Point pt = (Point)points.get(i);
            pt.x -= ptFrontOffset.x;
            pt.y -= ptFrontOffset.y;
        }
        ArrayList polyPoints = new ArrayList(16);
        boolean bCurrentSide = bDrawUnderside;
        polyPoints.add(points.get(0));
        for (int i = 0; i <= points.size() - 1; ++i) {
            if (i < points.size() - 1) {
                pt1 = (Point)points.get(i);
                pt2 = (Point)points.get(i + 1);
                double fAngleRad = Math.atan2(pt2.y - pt1.y, pt2.x - pt1.x);
                double fAngleDeg = fAngleRad * 57.29577951308232;
                if (this.m_nDepthAngle <= 90) {
                    bDrawUnderside = this.m_bHorz ? fAngleDeg < (double)(this.m_nDepthAngle - 180) : fAngleDeg > (double)this.m_nDepthAngle;
                } else {
                    boolean bl = bDrawUnderside = fAngleDeg + 180.0 < (double)this.m_nDepthAngle;
                }
            }
            if (i == 0) {
                bCurrentSide = bDrawUnderside;
            }
            if (bCurrentSide != bDrawUnderside && polyPoints.size() > 1 || i == points.size() - 1) {
                Point p1;
                int j;
                Polygon polyTop = new Polygon();
                for (j = 0; j < polyPoints.size(); ++j) {
                    p1 = (Point)polyPoints.get(j);
                    polyTop.addPoint(p1.x, p1.y);
                }
                for (j = polyPoints.size() - 1; j >= 0; --j) {
                    p1 = (Point)polyPoints.get(j);
                    polyTop.addPoint(p1.x + dx, p1.y + dy);
                }
                Point p12 = (Point)polyPoints.get(0);
                polyTop.addPoint(p12.x, p12.y);
                if (bCurrentSide) {
                    new DetPolygon(this.m_Detectiv, identObjTop, polyTop, blackBoxTop, 1.0);
                } else {
                    new DetPolygon(this.m_Detectiv, identObjBottom, polyTop, blackBoxBottom, 1.0);
                }
                bCurrentSide = bDrawUnderside;
                polyPoints = new ArrayList(16);
                if (i >= points.size() - 1) continue;
                polyPoints.add(points.get(i));
                polyPoints.add(points.get(i + 1));
                continue;
            }
            polyPoints.add(points.get(i + 1));
        }
    }

    protected void drawLines(boolean bCircular) {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        int s = 0;
        int gNext = -1;
        int g = 0;
        Point pt1 = null;
        Point pt2 = null;
        BlackBoxIF blackBox = null;
        int nWidth = 0;
        int nStyle = 0;
        boolean bCloseCircularLines = false;
        boolean bAutoMax = false;
        boolean bAutoMin = false;
        boolean is3D = false;
        int validStartGroup = -1;
        int validEndGroup = -1;
        if (this.m_nDepthRadius > 0 && this.m_gt.wantDepthEffect()) {
            is3D = true;
        }
        block5: while (sEnum.hasMoreElements() && (s = sEnum.nextSeries()) < this.m_nTotalSeries) {
            validStartGroup = -1;
            validEndGroup = -1;
            if (this.m_seriesTypes[s] != 2 || this.m_gt.isWaterfall() && this.m_seriesTypes[s] != 2 && this.m_seriesTypes[s] != 3) continue;
            IdentObj idSeries = new IdentObj(-3, s);
            nStyle = this.m_Perspective.getLineStyle(idSeries);
            gEnum.reset();
            if (gEnum.hasMoreElements()) {
                bCloseCircularLines = true;
            }
            boolean isSmooth = false;
            switch (this.m_Perspective.getLineType(idSeries)) {
                case 1: {
                    if (gEnum.getNumGroups() <= 2 || this.m_gt.isLineSelectPoint()) break;
                    isSmooth = true;
                    break;
                }
                case 2: {
                    this.drawSteppedLine(s, is3D);
                    continue block5;
                }
                case 3: {
                    this.drawCenteredSteppedLine(s, is3D);
                    continue block5;
                }
            }
            ArrayList<Point> points1 = new ArrayList<Point>(16);
            ArrayList<Point> points2 = new ArrayList<Point>(16);
            RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
            IdentObj AxisId = axisObj.getAxisIdentObj();
            bAutoMax = this.m_Perspective.getScaleMaxAuto(AxisId);
            bAutoMin = this.m_Perspective.getScaleMinAuto(AxisId);
            double max = axisObj.getMaxValue();
            double min = axisObj.getMinValue();
            int maxCoord = (int)axisObj.getValueCoord(max);
            int minCoord = (int)axisObj.getValueCoord(min);
            if (axisObj.isDescending()) {
                int temp = minCoord;
                minCoord = maxCoord;
                maxCoord = temp;
                boolean temp1 = bAutoMin;
                bAutoMin = bAutoMax;
                bAutoMax = temp1;
            }
            ArrayList<Integer> groupIndexes1 = new ArrayList<Integer>();
            ArrayList<Integer> groupIndexes2 = new ArrayList<Integer>();
            blackBox = this.assignSeriesColor(s, false);
            blackBox = blackBox.runRules(s, -3);
            blackBox.setTransparentBorderColor(false);
            Color fillColor = null;
            if (blackBox.getFillType() == 1) {
                fillColor = blackBox.getFillColor();
            }
            if (fillColor == null) {
                fillColor = this.m_Perspective.getFillColor(idSeries);
            }
            blackBox.setBorderColor(fillColor);
            while (gEnum.hasMoreElements()) {
                double newx;
                double newy;
                g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                if (!gEnum.hasMoreElements()) continue;
                gNext = gEnum.peekAtNextGroup();
                if (this.m_Perspective.isTimeAxis()) {
                    if (this.m_Perspective.getDateFrequency() == 3 && !this.m_dataOK[s][gNext]) {
                        while (gEnum.hasMoreElements() && !this.m_dataOK[s][gNext]) {
                            gNext = gEnum.nextGroup();
                            gNext = gEnum.peekAtNextGroup();
                        }
                    }
                }
                if (gNext < 0 || gNext >= this.m_nTotalGroups) continue;
                if (validStartGroup == -1 && this.m_dataOK[s][g]) {
                    validStartGroup = g;
                }
                if (gNext > validEndGroup && this.m_dataOK[s][gNext]) {
                    validEndGroup = gNext;
                }
                if (!this.m_dataOK[s][g] || !this.m_dataOK[s][gNext]) continue;
                pt1 = this.getCoords(s, g);
                pt2 = this.getCoords(s, gNext);
                if (!bAutoMax) {
                    if (this.m_numYCoords[s][g] > maxCoord && this.m_numYCoords[s][gNext] > maxCoord) continue;
                    if (this.m_numYCoords[s][g] > maxCoord) {
                        if (this.m_bHorz) {
                            newy = this.calcyPosition(pt1, pt2, maxCoord);
                            pt1.x = maxCoord;
                            pt1.y = (int)newy;
                        } else {
                            newx = this.calcxPosition(pt1, pt2, maxCoord);
                            pt1.y = maxCoord;
                            pt1.x = (int)newx;
                        }
                    } else if (this.m_numYCoords[s][gNext] > maxCoord) {
                        if (this.m_bHorz) {
                            double newy2 = this.calcyPosition(pt1, pt2, maxCoord);
                            pt2.x = maxCoord;
                            pt2.y = (int)newy2;
                        } else {
                            newx = this.calcxPosition(pt1, pt2, maxCoord);
                            pt2.y = maxCoord;
                            pt2.x = (int)newx;
                        }
                    }
                }
                if (!bAutoMin) {
                    if (this.m_numYCoords[s][g] < minCoord && this.m_numYCoords[s][gNext] < minCoord) continue;
                    if (this.m_numYCoords[s][g] < minCoord) {
                        if (this.m_bHorz) {
                            newy = this.calcyPosition(pt1, pt2, minCoord);
                            pt1.x = minCoord;
                            pt1.y = (int)newy;
                        } else {
                            newx = this.calcxPosition(pt1, pt2, minCoord);
                            pt1.y = minCoord;
                            pt1.x = (int)newx;
                        }
                    } else if (this.m_numYCoords[s][gNext] < minCoord) {
                        if (this.m_bHorz) {
                            newy = this.calcyPosition(pt1, pt2, minCoord);
                            pt2.x = minCoord;
                            pt2.y = (int)newy;
                        } else {
                            newx = this.calcxPosition(pt1, pt2, minCoord);
                            pt2.y = minCoord;
                            pt2.x = (int)newx;
                        }
                    }
                }
                boolean bDrawNormal = true;
                if (this.m_nFillMissingData != 0) {
                    boolean bFilledMissingData = this.m_Access.m_DataStorage.isMissingDataFilledIn(s, g);
                    int nNumSegments = this.m_Perspective.getNumMissingDataSegments();
                    if (bFilledMissingData && nNumSegments != 0) {
                        Line theLine = new Line(pt1, pt2);
                        int nDenominator = nNumSegments * 2 + 1;
                        for (int nIdx = 1; nIdx < nDenominator; ++nIdx) {
                            Point ptOne = theLine.fractionalPoint(nIdx, nDenominator);
                            Point ptTwo = theLine.fractionalPoint(nIdx + 1, nDenominator);
                            points1.add(ptOne);
                            points2.add(ptTwo);
                            groupIndexes1.add(g);
                            groupIndexes2.add(gNext);
                            ++nIdx;
                        }
                        bDrawNormal = false;
                    }
                }
                if (!bDrawNormal || blackBox.getTransparentFillColor()) continue;
                points1.add(pt1);
                points2.add(pt2);
                groupIndexes1.add(g);
                groupIndexes2.add(gNext);
            }
            nWidth = this.m_Perspective.getLineWidth(idSeries);
            if (nWidth == (Integer)Attr.SeriesLineWidthDefault.getDefault()) {
                nWidth = this.m_Perspective.updateMargin(nWidth, true);
            }
            this.addStartAndEndPoints(points1, points2, groupIndexes1, groupIndexes2, s, validStartGroup, validEndGroup, minCoord, maxCoord, bAutoMin, bAutoMax);
            if (points1.size() <= 0) {
                if (!is3D) continue;
                if (!this.m_bMarkerDisplay && this.m_Perspective.getTransparentMarkers()) {
                    this.drawTransparentMarkersWithDepth(s, 2);
                    continue;
                }
                this.drawMarkersWithDepth(s, false);
                continue;
            }
            List points = new ArrayList(16);
            points.add(points1.get(0));
            ArrayList groupIndexes = new ArrayList();
            groupIndexes.add(groupIndexes1.get(0));
            for (int i = 0; i < points1.size(); ++i) {
                points.add(points2.get(i));
                groupIndexes.add(groupIndexes2.get(i));
                if (i + 1 >= points1.size() || (pt1 = (Point)points1.get(i + 1)).equals(pt2 = (Point)points2.get(i))) continue;
                if (isSmooth && !this.m_bHorz) {
                    points = this.calcCurveLinePoints(points);
                }
                if (is3D) {
                    this.draw3DLine(s, points);
                } else {
                    Rectangle clipRect = new Rectangle(this.m_Frame.getBackWallBounds());
                    int boundOffset = this.m_Perspective.m_VC.destToVirtHeight(nWidth);
                    clipRect.y -= boundOffset / 2;
                    clipRect.height += boundOffset;
                    new DetPolyline(this.m_Detectiv, new IdentObj(258, s, g), points, blackBox, clipRect, nWidth, nStyle, false, groupIndexes);
                }
                points = new ArrayList(16);
                points.add(points1.get(i + 1));
                groupIndexes = new ArrayList();
                groupIndexes.add((Integer)groupIndexes1.get(i + 1));
            }
            if (isSmooth && !this.m_bHorz) {
                points = this.calcCurveLinePoints(points);
            }
            if (is3D) {
                this.draw3DLine(s, points);
            } else {
                Rectangle clipRect = new Rectangle(this.m_Frame.getBackWallBounds());
                int boundOffset = this.m_Perspective.m_VC.destToVirtHeight(nWidth);
                clipRect.y -= boundOffset / 2;
                clipRect.height += boundOffset;
                new DetPolyline(this.m_Detectiv, new IdentObj(258, s, g), points, blackBox, clipRect, nWidth, nStyle, false, groupIndexes);
            }
            if (!is3D) continue;
            if (!this.m_bMarkerDisplay && this.m_Perspective.getTransparentMarkers()) {
                this.drawTransparentMarkersWithDepth(s, 2);
                continue;
            }
            this.drawMarkersWithDepth(s, this.m_Perspective.getConnectLineMarkers());
        }
    }

    public void addStartAndEndPoints(List points1, List points2, ArrayList groups1, ArrayList groups2, int s, int validStartGroup, int validEndGroup, double minCoord, double maxCoord, boolean bAutoMin, boolean bAutoMax) {
        double maxXCoord;
        double max;
        double yCoord;
        double minXCoord;
        double min;
        Point pt1;
        RelativeAxisObj yAxis;
        double y;
        double x;
        DatumObj obj;
        if (!this.m_Perspective.isContinuousTimeAxis()) {
            return;
        }
        double fXValue = 0.0;
        double fYValue = 0.0;
        if (validStartGroup > 0 && this.m_dataOK[s][validStartGroup] && points1.size() > 0) {
            obj = this.getDataValue(s, validStartGroup - 1, DataItem.DI_XY_X);
            fXValue = obj.m_fValue;
            obj = this.getDataValue(s, validStartGroup - 1, DataItem.DI_XY_Y);
            fYValue = obj.m_fValue;
            x = 0.0;
            y = 0.0;
            if (obj.m_bOK) {
                x = this.getO1Axis().getValueCoord(fXValue);
                yAxis = this.whichAxisForSeries(s, DataItem.DI_XY_Y);
                y = yAxis.getValueCoord(fYValue);
                pt1 = (Point)points1.get(0);
                min = this.getO1Axis().getMinValue();
                minXCoord = this.getO1Axis().getValueCoord(min);
                yCoord = this.calcyPosition(new Point((int)x, (int)y), pt1, minXCoord);
                if (!bAutoMin && yCoord < minCoord) {
                    yCoord = minCoord;
                }
                if (!bAutoMax && yCoord > maxCoord) {
                    yCoord = maxCoord;
                }
                points1.add(0, new Point((int)minXCoord, (int)yCoord));
                points2.add(0, pt1);
                if (groups1 != null && groups1.size() > 0 && groups2 != null && groups2.size() > 0) {
                    groups1.add(0, validStartGroup - 1);
                    groups2.add(0, groups1.get(1));
                }
            }
        }
        if (validEndGroup < this.m_nTotalGroups - 1 && validEndGroup >= 0 && this.m_dataOK[s][validEndGroup] && points2.size() > 0) {
            obj = this.getDataValue(s, validEndGroup + 1, DataItem.DI_XY_X);
            fXValue = obj.m_fValue;
            obj = this.getDataValue(s, validEndGroup + 1, DataItem.DI_XY_Y);
            fYValue = obj.m_fValue;
            x = 0.0;
            y = 0.0;
            if (obj.m_bOK) {
                x = this.getO1Axis().getValueCoord(fXValue);
                yAxis = this.whichAxisForSeries(s, DataItem.DI_XY_Y);
                y = yAxis.getValueCoord(fYValue);
                pt1 = (Point)points2.get(points2.size() - 1);
                max = this.getO1Axis().getMaxValue();
                maxXCoord = this.getO1Axis().getValueCoord(max);
                yCoord = this.calcyPosition(new Point((int)x, (int)y), pt1, maxXCoord);
                if (!bAutoMin && yCoord < minCoord) {
                    yCoord = minCoord;
                }
                if (!bAutoMax && yCoord > maxCoord) {
                    yCoord = maxCoord;
                }
                points2.add(new Point((int)maxXCoord, (int)yCoord));
                points1.add(pt1);
                if (groups1 != null && groups1.size() > 0 && groups2 != null && groups2.size() > 0) {
                    groups1.add(groups2.get(groups2.size() - 1));
                    groups2.add(validEndGroup + 1);
                }
            }
        }
        if (validStartGroup == 0 && this.m_dataOK[s][validStartGroup] && !this.m_dataOK[s][validStartGroup + 1]) {
            obj = this.getDataValue(s, validStartGroup + 1, DataItem.DI_XY_X);
            fXValue = obj.m_fValue;
            obj = this.getDataValue(s, validStartGroup + 1, DataItem.DI_XY_Y);
            fYValue = obj.m_fValue;
            x = 0.0;
            y = 0.0;
            if (obj.m_bOK) {
                x = this.getO1Axis().getValueCoord(fXValue);
                yAxis = this.whichAxisForSeries(s, DataItem.DI_XY_Y);
                y = yAxis.getValueCoord(fYValue);
                pt1 = this.getCoords(s, validStartGroup);
                max = this.getO1Axis().getMaxValue();
                maxXCoord = this.getO1Axis().getValueCoord(max);
                yCoord = this.calcyPosition(pt1, new Point((int)x, (int)y), maxXCoord);
                if (!bAutoMin && (double)pt1.y < minCoord) {
                    pt1.y = (int)minCoord;
                }
                if (!bAutoMin && yCoord < minCoord) {
                    yCoord = minCoord;
                }
                if (!bAutoMax && (double)pt1.y > maxCoord) {
                    pt1.y = (int)maxCoord;
                }
                if (!bAutoMax && yCoord > maxCoord) {
                    yCoord = maxCoord;
                }
                points1.add(pt1);
                points2.add(new Point((int)maxXCoord, (int)yCoord));
                if (groups1 != null && groups2 != null) {
                    groups1.add(0, validStartGroup);
                    groups2.add(0, validStartGroup + 1);
                }
            }
        }
        if (validEndGroup == this.m_nTotalGroups - 1 && validEndGroup >= 1 && this.m_dataOK[s][validEndGroup] && !this.m_dataOK[s][validEndGroup - 1]) {
            obj = this.getDataValue(s, validEndGroup - 1, DataItem.DI_XY_X);
            fXValue = obj.m_fValue;
            obj = this.getDataValue(s, validEndGroup - 1, DataItem.DI_XY_Y);
            fYValue = obj.m_fValue;
            x = 0.0;
            y = 0.0;
            if (obj.m_bOK) {
                x = this.getO1Axis().getValueCoord(fXValue);
                yAxis = this.whichAxisForSeries(s, DataItem.DI_XY_Y);
                y = yAxis.getValueCoord(fYValue);
                pt1 = this.getCoords(s, validEndGroup);
                min = this.getO1Axis().getMinValue();
                minXCoord = this.getO1Axis().getValueCoord(min);
                yCoord = this.calcyPosition(new Point((int)x, (int)y), pt1, minXCoord);
                if (!bAutoMin && (double)pt1.y < minCoord) {
                    pt1.y = (int)minCoord;
                }
                if (!bAutoMin && yCoord < minCoord) {
                    yCoord = minCoord;
                }
                if (!bAutoMax && (double)pt1.y > maxCoord) {
                    pt1.y = (int)maxCoord;
                }
                if (!bAutoMax && yCoord > maxCoord) {
                    yCoord = maxCoord;
                }
                points2.add(new Point((int)minXCoord, (int)yCoord));
                points1.add(pt1);
                if (groups1 != null && groups2 != null) {
                    groups1.add(0, validEndGroup - 1);
                    groups2.add(0, validEndGroup);
                }
            }
        }
        if (validEndGroup < this.m_nTotalGroups - 1 && validStartGroup > 0 && validEndGroup == validStartGroup && this.m_dataOK[s][validEndGroup] && !this.m_dataOK[s][validEndGroup - 1] && !this.m_dataOK[s][validEndGroup + 1]) {
            double yCoord2;
            RelativeAxisObj yAxis2;
            obj = this.getDataValue(s, validEndGroup - 1, DataItem.DI_XY_X);
            fXValue = obj.m_fValue;
            obj = this.getDataValue(s, validEndGroup - 1, DataItem.DI_XY_Y);
            fYValue = obj.m_fValue;
            DatumObj obj2 = this.getDataValue(s, validEndGroup + 1, DataItem.DI_XY_X);
            double fXValue2 = obj2.m_fValue;
            obj2 = this.getDataValue(s, validEndGroup + 1, DataItem.DI_XY_Y);
            double fYValue2 = obj2.m_fValue;
            double x2 = 0.0;
            double y2 = 0.0;
            if (obj.m_bOK && obj2.m_bOK) {
                x2 = this.getO1Axis().getValueCoord(fXValue);
                yAxis2 = this.whichAxisForSeries(s, DataItem.DI_XY_Y);
                y2 = yAxis2.getValueCoord(fYValue);
                Point pt12 = this.getCoords(s, validEndGroup);
                double min2 = this.getO1Axis().getMinValue();
                double minXCoord2 = this.getO1Axis().getValueCoord(min2);
                yCoord2 = this.calcyPosition(new Point((int)x2, (int)y2), pt12, minXCoord2);
                if (!bAutoMin && (double)pt12.y < minCoord) {
                    pt12.y = (int)minCoord;
                }
                if (!bAutoMin && yCoord2 < minCoord) {
                    yCoord2 = minCoord;
                }
                if (!bAutoMax && (double)pt12.y > maxCoord) {
                    pt12.y = (int)maxCoord;
                }
                if (!bAutoMax && yCoord2 > maxCoord) {
                    yCoord2 = maxCoord;
                }
                points1.add(new Point((int)minXCoord2, (int)yCoord2));
                points2.add(pt12);
                if (groups1 != null && groups2 != null) {
                    groups1.add(0, validEndGroup - 1);
                    groups2.add(0, validEndGroup);
                }
            }
            if (obj.m_bOK && obj2.m_bOK) {
                x2 = this.getO1Axis().getValueCoord(fXValue2);
                yAxis2 = this.whichAxisForSeries(s, DataItem.DI_XY_Y);
                y2 = yAxis2.getValueCoord(fYValue2);
                Point pt13 = (Point)points2.get(points2.size() - 1);
                double max2 = this.getO1Axis().getMaxValue();
                double maxXCoord2 = this.getO1Axis().getValueCoord(max2);
                yCoord2 = this.calcyPosition(new Point((int)x2, (int)y2), pt13, maxXCoord2);
                if (!bAutoMin && yCoord2 < minCoord) {
                    yCoord2 = minCoord;
                }
                if (!bAutoMax && yCoord2 > maxCoord) {
                    yCoord2 = maxCoord;
                }
                points2.add(new Point((int)maxXCoord2, (int)yCoord2));
                points1.add(pt13);
                if (groups1 != null && groups1.size() > 0 && groups2 != null && groups2.size() > 0) {
                    groups1.add(groups2.get(groups2.size() - 1));
                    groups2.add(validEndGroup + 1);
                }
            }
        }
        if (validEndGroup == -1 && validStartGroup == -1) {
            int startGroup = -1;
            int endGroup = -1;
            double min3 = this.getO1Axis().getMinValue();
            double max3 = this.getO1Axis().getMaxValue();
            for (int i = 1; i < this.m_nTotalGroups; ++i) {
                if (!(this.getDataValue((int)s, (int)i, (DataItem)DataItem.DI_XY_X).m_fValue > max3)) continue;
                startGroup = i - 1;
                endGroup = i;
                break;
            }
            if (startGroup == endGroup) {
                return;
            }
            DatumObj obj2 = this.getDataValue(s, startGroup, DataItem.DI_XY_X);
            fXValue = obj2.m_fValue;
            obj2 = this.getDataValue(s, startGroup, DataItem.DI_XY_Y);
            fYValue = obj2.m_fValue;
            DatumObj obj22 = this.getDataValue(s, endGroup, DataItem.DI_XY_X);
            double fXValue2 = obj22.m_fValue;
            obj22 = this.getDataValue(s, endGroup, DataItem.DI_XY_Y);
            double fYValue2 = obj22.m_fValue;
            if (obj2.m_bOK && obj22.m_bOK) {
                double x1 = this.getO1Axis().getValueCoord(fXValue);
                RelativeAxisObj yAxis3 = this.whichAxisForSeries(s, DataItem.DI_XY_Y);
                double y1 = yAxis3.getValueCoord(fYValue);
                Point pt14 = new Point((int)x1, (int)y1);
                double x2 = this.getO1Axis().getValueCoord(fXValue2);
                double y2 = yAxis3.getValueCoord(fYValue2);
                Point pt2 = new Point((int)x2, (int)y2);
                double minXCoord3 = this.getO1Axis().getValueCoord(min3);
                double yCoord1 = this.calcyPosition(pt14, pt2, minXCoord3);
                double maxXCoord3 = this.getO1Axis().getValueCoord(max3);
                double yCoord2 = this.calcyPosition(pt14, pt2, maxXCoord3);
                if (!bAutoMin && yCoord1 < minCoord) {
                    yCoord1 = minCoord;
                }
                if (!bAutoMin && yCoord2 < minCoord) {
                    yCoord2 = minCoord;
                }
                if (!bAutoMax && yCoord1 > maxCoord) {
                    yCoord1 = maxCoord;
                }
                if (!bAutoMax && yCoord2 > maxCoord) {
                    yCoord2 = maxCoord;
                }
                points1.add(new Point((int)minXCoord3, (int)yCoord1));
                points2.add(new Point((int)maxXCoord3, (int)yCoord2));
                if (groups1 != null && groups2 != null) {
                    groups1.add(0, startGroup);
                    groups2.add(0, endGroup);
                }
            }
        }
    }

    protected void drawMissingLineData(int nNumMissingSegments, Point ptIn1, Point ptIn2, int nSeries, int nGroup, BlackBoxIF blackBox, int nLineWidth, int nLineStyle) {
        Line theLine = new Line(ptIn1, ptIn2);
        int nDenominator = nNumMissingSegments * 2 + 1;
        for (int nIdx = 1; nIdx < nDenominator; ++nIdx) {
            Point ptOne = theLine.fractionalPoint(nIdx, nDenominator);
            Point ptTwo = theLine.fractionalPoint(nIdx + 1, nDenominator);
            IdentObj idObj = new IdentObj(258, nSeries, nGroup);
            new DetLine(this.m_Detectiv, idObj, ptOne.x, ptOne.y, ptTwo.x, ptTwo.y, blackBox, null, nLineWidth, nLineStyle);
            ++nIdx;
        }
    }

    public Point calcSeriesOffset(int s, boolean bFront) {
        Point pt;
        if (bFront) {
            double fFront = this.calcFrontOffset(this.m_seriesPlanes[s], this.m_nDepthPlanes);
            pt = this.m_Frame.getDepthOffset(fFront);
        } else {
            double fBack = this.calcBackOffset(this.m_seriesPlanes[s], this.m_nDepthPlanes);
            pt = this.m_Frame.getDepthOffset(fBack);
        }
        return pt;
    }

    protected void calcFrontBackOffsets() {
        if (this.wantDepthEffect()) {
            this.m_seriesBackOffsets = new Point[this.m_nTotalSeries];
            this.m_seriesFrontOffsets = new Point[this.m_nTotalSeries];
            SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
            while (sEnum.hasMoreElements()) {
                int s = sEnum.nextSeries();
                PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                this.m_seriesBackOffsets[s] = this.calcSeriesOffset(s, false);
                this.m_seriesFrontOffsets[s] = this.calcSeriesOffset(s, true);
            }
        }
    }

    protected void drawTwoHalfDBarRiser(int s, int g, Rectangle rVirt, BlackBoxIF blackBox) {
        Point ptBackOffset = this.m_seriesBackOffsets[s];
        Point ptFrontOffset = this.m_seriesFrontOffsets[s];
        rVirt.x -= ptFrontOffset.x;
        rVirt.y -= ptFrontOffset.y;
        int barShape = this.m_Perspective.getBarShape();
        if (barShape == 0) {
            double fIntensity;
            Polygon polyVC;
            if (this.m_nDepthAngle != 90) {
                int nXFrame = this.m_nDepthAngle > 90 ? rVirt.x : rVirt.x + rVirt.width;
                polyVC = new Polygon();
                polyVC.addPoint(nXFrame, rVirt.y);
                polyVC.addPoint(nXFrame + (ptFrontOffset.x - ptBackOffset.x), rVirt.y + (ptFrontOffset.y - ptBackOffset.y));
                polyVC.addPoint(nXFrame + (ptFrontOffset.x - ptBackOffset.x), rVirt.y + rVirt.height + (ptFrontOffset.y - ptBackOffset.y));
                polyVC.addPoint(nXFrame, rVirt.y + rVirt.height);
                polyVC.addPoint(nXFrame, rVirt.y);
                fIntensity = this.m_bColorAutoshadeRisers ? 0.6 : 1.0;
                IdentObj idSide = new IdentObj(312, s);
                idSide.setUseSeriesLooping(true);
                BlackBoxIF bb = new BlackBoxObj(this.m_Perspective, idSide);
                idSide.setGroupID(g);
                bb = bb.runRules(s, g);
                if (this.m_Perspective.getIntegerProp(Attr.SeriesEffect) == 0) {
                    new DetPolygon(this.m_Detectiv, idSide, polyVC, blackBox, fIntensity);
                } else {
                    new DetPolygon(this.m_Detectiv, idSide, polyVC, bb, fIntensity);
                }
            }
            if (this.m_nDepthAngle != 0 && this.m_nDepthAngle != 180) {
                polyVC = new Polygon();
                polyVC.addPoint(rVirt.x, rVirt.y + rVirt.height);
                polyVC.addPoint(rVirt.x + rVirt.width, rVirt.y + rVirt.height);
                polyVC.addPoint(rVirt.x + rVirt.width + (ptFrontOffset.x - ptBackOffset.x), rVirt.y + rVirt.height + (ptFrontOffset.y - ptBackOffset.y));
                polyVC.addPoint(rVirt.x + (ptFrontOffset.x - ptBackOffset.x), rVirt.y + rVirt.height + (ptFrontOffset.y - ptBackOffset.y));
                polyVC.addPoint(rVirt.x, rVirt.y + rVirt.height);
                fIntensity = 0.8;
                IdentObj idSide = new IdentObj(313, s);
                idSide.setUseSeriesLooping(true);
                BlackBoxIF bb = new BlackBoxObj(this.m_Perspective, idSide);
                idSide.setGroupID(g);
                bb = bb.runRules(s, g);
                if (this.m_Perspective.getIntegerProp(Attr.SeriesEffect) == 0) {
                    new DetPolygon(this.m_Detectiv, idSide, polyVC, blackBox, fIntensity);
                } else {
                    new DetPolygon(this.m_Detectiv, idSide, polyVC, bb, fIntensity);
                }
            }
            IdentObj idFront = new IdentObj(277, s, g);
            fIntensity = this.m_bColorAutoshadeRisers ? 1.0 : 1.0;
            polyVC = new Polygon();
            polyVC.addPoint(rVirt.x, rVirt.y);
            polyVC.addPoint(rVirt.x + rVirt.width, rVirt.y);
            polyVC.addPoint(rVirt.x + rVirt.width, rVirt.y + rVirt.height);
            polyVC.addPoint(rVirt.x, rVirt.y + rVirt.height);
            polyVC.addPoint(rVirt.x, rVirt.y);
            new DetPolygon(this.m_Detectiv, idFront, polyVC, blackBox, fIntensity);
        } else if (barShape == 2) {
            boolean bHoriz = this.m_Perspective.getJGraphType().isOrientHorz();
            if (!bHoriz) {
                int nCenterX = rVirt.x + rVirt.width / 2;
                int nLeftX = rVirt.x + (ptFrontOffset.x - ptBackOffset.x);
                int nRightX = rVirt.x + rVirt.width + (ptFrontOffset.x - ptBackOffset.x);
                int nBottomFrontY = rVirt.y;
                int nTopFrontY = nBottomFrontY + rVirt.height;
                int nBottomBackY = rVirt.y + (ptFrontOffset.y - ptBackOffset.y);
                int nTopBackY = nBottomBackY + rVirt.height;
                BlackBoxIF bb = new SimpleBlackBoxObj(this.m_Perspective, this.assignSeriesIdent(s, g), this.m_bWantRiserBorder);
                bb = bb.runRules(s, g);
                Polygon leftPoly = new Polygon();
                leftPoly.addPoint(nLeftX, nBottomBackY);
                leftPoly.addPoint(nCenterX, nBottomFrontY);
                leftPoly.addPoint(nCenterX, nTopFrontY);
                leftPoly.addPoint(nLeftX, nTopBackY);
                leftPoly.addPoint(nLeftX, nBottomBackY);
                double fIntensity = this.m_bColorAutoshadeRisers ? 1.0 : 1.0;
                IdentObj idSide = new IdentObj(277, s, g);
                new DetPolygon(this.m_Detectiv, idSide, leftPoly, blackBox, fIntensity);
                Polygon rightPoly = new Polygon();
                rightPoly.addPoint(nCenterX, nBottomFrontY);
                rightPoly.addPoint(nRightX, nBottomBackY);
                rightPoly.addPoint(nRightX, nTopBackY);
                rightPoly.addPoint(nCenterX, nTopFrontY);
                rightPoly.addPoint(nCenterX, nBottomFrontY);
                fIntensity = this.m_bColorAutoshadeRisers ? 0.6 : 1.0;
                idSide = new IdentObj(312, s, g);
                new DetPolygon(this.m_Detectiv, idSide, rightPoly, bb, fIntensity);
                if (this.m_nDepthAngle != 0 && this.m_nDepthAngle != 180) {
                    Polygon topPoly = new Polygon();
                    topPoly.addPoint(nCenterX, nTopFrontY);
                    topPoly.addPoint(nRightX, nTopBackY);
                    topPoly.addPoint(nLeftX, nTopBackY);
                    topPoly.addPoint(nCenterX, nTopFrontY);
                    fIntensity = this.m_bColorAutoshadeRisers ? 0.8 : 1.0;
                    IdentObj idTop = new IdentObj(313, s, g);
                    new DetPolygon(this.m_Detectiv, idTop, topPoly, bb, fIntensity);
                }
            } else {
                int nCenterY = rVirt.y + rVirt.height / 2;
                int nLeftY = rVirt.y + (ptFrontOffset.y - ptBackOffset.y);
                int nRightY = rVirt.y + rVirt.height + (ptFrontOffset.y - ptBackOffset.y);
                int nBottomFrontX = rVirt.x;
                int nTopFrontX = nBottomFrontX + rVirt.width;
                int nBottomBackX = rVirt.x + (ptFrontOffset.x - ptBackOffset.x);
                int nTopBackX = nBottomBackX + rVirt.width;
                BlackBoxIF bb = new SimpleBlackBoxObj(this.m_Perspective, this.assignSeriesIdent(s, g), this.m_bWantRiserBorder);
                bb = bb.runRules(s, g);
                Polygon leftPoly = new Polygon();
                leftPoly.addPoint(nBottomBackX, nLeftY);
                leftPoly.addPoint(nBottomFrontX, nCenterY);
                leftPoly.addPoint(nTopFrontX, nCenterY);
                leftPoly.addPoint(nTopBackX, nLeftY);
                leftPoly.addPoint(nBottomBackX, nLeftY);
                double fIntensity = this.m_bColorAutoshadeRisers ? 1.0 : 1.0;
                IdentObj idSide = new IdentObj(277, s, g);
                new DetPolygon(this.m_Detectiv, idSide, leftPoly, blackBox, fIntensity);
                Polygon rightPoly = new Polygon();
                rightPoly.addPoint(nBottomFrontX, nCenterY);
                rightPoly.addPoint(nBottomBackX, nRightY);
                rightPoly.addPoint(nTopBackX, nRightY);
                rightPoly.addPoint(nTopFrontX, nCenterY);
                rightPoly.addPoint(nBottomFrontX, nCenterY);
                fIntensity = this.m_bColorAutoshadeRisers ? 0.6 : 1.0;
                idSide = new IdentObj(312, s, g);
                new DetPolygon(this.m_Detectiv, idSide, rightPoly, bb, fIntensity);
                if (this.m_nDepthAngle < 90) {
                    Polygon topPoly = new Polygon();
                    topPoly.addPoint(nTopFrontX, nCenterY);
                    topPoly.addPoint(nTopBackX, nRightY);
                    topPoly.addPoint(nTopBackX, nLeftY);
                    topPoly.addPoint(nTopFrontX, nCenterY);
                    fIntensity = this.m_bColorAutoshadeRisers ? 0.8 : 1.0;
                    IdentObj idTop = new IdentObj(313, s, g);
                    new DetPolygon(this.m_Detectiv, idTop, topPoly, bb, fIntensity);
                } else if (this.m_nDepthAngle > 90) {
                    Polygon bottomPoly = new Polygon();
                    bottomPoly.addPoint(nBottomFrontX, nCenterY);
                    bottomPoly.addPoint(nBottomBackX, nRightY);
                    bottomPoly.addPoint(nBottomBackX, nLeftY);
                    bottomPoly.addPoint(nBottomFrontX, nCenterY);
                    fIntensity = this.m_bColorAutoshadeRisers ? 0.8 : 1.0;
                    IdentObj idBottom = new IdentObj(313, s, g);
                    new DetPolygon(this.m_Detectiv, idBottom, bottomPoly, bb, fIntensity);
                }
            }
        } else if (barShape == 3) {
            boolean bHoriz = this.m_Perspective.getJGraphType().isOrientHorz();
            if (!bHoriz) {
                int nCenterFrontX = rVirt.x + rVirt.width / 2;
                int nCenterBackX = nCenterFrontX + (ptFrontOffset.x - ptBackOffset.x);
                int nLeftX = rVirt.x + (ptFrontOffset.x - ptBackOffset.x) / 2;
                int nRightX = rVirt.x + rVirt.width + (ptFrontOffset.x - ptBackOffset.x) / 2;
                int nBottomFrontY = rVirt.y;
                int nTopFrontY = nBottomFrontY + rVirt.height;
                int nBottomMidY = rVirt.y + (ptFrontOffset.y - ptBackOffset.y) / 2;
                int nTopMidY = nBottomMidY + rVirt.height;
                int nTopBackY = rVirt.y + rVirt.height + (ptFrontOffset.y - ptBackOffset.y);
                BlackBoxIF bb = new SimpleBlackBoxObj(this.m_Perspective, this.assignSeriesIdent(s, g), this.m_bWantRiserBorder);
                bb = bb.runRules(s, g);
                Polygon leftPoly = new Polygon();
                leftPoly.addPoint(nLeftX, nBottomMidY);
                leftPoly.addPoint(nCenterFrontX, nBottomFrontY);
                leftPoly.addPoint(nCenterFrontX, nTopFrontY);
                leftPoly.addPoint(nLeftX, nTopMidY);
                leftPoly.addPoint(nLeftX, nBottomMidY);
                double fIntensity = this.m_bColorAutoshadeRisers ? 1.0 : 1.0;
                IdentObj idSide = new IdentObj(277, s, g);
                new DetPolygon(this.m_Detectiv, idSide, leftPoly, blackBox, fIntensity);
                Polygon rightPoly = new Polygon();
                rightPoly.addPoint(nCenterFrontX, nBottomFrontY);
                rightPoly.addPoint(nRightX, nBottomMidY);
                rightPoly.addPoint(nRightX, nTopMidY);
                rightPoly.addPoint(nCenterFrontX, nTopFrontY);
                rightPoly.addPoint(nCenterFrontX, nBottomFrontY);
                fIntensity = this.m_bColorAutoshadeRisers ? 0.6 : 1.0;
                idSide = new IdentObj(312, s, g);
                new DetPolygon(this.m_Detectiv, idSide, rightPoly, bb, fIntensity);
                if (this.m_nDepthAngle != 0 && this.m_nDepthAngle != 180) {
                    Polygon topPoly = new Polygon();
                    topPoly.addPoint(nCenterFrontX, nTopFrontY);
                    topPoly.addPoint(nRightX, nTopMidY);
                    topPoly.addPoint(nCenterBackX, nTopBackY);
                    topPoly.addPoint(nLeftX, nTopMidY);
                    topPoly.addPoint(nCenterFrontX, nTopFrontY);
                    fIntensity = this.m_bColorAutoshadeRisers ? 0.8 : 1.0;
                    IdentObj idTop = new IdentObj(313, s, g);
                    new DetPolygon(this.m_Detectiv, idTop, topPoly, bb, fIntensity);
                }
            } else {
                int nCenterFrontY = rVirt.y + rVirt.height / 2;
                int nCenterBackY = nCenterFrontY + (ptFrontOffset.y - ptBackOffset.y);
                int nLeftY = rVirt.y + (ptFrontOffset.y - ptBackOffset.y) / 2;
                int nRightY = rVirt.y + rVirt.height + (ptFrontOffset.y - ptBackOffset.y) / 2;
                int nBottomFrontX = rVirt.x;
                int nTopFrontX = nBottomFrontX + rVirt.width;
                int nBottomMidX = rVirt.x + (ptFrontOffset.x - ptBackOffset.x) / 2;
                int nTopMidX = nBottomMidX + rVirt.width;
                int nBottomBackX = rVirt.x + (ptFrontOffset.x - ptBackOffset.x);
                int nTopBackX = nBottomBackX + rVirt.width;
                BlackBoxIF bb = new SimpleBlackBoxObj(this.m_Perspective, this.assignSeriesIdent(s, g), this.m_bWantRiserBorder);
                bb = bb.runRules(s, g);
                Polygon leftPoly = new Polygon();
                leftPoly.addPoint(nBottomMidX, nLeftY);
                leftPoly.addPoint(nBottomFrontX, nCenterFrontY);
                leftPoly.addPoint(nTopFrontX, nCenterFrontY);
                leftPoly.addPoint(nTopMidX, nLeftY);
                leftPoly.addPoint(nBottomMidX, nLeftY);
                double fIntensity = this.m_bColorAutoshadeRisers ? 1.0 : 1.0;
                IdentObj idSide = new IdentObj(277, s, g);
                new DetPolygon(this.m_Detectiv, idSide, leftPoly, blackBox, fIntensity);
                Polygon rightPoly = new Polygon();
                rightPoly.addPoint(nBottomFrontX, nCenterFrontY);
                rightPoly.addPoint(nBottomMidX, nRightY);
                rightPoly.addPoint(nTopMidX, nRightY);
                rightPoly.addPoint(nTopFrontX, nCenterFrontY);
                rightPoly.addPoint(nBottomFrontX, nCenterFrontY);
                fIntensity = this.m_bColorAutoshadeRisers ? 0.6 : 1.0;
                idSide = new IdentObj(312, s, g);
                new DetPolygon(this.m_Detectiv, idSide, rightPoly, bb, fIntensity);
                if (this.m_nDepthAngle < 90) {
                    Polygon topPoly = new Polygon();
                    topPoly.addPoint(nTopFrontX, nCenterFrontY);
                    topPoly.addPoint(nTopMidX, nRightY);
                    topPoly.addPoint(nTopBackX, nCenterBackY);
                    topPoly.addPoint(nTopMidX, nLeftY);
                    topPoly.addPoint(nTopFrontX, nCenterFrontY);
                    fIntensity = this.m_bColorAutoshadeRisers ? 0.8 : 1.0;
                    IdentObj idTop = new IdentObj(313, s, g);
                    new DetPolygon(this.m_Detectiv, idTop, topPoly, bb, fIntensity);
                } else if (this.m_nDepthAngle > 90) {
                    Polygon bottomPoly = new Polygon();
                    bottomPoly.addPoint(nBottomFrontX, nCenterFrontY);
                    bottomPoly.addPoint(nBottomMidX, nRightY);
                    bottomPoly.addPoint(nBottomBackX, nCenterBackY);
                    bottomPoly.addPoint(nBottomMidX, nLeftY);
                    bottomPoly.addPoint(nBottomFrontX, nCenterFrontY);
                    fIntensity = this.m_bColorAutoshadeRisers ? 0.8 : 1.0;
                    IdentObj idBottom = new IdentObj(313, s, g);
                    new DetPolygon(this.m_Detectiv, idBottom, bottomPoly, bb, fIntensity);
                }
            }
        } else if (barShape == 1) {
            boolean bHoriz = this.m_Perspective.getJGraphType().isOrientHorz();
            if (!bHoriz) {
                BlackBoxIF bb = new SimpleBlackBoxObj(this.m_Perspective, this.assignSeriesIdent(s, g), this.m_bWantRiserBorder);
                bb = bb.runRules(s, g);
                if (this.m_nDepthAngle != 0 && this.m_nDepthAngle != 180) {
                    double width = rVirt.width;
                    double height = ptFrontOffset.y - ptBackOffset.y;
                    double x = rVirt.x;
                    double y = (double)(rVirt.y + rVirt.height) + height;
                    VC vc = this.m_Perspective.getVC();
                    if (this.m_Perspective.getZoomAndScroll() == 0 && this.m_Perspective.isExportingToXML()) {
                        vc = this.m_Perspective.getRangeSliderVC();
                    }
                    double destX = vc.virtToDestX(x);
                    double destY = vc.virtToDestY(y);
                    double destWidth = vc.virtToDestWidth(width);
                    double destHeight = vc.virtToDestHeight(height);
                    IdentObj idFront = new IdentObj(277, s, g);
                    Arc2D.Double topArc = new Arc2D.Double(destX, destY, destWidth, destHeight, 180.0, 180.0, 0);
                    Arc2D.Double bottomArc = new Arc2D.Double(destX, destY + (double)vc.virtToDestHeight(rVirt.height), destWidth, destHeight, 180.0, 180.0, 0);
                    Area frontBar = JChart_2D_Pie._convertShapeToArea(topArc, bottomArc);
                    double fIntensity = this.m_bColorAutoshadeRisers ? 1.0 : 1.0;
                    BlackBoxIF bbox = new BlackBoxObj(this.m_Perspective, new IdentObj(-3, s, g));
                    bbox = bbox.runRules(s, g);
                    this.applyCylinderBarsGradientEffect(bbox);
                    new DetArea(this.m_Detectiv, idFront, frontBar, bbox, fIntensity);
                    IdentObj idTop = new IdentObj(313, s, g);
                    Ellipse2D.Double topOval = new Ellipse2D.Double(destX, destY + 1.0, destWidth, destHeight);
                    fIntensity = this.m_bColorAutoshadeRisers ? 0.8 : 1.0;
                    new DetArea(this.m_Detectiv, idTop, new Area(topOval), bb, fIntensity);
                } else {
                    IdentObj idFront = new IdentObj(277, s, g);
                    double fIntensity = this.m_bColorAutoshadeRisers ? 1.0 : 1.0;
                    Polygon poly = new Polygon();
                    poly.addPoint(rVirt.x, rVirt.y);
                    poly.addPoint(rVirt.x + rVirt.width, rVirt.y);
                    poly.addPoint(rVirt.x + rVirt.width, rVirt.y + rVirt.height);
                    poly.addPoint(rVirt.x, rVirt.y + rVirt.height);
                    poly.addPoint(rVirt.x, rVirt.y);
                    BlackBoxIF bbox = new BlackBoxObj(this.m_Perspective, new IdentObj(-3, s, g));
                    bbox = bbox.runRules(s, g);
                    this.applyCylinderBarsGradientEffect(bbox);
                    new DetPolygon(this.m_Detectiv, idFront, poly, bbox, fIntensity);
                }
            } else {
                BlackBoxIF bb = new SimpleBlackBoxObj(this.m_Perspective, this.assignSeriesIdent(s, g), this.m_bWantRiserBorder);
                bb = bb.runRules(s, g);
                if (this.m_nDepthAngle != 90) {
                    double width = ptFrontOffset.x - ptBackOffset.x;
                    double height = rVirt.height;
                    double x = rVirt.x + rVirt.width;
                    double y = rVirt.y + rVirt.height;
                    VC vc = this.m_Perspective.getVC();
                    if (this.m_Perspective.getZoomAndScroll() == 0 && this.m_Perspective.isExportingToXML()) {
                        vc = this.m_Perspective.getRangeSliderVC();
                    }
                    double destX = vc.virtToDestX(x);
                    double destY = vc.virtToDestY(y);
                    double destWidth = vc.virtToDestWidth(width);
                    double destHeight = vc.virtToDestHeight(height);
                    Arc2D.Double leftArc = new Arc2D.Double(destX, destY, destWidth, destHeight, 90.0, 180.0, 0);
                    Arc2D.Double rightArc = new Arc2D.Double(destX - (double)vc.virtToDestWidth(rVirt.width), destY, destWidth, destHeight, 90.0, 180.0, 0);
                    Area frontBar = JChart_2D_Pie._convertShapeToArea(leftArc, rightArc);
                    double fIntensity = this.m_bColorAutoshadeRisers ? 1.0 : 1.0;
                    BlackBoxIF bbox = new BlackBoxObj(this.m_Perspective, new IdentObj(-3, s, g));
                    bbox = bbox.runRules(s, g);
                    this.applyCylinderBarsGradientEffect(bbox);
                    IdentObj idFront = new IdentObj(277, s, g);
                    new DetArea(this.m_Detectiv, idFront, frontBar, bbox, fIntensity);
                    IdentObj idTop = new IdentObj(313, s, g);
                    fIntensity = this.m_bColorAutoshadeRisers ? 0.8 : 1.0;
                    Ellipse2D.Double topOval = new Ellipse2D.Double(destX, destY, destWidth, destHeight);
                    new DetArea(this.m_Detectiv, idTop, new Area(topOval), bb, fIntensity);
                } else {
                    IdentObj idFront = new IdentObj(277, s, g);
                    double fIntensity = this.m_bColorAutoshadeRisers ? 1.0 : 1.0;
                    Polygon poly = new Polygon();
                    poly.addPoint(rVirt.x, rVirt.y);
                    poly.addPoint(rVirt.x + rVirt.width, rVirt.y);
                    poly.addPoint(rVirt.x + rVirt.width, rVirt.y + rVirt.height);
                    poly.addPoint(rVirt.x, rVirt.y + rVirt.height);
                    poly.addPoint(rVirt.x, rVirt.y);
                    BlackBoxIF bbox = new BlackBoxObj(this.m_Perspective, new IdentObj(-3, s, g));
                    bbox = bbox.runRules(s, g);
                    this.applyCylinderBarsGradientEffect(bbox);
                    new DetPolygon(this.m_Detectiv, idFront, poly, bbox, fIntensity);
                }
            }
        }
    }

    protected void drawMarkers() {
        double markerSizeX;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        MarkerTemplate markerTemplate = null;
        int s = 0;
        int g = 0;
        double destWidth = 0.0;
        boolean newBehavior = this.m_Perspective.isMarkerSizeDefaultChanged();
        if (!(this.m_bMarkerDisplay || this.m_gt.isBLAType() || this.m_gt.isPolar() || this.m_gt.isScatter() || this.m_gt.isBubble())) {
            return;
        }
        double markerSizeY = markerSizeX = (double)this.m_Perspective.getMarkerSizeDefault();
        if (this.m_bSquareMarkers) {
            if (newBehavior) {
                destX = this.m_Perspective.m_VC.virtToDestWidth(markerSizeX);
                if (destX > (destY = this.m_Perspective.m_VC.virtToDestHeight(markerSizeY))) {
                    markerSizeX = markerSizeX * destY / destX;
                } else {
                    markerSizeY = markerSizeY * destX / destY;
                }
            } else {
                destX = this.m_Perspective.m_VC.virtToDestWidth((int)markerSizeX);
                if (destX > (destY = (double)this.m_Perspective.m_VC.virtToDestHeight((int)markerSizeY))) {
                    markerSizeX = this.m_Perspective.m_VC.destToVirtWidth((int)((double)this.m_Perspective.m_VC.virtToDestWidth((int)markerSizeX) * destY / destX));
                } else {
                    markerSizeY = this.m_Perspective.m_VC.destToVirtHeight((int)((double)this.m_Perspective.m_VC.virtToDestHeight((int)markerSizeY) * destX / destY));
                }
            }
        }
        destWidth = this.m_Perspective.m_VC.virtToDestWidth(markerSizeX);
        IdentObj idSeries = new IdentObj(-3, s);
        IdentObj lineMarkerID = new IdentObj(259, s);
        boolean bMarkerShape = false;
        boolean bMarkerColor = false;
        if (this.m_gt.isScatter() && this.m_Perspective.m_ScatterGraphDataStyle != null) {
            bMarkerShape = this.m_Perspective.m_ScatterGraphDataStyle.isMarkerShapePresent();
            bMarkerColor = this.m_Perspective.m_ScatterGraphDataStyle.isMarkerColorPresent();
        }
        while (sEnum.hasMoreElements()) {
            s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            if (this.m_seriesTypes[s] != 2 && this.m_seriesTypes[s] != 3) continue;
            lineMarkerID.setSeriesID(s);
            boolean temp = lineMarkerID.useSeriesLooping();
            lineMarkerID.setUseSeriesLooping(true);
            BlackBoxIF bb = new BlackBoxObj(this.m_Perspective, lineMarkerID);
            lineMarkerID.setUseSeriesLooping(temp);
            if (s >= this.m_nSeriesLooping) {
                this.m_Perspective.m_getDefault = false;
                IdentObj idS = this.m_Perspective.getSeries(s);
                Color c = this.m_Perspective.getFillColor(idS);
                this.m_Perspective.m_getDefault = true;
                if (c != null) {
                    bb = new BlackBoxObj(this.m_Perspective, lineMarkerID);
                }
            }
            idSeries.setSeriesID(s);
            if (this.m_Perspective.getMarkerShapeObj(idSeries) != null) {
                markerTemplate = this.getMarkerShape(idSeries);
            } else {
                boolean temp1 = idSeries.useSeriesLooping();
                idSeries.setUseSeriesLooping(true);
                markerTemplate = this.getMarkerShape(idSeries);
                idSeries.setUseSeriesLooping(temp1);
            }
            RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
            int maxCoord = (int)axisObj.getValueCoord(axisObj.getMaxValue());
            int minCoord = (int)axisObj.getValueCoord(axisObj.getMinValue());
            if (this.m_gt.isBubble() && (!this.m_Perspective.getUseDefaultBubbleMarker(idSeries) && markerTemplate != MarkerTemplateArray.PRESET_HUMAN && markerTemplate.getMarkerType() != 12 && markerTemplate != MarkerTemplateArray.PRESET_NULL || this.m_Perspective.getUseDefaultBubbleMarker(idSeries))) {
                markerTemplate = MarkerTemplateArray.PRESET_BUBBLE;
            }
            if (this.m_Perspective.getMarkerSizeUniqueness() == 1 && !this.m_gt.isBubble()) {
                markerSizeY = markerSizeX = (double)this.m_Perspective.getMarkerSize(s);
                if (this.m_bSquareMarkers) {
                    if (newBehavior) {
                        double destX = this.m_Perspective.m_VC.virtToDestWidth(markerSizeX);
                        if (destX > (destY = this.m_Perspective.m_VC.virtToDestHeight(markerSizeY))) {
                            markerSizeX = markerSizeX * destY / destX;
                        } else {
                            markerSizeY = markerSizeY * destX / destY;
                        }
                    } else {
                        double destX = this.m_Perspective.m_VC.virtToDestWidth((int)markerSizeX);
                        if (destX > (destY = (double)this.m_Perspective.m_VC.virtToDestHeight((int)markerSizeY))) {
                            markerSizeX = (int)(markerSizeX * destY / destX);
                        } else {
                            markerSizeY = (int)(markerSizeY * destX / destY);
                        }
                    }
                }
                destWidth = this.m_Perspective.m_VC.virtToDestWidth(markerSizeX);
            }
            boolean bDisableFormatting = this.m_Perspective.isNoRescaleHiddenSeries(s);
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                boolean hasFillColorStyle;
                g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                if (!this.m_dataOK[s][g] || this.m_gt.isBLAType() && (this.m_numYCoords[s][g] > maxCoord || this.m_numYCoords[s][g] < minCoord)) continue;
                Point center = this.getCoords(s, g);
                if (this.m_Perspective.getMarkerSizeUniqueness() >= 2 || this.m_gt.isBubble()) {
                    markerSizeY = markerSizeX = (double)this.getMarkerSize(s, g);
                    if (this.m_bSquareMarkers) {
                        if (newBehavior) {
                            double destY;
                            double destX = this.m_Perspective.m_VC.virtToDestWidth(markerSizeX);
                            if (destX > (destY = this.m_Perspective.m_VC.virtToDestHeight(markerSizeY))) {
                                markerSizeX = markerSizeX * destY / destX;
                            } else {
                                markerSizeY = markerSizeY * destX / destY;
                            }
                        } else {
                            double destY;
                            double destX = this.m_Perspective.m_VC.virtToDestWidth((int)markerSizeX);
                            if (destX > (destY = (double)this.m_Perspective.m_VC.virtToDestHeight((int)markerSizeY))) {
                                markerSizeX = (int)(markerSizeX * destY / destX);
                            } else {
                                markerSizeY = (int)(markerSizeY * destX / destY);
                            }
                        }
                    }
                    destWidth = this.m_Perspective.m_VC.virtToDestWidth(markerSizeX);
                }
                this.m_smallMarker = this.m_autoGradient && destWidth <= 8.0;
                BlackBoxIF blackBox = this.assignSeriesColor(s, g);
                GraphStyle style = blackBox.getGraphStyle(s, g);
                blackBox = blackBox.runRules(s, g);
                boolean bl = hasFillColorStyle = style != null && style.getFillColor() != null;
                if (!this.m_bMarkerDisplay && this.m_gt.isBLAType() && (style == null || !style.isMarkerVisibleUsed())) continue;
                if (this.m_gt.isBubble()) {
                    boolean hasBubbleStyle = style != null && style.getEffect() != -1;
                    BlackBoxIF bubbleBB = this.m_Perspective.getFillColor(lineMarkerID, false) != null && !hasFillColorStyle && this.m_Perspective.getEffect(this.m_Perspective.getSeries(s)) == -1 && !hasBubbleStyle ? bb : blackBox;
                    this._addBubbleMarker(this.m_Detectiv, new IdentObj(259, s, g), markerTemplate, center, (int)markerSizeX, (int)markerSizeY, bubbleBB, this.m_rClip, true);
                    continue;
                }
                MarkerTemplate saveShape = null;
                if (style != null) {
                    if (style.isMarkerVisibleUsed() && !style.isMarkerVisible()) {
                        saveShape = markerTemplate;
                        markerTemplate = this.m_Perspective.getMarkerTemplate(0);
                    } else if (style.isMarkerShapeUsed() && style.getMarkerShape() != markerTemplate.getMarkerType() || style.isMarkerVisibleUsed() && style.isMarkerVisible()) {
                        saveShape = markerTemplate;
                        markerTemplate = this.m_Perspective.getMarkerTemplate(style.getMarkerShape());
                    }
                }
                BlackBoxObj tempBB = bb;
                if (hasFillColorStyle) {
                    bb = blackBox;
                }
                bb = this.checkForMarkerColorOverride(g, bb);
                if (blackBox.getBorderColor() != null) {
                    bb.setBorderColor(blackBox.getBorderColor());
                }
                bb.setTransparentBorderColor(blackBox.getTransparentBorderColor());
                if (markerTemplate.m_markerType == 0 && !this.m_gt.isPolar() && !this.m_gt.isScatter()) {
                    Dimension dimMarker = this.getTransparentMarkerDimension();
                    bb.setTransparentFillColor(true);
                    MarkerObj.createMarker(this.m_Detectiv, new IdentObj(259, s, g), MarkerTemplateArray.PRESET_SQUARE, center, dimMarker.width, dimMarker.height, bb, null, true, false, 0, 0, 0, false);
                } else {
                    BlackBoxIF saveBB = null;
                    if (bMarkerShape || bMarkerColor) {
                        int row = this.m_Access.getRow(s, g);
                        int col = this.m_Access.getCol(s, g);
                        if (bMarkerShape && !bDisableFormatting) {
                            MarkerTemplate newShape = DetMarker.getMarkerTemplate(this.m_Perspective.m_ScatterGraphDataStyle.getMarkerShape(row, col));
                            if (newShape == null) continue;
                            saveShape = markerTemplate;
                            markerTemplate = newShape;
                        }
                        if (bMarkerColor && !bDisableFormatting) {
                            Color newColor = this.m_Perspective.m_ScatterGraphDataStyle.getMarkerColor(row, col);
                            if (newColor == null) continue;
                            saveBB = bb;
                            bb = new BlackBoxObj(this.m_Perspective, new IdentObj(259));
                            bb.setFillColor(newColor);
                        }
                    }
                    MarkerObj.createMarker(this.m_Detectiv, new IdentObj(259, s, g), markerTemplate, center, (int)markerSizeX, (int)markerSizeY, bb, null, true);
                    this._addUnderlayAttrs(s, g);
                    if (this.m_gt.isScatter()) {
                        this.drawLabel(s, g);
                    }
                    if (saveBB != null) {
                        bb = saveBB;
                    }
                }
                if (tempBB != bb) {
                    bb = tempBB;
                }
                if (saveShape == null) continue;
                markerTemplate = saveShape;
            }
        }
        if (this.m_gt.isBubble()) {
            this._createBubbleMarkerObjs();
        }
    }

    private void _addUnderlayAttrs(int s, int g) {
        List underlayAttrib;
        if (this.m_Perspective.isExportingToXML() && this.m_Perspective.m_ScatterGraphDataStyle != null && (this.m_Perspective.m_ScatterGraphDataStyle.isUnderlayShapePresent() || this.m_Perspective.m_ScatterGraphDataStyle.isUnderlayColorPresent()) && (underlayAttrib = this.m_Perspective.m_ScatterGraphDataStyle.getUnderlayAttributesFromSeries(s, g)) != null) {
            Color underlayColor = (Color)underlayAttrib.get(ScatterGraphDataStyle.UnderlayAttributesIndex.Color.getId());
            DataStyleType.Shape underlayShape = (DataStyleType.Shape)((Object)underlayAttrib.get(ScatterGraphDataStyle.UnderlayAttributesIndex.Shape.getId()));
            this.m_Detectiv.addDetMarkerAttributes(DataStyleType.UNDERLAY_COLOR.toString(), underlayColor);
            this.m_Detectiv.addDetMarkerAttributes(DataStyleType.UNDERLAY_SHAPE.toString(), (Object)underlayShape);
        }
    }

    private void _addBubbleMarker(Detectiv a_Detectiv, IdentObj id, MarkerTemplate template, Point center, int markerSizeX, int markerSizeY, BlackBoxIF blackBox, Rectangle rClip, boolean bLimitSize) {
        if (this.m_bubbleMarkerInfo == null) {
            this.m_bubbleMarkerInfo = new ArrayList(this.m_nTotalGroups * this.m_nTotalSeries);
        }
        Object[] bubbleInfo = new Object[]{a_Detectiv, id, template, center, markerSizeX, markerSizeY, blackBox, rClip, bLimitSize};
        this.m_bubbleMarkerInfo.add(bubbleInfo);
    }

    private void _createBubbleMarkerObjs() {
        if (this.m_bubbleMarkerInfo != null) {
            if (!this.m_Perspective.isExportingToXML()) {
                Collections.sort(this.m_bubbleMarkerInfo, m_bubbleComparator);
            }
            for (Object[] bubbleInfo : this.m_bubbleMarkerInfo) {
                MarkerTemplate template = (MarkerTemplate)bubbleInfo[2];
                if (template.m_markerType == 0) continue;
                Detectiv detectiv = (Detectiv)bubbleInfo[0];
                IdentObj id = (IdentObj)bubbleInfo[1];
                Point center = (Point)bubbleInfo[3];
                int markerSizeX = (Integer)bubbleInfo[4];
                int markerSizeY = (Integer)bubbleInfo[5];
                BlackBoxIF blackBox = (BlackBoxIF)bubbleInfo[6];
                Rectangle rClip = (Rectangle)bubbleInfo[7];
                boolean bLimitSize = (Boolean)bubbleInfo[8];
                MarkerObj.createMarker(detectiv, id, template, center, markerSizeX, markerSizeY, blackBox, rClip, bLimitSize);
                this.drawLabel(id.getSeriesID(), id.getGroupID());
                this._addUnderlayAttrs(id.getSeriesID(), id.getGroupID());
            }
            this.m_bubbleMarkerInfo = null;
        }
    }

    protected void drawTransparentMarkers(int nSeriesType) {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        MarkerTemplate markerTemplate = MarkerTemplateArray.PRESET_SQUARE;
        Dimension dimMarker = this.getTransparentMarkerDimension();
        SimpleBlackBoxObj blackBoxTransparent = new SimpleBlackBoxObj(this.m_Perspective);
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            if (this.m_seriesTypes[s] != nSeriesType) continue;
            gEnum.reset();
            RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
            int maxCoord = (int)axisObj.getValueCoord(axisObj.getMaxValue());
            int minCoord = (int)axisObj.getValueCoord(axisObj.getMinValue());
            if (axisObj.isDescending()) {
                int temp = minCoord;
                minCoord = maxCoord;
                maxCoord = temp;
            }
            int prevX = -1;
            int prevY = -1;
            while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                if (!this.m_dataOK[s][g] || !this.m_gt.isPolar() && !this.m_gt.isRadarType() && (this.m_numYCoords[s][g] > maxCoord || this.m_numYCoords[s][g] < minCoord)) continue;
                IdentObj identObjLineMarker = new IdentObj(259, s, g);
                Point ptCenter = this.getCoords(s, g);
                int destX = this.m_Perspective.m_VC.virtToDestX(ptCenter.x);
                int destY = this.m_Perspective.m_VC.virtToDestY(ptCenter.y);
                prevX = destX;
                prevY = destY;
                MarkerObj.createMarker(this.m_Detectiv, identObjLineMarker, markerTemplate, ptCenter, dimMarker.width, dimMarker.height, blackBoxTransparent, null, true, false, 0, 0, 0, false);
            }
        }
    }

    protected Dimension getTransparentMarkerDimension() {
        double destY;
        int nMarkerHeight;
        int nMarkerSize = this.m_Perspective.getTransparentMarkerSize();
        int nMarkerWidth = nMarkerSize == 0 ? (nMarkerHeight = this.m_Perspective.getMarkerSizeDefault()) : (nMarkerHeight = nMarkerSize);
        double destX = this.m_Perspective.m_VC.virtToDestWidth((double)nMarkerWidth);
        if (destX > (destY = this.m_Perspective.m_VC.virtToDestHeight((double)nMarkerHeight))) {
            nMarkerWidth = (int)((double)nMarkerWidth * destY / destX);
        } else {
            nMarkerHeight = (int)((double)nMarkerHeight * destX / destY);
        }
        Dimension dimMarker = new Dimension(nMarkerWidth, nMarkerHeight);
        return dimMarker;
    }

    protected void drawAllMarkersWithDepth(boolean faceOnly) {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        if (!(this.m_bMarkerDisplay || this.m_gt.isBLAType() || this.m_gt.isPolar() || this.m_gt.isRadarType() || this.m_gt.isScatter() || this.m_gt.isBubble())) {
            return;
        }
        if (this.m_nDepthRadius <= 0) {
            throw new AssertionException("Can't draw 2.5D markers without positive DepthRadius");
        }
        if (this.m_Frame == null) {
            throw new AssertionException("Can't draw 2.5D markers without m_Frame");
        }
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            this.drawMarkersWithDepth(s, faceOnly);
        }
        if (this.m_gt.isBubble()) {
            this._createBubbleMarkerObjsWithDepth();
        }
    }

    protected void drawMarkersWithDepth(int s, boolean faceOnly) {
        int nYDepth;
        int nXDepth;
        Point ptFrontOffset;
        boolean bThreeD;
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        boolean bl = bThreeD = !faceOnly;
        if (!(this.m_bMarkerDisplay || this.m_gt.isBLAType() || this.m_gt.isPolar() || this.m_gt.isRadarType() || this.m_gt.isScatter() || this.m_gt.isBubble())) {
            return;
        }
        RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
        if (this.m_nDepthRadius <= 0) {
            throw new AssertionException("Can't draw 2.5D markers without positive DepthRadius");
        }
        if (this.m_Frame == null) {
            throw new AssertionException("Can't draw 2.5D markers without m_Frame");
        }
        PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
        if (this.m_seriesTypes[s] != 2) {
            return;
        }
        IdentObj idMarkerSeries = this.m_Perspective.getSeries(s);
        boolean temp = idMarkerSeries.useSeriesLooping();
        idMarkerSeries.setUseSeriesLooping(true);
        MarkerTemplate markerTemplate = this.getMarkerShape(idMarkerSeries);
        idMarkerSeries.setUseSeriesLooping(temp);
        if (markerTemplate.m_markerType == 2) {
            markerTemplate = MarkerTemplateArray.PRESET_DEPTHCIRCLE;
        }
        if (this.m_gt.isBubble() && (!this.m_Perspective.getUseDefaultBubbleMarker(idMarkerSeries) && markerTemplate != MarkerTemplateArray.PRESET_HUMAN && markerTemplate != MarkerTemplateArray.PRESET_NULL || this.m_Perspective.getUseDefaultBubbleMarker(idMarkerSeries))) {
            markerTemplate = MarkerTemplateArray.PRESET_BUBBLE;
        }
        if (this.m_nDepthRadius > 0 && this.m_nDepthPlanes > 0) {
            double fFrontOffset = this.calcFrontOffset(this.m_seriesPlanes[s], this.m_nDepthPlanes);
            double fBackOffset = this.calcBackOffset(this.m_seriesPlanes[s], this.m_nDepthPlanes);
            if (fBackOffset > 0.0) {
                fBackOffset -= 1.0 / (double)this.m_nDepthPlanes / 2.0;
            } else {
                fFrontOffset = 1.0 / (double)this.m_nDepthPlanes / 2.0 + fFrontOffset;
            }
            ptFrontOffset = this.m_Frame.getDepthOffset(fFrontOffset);
            ptBackOffset = this.m_Frame.getDepthOffset(fBackOffset);
            nXDepth = ptFrontOffset.x - ptBackOffset.x;
            nYDepth = ptFrontOffset.y - ptBackOffset.y;
        } else {
            ptFrontOffset = new Point();
            ptBackOffset = new Point();
            nXDepth = 0;
            nYDepth = 0;
        }
        gEnum.reset();
        int maxCoord = (int)axisObj.getValueCoord(axisObj.getMaxValue());
        int minCoord = (int)axisObj.getValueCoord(axisObj.getMinValue());
        boolean bMarkerShape = false;
        boolean bMarkerColor = false;
        if (this.m_gt.isScatter() && this.m_Perspective.m_ScatterGraphDataStyle != null) {
            bMarkerShape = this.m_Perspective.m_ScatterGraphDataStyle.isMarkerShapePresent();
            bMarkerColor = this.m_Perspective.m_ScatterGraphDataStyle.isMarkerColorPresent();
        }
        boolean bDisableFormatting = this.m_Perspective.isNoRescaleHiddenSeries(s);
        boolean wasMarkerConditionallySet = false;
        while (gEnum.hasMoreElements()) {
            boolean hasFillColorStyle;
            int markerSizeY;
            int g;
            if (wasMarkerConditionallySet) {
                markerTemplate = this.getMarkerShape(idMarkerSeries);
                wasMarkerConditionallySet = false;
            }
            PfjAssert.pfjAssert((g = gEnum.nextGroup()) >= 0 && g < this.m_nTotalGroups);
            if (!this.m_dataOK[s][g] || this.m_gt.isBLAType() && (this.m_numYCoords[s][g] > maxCoord || this.m_numYCoords[s][g] < minCoord)) continue;
            Point ptCenter = this.getCoords(s, g);
            Point ptFront = new Point(ptCenter.x - ptFrontOffset.x, ptCenter.y - ptFrontOffset.y);
            int markerSizeX = markerSizeY = this.getMarkerSize(s, g);
            if (this.m_bSquareMarkers) {
                double destY;
                double destX = this.m_Perspective.m_VC.virtToDestWidth((double)markerSizeX);
                if (destX > (destY = this.m_Perspective.m_VC.virtToDestHeight((double)markerSizeY))) {
                    markerSizeX = (int)((double)markerSizeX * destY / destX);
                } else {
                    markerSizeY = (int)((double)markerSizeY * destX / destY);
                }
            }
            BlackBoxIF blackBox = this.assignSeriesColor(s, g);
            GraphStyle style = blackBox.getGraphStyle(s, g);
            blackBox = blackBox.runRules(s, g);
            boolean bl2 = hasFillColorStyle = style != null && style.getFillColor() != null;
            if (!this.m_bMarkerDisplay && this.m_gt.isBLAType() && (style == null || !style.isMarkerVisibleUsed())) continue;
            IdentObj identObjLineMarker = new IdentObj(259, s, g);
            identObjLineMarker.setMiscID(0);
            if (this.m_gt.isBubble()) {
                this._addBubbleMarkerWithDepth(this.m_Detectiv, identObjLineMarker, markerTemplate, ptFront, markerSizeX, markerSizeY, blackBox, this.m_rClip, true, true, nXDepth, nYDepth, this.m_nDepthAngle);
                continue;
            }
            if (style != null) {
                if (style.isMarkerVisibleUsed() && !style.isMarkerVisible()) {
                    markerTemplate = new MarkerTemplateArray().getMarkerTemplate(0);
                } else if (style.isMarkerShapeUsed() && style.getMarkerShape() != markerTemplate.getMarkerType()) {
                    markerTemplate = new MarkerTemplateArray().getMarkerTemplate(style.getMarkerShape());
                    wasMarkerConditionallySet = true;
                }
            }
            IdentObj lineMarkerID = new IdentObj(259, s);
            BlackBoxIF bb = new BlackBoxObj(this.m_Perspective, lineMarkerID);
            if (blackBox.getBorderColor() != null) {
                bb.setBorderColor(blackBox.getBorderColor());
            }
            bb.setTransparentBorderColor(blackBox.getTransparentBorderColor());
            Color markerColor = this.m_Perspective.getFillColor(lineMarkerID);
            if (markerColor.equals(blackBox.getFillColor()) || hasFillColorStyle) {
                bb = blackBox;
            }
            MarkerTemplate saveShape = null;
            BlackBoxIF saveBB = null;
            if (bMarkerShape || bMarkerColor) {
                int row = this.m_Access.getRow(s, g);
                int col = this.m_Access.getCol(s, g);
                if (bMarkerShape && !bDisableFormatting) {
                    MarkerTemplate newShape = DetMarker.getMarkerTemplate(this.m_Perspective.m_ScatterGraphDataStyle.getMarkerShape(row, col));
                    if (newShape == null) continue;
                    saveShape = markerTemplate;
                    markerTemplate = newShape;
                }
                if (bMarkerColor && !bDisableFormatting) {
                    Color newColor = this.m_Perspective.m_ScatterGraphDataStyle.getMarkerColor(row, col);
                    if (newColor == null) continue;
                    saveBB = bb;
                    bb = new BlackBoxObj(this.m_Perspective, new IdentObj(259));
                    bb.setFillColor(newColor);
                }
            }
            MarkerObj.createMarker(this.m_Detectiv, identObjLineMarker, markerTemplate, ptFront, markerSizeX, markerSizeY, bb, null, true, bThreeD, nXDepth, nYDepth, this.m_nDepthAngle);
            if (this.m_gt.isScatter()) {
                this.drawLabel(s, g);
            }
            if (saveBB != null) {
                bb = saveBB;
            }
            if (saveShape == null) continue;
            markerTemplate = saveShape;
        }
    }

    private void _addBubbleMarkerWithDepth(Detectiv a_Detectiv, IdentObj id, MarkerTemplate template, Point center, int markerSizeX, int markerSizeY, BlackBoxIF blackBox, Rectangle rClip, boolean bLimitSize, boolean threed, int nXDepth, int nYDepth, int nDepthAngle) {
        if (this.m_bubbleMarkerInfo == null) {
            this.m_bubbleMarkerInfo = new ArrayList(this.m_nTotalGroups * this.m_nTotalSeries);
        }
        Object[] bubbleInfo = new Object[]{a_Detectiv, id, template, center, markerSizeX, markerSizeY, blackBox, rClip, bLimitSize, threed, nXDepth, nYDepth, nDepthAngle};
        this.m_bubbleMarkerInfo.add(bubbleInfo);
    }

    private void _createBubbleMarkerObjsWithDepth() {
        if (this.m_bubbleMarkerInfo != null) {
            if (!this.m_Perspective.isExportingToXML()) {
                Collections.sort(this.m_bubbleMarkerInfo, m_bubbleComparator);
            }
            for (Object[] bubbleInfo : this.m_bubbleMarkerInfo) {
                MarkerTemplate template = (MarkerTemplate)bubbleInfo[2];
                if (template.m_markerType == 0) continue;
                Detectiv detectiv = (Detectiv)bubbleInfo[0];
                IdentObj id = (IdentObj)bubbleInfo[1];
                Point center = (Point)bubbleInfo[3];
                int markerSizeX = (Integer)bubbleInfo[4];
                int markerSizeY = (Integer)bubbleInfo[5];
                BlackBoxIF blackBox = (BlackBoxIF)bubbleInfo[6];
                Rectangle rClip = (Rectangle)bubbleInfo[7];
                boolean bLimitSize = (Boolean)bubbleInfo[8];
                boolean threed = (Boolean)bubbleInfo[9];
                int nXDepth = (Integer)bubbleInfo[10];
                int nYDepth = (Integer)bubbleInfo[11];
                int nDepthAngle = (Integer)bubbleInfo[12];
                MarkerObj.createMarker(detectiv, id, template, center, markerSizeX, markerSizeY, blackBox, rClip, bLimitSize, threed, nXDepth, nYDepth, nDepthAngle);
                this.drawLabel(id.getSeriesID(), id.getGroupID());
            }
            this.m_bubbleMarkerInfo = null;
        }
    }

    protected void drawTransparentMarkersWithDepth(int s, int nSeriesType) {
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        Point ptFront = new Point();
        if (this.m_nDepthRadius <= 0) {
            throw new AssertionException("Can't draw 2.5D markers without positive DepthRadius");
        }
        if (this.m_Frame == null) {
            throw new AssertionException("Can't draw 2.5D markers without m_Frame");
        }
        PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
        MarkerTemplate markerTemplate = MarkerTemplateArray.PRESET_SQUARE;
        Dimension dimMarker = this.getTransparentMarkerDimension();
        if (this.m_seriesTypes[s] == nSeriesType) {
            int nYDepth;
            int nXDepth;
            Point ptFrontOffset;
            if (this.m_nDepthRadius > 0 && this.m_nDepthPlanes > 0) {
                double fFrontOffset = this.calcFrontOffset(this.m_seriesPlanes[s], this.m_nDepthPlanes);
                ptFrontOffset = this.m_Frame.getDepthOffset(fFrontOffset);
                double fBackOffset = this.calcBackOffset(this.m_seriesPlanes[s], this.m_nDepthPlanes);
                ptBackOffset = this.m_Frame.getDepthOffset(fBackOffset);
                nXDepth = ptFrontOffset.x - ptBackOffset.x;
                nYDepth = ptFrontOffset.y - ptBackOffset.y;
                nXDepth = 3 * nXDepth;
                nYDepth = 3 * nYDepth;
            } else {
                ptFrontOffset = new Point();
                ptBackOffset = new Point();
                nXDepth = 0;
                nYDepth = 0;
            }
            nYDepth = 0;
            nXDepth = 0;
            gEnum.reset();
            RelativeAxisObj axisObj = this.whichAxisForSeries(s, null);
            int maxCoord = (int)axisObj.getValueCoord(axisObj.getMaxValue());
            int minCoord = (int)axisObj.getValueCoord(axisObj.getMinValue());
            if (axisObj.isDescending()) {
                int temp = minCoord;
                minCoord = maxCoord;
                maxCoord = temp;
            }
            while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                if (!this.m_dataOK[s][g] || !this.m_gt.isPolar() && !this.m_gt.isRadarType() && (this.m_numYCoords[s][g] > maxCoord || this.m_numYCoords[s][g] < minCoord)) continue;
                Point ptCenter = this.getCoords(s, g);
                ptFront.x = ptCenter.x - ptFrontOffset.x;
                ptFront.y = ptCenter.y - ptFrontOffset.y;
                IdentObj identObjLineMarker = new IdentObj(259, s, g);
                identObjLineMarker.setMiscID(0);
                SimpleBlackBoxObj blackBoxTransparent = new SimpleBlackBoxObj(this.m_Perspective, identObjLineMarker, false);
                blackBoxTransparent.setTransparentFillColor(true);
                MarkerObj.createMarker(this.m_Detectiv, identObjLineMarker, markerTemplate, ptFront, dimMarker.width, dimMarker.height, blackBoxTransparent, null, true, true, nXDepth, nYDepth, this.m_nDepthAngle, false);
            }
        }
    }

    protected MinMaxObj findLimits(int axis, int scaling, boolean bMustIncludeZero, MinMaxObj mmZoom) {
        int s;
        double fEndOfPreviousStack = 0.0;
        int nZeroValue = 0;
        MinMaxObj minMaxObj = this.findPreScaledLimits(axis, scaling, bMustIncludeZero);
        if (minMaxObj != null) {
            return minMaxObj;
        }
        minMaxObj = new MinMaxObj(bMustIncludeZero);
        DataFormat df = this.m_Access.getDataFormat();
        int nItems = df.getNumDataItems();
        int[] axisAssignments = new int[this.m_nTotalSeries];
        for (s = 0; s < this.m_nTotalSeries; ++s) {
            axisAssignments[s] = this.getAxisAssignment(s);
        }
        this.setNonDataLimits(minMaxObj);
        if (scaling == 1) {
            for (s = 0; s < this.m_nTotalSeries; ++s) {
                if (this.m_Perspective.getSeriesVisibility(s) == 1 || (axis == 0 || axis == 1 || axis == 2 || axis == 3 || axis == 4) && axisAssignments[s] != axis) continue;
                if (axis == 1) {
                    this.m_dualY = true;
                }
                if (axis == 7) {
                    this.m_XY = true;
                }
                if (this.m_dualY && this.m_XY) {
                    this.m_dualYX = true;
                    this.m_dualY = false;
                    this.m_XY = false;
                }
                for (int g = 0; g < this.m_nTotalGroups; ++g) {
                    for (int i = 0; i < nItems; ++i) {
                        DataItem item = df.getDataItem(i);
                        if (item.ignoreInScaling() || !AxisTemplate.isSameType(item.getAssocAxis(), axis)) continue;
                        DatumObj dObj = this.getDataValue(s, g, item);
                        double fValue = dObj.m_fValue;
                        if (fValue == 0.0 && !dObj.m_bOK) {
                            if (axis == 0) {
                                this.m_nullValY1 = true;
                            } else if (axis == 1) {
                                this.m_nullValY2 = true;
                            } else if (axis == 7) {
                                this.m_nullValX1 = true;
                            }
                        }
                        if (!dObj.m_bOK) continue;
                        if (fValue <= 0.0 && this.isBadValueInLogscale(axis, fValue)) {
                            if (axis == 0) {
                                if (fValue == 0.0 && dObj.m_bOK) {
                                    this.m_zeroValY1 = true;
                                    continue;
                                }
                                if (fValue == 0.0 && !dObj.m_bOK) {
                                    this.m_nullValY1 = true;
                                    continue;
                                }
                                this.m_negativeValY1 = true;
                                continue;
                            }
                            if (axis == 1) {
                                if (fValue == 0.0 && dObj.m_bOK) {
                                    this.m_zeroValY2 = true;
                                    continue;
                                }
                                if (fValue == 0.0 && !dObj.m_bOK) {
                                    this.m_nullValY2 = true;
                                    continue;
                                }
                                this.m_negativeValY2 = true;
                                continue;
                            }
                            if (axis == 7) {
                                if (fValue == 0.0 && dObj.m_bOK) {
                                    this.m_zeroValX1 = true;
                                    continue;
                                }
                                if (fValue == 0.0 && !dObj.m_bOK) {
                                    this.m_nullValX1 = true;
                                    continue;
                                }
                                this.m_negativeValX1 = true;
                                continue;
                            }
                        } else if (axis == 0) {
                            this.m_positiveValY1 = true;
                        } else if (axis == 1) {
                            this.m_positiveValY2 = true;
                        } else if (axis == 7) {
                            this.m_positiveValX1 = true;
                        }
                        if (mmZoom != null && (fValue < mmZoom.getAdjMin() || fValue > mmZoom.getAdjMax())) continue;
                        minMaxObj.testRawValue(fValue);
                    }
                }
            }
        } else if (scaling == 2) {
            SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
            GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
            while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                SumObj sumObj = new SumObj();
                double initialSeriesValue = 0.0;
                sEnum.reset();
                while (sEnum.hasMoreElements()) {
                    s = sEnum.nextSeries();
                    PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                    if (this.m_Perspective.getSeriesVisibility(s) == 1 || (axis == 0 || axis == 1 || axis == 2 || axis == 3 || axis == 4) && axisAssignments[s] != axis) continue;
                    if (axis == 1) {
                        this.m_dualY = true;
                    }
                    if (axis == 7) {
                        this.m_XY = true;
                    }
                    if (this.m_dualY && this.m_XY) {
                        this.m_dualYX = true;
                        this.m_dualY = false;
                        this.m_XY = false;
                    }
                    for (int i = 0; i < nItems; ++i) {
                        boolean bPos;
                        DataItem item = df.getDataItem(i);
                        if (item.ignoreInScaling() || !AxisTemplate.isSameType(item.getAssocAxis(), axis)) continue;
                        DatumObj dObj = this.getDataValue(s, g, item);
                        double fValue = dObj.m_fValue;
                        if (fValue == 0.0 && !dObj.m_bOK) {
                            if (axis == 0) {
                                this.m_nullValY1 = true;
                            } else if (axis == 1) {
                                this.m_nullValY2 = true;
                            } else if (axis == 7) {
                                this.m_nullValX1 = true;
                            }
                        }
                        if (!dObj.m_bOK) continue;
                        if (fValue <= 0.0 && this.isBadValueInLogscale(axis, fValue)) {
                            if (axis == 0) {
                                if (fValue == 0.0 && dObj.m_bOK) {
                                    this.m_zeroValY1 = true;
                                    continue;
                                }
                                if (fValue == 0.0 && !dObj.m_bOK) {
                                    this.m_nullValY1 = true;
                                    continue;
                                }
                                this.m_negativeValY1 = true;
                                continue;
                            }
                            if (axis == 1) {
                                if (fValue == 0.0 && dObj.m_bOK) {
                                    this.m_zeroValY2 = true;
                                    continue;
                                }
                                if (fValue == 0.0 && !dObj.m_bOK) {
                                    this.m_nullValY2 = true;
                                    continue;
                                }
                                this.m_negativeValY2 = true;
                                continue;
                            }
                            if (axis == 7) {
                                if (fValue == 0.0 && dObj.m_bOK) {
                                    this.m_zeroValX1 = true;
                                    continue;
                                }
                                if (fValue == 0.0 && !dObj.m_bOK) {
                                    this.m_nullValX1 = true;
                                    continue;
                                }
                                this.m_negativeValX1 = true;
                                continue;
                            }
                        } else if (axis == 0) {
                            this.m_positiveValY1 = true;
                        } else if (axis == 1) {
                            this.m_positiveValY2 = true;
                        } else if (axis == 7) {
                            this.m_positiveValX1 = true;
                        }
                        boolean bl = bPos = fValue >= 0.0;
                        if (this.m_Perspective.getGraphType() == 95) {
                            if (s == 0) {
                                initialSeriesValue = fValue;
                            } else if (initialSeriesValue > 0.0 && fValue < 0.0 || initialSeriesValue < 0.0 && fValue > 0.0) {
                                initialSeriesValue = fValue += initialSeriesValue;
                            }
                        }
                        boolean bY2 = axis == 1;
                        int nRiser = this.m_seriesTypes[s];
                        if (this.m_Perspective.isMarkerTypeStacked(nRiser)) {
                            double fSum = sumObj.getSum(bPos, bY2, nRiser) + fValue;
                            sumObj.setSum(bPos, bY2, nRiser, fSum);
                            minMaxObj.testRawValue(fSum);
                            continue;
                        }
                        minMaxObj.testRawValue(fValue);
                    }
                }
            }
        } else if (scaling == 5) {
            SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
            GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
            while (gEnum.hasMoreElements()) {
                int g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                SumObj sumObj = new SumObj();
                sEnum.reset();
                while (sEnum.hasMoreElements()) {
                    s = sEnum.nextSeries();
                    PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                    if (this.m_Perspective.getSeriesVisibility(s) == 1 || (axis == 0 || axis == 1 || axis == 2 || axis == 3 || axis == 4) && axisAssignments[s] != axis) continue;
                    for (int i = 0; i < nItems; ++i) {
                        DataItem item = df.getDataItem(i);
                        if (item.ignoreInScaling() || !AxisTemplate.isSameType(item.getAssocAxis(), axis)) continue;
                        DatumObj dObj = this.getDataValue(s, g, item);
                        double fValue = dObj.m_fValue;
                        if (!dObj.m_bOK) continue;
                        if (!sumObj.m_bFirstTime && sumObj.m_bFirstSetIsPositive == fValue < 0.0) {
                            fValue = -fValue;
                        }
                        if (fValue <= 0.0 && this.isBadValueInLogscale(axis, fValue)) continue;
                        boolean bPos = fValue >= 0.0;
                        boolean bY2 = axis == 1;
                        int nRiser = this.m_seriesTypes[s];
                        double fSum = sumObj.getSum(bPos, bY2, nRiser) + fValue;
                        sumObj.setSum(bPos, bY2, nRiser, fSum);
                        minMaxObj.testRawValue(fSum += fEndOfPreviousStack);
                        if (s != sEnum.getLastSeries()) continue;
                        fEndOfPreviousStack = fSum;
                    }
                }
            }
        } else if (scaling == 3) {
            block10: for (s = 0; s < this.m_nTotalSeries; ++s) {
                if (this.m_Perspective.getSeriesVisibility(s) == 1 || (axis == 0 || axis == 1 || axis == 2 || axis == 3 || axis == 4) && axisAssignments[s] != axis) continue;
                for (int g = 0; g < this.m_nTotalGroups; ++g) {
                    for (int i = 0; i < nItems; ++i) {
                        DataItem item = df.getDataItem(i);
                        if (item.ignoreInScaling() || !AxisTemplate.isSameType(item.getAssocAxis(), axis)) continue;
                        DatumObj dObj = this.getDataValue(s, g, item);
                        double fValue = dObj.m_fValue;
                        if (!dObj.m_bOK) continue;
                        if (fValue < 0.0) {
                            this.m_negativeVal = true;
                            break block10;
                        }
                        if (fValue == 0.0 && dObj.m_bOK) {
                            this.m_zeroVal = true;
                            ++nZeroValue;
                        }
                        if (!(fValue > 0.0)) continue;
                        this.m_positiveVal = true;
                    }
                }
            }
            minMaxObj.testRawValue(1.0);
            minMaxObj.testRawValue(0.0);
        } else if (scaling == 4) {
            for (s = 0; s < this.m_nTotalSeries; ++s) {
                if (this.m_Perspective.getSeriesVisibility(s) == 1) continue;
                for (int g = 0; g < this.m_nTotalGroups; ++g) {
                    if (axis == 7) {
                        for (int i = 0; i < nItems; ++i) {
                            DataItem item = df.getDataItem(i);
                            if (item.ignoreInScaling()) continue;
                            DatumObj dObj = this.getDataValue(s, g, item);
                            double fValue = dObj.m_fValue;
                            if (!dObj.m_bOK || fValue <= 0.0 && this.isBadValueInLogscale(axis, fValue)) continue;
                            minMaxObj.testRawValue(fValue);
                        }
                        continue;
                    }
                    throw new AssertionException("FindLimit should not be called for Y1 axis");
                }
            }
        } else {
            throw new AssertionException(1, 5, scaling);
        }
        return minMaxObj;
    }

    public int getBaseCoord(int s) {
        RelativeAxisObj yAxisObj = this.whichAxisForSeries(s, null);
        boolean bFromZero = this.m_Perspective.getScaleFromZero() || yAxisObj.hasNegData() && !this.m_bAbsolute && !this.m_bStacked;
        int baseCoord = bFromZero ? (int)yAxisObj.getValueCoord(0.0) : (int)yAxisObj.getBaseCoord();
        return baseCoord;
    }

    public int getDataCoord(int s, int g, DataItem item, boolean bCumulative) {
        RelativeAxisObj axisObj = this.whichAxisForSeries(s, item);
        double val = this.getDataValue((int)s, (int)g, (DataItem)item).m_fValue;
        if (bCumulative) {
            return this.getDataCoordCum(s, g, item);
        }
        return (int)axisObj.getValueCoord(val);
    }

    public int getDataCoordCum(int s, int g, DataItem item) {
        return this.m_numYCoords[s][g];
    }

    public double getDataFromCoord(int s, int g, int nCoord) {
        RelativeAxisObj yAxisObj = this.whichAxisForSeries(s, DataItem.DI_GENERAL);
        return yAxisObj.getValueFromCoord(nCoord);
    }

    public double getDataFromCoord(int s, int g, DataItem item, int nCoord) {
        RelativeAxisObj axisObj = this.whichAxisForSeries(s, item);
        return axisObj.getValueFromCoord(nCoord);
    }

    @Override
    public DatumObj getDataValue(int s, int g, DataItem item) {
        DatumObj dObj = super.getDataValue(s, g, item);
        double fValue = dObj.m_fValue;
        boolean bOK = dObj.m_bOK;
        if (this.m_gt.isRiserArea() && !this.m_bAbsolute && !this.m_bStacked && fValue < 0.0) {
            dObj = new DatumObj(-fValue, bOK);
        }
        return dObj;
    }

    @Override
    public DatumObj getDataValue(int s, int g) {
        DatumObj dObj = super.getDataValue(s, g);
        double fValue = dObj.m_fValue;
        boolean bOK = dObj.m_bOK;
        if (this.m_gt.isRiserArea() && !this.m_bAbsolute && !this.m_bStacked && fValue < 0.0) {
            dObj = new DatumObj(-fValue, bOK);
        }
        return dObj;
    }

    @Override
    public double getAutoLowerSplitValue(IdentObj id) {
        if (id == null) {
            return Double.NaN;
        }
        if (this.m_X1Axis != null && id.equals(this.m_X1Axis.getAxisIdentObj())) {
            return this.m_X1Axis.getAutoLowerSplitValue();
        }
        if (this.m_Y1Axis != null && id.equals(this.m_Y1Axis.getAxisIdentObj())) {
            return this.m_Y1Axis.getAutoLowerSplitValue();
        }
        if (this.m_Y2Axis != null && id.equals(this.m_Y2Axis.getAxisIdentObj())) {
            return this.m_Y2Axis.getAutoLowerSplitValue();
        }
        return Double.NaN;
    }

    @Override
    public double getAutoHigherSplitValue(IdentObj id) {
        if (id == null) {
            return Double.NaN;
        }
        if (this.m_X1Axis != null && id.equals(this.m_X1Axis.getAxisIdentObj())) {
            return this.m_X1Axis.getAutoHigherSplitValue();
        }
        if (this.m_Y1Axis != null && id.equals(this.m_Y1Axis.getAxisIdentObj())) {
            return this.m_Y1Axis.getAutoHigherSplitValue();
        }
        if (this.m_Y2Axis != null && id.equals(this.m_Y2Axis.getAxisIdentObj())) {
            return this.m_Y2Axis.getAutoHigherSplitValue();
        }
        return Double.NaN;
    }

    public int getMarkerSize(int s, int g) {
        return this.m_Perspective.getMarkerSize(s, g);
    }

    protected MarkerTemplate getMarkerShape(IdentObj idMarkerSeries) {
        return this.m_Perspective.getMarkerTemplate(idMarkerSeries);
    }

    @Override
    public double getQuantizedDataValue(int nSeries, int nGroup, DataItem item) {
        double fValue = this.getDataValue((int)nSeries, (int)nGroup, (DataItem)item).m_fValue;
        boolean bExact = this.m_Perspective.getExactColorByHeight();
        if (!bExact) {
            List dLabels = this.m_Y1Axis.getNumericLabelsAsDouble();
            int nLabels = dLabels.size();
            PfjAssert.pfjAssert(nLabels > 1);
            boolean bFound = false;
            for (int i = 1; i < nLabels && !bFound; ++i) {
                double fCurr;
                double fPrev = (Double)dLabels.get(i - 1);
                double fMid = (fPrev + (fCurr = ((Double)dLabels.get(i)).doubleValue())) / 2.0;
                if (!(fValue < fMid)) continue;
                fValue = fPrev;
                bFound = true;
            }
            if (!bFound) {
                fValue = (Double)dLabels.get(nLabels - 1);
            }
        }
        return fValue;
    }

    public RelativeAxisObj getX1Axis() {
        return this.m_X1Axis;
    }

    public RelativeAxisObj getY1Axis() {
        return this.m_Y1Axis;
    }

    public RelativeAxisObj getY2Axis() {
        return this.m_Y2Axis;
    }

    public RelativeAxisObj getO1Axis() {
        return this.m_O1Axis;
    }

    @Override
    public void init(Perspective perspective) {
        super.init(perspective);
        this.m_O1Axis = null;
        this.m_X1Axis = null;
        this.m_Y1Axis = null;
        this.m_Y2Axis = null;
        this.m_Z1Axis = null;
    }

    protected boolean isAxisAscending(int nSeries) {
        RelativeAxisObj axis = this.whichAxisForSeries(nSeries, DataItem.DI_GENERAL);
        return axis.isAscending();
    }

    public boolean isComboWithBar() {
        boolean bIsCombo = false;
        SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        while (sEnum.hasMoreElements() && !bIsCombo) {
            int s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            if (this.m_seriesTypes[s] == 1) {
                bIsCombo = true;
            }
            if (this.m_seriesTypes[s] != 2 || this.m_Perspective.getLineType(this.m_Perspective.getSeries(s)) != 3) continue;
            bIsCombo = true;
        }
        return bIsCombo;
    }

    public boolean isComboWithNonBar() {
        boolean bIsCombo = false;
        if (this.m_Perspective.getGraphType() == 96) {
            return false;
        }
        SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        while (sEnum.hasMoreElements() && !bIsCombo) {
            int s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            if (this.m_seriesTypes[s] == 1) continue;
            bIsCombo = true;
        }
        return bIsCombo;
    }

    public boolean isZoomingArmed() {
        boolean bEnabled = this.m_Perspective.getZoomList().isCurrentlyZoomed();
        return bEnabled;
    }

    protected int prevSeriesForAxis(int sCurrent, int axisCurrent) {
        SeriesEnumerator sEnum = this.m_sEnumReverseForPrev;
        int nPrevSeries = -2;
        sEnum.reset();
        while (sEnum.hasMoreElements()) {
            int axis;
            int s = sEnum.nextSeries();
            if (s >= sCurrent || (axis = this.getAxisAssignment(s)) != axisCurrent) continue;
            nPrevSeries = s;
            break;
        }
        return nPrevSeries;
    }

    protected int prevSeriesForAxis(int sCurrent, int gCurrent, int axisCurrent, boolean bNegCurrent) {
        SeriesEnumerator sEnum = this.m_sEnumReverseForPrev;
        int nPrevSeries = -2;
        int nRiserCurrent = this.m_seriesTypes[sCurrent];
        sEnum.reset();
        while (sEnum.hasMoreElements()) {
            int nRiserType;
            boolean bNegPrev;
            int axis;
            int s = sEnum.nextSeries();
            if (s >= sCurrent || (axis = this.getAxisAssignment(s)) != axisCurrent || !this.m_dataOK[s][gCurrent]) continue;
            int zeroCoord = (int)(switch (axis) {
                case 7 -> this.m_X1Axis;
                case 0 -> this.m_Y1Axis;
                case 1 -> this.m_Y2Axis;
                case 2 -> this.m_Y3Axis;
                case 3 -> this.m_Y4Axis;
                case 4 -> this.m_Y5Axis;
                case 8 -> this.m_Z1Axis;
                default -> throw new AssertionException("Invalid axis = " + axis);
            }).getValueCoord(0.0);
            if (this.m_Perspective.isAxisFlipped() && this.m_bHorz) {
                bNegPrev = this.m_numYCoords[s][gCurrent] > zeroCoord;
            } else {
                boolean bl = bNegPrev = this.m_numYCoords[s][gCurrent] < zeroCoord;
            }
            if (!bNegPrev && this.getDataValue((int)s, (int)gCurrent, (DataItem)DataItem.DI_GENERAL).m_fValue < 0.0) {
                bNegPrev = true;
            }
            if (bNegPrev != bNegCurrent || (nRiserType = this.m_seriesTypes[s]) != nRiserCurrent) continue;
            nPrevSeries = s;
            break;
        }
        return nPrevSeries;
    }

    protected int prevSeriesForAxis(int sCurrent, int gCurrent, RelativeAxisObj axisObjDesired, boolean bNegValue) {
        return this.prevSeriesForAxis(sCurrent, gCurrent, axisObjDesired.getAxisObjID(), bNegValue);
    }

    protected int prevSeriesForAxis(int sCurrent, RelativeAxisObj axisObjDesired) {
        return this.prevSeriesForAxis(sCurrent, axisObjDesired.getAxisObjID());
    }

    protected double processOneStackedValue(int s, int g, RelativeAxisObj yAxisObj, double fValue, SumObj sumObj) {
        int nRiser;
        boolean bY2;
        boolean bPos = fValue >= 0.0;
        double fNewSum = sumObj.getSum(bPos, bY2 = yAxisObj == this.m_Y2Axis, nRiser = this.m_seriesTypes[s]) + fValue;
        if (this.isIgnoredOffScale(yAxisObj, fNewSum)) {
            this.m_dataOK[s][g] = false;
        } else if (this.m_gt.isWaterfall() && nRiser != 1 || !this.m_gt.isWaterfall() && !this.m_Perspective.isMarkerTypeStacked(nRiser)) {
            this.m_numYCoords[s][g] = (int)yAxisObj.getValueCoord(fValue);
        } else {
            sumObj.setSum(bPos, bY2, nRiser, fNewSum);
            if (this.m_gt.isWaterfall() && s == 0) {
                sumObj.setSum(!bPos, bY2, nRiser, fNewSum);
            }
            this.m_numYCoords[s][g] = (int)yAxisObj.getValueCoord(fNewSum);
        }
        return fNewSum;
    }

    @Override
    public void releaseReferences() {
        if (this.m_O1Axis != null) {
            this.m_O1Axis.releaseReferences();
        }
        if (this.m_X1Axis != null) {
            this.m_X1Axis.releaseReferences();
        }
        if (this.m_Y1Axis != null) {
            this.m_Y1Axis.releaseReferences();
        }
        if (this.m_Y2Axis != null) {
            this.m_Y2Axis.releaseReferences();
        }
        if (this.m_Z1Axis != null) {
            this.m_Z1Axis.releaseReferences();
        }
        super.releaseReferences();
    }

    public boolean seriesAssignedToBothAxes() {
        boolean bAssignedToY1 = false;
        boolean bAssignedToOtherY = false;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            int seriesType = this.m_Perspective.getSeriesType(s);
            if ((!this.m_gt.isRiserBar() || seriesType != 0) && seriesType != 1) continue;
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            int assignedAxis = this.getAxisAssignment(s);
            if (!(bAssignedToY1 |= assignedAxis == 0) || !(bAssignedToOtherY |= assignedAxis != 0)) continue;
            break;
        }
        return bAssignedToY1 && bAssignedToOtherY;
    }

    public void setNonDataLimits(MinMaxObj mm) {
    }

    protected RelativeAxisObj whichAxisForSeries(int s, DataItem item) {
        int axis = this.axisAssignedToSeries(s, item);
        return switch (axis) {
            case 7 -> {
                if (this.m_Perspective.isContinuousTimeAxis() && (this.m_gt.isBLAType() || this.m_gt.isScatter() || this.m_gt.isBubble())) {
                    yield this.m_O1Axis;
                }
                yield this.m_X1Axis;
            }
            case 0 -> this.m_Y1Axis;
            case 1 -> this.m_Y2Axis;
            case 2 -> this.m_Y3Axis;
            case 3 -> this.m_Y4Axis;
            case 4 -> this.m_Y5Axis;
            case 8 -> this.m_Z1Axis;
            default -> null;
        };
    }

    public int axisAssignedToSeries(int s, DataItem item) {
        int nAxis;
        if (this.m_gt.isMultiY()) {
            nAxis = this.getAxisAssignment(s);
        } else {
            nAxis = item == null ? 0 : item.getAssocAxis();
            if (nAxis == 0) {
                nAxis = this.getAxisAssignment(s);
            }
        }
        return nAxis;
    }

    protected int whichOrdType() {
        int nOrdType = 1;
        if (this.m_bExtendToFrameEdge && !this.m_bIsThisAComboWithBar) {
            nOrdType = 6;
        } else if (this.m_gt.isRiserBar()) {
            if (this.m_bAbsolute) {
                nOrdType = 0;
            } else if (this.m_bStacked && this.m_gt.isDualY() && !this.m_gt.isBipolar() && this.seriesAssignedToBothAxes()) {
                nOrdType = 3;
            }
        } else if (this.m_gt.isRiserArea() || this.m_gt.isRiserMarker()) {
            nOrdType = 2;
        } else if (this.m_gt.isParetoType()) {
            nOrdType = 10;
        }
        return nOrdType;
    }

    String ReplaceMacro(String SourceString, String aMacro, String Replacement) {
        int aPosition;
        Object aProcessedString = "";
        aProcessedString = SourceString;
        while ((aPosition = ((String)aProcessedString).indexOf(aMacro)) != -1) {
            Object testString = ((String)aProcessedString).substring(0, aPosition);
            testString = (String)testString + Replacement;
            aProcessedString = testString = (String)testString + ((String)aProcessedString).substring(aPosition += aMacro.length(), ((String)aProcessedString).length());
        }
        return aProcessedString;
    }

    protected abstract Point getCoords(int var1, int var2);

    protected abstract String processDataTextTemplate(String[] var1, String var2);

    protected double calcxPosition(Point startPt, Point endPt, double currentY) {
        double dx2 = endPt.x;
        double dx1 = startPt.x;
        double dy1 = startPt.y;
        double dy2 = endPt.y;
        double a1 = (dy1 - dy2) / (dx1 - dx2);
        double a0 = dy1 - dx1 * a1;
        double x11 = (currentY - a0) / a1;
        return x11;
    }

    protected double calcyPosition(Point startPt, Point endPt, double currentX) {
        double dx2 = endPt.x;
        double dx1 = startPt.x;
        double dy1 = startPt.y;
        double dy2 = endPt.y;
        double a1 = (dy1 - dy2) / (dx1 - dx2);
        double a0 = dy1 - dx1 * a1;
        double y11 = a1 * currentX + a0;
        return y11;
    }

    protected Point checkEndPointVertical(Point p, int s, int g, Point cPt) {
        Point pt2 = new Point();
        if (p.x != cPt.x) {
            pt2.y = cPt.y;
            pt2.x = p.x;
            return pt2;
        }
        return cPt;
    }

    protected Point checkStartPointHorizontal(Point p, int s, int g, Point cPt) {
        Point pt2 = new Point();
        if (p.y != cPt.y) {
            pt2.y = p.y;
            pt2.x = cPt.x;
            return pt2;
        }
        return cPt;
    }

    protected Point checkStartPointVertical(Point p, int s, int g, Point cPt) {
        Point pt2 = new Point();
        if (p.x != cPt.x) {
            pt2.y = cPt.y;
            pt2.x = p.x;
            return pt2;
        }
        return cPt;
    }

    protected Point checkEndPointHorizontal(Point p, int s, int g, Point cPt) {
        Point pt2 = new Point();
        if (p.y != cPt.y) {
            pt2.y = p.y;
            pt2.x = cPt.x;
            return pt2;
        }
        return cPt;
    }

    public void createRangeSlider() {
        Rectangle horzSliderRect = null;
        Rectangle vertSliderRect = null;
        Rectangle y2SliderRect = null;
        Rectangle frameRect = this.m_Perspective.getFrameRect(false);
        if (!this.m_Perspective.isChartOrientHorz()) {
            frameRect.height -= this.m_Perspective.getVC().destToVirtHeight(1);
        }
        RangeSlider horzRS = this.m_Perspective.getHorzPosRS();
        RangeSlider vertRS = this.m_Perspective.getVertPosRS();
        RangeSlider y2RangeSlider = this.m_Perspective.getY2RangeSlider();
        if (horzRS != null) {
            horzSliderRect = horzRS.getRect();
            horzSliderRect.x = frameRect.x;
            horzSliderRect.width = frameRect.width;
            horzRS.calc();
            if (horzRS.isRendered()) {
                DetMetadata.newRangeSliderMetadata(this.m_Detectiv, horzRS);
            }
        }
        if (vertRS != null) {
            vertSliderRect = vertRS.getRect();
            vertSliderRect.y = frameRect.y;
            vertSliderRect.height = frameRect.height;
            vertRS.calc();
            if (vertRS.isRendered()) {
                DetMetadata.newRangeSliderMetadata(this.m_Detectiv, vertRS);
            }
        }
        if (y2RangeSlider != null) {
            y2SliderRect = this.m_Perspective.getY2RangeSlider().getRect();
            if (!this.m_Perspective.isChartOrientHorz()) {
                y2SliderRect.y = frameRect.y;
                y2SliderRect.height = frameRect.height;
            } else {
                y2SliderRect.x = frameRect.x;
                y2SliderRect.width = frameRect.width;
            }
            y2RangeSlider.calc();
            if (y2RangeSlider.isRendered()) {
                DetMetadata.newRangeSliderMetadata(this.m_Detectiv, this.m_Perspective.getY2RangeSlider());
            }
        }
        if (horzRS != null || vertRS != null || y2RangeSlider != null) {
            int buttonWidth = this.m_Perspective.getVC().destToVirtWidth(21);
            int buttonHeight = this.m_Perspective.getVC().destToVirtHeight(15);
            int buttonX = 0;
            int buttonY = 0;
            boolean bZoomButton = false;
            boolean bHorzRS = false;
            boolean bVertRS = false;
            boolean bY2RS = false;
            if (horzRS != null) {
                boolean bl = bHorzRS = horzRS.isVisible() || horzRS.isReserved();
            }
            if (vertRS != null) {
                boolean bl = bVertRS = vertRS.isVisible() || vertRS.isReserved();
            }
            if (y2RangeSlider != null) {
                boolean bl = bY2RS = y2RangeSlider.isVisible() || y2RangeSlider.isReserved();
            }
            if (bHorzRS || bVertRS || bY2RS) {
                if (bHorzRS && bVertRS || bY2RS) {
                    buttonY = horzSliderRect.y;
                    buttonX = vertSliderRect.x;
                } else if (bHorzRS) {
                    buttonY = horzSliderRect.y;
                    buttonX = this.m_Perspective.isAxisFlipped() ? horzSliderRect.x + horzSliderRect.width + this.m_Perspective.getVC().destToVirtWidth(4) : horzSliderRect.x - buttonWidth - this.m_Perspective.getVC().destToVirtWidth(4);
                } else if (bVertRS) {
                    buttonY = vertSliderRect.y - buttonHeight - this.m_Perspective.getVC().destToVirtHeight(4);
                    buttonX = vertSliderRect.x;
                }
                bZoomButton = true;
            }
            if (bZoomButton && this.m_Perspective.getZoomButtonPresence() != 1) {
                DetMetadata.newRangeSliderZoomButtonMetadata(this.m_Perspective.getDetectiv(), new Rectangle(buttonX, buttonY, buttonWidth, buttonHeight));
            }
            if (horzRS != null && horzRS.getID() == 2000) {
                this.m_Perspective.setHorzPosRS(null);
            }
            if (vertRS != null && vertRS.getID() == 2000) {
                this.m_Perspective.setVertPosRS(null);
            }
        }
    }

    protected void setMinValueGroupIndex(int group) {
        this.m_minValueGroupIndex = group;
    }

    protected void setMaxValueGroupIndex(int group) {
        this.m_maxValueGroupIndex = group;
    }

    boolean isSparkchart() {
        return this.m_Perspective.getFormFactor() == GraphConstants.FormFactor.SPARKCHART;
    }

    BlackBoxIF checkForMarkerColorOverride(int g, BlackBoxIF blackBox) {
        Color override = null;
        if (g == this.m_minValueGroupIndex && this.isSparkchart()) {
            enumSet = this.m_Perspective.getDefaultMarkers();
            if (enumSet.contains((Object)GraphConstants.Markers.LOW)) {
                override = this.m_Perspective.getDefaultMarkerColor(GraphConstants.Markers.LOW, true);
            } else if (enumSet.contains((Object)GraphConstants.Markers.AUTO)) {
                override = this.m_Perspective.getDefaultMarkerColor(GraphConstants.Markers.LOW, false);
            }
        } else if (g == this.m_maxValueGroupIndex && this.isSparkchart()) {
            enumSet = this.m_Perspective.getDefaultMarkers();
            if (enumSet.contains((Object)GraphConstants.Markers.HIGH)) {
                override = this.m_Perspective.getDefaultMarkerColor(GraphConstants.Markers.HIGH, true);
            } else if (enumSet.contains((Object)GraphConstants.Markers.AUTO)) {
                override = this.m_Perspective.getDefaultMarkerColor(GraphConstants.Markers.HIGH, false);
            }
        } else if (g == 0 && this.isSparkchart()) {
            enumSet = this.m_Perspective.getDefaultMarkers();
            if (enumSet.contains((Object)GraphConstants.Markers.FIRST)) {
                override = this.m_Perspective.getDefaultMarkerColor(GraphConstants.Markers.FIRST, true);
            } else if (enumSet.contains((Object)GraphConstants.Markers.AUTO)) {
                override = this.m_Perspective.getDefaultMarkerColor(GraphConstants.Markers.FIRST, false);
            }
        } else if (g == this.m_Perspective.getNumTotalGroups() - 1 && this.isSparkchart()) {
            enumSet = this.m_Perspective.getDefaultMarkers();
            if (enumSet.contains((Object)GraphConstants.Markers.LAST)) {
                override = this.m_Perspective.getDefaultMarkerColor(GraphConstants.Markers.LAST, true);
            } else if (enumSet.contains((Object)GraphConstants.Markers.AUTO)) {
                override = this.m_Perspective.getDefaultMarkerColor(GraphConstants.Markers.LAST, false);
            }
        }
        if (override != null) {
            BlackBoxIF blackBoxNew = null;
            if (blackBox instanceof BlackBoxObj) {
                blackBoxNew = new BlackBoxObj((BlackBoxObj)blackBox);
            } else if (blackBox instanceof SimpleBlackBoxObj) {
                blackBoxNew = new SimpleBlackBoxObj(this.m_Perspective);
                ((SimpleBlackBoxObj)blackBoxNew).copy((SimpleBlackBoxObj)blackBox);
            }
            if (blackBoxNew != null) {
                blackBoxNew.setFillColor(override);
                return blackBoxNew;
            }
        }
        return blackBox;
    }

    class SumObj {
        double[] m_sumPosY1 = new double[3];
        double[] m_sumPosY2 = new double[3];
        double[] m_sumNegY1 = new double[3];
        double[] m_sumNegY2 = new double[3];
        boolean m_bFirstSetIsPositive;
        boolean m_bFirstTime = true;

        public double getSum(boolean bPositive, boolean bY2, int nRiserType) {
            int i = switch (nRiserType) {
                case 2 -> 1;
                case 3 -> 2;
                default -> 0;
            };
            if (bPositive) {
                if (bY2) {
                    return this.m_sumPosY2[i];
                }
                return this.m_sumPosY1[i];
            }
            if (bY2) {
                return this.m_sumNegY2[i];
            }
            return this.m_sumNegY1[i];
        }

        public void setSum(boolean bPositive, boolean bY2, int nRiserType, double newValue) {
            switch (nRiserType) {
                case 2: {
                    int i = 1;
                    break;
                }
                case 3: {
                    int i = 2;
                    break;
                }
                default: {
                    int i = 0;
                }
            }
            if (bPositive) {
                if (bY2) {
                    this.m_sumPosY2[i] = newValue;
                } else {
                    this.m_sumPosY1[i] = newValue;
                }
            } else if (bY2) {
                this.m_sumNegY2[i] = newValue;
            } else {
                this.m_sumNegY1[i] = newValue;
            }
            if (this.m_bFirstTime) {
                this.m_bFirstSetIsPositive = bPositive;
                this.m_bFirstTime = false;
            }
        }
    }

    class LineDesc {
        protected Point m_pt;
        protected int m_nSeries = 0;
        protected int m_nGroup = 0;

        LineDesc() {
        }

        public void LineDesc() {
            this.m_pt = null;
            this.m_nSeries = 0;
            this.m_nGroup = 0;
        }

        public void LineDesc(Point a, int s, int g) {
            this.m_pt = a;
            this.m_nSeries = s;
            this.m_nGroup = g;
        }

        public void setLineDesc(Point a, int s, int g) {
            this.m_pt = a;
            this.m_nSeries = s;
            this.m_nGroup = g;
        }

        public int getGroup() {
            return this.m_nGroup;
        }

        public int getSeries() {
            return this.m_nSeries;
        }

        public Point getPt() {
            return this.m_pt;
        }
    }
}

