/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import java.util.Enumeration;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.Line;
import oracle.dss.graph.Visible;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.util.xml.BaseNode;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.annotations.Concealed;

public class QuadrantLine
extends BaseGraphComponent
implements Line,
Visible {
    @Concealed
    protected boolean visible;
    @Concealed
    protected int lineColor;
    @Concealed
    protected int lineWidth;
    @Concealed
    protected int quadrantLineCountX;
    @Concealed
    protected int quadrantLineCountY;
    @Concealed
    protected double quadrantLineValueX;
    @Concealed
    protected double quadrantLineValueY;

    @Concealed
    public QuadrantLine(CommonGraph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getQuadrantLine();
    }

    @Override
    public boolean selectObject(int series, int group) {
        this.m_pfj.setSelection(this.m_identObj);
        return this.m_identObj.equals(this.m_pfj.getSelectionID());
    }

    @Override
    public Color getLineColor() {
        return this.m_pfj.getBorderColor(this.m_identObj);
    }

    @Override
    public void setLineColor(Color newColor) {
        if (newColor == null) {
            this.m_commonGraph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setLineColor( Color newColor )");
            return;
        }
        this.m_pfj.setBorderColor(this.m_identObj, newColor);
    }

    @Override
    public int getLineWidth() {
        return this.m_pfj.getLineWidth(this.m_identObj);
    }

    @Override
    public void setLineWidth(int width) {
        if (width < 0) {
            this.m_commonGraph.getErrorHandler().log("invalid line width", this.getClass().getName(), "setLineWidth (int width)");
        } else {
            this.m_pfj.setLineWidth(this.m_identObj, width);
        }
    }

    public int getQuadrantLineCountX() {
        return this.m_pfj.getQuadrantLineCountX();
    }

    public void setQuadrantLineCountX(int count) {
        if (count < 1 || count > 10) {
            this.m_commonGraph.getErrorHandler().log("invalid count of quadrant lines", this.getClass().getName(), "setQuadrantLineCountX (int count)");
        } else {
            this.m_pfj.setQuadrantLineCountX(count);
        }
    }

    public int getQuadrantLineCountY() {
        return this.m_pfj.getQuadrantLineCountY();
    }

    public void setQuadrantLineCountY(int count) {
        if (count < 1 || count > 10) {
            this.m_commonGraph.getErrorHandler().log("invalid count of quadrant lines", this.getClass().getName(), "setQuadrantLineCountY (int count)");
        } else {
            this.m_pfj.setQuadrantLineCountY(count);
        }
    }

    public double getQuadrantLineValueX(int whichLine) {
        return this.m_pfj.getQuadrantLineValueX(whichLine);
    }

    public void setQuadrantLineValueX(int whichLine, double position) {
        if (whichLine < 0 || whichLine >= 10) {
            this.m_commonGraph.getErrorHandler().log("invalid quadrant line", this.getClass().getName(), "setQuadrantLineValueX (int count, position)");
        } else {
            this.m_pfj.setQuadrantLineValueX(whichLine, position);
        }
    }

    public double getQuadrantLineValueY(int whichLine) {
        return this.m_pfj.getQuadrantLineValueY(whichLine);
    }

    public void setQuadrantLineValueY(int whichLine, double position) {
        if (whichLine < 0 || whichLine >= 10) {
            this.m_commonGraph.getErrorHandler().log("invalid quadrant line", this.getClass().getName(), "setQuadrantLineValueY (int count, position)");
        } else {
            this.m_pfj.setQuadrantLineValueY(whichLine, position);
        }
    }

    @Override
    public boolean isVisible() {
        return this.m_pfj.getDisplay(this.m_identObj);
    }

    @Override
    public void setVisible(boolean visible) {
        this.m_pfj.setDisplay(this.m_identObj, visible);
    }

    @Override
    @Concealed
    protected String getComponentName() {
        return "QuadrantLine";
    }

    @Concealed
    protected boolean getXML(boolean allProperties, ObjectNode parent) {
        ContainerNode node = new ContainerNode(this.getComponentName());
        boolean nodeExists = this.getStyleXML(allProperties, node);
        if (nodeExists) {
            parent.addContainer(node);
        }
        return nodeExists;
    }

    @Concealed
    protected boolean getStyleXML(boolean allProperties, ContainerNode node) {
        ObjectNode subNode;
        boolean subNodeExit;
        int i;
        boolean nodeExists = false;
        Object val = this.getLineColor();
        if (val != null) {
            node.addProperty("lineColor", BaseGraphComponent.toHexString(((Color)val).getRGB()));
            nodeExists = true;
        }
        if ((val = this.m_pfj.getLineWidthObj(this.m_identObj)) != null) {
            node.addProperty("lineWidth", ((Integer)val).intValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.QuadrantLineCountX)) != null) {
            node.addProperty("quadrantLineCountX", ((Integer)val).intValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getObjProp(Attr.QuadrantLineCountY)) != null) {
            node.addProperty("quadrantLineCountY", ((Integer)val).intValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getDisplayObj(this.m_identObj)) != null) {
            node.addProperty("visible", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        for (i = 0; i < this.getQuadrantLineCountX(); ++i) {
            subNodeExit = false;
            subNode = new ObjectNode("QuadrantLineValueX");
            subNode.addProperty("lineIndex", i);
            val = this.m_pfj.getQuadrantLineValueXObj(i);
            if (val != null) {
                subNode.addProperty("position", ((Double)val).doubleValue());
                subNodeExit = true;
            }
            if (!subNodeExit) continue;
            node.addContainedObject((BaseNode)subNode);
            nodeExists = true;
        }
        for (i = 0; i < this.getQuadrantLineCountY(); ++i) {
            subNodeExit = false;
            subNode = new ObjectNode("QuadrantLineValueY");
            subNode.addProperty("lineIndex", i);
            val = this.m_pfj.getQuadrantLineValueYObj(i);
            if (val != null) {
                subNode.addProperty("position", ((Double)val).doubleValue());
                subNodeExit = true;
            }
            if (!subNodeExit) continue;
            node.addContainedObject((BaseNode)subNode);
            nodeExists = true;
        }
        return nodeExists;
    }

    @Concealed
    protected void setXML(ContainerNode node) {
        this.setStyleXML(node);
    }

    @Concealed
    protected void setStyleXML(ContainerNode node) {
        int lineIndex;
        PropertyNode sNode;
        PropertyNode pNode = node.getProperty("lineColor");
        if (pNode != null) {
            this.setLineColor(new Color(BaseGraphComponent.hexStringToInt(pNode.getValueAsString()), true));
        }
        if ((pNode = node.getProperty("lineWidth")) != null) {
            this.setLineWidth(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty("quadrantLineCountX")) != null) {
            this.setQuadrantLineCountX(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty("quadrantLineCountY")) != null) {
            this.setQuadrantLineCountY(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty("visible")) != null) {
            this.setVisible(pNode.getValueAsBoolean());
        }
        Enumeration e = node.getContainedObject("QuadrantLineValueX");
        while (e.hasMoreElements()) {
            ObjectNode quadrantLineValueXNode = (ObjectNode)e.nextElement();
            sNode = quadrantLineValueXNode.getProperty("lineIndex");
            if (sNode == null) continue;
            lineIndex = sNode.getValueAsInteger();
            pNode = quadrantLineValueXNode.getProperty("position");
            if (pNode == null) continue;
            this.setQuadrantLineValueX(lineIndex, pNode.getValueAsDouble());
        }
        e = node.getContainedObject("QuadrantLineValueY");
        while (e.hasMoreElements()) {
            ObjectNode quadrantLineValueYNode = (ObjectNode)e.nextElement();
            sNode = quadrantLineValueYNode.getProperty("lineIndex");
            if (sNode == null) continue;
            lineIndex = sNode.getValueAsInteger();
            pNode = quadrantLineValueYNode.getProperty("position");
            if (pNode == null) continue;
            this.setQuadrantLineValueY(lineIndex, pNode.getValueAsDouble());
        }
    }

    @Concealed
    protected void resetStyle() {
        int i;
        this.setLineColor(Color.black);
        this.setLineWidth(1);
        this.setQuadrantLineCountX(1);
        this.setQuadrantLineCountY(1);
        this.setVisible(false);
        for (i = 0; i < this.getQuadrantLineCountX(); ++i) {
            this.setQuadrantLineValueX(i, 0.0);
        }
        for (i = 0; i < this.getQuadrantLineCountY(); ++i) {
            this.setQuadrantLineValueY(i, 0.0);
        }
    }
}

