/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import java.util.HashMap;
import oracle.dss.dataView.Background;
import oracle.dss.dataView.Fill;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.SFX;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.javatools.annotations.Concealed;

public class GraphBackground
extends BaseGraphComponent
implements Fill,
Background {
    @Concealed
    protected SFX m_sfx;

    @Concealed
    public GraphBackground(CommonGraph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getChartBackground();
    }

    public SFX getSFX() {
        if (this.m_sfx == null) {
            this.m_sfx = new SFX(this.m_commonGraph, this.m_identObj);
        }
        return this.m_sfx;
    }

    @Override
    public boolean selectObject(int series, int group) {
        this.m_pfj.setSelection(this.m_identObj);
        return this.m_identObj.equals(this.m_pfj.getSelectionID());
    }

    @Override
    public Color getFillColor() {
        return this.m_pfj.getFillColor(this.m_identObj);
    }

    @Override
    public void setFillColor(Color newColor) {
        if (newColor == null) {
            this.m_commonGraph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setFillColor( Color newColor)");
            return;
        }
        this.m_pfj.setFillColor(this.m_identObj, newColor);
    }

    @Override
    public boolean isFillTransparent() {
        return this.m_pfj.getTransparentFillColor(this.m_identObj);
    }

    @Override
    public void setFillTransparent(boolean yesNo) {
        this.m_commonGraph.setBackgroundTransparent(yesNo);
        this.m_pfj.setTransparentFillColor(this.m_identObj, yesNo);
    }

    @Override
    public void setBackground(Color background) {
        this.setFillColor(background);
    }

    @Override
    public Color getBackground() {
        return this.getFillColor();
    }

    @Override
    @Concealed
    protected String getComponentName() {
        return "Background";
    }

    @Concealed
    protected ObjectNode getXML(boolean allProperties, boolean allOverriddenProperties) {
        ContainerNode sfxNode;
        ObjectNode node = new ObjectNode(this.getComponentName());
        boolean nodeExists = false;
        Object val = this.getFillColor();
        if (val != null) {
            node.addProperty("fillColor", GraphBackground.toHexString(((Color)val).getRGB()));
            nodeExists = true;
        }
        if ((val = this.m_pfj.getTransparentFillColorObj(this.m_identObj)) != null) {
            node.addProperty("fillTransparent", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        if ((sfxNode = this.getSFX().getXML(allProperties, allOverriddenProperties)) != null) {
            node.addContainer(sfxNode);
            nodeExists = true;
        }
        return nodeExists ? node : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Concealed
    protected void setXML(ObjectNode node, boolean allProperties, HashMap map) {
        this.m_jsfHashMap = map;
        try {
            this.setXML(node, allProperties);
        }
        finally {
            this.m_jsfHashMap = null;
        }
    }

    @Concealed
    protected void setXML(ObjectNode node, boolean allProperties) {
        ContainerNode sfx;
        PropertyNode pNode = node.getProperty("fillColor");
        if (pNode != null) {
            Color c = new Color(BaseGraphComponent.hexStringToInt(pNode.getValueAsString()), true);
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("fillColor", c);
            } else {
                this.setFillColor(c);
            }
        }
        if ((sfx = node.getContainer("SFX")) != null) {
            this.getSFX().setXML(sfx, allProperties);
        }
        if ((pNode = node.getProperty("fillTransparent")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("fillTransparent", pNode.getValueAsBoolean());
            } else {
                this.setFillTransparent(pNode.getValueAsBoolean());
            }
        }
        if (allProperties && (pNode = node.getProperty("backGround")) != null) {
            Color c = new Color(BaseGraphComponent.hexStringToInt(pNode.getValueAsString()), true);
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("fillColor", c);
            } else {
                this.setBackground(c);
            }
        }
    }

    @Concealed
    protected void resetStyle() {
        this.m_pfj.setFillColor(this.m_identObj, Color.black);
        this.m_pfj.setTransparentFillColor(this.m_identObj, false);
        if (this.m_sfx != null) {
            this.getSFX().resetStyle();
        }
    }
}

