/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dss.gauge.CommonGauge;
import oracle.dss.gauge.CustomShape;
import oracle.dss.gauge.DrawableObject;
import oracle.dss.gauge.GaugeDefaultValues;
import oracle.dss.gauge.GaugeEngine;
import oracle.dss.gauge.GaugeType;
import oracle.dss.gauge.KPIStyleCallback;
import oracle.dss.gauge.LEDStyleCallback;
import oracle.dss.util.graphics.ImageUtils;
import oracle.javatools.annotations.Concealed;
import oracle.javatools.mt.annotation.CodeSharingSafe;

@Concealed
public class LEDGauge
extends GaugeType {
    @CodeSharingSafe(value="StaticField")
    private static HashMap _ledImgs = null;
    private static final double HEIGHT_FULL_LED_GAUGE = 0.75;
    private HashMap DOT_VISUAL_SFX = null;
    private HashMap DOT_SPECULAR_SFX = null;
    private HashMap RECTANGLE_SFX = null;
    private Shape ARROW_LED_SHAPE = null;
    private Shape ARROW_INNER_SHAPE = null;
    private HashMap ARROW_UP_SFX = null;
    private HashMap ARROW_DOWN_SFX = null;
    private HashMap ARROW_RIGHT_SFX = null;
    private HashMap ARROW_OTHER_SFX = null;
    private Shape TRIANGLE_LED_SHAPE = null;
    private Shape TRIANGLE_INNER_SHAPE = null;
    private HashMap TRIANGLE_SFX = null;
    private Shape SQUARE_LED_SHAPE = null;
    private Shape SQUARE_INNER_SHAPE = null;
    private HashMap SQUARE_SFX = null;
    private static final double BOUNDARY_PERCENTAGE = 0.065;
    private static final Color SFX_C0 = new Color(1.0f, 1.0f, 1.0f, 0.0f);
    private static final Color SFX_C1 = new Color(1.0f, 1.0f, 1.0f, 0.25f);
    private static final Color SFX_C2 = new Color(1.0f, 1.0f, 1.0f, 0.5f);
    private static final Color SFX_C3 = new Color(1.0f, 1.0f, 1.0f, 0.75f);
    private static final Color SFX_C4 = new Color(1.0f, 1.0f, 1.0f, 1.0f);

    public LEDGauge(GaugeEngine engine) {
        super(engine);
    }

    @Override
    public int getGaugeType() {
        return 2;
    }

    @Override
    protected Dimension autoLayout(Graphics2D g, Rectangle rect, Map map) {
        Dimension dim = super.autoLayout(g, rect, map);
        if (this._csParser == null || !this._csParser.defines("plotAreaBounds") && !this._csParser.defines("gaugeFrame")) {
            int metLblPos;
            if (this.isSpaceLimited(dim, rect)) {
                this._layout.setScalingUsed(true);
                dim = super.autoLayout(g, rect, map);
            }
            int labelsRemoved = 0;
            if (this.isSpaceLimited(dim, rect)) {
                int topLblPos = this.getTopLabelPosition(map);
                if (topLblPos == 3 && (this._csParser == null || !this._csParser.defines("topLabelBounds") && !this._csParser.defines("upperLabelFrame"))) {
                    map.put("TopLabelPosition", 0);
                    dim = super.autoLayout(g, rect, map);
                }
                ++labelsRemoved;
            }
            if (this.isSpaceLimited(dim, rect)) {
                int bottomLblPos = this.getBottomLabelPosition(map);
                if (bottomLblPos == 1 && (this._csParser == null || !this._csParser.defines("bottomLabelBounds") && !this._csParser.defines("lowerLabelFrame"))) {
                    map.put("BottomLabelPosition", 0);
                    dim = super.autoLayout(g, rect, map);
                }
                ++labelsRemoved;
            }
            if (this.isSpaceLimited(dim, rect) && (metLblPos = this.getMetricLabelPosition(map)) == 1 && (this._csParser == null || !this._csParser.defines("metricLabelBounds") && !this._csParser.defines("lowerLabelFrame"))) {
                map.put("MetricLabelPosition", 0);
                dim = super.autoLayout(g, rect, map);
            }
            if (labelsRemoved == 2) {
                this._engine.getErrorHandler().trace(this._engine.getIntlString("af_dvt_gauge.LABEL_REMOVE_TOP_TICK_BOTTOM", this._gaugeBundle), this.getClass().getName(), "autoLayout");
            } else if (labelsRemoved == 1) {
                this._engine.getErrorHandler().trace(this._engine.getIntlString("af_dvt_gauge.LABEL_REMOVE_TOP", this._gaugeBundle), this.getClass().getName(), "autoLayout");
            }
        }
        return dim;
    }

    boolean isSpaceLimited(Dimension reqSize, Rectangle availBounds) {
        return this._innerBounds.height < 20 || reqSize.height > availBounds.height;
    }

    @Override
    protected Collection getPlotAreaObject(Map map, int type) {
        ArrayList list = new ArrayList();
        return list;
    }

    @Override
    protected Collection getIndicatorObject(Map map, int metricIndex) {
        Double metric = this._engine.getMetric();
        if (metricIndex > 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<DrawableObject> objects = new ArrayList<DrawableObject>(15);
        if (metric == null) {
            DrawableObject noDataObj = this.getNoDataLabelObject(map);
            if (noDataObj != null) {
                objects.add(noDataObj);
            }
            return objects;
        }
        Integer styleObj = (Integer)map.get("LEDStyle");
        int style = styleObj != null ? styleObj : GaugeDefaultValues.getLEDStyle();
        LEDStyleCallback styleCallback = (LEDStyleCallback)map.get("LEDStyleCallback");
        if (styleCallback == null) {
            if (style == 1) {
                styleCallback = new KPIStyleCallback();
            } else if (style == 4) {
                style = GaugeDefaultValues.getLEDStyle();
                this._engine.getErrorHandler().log("No LED style callback specified", this.getClass().getName(), "getIndicatorObject(Map map)");
            }
        }
        double[] tValues = null;
        int imgIndex = -1;
        int thresholdCount = 1;
        if (map.get("ThresholdValues") != null) {
            tValues = (double[])map.get("ThresholdValues");
            thresholdCount = tValues.length;
            if (styleCallback != null) {
                styleCallback.setLEDCount(thresholdCount + 1);
            }
            for (int i = 0; i < tValues.length; ++i) {
                if (!(metric <= tValues[i])) continue;
                imgIndex = i;
                break;
            }
            if (imgIndex == -1) {
                imgIndex = thresholdCount;
            }
        }
        ArrayList tList = (ArrayList)map.get("THRESHOLD_ATTRIBUTES");
        HashMap tMap = null;
        Color indColor = null;
        Color indBorderColor = null;
        HashMap sfxMap = null;
        if (tList != null && imgIndex < tList.size() && imgIndex != -1) {
            tMap = (HashMap)tList.get(imgIndex);
            sfxMap = (HashMap)LEDGauge.getThresholdAttribute(tMap, imgIndex, "ThresholdSFX");
        }
        if (imgIndex > -1) {
            indColor = (Color)LEDGauge.getThresholdAttribute(tMap, imgIndex, "ThresholdFillColor");
        }
        if (indColor == null) {
            Color[] defClrs = GaugeDefaultValues.getThresholdColors();
            if (imgIndex < defClrs.length && imgIndex != -1) {
                indColor = defClrs[imgIndex];
            } else {
                indColor = GaugeDefaultValues.getIndicatorFillColor();
                sfxMap = GaugeDefaultValues.getLEDIndicatorSFX();
            }
        }
        if ((indBorderColor = (Color)LEDGauge.getThresholdAttribute(tMap, imgIndex, "ThresholdBorderColor")) == null) {
            indBorderColor = indColor;
        }
        if (this._csParser != null && (this._csParser.defines("plotArea") || this._csParser.defines("ledFillArea"))) {
            Rectangle2D bounds = this._csParser.getBounds("plotArea");
            if (this._csParser.getBounds("ledFillArea") != null) {
                bounds = bounds != null ? bounds.createUnion(this._csParser.getBounds("ledFillArea")) : this._csParser.getBounds("ledFillArea");
            }
            AffineTransform scale = LEDGauge.getScalingTransform(bounds, this._innerBounds);
            AffineTransform move = LEDGauge.getTranslateTransform(bounds, this._innerBounds, scale);
            Color userBorderColor = (Color)map.get("PlotAreaBorderColor");
            Color userFillColor = (Color)map.get("PlotAreaFillColor");
            HashMap userSFXMap = (HashMap)map.get("PlotAreaSFX");
            List<CustomShape> plotAreaShapes = this._csParser.getShapes("plotArea");
            List<CustomShape> fillAreaShapes = this._csParser.getShapes("ledFillArea");
            int i = 0;
            int j = 0;
            while (i < plotAreaShapes.size() || j < fillAreaShapes.size()) {
                Color fillColor;
                int compid;
                Shape s;
                CustomShape plotArea = null;
                CustomShape fillArea = null;
                if (i < plotAreaShapes.size()) {
                    plotArea = plotAreaShapes.get(i);
                }
                if (j < fillAreaShapes.size()) {
                    fillArea = fillAreaShapes.get(j);
                }
                Color borderColor = null;
                HashMap sfx = null;
                if (fillArea == null || plotArea != null && plotArea.getZOrder() < fillArea.getZOrder()) {
                    s = plotArea.getShape();
                    compid = 11;
                    borderColor = userBorderColor != null ? userBorderColor : plotArea.getBorderColor();
                    fillColor = userFillColor != null ? userFillColor : plotArea.getFillColor();
                    sfx = userSFXMap != null ? userSFXMap : plotArea.getSFXMap();
                    ++i;
                } else {
                    s = fillArea.getShape();
                    compid = 14;
                    fillColor = indColor;
                    sfx = sfxMap;
                    ++j;
                }
                s = scale.createTransformedShape(s);
                s = move.createTransformedShape(s);
                objects.add(new DrawableObject.Shape(compid, s, borderColor, fillColor, sfx, null));
            }
        } else if (style == 0 || style == 5 || style == 2 || style == 3 || style == 6) {
            if (style == 0) {
                Integer sh;
                double dotBoundaryDiam = this._innerBounds.width > this._innerBounds.height ? (double)this._innerBounds.height : (double)this._innerBounds.width;
                double dotDiam = dotBoundaryDiam * 0.935;
                Point2D.Double dotCtr = new Point2D.Double(this._innerBounds.x + this._innerBounds.width / 2, this._innerBounds.y + this._innerBounds.height / 2);
                Rectangle2D.Double dotBoundaryBounds = new Rectangle2D.Double();
                dotBoundaryBounds.setRect(((Point2D)dotCtr).getX() - dotBoundaryDiam / 2.0, ((Point2D)dotCtr).getY() - dotBoundaryDiam / 2.0, dotBoundaryDiam, dotBoundaryDiam);
                Ellipse2D.Double dotBoundary = new Ellipse2D.Double();
                dotBoundary.setFrame(dotBoundaryBounds);
                objects.add(new DrawableObject.Shape(34, dotBoundary, null, indBorderColor, null, null));
                Rectangle2D.Double dotBounds = new Rectangle2D.Double();
                dotBounds.setRect(((Point2D)dotCtr).getX() - dotDiam / 2.0, ((Point2D)dotCtr).getY() - dotDiam / 2.0, dotDiam, dotDiam);
                Ellipse2D.Double dot = new Ellipse2D.Double();
                dot.setFrame(dotBounds);
                objects.add(new DrawableObject.Shape(14, dot, null, indColor, sfxMap, null));
                Integer ve = (Integer)map.get("VisualEffects");
                if (ve == null && GaugeDefaultValues.getVisualEffects() == 1 || ve != null && ve == 1) {
                    objects.add(new DrawableObject.Shape(34, dot, null, null, this.getDotVisualSFX(), null));
                }
                if ((sh = (Integer)map.get("SpecularHighlight")) == null && GaugeDefaultValues.getSpecularHighlight() == 0 || sh != null && sh == 0) {
                    Rectangle2D.Double halfCircleInnerBounds = new Rectangle2D.Double();
                    halfCircleInnerBounds.setRect(((Point2D)dotCtr).getX() - dotDiam * 0.325, ((Point2D)dotCtr).getY() - dotDiam * 0.46, dotDiam * 0.65, dotDiam * 0.46);
                    Ellipse2D.Double halfCircleInner = new Ellipse2D.Double();
                    halfCircleInner.setFrame(halfCircleInnerBounds);
                    objects.add(new DrawableObject.Shape(34, halfCircleInner, null, null, this.getDotSpecularSFX(), null));
                }
            } else if (style == 5) {
                double borderWidth = 0.0;
                borderWidth = this._innerBounds.width < this._innerBounds.height ? (double)this._innerBounds.width * 0.065 / 2.0 : (double)this._innerBounds.height * 0.065 / 2.0;
                RoundRectangle2D.Double roundBoundaryRect = new RoundRectangle2D.Double();
                roundBoundaryRect.setRoundRect(this._innerBounds.x, this._innerBounds.y, this._innerBounds.width, this._innerBounds.height, this._innerBounds.getHeight() / 2.0, this._innerBounds.getHeight() / 2.0);
                RoundRectangle2D.Double roundRect = new RoundRectangle2D.Double();
                roundRect.setRoundRect((double)this._innerBounds.x + borderWidth, (double)this._innerBounds.y + borderWidth, (double)this._innerBounds.width - borderWidth * 2.0, (double)this._innerBounds.height - borderWidth * 2.0, this._innerBounds.getHeight() / 2.0, this._innerBounds.getHeight() / 2.0);
                objects.add(new DrawableObject.Shape(34, roundBoundaryRect, null, indBorderColor, sfxMap, null));
                objects.add(new DrawableObject.Shape(14, roundRect, null, indColor, sfxMap, null));
                Integer ve = (Integer)map.get("VisualEffects");
                if (ve == null && GaugeDefaultValues.getVisualEffects() == 1 || ve != null && ve == 1) {
                    objects.add(new DrawableObject.Shape(34, roundRect, null, null, this.getRectangleSFX(), null));
                }
            } else {
                Shape innerPath;
                Shape path;
                double rotation = Math.PI;
                if (imgIndex == 1) {
                    rotation = 1.5707963267948966;
                } else if (imgIndex == 2) {
                    rotation = 0.0;
                }
                if (style == 2) {
                    path = this.getArrowLEDShape();
                    innerPath = this.getArrowInnerShape();
                } else if (style == 6) {
                    path = this.getSquareLEDShape();
                    innerPath = this.getSquareInnerShape();
                } else {
                    path = this.getTriangleLEDShape();
                    innerPath = this.getTriangleInnerShape();
                }
                AffineTransform rotate = AffineTransform.getRotateInstance(rotation);
                Shape xformPoly = rotate.createTransformedShape(path);
                AffineTransform scale = LEDGauge.getScalingTransform(xformPoly, this._innerBounds);
                AffineTransform move = LEDGauge.getTranslateTransform(xformPoly, this._innerBounds, scale);
                xformPoly = scale.createTransformedShape(xformPoly);
                xformPoly = move.createTransformedShape(xformPoly);
                objects.add(new DrawableObject.Shape(34, xformPoly, null, indBorderColor, null, null));
                Shape xformPolyInner = rotate.createTransformedShape(innerPath);
                xformPolyInner = scale.createTransformedShape(xformPolyInner);
                xformPolyInner = move.createTransformedShape(xformPolyInner);
                objects.add(new DrawableObject.Shape(14, xformPolyInner, null, indColor, sfxMap, null));
                Integer ve = (Integer)map.get("VisualEffects");
                if (ve == null && GaugeDefaultValues.getVisualEffects() == 1 || ve != null && ve == 1) {
                    if (style == 2) {
                        HashMap lightSfx = null;
                        lightSfx = imgIndex == 1 ? this.getArrowRightSFX() : (imgIndex == 2 ? this.getArrowUpSFX() : this.getArrowDownSFX());
                        objects.add(new DrawableObject.Shape(34, xformPolyInner, null, null, lightSfx, null));
                        objects.add(new DrawableObject.Shape(34, xformPolyInner, null, null, this.getArrowOtherSFX(), null));
                    } else if (style == 6) {
                        objects.add(new DrawableObject.Shape(34, xformPolyInner, null, null, this.getSquareSFX(), null));
                    } else if (style == 3) {
                        objects.add(new DrawableObject.Shape(34, xformPolyInner, null, null, this.getTriangleSFX(), null));
                    }
                }
            }
        } else if (style == 1 || style == 4) {
            Image img;
            if (imgIndex == -1) {
                this._engine.getErrorHandler().log("Threshold values are required for KPI or custom LED gauges.", this.getClass().getName(), "public Collection getIndicatorObject(Map map)");
                imgIndex = 0;
            }
            if ((img = styleCallback.getLEDImage(imgIndex)) == null) {
                img = ImageUtils.getNotLoadedImage();
            }
            ImageUtils.loadImage((Image)img);
            Dimension imgSize = new Dimension(img.getWidth(null), img.getHeight(null));
            Rectangle2D.Double rect2d = new Rectangle2D.Double((double)this._innerBounds.x + (double)(this._innerBounds.width / 2) - imgSize.getWidth() / 2.0, (double)this._innerBounds.y + (double)(this._innerBounds.height / 2) - imgSize.getHeight() / 2.0, imgSize.getWidth(), imgSize.getHeight());
            objects.add(new DrawableObject.Image(14, styleCallback.getLEDImagePath(imgIndex), img, rect2d, 1.0, null, null));
            Color color = new Color(1.0f, 1.0f, 1.0f, 0.01f);
            objects.add(new DrawableObject.Shape(14, map, (Shape)rect2d, null, color, null, null));
        }
        return objects;
    }

    @Override
    protected Collection getTickLabelObjects(Map map) {
        ArrayList list = new ArrayList();
        return list;
    }

    @Override
    protected Collection getTickMarkObjects(Map map) {
        ArrayList list = new ArrayList();
        return list;
    }

    @Override
    protected DrawableObject getNoDataLabelObject(Map map) {
        String noDataLabel = this._engine.getIntlStringFromUtilBundle("af_dvt_util.NO_DATA");
        Font font = (Font)map.get("TickLabelFont");
        if (font == null) {
            font = GaugeDefaultValues.getNoDataLabelFont();
        }
        Dimension dim = DrawableObject.getLabelDimensions(this._engine.getGraphics(), font, noDataLabel);
        int drawWidth = this._innerBounds.width - this._layout.getGapWidth(5) * 2;
        if (dim.width > drawWidth) {
            return null;
        }
        Rectangle bounds = new Rectangle();
        bounds.x = this._innerBounds.x + this._innerBounds.width / 2 - dim.width / 2;
        bounds.y = this._innerBounds.y + this._innerBounds.height - this._layout.getGapHeight(3) - dim.height;
        bounds.width = dim.width;
        bounds.height = dim.height;
        return DrawableObject.getLabelObject(this._engine.getGraphics(), noDataLabel, font, GaugeDefaultValues.getNoDataLabelFontColor(), bounds, "NoDataLabel");
    }

    @Override
    protected Collection getGaugeFrameObject(Map map) {
        ArrayList list = new ArrayList();
        return list;
    }

    @Override
    protected Collection getGaugeLinkObject(Map map, Rectangle outerBounds) {
        ArrayList list = new ArrayList();
        return list;
    }

    @Override
    protected int getGaugeRadius(int availWidth, int availHeight) {
        return Math.min(availHeight, availWidth);
    }

    @Override
    protected Rectangle getInnerBounds(Map map, Rectangle rect, int reqAboveSpace, int reqBelowSpace, int reqLeftSpace, int reqRightSpace) {
        int availHeight = rect.height - reqAboveSpace - reqBelowSpace;
        int availWidth = rect.width - reqLeftSpace - reqRightSpace;
        LEDStyleCallback styleCallback = (LEDStyleCallback)this._engine.getAttribute("LEDStyleCallback");
        if (styleCallback == null) {
            styleCallback = new KPIStyleCallback();
        }
        Rectangle bounds = new Rectangle();
        bounds.x = rect.x + reqLeftSpace;
        bounds.y = rect.y + reqAboveSpace;
        bounds.width = availWidth;
        bounds.height = availHeight;
        return bounds;
    }

    @Override
    protected int getMaxNumberOfSteps() {
        return 0;
    }

    @Override
    protected int getGaugeSetGap(Map map, Graphics2D g, int dir) {
        boolean bMetLbl;
        int topLblPos = this.getTopLabelPosition(map);
        int metLblPos = this.getMetricLabelPosition(map);
        int btmLblPos = this.getBottomLabelPosition(map);
        String topLabel = this._engine.getTopLabel();
        String btmLabel = this._engine.getBottomLabel();
        String metLabel = this._engine.formatValue(this._engine.getMetric(), "MetricLabelViewFormat");
        boolean bTopLbl = topLabel != null && topLblPos == 3;
        boolean bBtmLbl = btmLabel != null && btmLblPos == 1;
        boolean bHasMetWithBtmLbl = btmLblPos == 1 && metLblPos == 2;
        boolean bl = bMetLbl = metLabel != null && (metLblPos == 1 || bHasMetWithBtmLbl);
        if (!(bTopLbl || bBtmLbl || bMetLbl)) {
            if (dir == 0 || dir == 1) {
                return this._layout.getGapHeight(2);
            }
            return this._layout.getGapWidth(2);
        }
        return super.getGaugeSetGap(map, g, dir);
    }

    protected static Image loadImage(String strURL) {
        if (_ledImgs != null && _ledImgs.containsKey(strURL)) {
            return (Image)_ledImgs.get(strURL);
        }
        Image image = null;
        try {
            image = Toolkit.getDefaultToolkit().getImage(strURL);
        }
        catch (Exception e) {
            image = ImageUtils.getImageResource(CommonGauge.class, (String)strURL);
        }
        if (image == null) {
            return null;
        }
        if (!ImageUtils.loadImage((Image)image)) {
            image = ImageUtils.getNotLoadedImage();
            ImageUtils.loadImage((Image)image);
        }
        if (_ledImgs == null) {
            _ledImgs = new HashMap(GaugeDefaultValues.getThresholdCount());
        }
        _ledImgs.put(strURL, image);
        return image;
    }

    @Override
    protected Rectangle _getPlotAreaBounds(Rectangle gaugeFrameBounds, Map map, Graphics2D g) {
        int availHeight = gaugeFrameBounds.height;
        String topLabel = this._engine.getTopLabel();
        int topLblPos = this.getTopLabelPosition(map);
        int btmLblPos = this.getBottomLabelPosition(map);
        int metLblPos = this.getMetricLabelPosition(map);
        boolean showLowLbl = GaugeDefaultValues.isLowerLabelFrameVisible();
        if (map.get("LowLblFrameVisible") != null) {
            showLowLbl = (Boolean)map.get("LowLblFrameVisible");
        }
        int customLayout = GaugeDefaultValues.getCustomLayout();
        if (map.get("CustomLayout") != null) {
            customLayout = (Integer)map.get("CustomLayout");
        }
        boolean bTitleSeparator = (customLayout & 1) != 0 && topLblPos == 3;
        boolean bFullGauge = topLabel != null && bTitleSeparator && showLowLbl && (btmLblPos == 1 || metLblPos == 1);
        int ledHeight = availHeight;
        if (bFullGauge) {
            ledHeight = (int)(0.75 * (double)availHeight);
        }
        int reqAboveSpace = (availHeight - ledHeight) / 2;
        int reqBelowSpace = (availHeight - ledHeight) / 2;
        int reqLeftSpace = 0;
        int reqRightSpace = 0;
        Rectangle bounds = this.getInnerBounds(map, gaugeFrameBounds, reqAboveSpace, reqBelowSpace, reqLeftSpace, reqRightSpace);
        if (this._csParser == null || !this._csParser.defines("gaugeFrame")) {
            this._gaugeFrameBounds = new Rectangle(bounds.x - reqLeftSpace, bounds.y - reqAboveSpace, bounds.width + reqLeftSpace + reqRightSpace, bounds.height + reqAboveSpace + reqBelowSpace);
        }
        return bounds;
    }

    private Collection _getFocusSpotObject(Point2D dotCtr, double dotDiam) {
        ArrayList<DrawableObject.Shape> objects = new ArrayList<DrawableObject.Shape>(2);
        double focusRadius = dotDiam * 0.15;
        int MIN_ALPHA = 20;
        Rectangle2D.Double baseRect = new Rectangle2D.Double();
        ((Rectangle2D)baseRect).setRect(dotCtr.getX() - focusRadius * 2.0, dotCtr.getY() - focusRadius * 2.0, focusRadius * 2.0, focusRadius * 2.0);
        double rectWidth = ((RectangularShape)baseRect).getWidth();
        int locOffset = 0;
        int i = 0;
        while (rectWidth > 2.0) {
            Rectangle2D tempRect = (Rectangle2D)baseRect.clone();
            if (i % 2 > 0) {
                ++locOffset;
            }
            if (i != 0) {
                tempRect.setRect(((RectangularShape)baseRect).getX() + (double)locOffset, ((RectangularShape)baseRect).getY() + (double)locOffset, ((RectangularShape)baseRect).getWidth() + (double)locOffset - (double)(i * 2), ((RectangularShape)baseRect).getHeight() + (double)locOffset - (double)(i * 2));
            }
            rectWidth = tempRect.getWidth();
            Arc2D.Double focusArc = new Arc2D.Double();
            focusArc.setArc(tempRect, 30.0, 210.0, 2);
            Color focusClr = new Color(255, 255, 255, MIN_ALPHA + i);
            objects.add(new DrawableObject.Shape(14, focusArc, null, focusClr, null, null));
            ++i;
        }
        return objects;
    }

    private Shape getArrowLEDShape() {
        if (this.ARROW_LED_SHAPE == null) {
            GeneralPath path = new GeneralPath();
            path.moveTo(50.0f, 95.0f);
            path.lineTo(71.0f, 95.0f);
            path.quadTo(74.414, 94.414, 75.0, 91.0);
            path.lineTo(75.0f, 60.0f);
            path.lineTo(92.0f, 60.0f);
            path.quadTo(98.5, 59.1, 95.0, 54.0);
            path.lineTo(52.0f, 12.0f);
            path.quadTo(50.0f, 11.0f, 48.0f, 12.0f);
            path.lineTo(5.0f, 54.0f);
            path.quadTo(1.5, 59.1, 8.0, 60.0);
            path.lineTo(25.0f, 60.0f);
            path.lineTo(25.0f, 91.0f);
            path.quadTo(25.586, 94.414, 29.0, 95.0);
            path.closePath();
            this.ARROW_LED_SHAPE = path;
        }
        return this.ARROW_LED_SHAPE;
    }

    private Shape getArrowInnerShape() {
        if (this.ARROW_INNER_SHAPE == null) {
            GeneralPath innerPath = new GeneralPath();
            double boundary = 3.25;
            innerPath.moveTo(boundary * 2.0, 60.0 - boundary);
            innerPath.lineTo(25.0 + boundary, 60.0 - boundary);
            innerPath.lineTo(25.0 + boundary, 95.0 - boundary);
            innerPath.lineTo(75.0 - boundary, 95.0 - boundary);
            innerPath.lineTo(75.0 - boundary, 60.0 - boundary);
            innerPath.lineTo(100.0 - boundary * 2.0, 60.0 - boundary);
            innerPath.lineTo(50.0, boundary * 1.414 + 10.0);
            innerPath.closePath();
            this.ARROW_INNER_SHAPE = innerPath;
        }
        return this.ARROW_INNER_SHAPE;
    }

    private Shape getTriangleLEDShape() {
        if (this.TRIANGLE_LED_SHAPE == null) {
            GeneralPath path = new GeneralPath();
            path.moveTo(50.0, 86.6);
            path.moveTo(8.0, 86.6);
            path.quadTo(0.0, 86.6, 3.46, 78.6);
            path.lineTo(46.0, 6.93);
            path.quadTo(50.0, 0.0, 54.0, 6.93);
            path.lineTo(96.54, 78.6);
            path.quadTo(100.0, 86.6, 92.0, 86.6);
            path.closePath();
            this.TRIANGLE_LED_SHAPE = path;
        }
        return this.TRIANGLE_LED_SHAPE;
    }

    private Shape getTriangleInnerShape() {
        if (this.TRIANGLE_INNER_SHAPE == null) {
            GeneralPath innerPath = new GeneralPath();
            double boundary = 3.25;
            innerPath.moveTo(boundary * 1.73, 86.6 - boundary);
            innerPath.lineTo(50.0, boundary * 2.0);
            innerPath.lineTo(100.0 - boundary * 1.73, 86.6 - boundary);
            innerPath.closePath();
            this.TRIANGLE_INNER_SHAPE = innerPath;
        }
        return this.TRIANGLE_INNER_SHAPE;
    }

    private Shape getSquareLEDShape() {
        if (this.SQUARE_LED_SHAPE == null) {
            GeneralPath path = new GeneralPath();
            path.moveTo(50.0f, 0.0f);
            path.lineTo(6.0f, 0.0f);
            path.quadTo(0.568, 0.568, 0.0, 6.0);
            path.lineTo(0.0f, 94.0f);
            path.quadTo(0.568, 99.414, 6.0, 100.0);
            path.lineTo(96.0f, 100.0f);
            path.quadTo(99.414, 99.414, 100.0, 94.0);
            path.lineTo(100.0f, 6.0f);
            path.quadTo(99.414, 0.568, 94.0, 0.0);
            path.closePath();
            this.SQUARE_LED_SHAPE = path;
        }
        return this.SQUARE_LED_SHAPE;
    }

    private Shape getSquareInnerShape() {
        if (this.SQUARE_INNER_SHAPE == null) {
            GeneralPath innerPath = new GeneralPath();
            double boundary = 3.25;
            innerPath.moveTo(boundary, boundary);
            innerPath.lineTo(boundary, 100.0 - boundary);
            innerPath.lineTo(100.0 - boundary, 100.0 - boundary);
            innerPath.lineTo(100.0 - boundary, boundary);
            innerPath.closePath();
            this.SQUARE_INNER_SHAPE = innerPath;
        }
        return this.SQUARE_INNER_SHAPE;
    }

    private HashMap getSquareSFX() {
        if (this.SQUARE_SFX == null) {
            HashMap<String, Object> lightSfx = new HashMap<String, Object>();
            ArrayList<Double> stops = new ArrayList<Double>();
            stops.add(0.0);
            stops.add(0.05);
            stops.add(0.4);
            stops.add(0.6);
            stops.add(0.8);
            stops.add(0.9);
            stops.add(1.0);
            ArrayList<Color> colors = new ArrayList<Color>();
            colors.add(SFX_C1);
            colors.add(SFX_C2);
            colors.add(SFX_C1);
            colors.add(SFX_C0);
            colors.add(SFX_C1);
            colors.add(SFX_C2);
            colors.add(SFX_C3);
            lightSfx.put("SFX_FILL_TYPE", 2);
            lightSfx.put("SFX_GRADIENT_DIRECTION", 3);
            lightSfx.put("SFX_GRADIENT_REVERSED", true);
            lightSfx.put("SFX_NUM_STOPS", 7);
            lightSfx.put("SFX_STOP_POSITIONS", stops);
            lightSfx.put("SFX_STOP_COLORS", colors);
            this.SQUARE_SFX = lightSfx;
        }
        return this.SQUARE_SFX;
    }

    private HashMap getTriangleSFX() {
        if (this.TRIANGLE_SFX == null) {
            HashMap<String, Serializable> lightSfx = new HashMap<String, Serializable>();
            ArrayList<Double> stops = new ArrayList<Double>();
            stops.add(0.0);
            stops.add(0.05);
            stops.add(0.4);
            stops.add(0.9);
            stops.add(1.0);
            ArrayList<Color> colors = new ArrayList<Color>();
            colors.add(SFX_C1);
            colors.add(SFX_C3);
            colors.add(SFX_C0);
            colors.add(SFX_C1);
            colors.add(SFX_C0);
            lightSfx.put("SFX_FILL_TYPE", Integer.valueOf(2));
            lightSfx.put("SFX_GRADIENT_DIRECTION", Integer.valueOf(3));
            lightSfx.put("SFX_NUM_STOPS", Integer.valueOf(5));
            lightSfx.put("SFX_STOP_POSITIONS", stops);
            lightSfx.put("SFX_STOP_COLORS", colors);
            this.TRIANGLE_SFX = lightSfx;
        }
        return this.TRIANGLE_SFX;
    }

    private HashMap getArrowUpSFX() {
        if (this.ARROW_UP_SFX == null) {
            HashMap<String, Serializable> lightSfx = new HashMap<String, Serializable>();
            ArrayList<Double> stops = new ArrayList<Double>();
            stops.add(0.0);
            stops.add(0.15);
            stops.add(0.3);
            stops.add(0.6);
            ArrayList<Color> colors = new ArrayList<Color>();
            colors.add(SFX_C1);
            colors.add(SFX_C3);
            colors.add(SFX_C2);
            colors.add(SFX_C0);
            lightSfx.put("SFX_NUM_STOPS", Integer.valueOf(4));
            lightSfx.put("SFX_FILL_TYPE", Integer.valueOf(2));
            lightSfx.put("SFX_GRADIENT_DIRECTION", Integer.valueOf(7));
            lightSfx.put("SFX_STOP_POSITIONS", stops);
            lightSfx.put("SFX_STOP_COLORS", colors);
            this.ARROW_UP_SFX = lightSfx;
        }
        return this.ARROW_UP_SFX;
    }

    private HashMap getArrowDownSFX() {
        if (this.ARROW_DOWN_SFX == null) {
            HashMap<String, Serializable> lightSfx = new HashMap<String, Serializable>();
            ArrayList<Double> stops = new ArrayList<Double>();
            stops.add(0.0);
            stops.add(0.05);
            stops.add(0.15);
            stops.add(0.4);
            ArrayList<Color> colors = new ArrayList<Color>();
            colors.add(SFX_C1);
            colors.add(SFX_C3);
            colors.add(SFX_C2);
            colors.add(SFX_C0);
            lightSfx.put("SFX_NUM_STOPS", Integer.valueOf(4));
            lightSfx.put("SFX_FILL_TYPE", Integer.valueOf(2));
            lightSfx.put("SFX_GRADIENT_DIRECTION", Integer.valueOf(3));
            lightSfx.put("SFX_STOP_POSITIONS", stops);
            lightSfx.put("SFX_STOP_COLORS", colors);
            this.ARROW_DOWN_SFX = lightSfx;
        }
        return this.ARROW_DOWN_SFX;
    }

    private HashMap getArrowRightSFX() {
        if (this.ARROW_RIGHT_SFX == null) {
            HashMap<String, Serializable> lightSfx = new HashMap<String, Serializable>();
            ArrayList<Double> stops = new ArrayList<Double>();
            stops.add(0.0);
            stops.add(0.15);
            stops.add(0.25);
            stops.add(0.6);
            ArrayList<Color> colors = new ArrayList<Color>();
            colors.add(SFX_C1);
            colors.add(SFX_C3);
            colors.add(SFX_C2);
            colors.add(SFX_C0);
            lightSfx.put("SFX_NUM_STOPS", Integer.valueOf(4));
            lightSfx.put("SFX_FILL_TYPE", Integer.valueOf(2));
            lightSfx.put("SFX_GRADIENT_DIRECTION", Integer.valueOf(3));
            lightSfx.put("SFX_STOP_POSITIONS", stops);
            lightSfx.put("SFX_STOP_COLORS", colors);
            this.ARROW_RIGHT_SFX = lightSfx;
        }
        return this.ARROW_RIGHT_SFX;
    }

    private HashMap getArrowOtherSFX() {
        if (this.ARROW_OTHER_SFX == null) {
            HashMap<String, Serializable> squareSfx = new HashMap<String, Serializable>();
            ArrayList<Double> stops = new ArrayList<Double>();
            stops.add(0.5);
            stops.add(0.9);
            stops.add(1.0);
            ArrayList<Color> colors = new ArrayList<Color>();
            colors.add(SFX_C0);
            colors.add(SFX_C2);
            colors.add(SFX_C1);
            squareSfx.put("SFX_FILL_TYPE", Integer.valueOf(2));
            squareSfx.put("SFX_GRADIENT_DIRECTION", Integer.valueOf(3));
            squareSfx.put("SFX_NUM_STOPS", Integer.valueOf(3));
            squareSfx.put("SFX_STOP_POSITIONS", stops);
            squareSfx.put("SFX_STOP_COLORS", colors);
            this.ARROW_OTHER_SFX = squareSfx;
        }
        return this.ARROW_OTHER_SFX;
    }

    private HashMap getDotVisualSFX() {
        if (this.DOT_VISUAL_SFX == null) {
            HashMap<String, Serializable> dotSfx = new HashMap<String, Serializable>();
            ArrayList<Double> stops = new ArrayList<Double>();
            stops.add(0.15);
            stops.add(0.7);
            stops.add(0.95);
            ArrayList<Color> colors = new ArrayList<Color>();
            colors.add(SFX_C0);
            colors.add(SFX_C1);
            colors.add(SFX_C3);
            dotSfx.put("SFX_FILL_TYPE", Integer.valueOf(2));
            dotSfx.put("SFX_GRADIENT_DIRECTION", Integer.valueOf(21));
            dotSfx.put("SFX_GRADIENT_CENTER", new Point2D.Double(50.0, 20.0));
            dotSfx.put("SFX_NUM_STOPS", Integer.valueOf(3));
            dotSfx.put("SFX_STOP_POSITIONS", stops);
            dotSfx.put("SFX_STOP_COLORS", colors);
            this.DOT_VISUAL_SFX = dotSfx;
        }
        return this.DOT_VISUAL_SFX;
    }

    private HashMap getDotSpecularSFX() {
        if (this.DOT_SPECULAR_SFX == null) {
            HashMap<String, Serializable> lightSfx = new HashMap<String, Serializable>();
            ArrayList<Double> stops = new ArrayList<Double>();
            stops.add(0.5);
            stops.add(0.7);
            stops.add(0.9);
            stops.add(1.0);
            ArrayList<Color> colors = new ArrayList<Color>();
            colors.add(SFX_C0);
            colors.add(SFX_C2);
            colors.add(SFX_C4);
            colors.add(SFX_C3);
            lightSfx.put("SFX_FILL_TYPE", Integer.valueOf(2));
            lightSfx.put("SFX_GRADIENT_DIRECTION", Integer.valueOf(21));
            lightSfx.put("SFX_GRADIENT_CENTER", new Point2D.Double(50.0, 90.0));
            lightSfx.put("SFX_NUM_STOPS", Integer.valueOf(4));
            lightSfx.put("SFX_STOP_POSITIONS", stops);
            lightSfx.put("SFX_STOP_COLORS", colors);
            this.DOT_SPECULAR_SFX = lightSfx;
        }
        return this.DOT_SPECULAR_SFX;
    }

    private HashMap getRectangleSFX() {
        if (this.RECTANGLE_SFX == null) {
            HashMap<String, Serializable> lightSfx = new HashMap<String, Serializable>();
            ArrayList<Double> stops = new ArrayList<Double>();
            stops.add(0.0);
            stops.add(0.1);
            stops.add(0.4);
            stops.add(0.8);
            stops.add(0.9);
            stops.add(1.0);
            ArrayList<Color> colors = new ArrayList<Color>();
            colors.add(SFX_C2);
            colors.add(SFX_C3);
            colors.add(SFX_C0);
            colors.add(SFX_C1);
            colors.add(SFX_C2);
            colors.add(SFX_C1);
            lightSfx.put("SFX_FILL_TYPE", Integer.valueOf(2));
            lightSfx.put("SFX_GRADIENT_DIRECTION", Integer.valueOf(3));
            lightSfx.put("SFX_NUM_STOPS", Integer.valueOf(6));
            lightSfx.put("SFX_STOP_POSITIONS", stops);
            lightSfx.put("SFX_STOP_COLORS", colors);
            this.RECTANGLE_SFX = lightSfx;
        }
        return this.RECTANGLE_SFX;
    }
}

