/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jrf.JRFInternalPlatform;
import oracle.jrf.JRFInternalPlatformFactory;
import oracle.jrf.JrfUtils;
import oracle.jrf.ServerStartupShutdownProvider;
import oracle.jrf.i18n.JRFMessageBundleHelper;

public class ServerStartupShutdownManager {
    protected List<ServerStartupShutdownProvider> startupList;
    protected List<ServerStartupShutdownProvider> shutdownList;
    private static List<String> failedStartupProviders;
    private static int startupCount;
    private static final Logger LOGGER;

    public ServerStartupShutdownManager() {
        this.initialize();
    }

    private void initialize() {
        ServiceLoader<ServerStartupShutdownProvider> providerSet = ServiceLoader.load(ServerStartupShutdownProvider.class);
        this.startupList = new ArrayList<ServerStartupShutdownProvider>();
        for (ServerStartupShutdownProvider provider : providerSet) {
            this.startupList.add(provider);
        }
        Collections.sort(this.startupList, new Comparator<ServerStartupShutdownProvider>(){

            @Override
            public int compare(ServerStartupShutdownProvider provider1, ServerStartupShutdownProvider provider2) {
                return provider1.getStartupOrder() - provider2.getStartupOrder();
            }
        });
        this.shutdownList = new ArrayList<ServerStartupShutdownProvider>(this.startupList);
        Collections.sort(this.shutdownList, new Comparator<ServerStartupShutdownProvider>(){

            @Override
            public int compare(ServerStartupShutdownProvider provider1, ServerStartupShutdownProvider provider2) {
                return provider1.getShutdownOrder() - provider2.getShutdownOrder();
            }
        });
    }

    public void startup() throws Exception {
        Throwable firstEx = null;
        JRFInternalPlatform internalPlatform = JRFInternalPlatformFactory.getInstance();
        for (ServerStartupShutdownProvider provider : this.startupList) {
            try {
                if (!internalPlatform.isTargeted(provider.getTargets())) continue;
                LOGGER.log(Level.INFO, JRFMessageBundleHelper.msg.getString("JRF-10028", new String[]{provider.getClass().getName()}));
                provider.startup();
                ++startupCount;
            }
            catch (Throwable ex) {
                ex.printStackTrace(System.err);
                ServerStartupShutdownManager.getFailedStartupProviders().add(provider.getClass().getName());
                firstEx = firstEx == null ? ex : firstEx;
            }
        }
        if (firstEx != null) {
            String msg = JRFMessageBundleHelper.msg.getString("JRF-20033", new String[]{ServerStartupShutdownManager.getFailedStartupProviders().toString()});
            throw (Exception)new Exception(msg).initCause(firstEx);
        }
    }

    public void shutdown() throws Exception {
        Throwable firstEx = null;
        ArrayList<String> failedProviders = new ArrayList<String>();
        JRFInternalPlatform internalPlatform = JRFInternalPlatformFactory.getInstance();
        for (ServerStartupShutdownProvider provider : this.shutdownList) {
            try {
                if (!internalPlatform.isTargeted(provider.getTargets())) continue;
                LOGGER.log(Level.INFO, JRFMessageBundleHelper.msg.getString("JRF-10028", new String[]{provider.getClass().getName()}));
                provider.shutdown();
            }
            catch (Throwable ex) {
                ex.printStackTrace(System.err);
                failedProviders.add(provider.getClass().getName());
                firstEx = firstEx == null ? ex : firstEx;
            }
        }
        if (firstEx != null) {
            String msg = JRFMessageBundleHelper.msg.getString("JRF-20034", new String[]{failedProviders.toString()});
            throw (Exception)new Exception(msg).initCause(firstEx);
        }
    }

    public static boolean areAllProvidersStarted() {
        return startupCount > 0 && ServerStartupShutdownManager.getFailedStartupProviders().isEmpty();
    }

    protected static void resetStartedProvidersStatus() {
        startupCount = 0;
        failedStartupProviders = null;
    }

    private static List<String> getFailedStartupProviders() {
        if (failedStartupProviders == null) {
            failedStartupProviders = new ArrayList<String>();
        }
        return failedStartupProviders;
    }

    static {
        startupCount = 0;
        LOGGER = Logger.getLogger(JrfUtils.JRF_LOGGER);
    }
}

