/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf;

import java.io.Serializable;

public class ApplicationIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String applicationName;
    private final String partitionName;
    private final String version;
    private final String deploymentName;
    private final String runtimeName;
    private final String displayName;

    public ApplicationIdentifier(String deploymentName, String runtimeName, String version) {
        this.deploymentName = deploymentName;
        this.runtimeName = runtimeName;
        this.version = version;
        this.displayName = version != null && !version.trim().equals("") ? deploymentName + "(" + version + ")" : deploymentName;
        this.applicationName = deploymentName;
        this.partitionName = null;
    }

    public ApplicationIdentifier(String appName, String version, String partitionName, boolean globalPartition) {
        this.version = version;
        this.partitionName = partitionName;
        if (partitionName != null && partitionName.trim().length() > 0) {
            if (version != null && version.trim().length() > 0) {
                if (globalPartition) {
                    this.displayName = appName + "(" + version + ")";
                    this.deploymentName = appName;
                } else {
                    this.displayName = appName + "(" + version + "$" + partitionName + ")";
                    this.deploymentName = appName + "$" + partitionName;
                }
                this.runtimeName = appName + "#" + version + "$" + partitionName;
                this.applicationName = appName;
            } else {
                this.applicationName = appName;
                if (globalPartition) {
                    this.displayName = appName;
                    this.deploymentName = appName;
                } else {
                    this.displayName = appName + "$" + partitionName;
                    this.deploymentName = appName + "$" + partitionName;
                }
                this.runtimeName = appName + "$" + partitionName;
            }
        } else {
            this.deploymentName = appName;
            if (version != null && version.trim().length() > 0) {
                this.displayName = appName + "(" + version + ")";
                this.runtimeName = appName + "#" + version;
                this.applicationName = appName;
            } else {
                this.displayName = appName;
                this.runtimeName = appName;
                this.applicationName = appName;
            }
        }
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public String getRuntimeName() {
        return this.runtimeName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.applicationName == null ? 0 : this.applicationName.hashCode());
        result = 31 * result + (this.partitionName == null ? 0 : this.partitionName.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicationIdentifier other = (ApplicationIdentifier)obj;
        if (this.applicationName == null ? other.applicationName != null : !this.applicationName.equals(other.applicationName)) {
            return false;
        }
        if (this.partitionName == null ? other.partitionName != null : !this.partitionName.equals(other.partitionName)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

