/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.ide.insight.InsightItem;
import oracle.ide.insight.filter.InsightSorter;

public class CamelCaseInsightSorter<T extends InsightItem>
implements InsightSorter<T> {
    private final Comparator<InsightItem> COMPARATOR = new InsightDataItemComparator();
    private String prefix = "a";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sort(List<T> listDataItems, String prefix) {
        this.prefix = prefix;
        List<T> list = listDataItems;
        synchronized (list) {
            ArrayList<T> sortList = new ArrayList<T>(listDataItems);
            Collections.sort(sortList, this.COMPARATOR);
            listDataItems.clear();
            listDataItems.addAll(sortList);
        }
    }

    private class InsightDataItemComparator
    implements Comparator<InsightItem> {
        private InsightDataItemComparator() {
        }

        @Override
        public int compare(InsightItem itemA, InsightItem itemB) {
            boolean upperB;
            boolean upperA;
            if (itemA == itemB) {
                return 0;
            }
            if (itemA.getGroup() != itemB.getGroup()) {
                return itemA.getGroup() < itemB.getGroup() ? -1 : 1;
            }
            String nameA = itemA.getName();
            String nameB = itemB.getName();
            if (nameA == null && nameB == null) {
                return 0;
            }
            if (nameA == null) {
                return 1;
            }
            if (nameB == null) {
                return -1;
            }
            if (CamelCaseInsightSorter.this.prefix != null) {
                if (nameA.startsWith(CamelCaseInsightSorter.this.prefix) && !nameB.startsWith(CamelCaseInsightSorter.this.prefix)) {
                    return -1;
                }
                if (!nameA.startsWith(CamelCaseInsightSorter.this.prefix) && nameB.startsWith(CamelCaseInsightSorter.this.prefix)) {
                    return 1;
                }
            }
            if (itemA.getWeight() != itemB.getWeight()) {
                return itemA.getWeight() < itemB.getWeight() ? -1 : 1;
            }
            if (CamelCaseInsightSorter.this.prefix != null && CamelCaseInsightSorter.this.prefix.length() > 0 && Character.isUpperCase(CamelCaseInsightSorter.this.prefix.charAt(0))) {
                upperA = nameA.length() > 0 && Character.isUpperCase(nameA.charAt(0));
                boolean bl = upperB = nameB.length() > 0 && Character.isUpperCase(nameB.charAt(0));
                if (upperA && !upperB) {
                    return -1;
                }
                if (!upperA && upperB) {
                    return 1;
                }
            }
            if (CamelCaseInsightSorter.this.prefix == null || CamelCaseInsightSorter.this.prefix.length() == 0 || Character.isLowerCase(CamelCaseInsightSorter.this.prefix.charAt(0))) {
                upperA = nameA.length() > 0 && Character.isLowerCase(nameA.charAt(0));
                boolean bl = upperB = nameB.length() > 0 && Character.isLowerCase(nameB.charAt(0));
                if (upperA && !upperB) {
                    return -1;
                }
                if (!upperA && upperB) {
                    return 1;
                }
            }
            return nameA.compareTo(nameB);
        }
    }
}

