/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.insight.InsightActionListener;
import oracle.ide.insight.InsightAdapter;
import oracle.ide.insight.InsightController;
import oracle.ide.insight.InsightSupport;
import oracle.javatools.editor.EditDescriptor;

public final class DefaultAdapter<T extends JTextComponent, C extends InsightController>
implements InsightAdapter<T, C> {
    private InsightSupport<T, C> insightSupport;
    private int state = Integer.MIN_VALUE;
    private final DocumentL documentL = new DocumentL();
    private final KeyL keyL = new KeyL();
    private List<InsightActionListener> listeners = new CopyOnWriteArrayList<InsightActionListener>();

    @Override
    public void install(InsightSupport<T, C> insightSupport) {
        this.insightSupport = insightSupport;
        ((JTextComponent)this.getTextComponent()).getDocument().addDocumentListener(this.documentL);
        ((Component)this.getTextComponent()).addKeyListener(this.keyL);
    }

    @Override
    public void deinstall() {
        ((Component)this.getTextComponent()).removeKeyListener(this.keyL);
        ((JTextComponent)this.getTextComponent()).getDocument().removeDocumentListener(this.documentL);
        this.insightSupport = null;
    }

    @Override
    public InsightSupport<T, C> getInsightSuport() {
        return this.insightSupport;
    }

    @Override
    public T getTextComponent() {
        return this.insightSupport.getTextComponent();
    }

    @Override
    public int getOffset() {
        return ((JTextComponent)this.getTextComponent()).getCaretPosition();
    }

    @Override
    public Integer getState() {
        return this.state;
    }

    private void stateChange() {
        this.state = this.state == Integer.MAX_VALUE ? Integer.MIN_VALUE : ++this.state;
    }

    @Override
    public boolean isEditable() {
        return ((JTextComponent)this.getTextComponent()).isEditable();
    }

    @Override
    public void makeEditable() {
    }

    @Override
    public void showFeedback(String message) {
    }

    @Override
    public void beginEdit(EditDescriptor editDescriptor) {
    }

    @Override
    public void endEdit() {
    }

    @Override
    public void recordUndo(String undoDescription, Context context, UndoableEdit edit) {
    }

    @Override
    public void addInsightActionListener(InsightActionListener actionListener) {
        if (!this.listeners.contains(actionListener)) {
            this.listeners.add(actionListener);
        }
    }

    @Override
    public void removeInsightActionListener(InsightActionListener actionListener) {
        this.listeners.remove(actionListener);
    }

    private class DocumentL
    implements DocumentListener {
        private DocumentL() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            DefaultAdapter.this.stateChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            DefaultAdapter.this.stateChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }

    private class KeyL
    implements KeyListener {
        private KeyL() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            this.processKey(e, false);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.processKey(e, true);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.processKey(e, false);
        }

        private void processKey(KeyEvent e, boolean doIt) {
            if (DefaultAdapter.this.insightSupport == null || DefaultAdapter.this.insightSupport.getInsightController().getState() != InsightController.State.SHOWING) {
                return;
            }
            InsightActionListener.Action action = null;
            switch (e.getKeyCode()) {
                case 32: {
                    if (!e.isControlDown()) break;
                    action = InsightActionListener.Action.INVOKE;
                    break;
                }
                case 10: {
                    action = InsightActionListener.Action.ENTER;
                    break;
                }
                case 27: {
                    action = InsightActionListener.Action.CANCEL;
                    break;
                }
                case 9: {
                    action = InsightActionListener.Action.TAB;
                    break;
                }
                case 38: {
                    if (e.isControlDown()) {
                        action = InsightActionListener.Action.SCROLL_DOC_UP;
                        break;
                    }
                    action = InsightActionListener.Action.UP;
                    break;
                }
                case 40: {
                    if (e.isControlDown()) {
                        action = InsightActionListener.Action.SCROLL_DOC_DOWN;
                        break;
                    }
                    action = InsightActionListener.Action.DOWN;
                    break;
                }
                case 33: {
                    action = InsightActionListener.Action.PAGE_UP;
                    break;
                }
                case 34: {
                    action = InsightActionListener.Action.SCROLL_DOC_UP;
                    break;
                }
                case 68: {
                    if (!e.isControlDown()) break;
                    action = InsightActionListener.Action.SHOW_DOC;
                }
            }
            if (action != null) {
                e.consume();
                if (doIt) {
                    for (InsightActionListener l : DefaultAdapter.this.listeners) {
                        l.insightActionPerformed(action, DefaultAdapter.this.getTextComponent());
                    }
                }
            }
        }
    }
}

