/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.util;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.bali.xml.util.BaseParser;
import oracle.bali.xml.util.NameToStringUtils;

class PrefixMapParser
extends BaseParser {
    private final Map<String, String> _prefixMap = new LinkedHashMap<String, String>();

    public static Map<String, String> parsePrefixMappings(CharSequence input, int[] indexInOut) throws NameToStringUtils.ParseException {
        int startIndex = indexInOut[0];
        if (startIndex >= input.length()) {
            return Collections.emptyMap();
        }
        char c = input.charAt(startIndex);
        if (c != '[') {
            return Collections.emptyMap();
        }
        PrefixMapParser parser = new PrefixMapParser(input, startIndex);
        parser._parsePrefixMap();
        indexInOut[0] = parser.getNextIndex();
        return parser._prefixMap;
    }

    private void _parsePrefixMap() throws NameToStringUtils.ParseException {
        this.requireAndSkipChar('[');
        StringBuilder buffer = new StringBuilder();
        while (this.notAtEnd()) {
            String prefix = this.curChar() == ':' ? null : this.parseName();
            this.requireAndSkipChar(':');
            buffer.delete(0, buffer.length());
            this.parseUntil(buffer, '|', ']');
            if (this.atEnd()) {
                this.fail("unterminated prefix map");
            }
            String namespace = buffer.length() == 0 ? null : buffer.toString();
            this._prefixMap.put(prefix, namespace);
            char c = this.curChar();
            this.moveNext();
            if (c != ']') continue;
            break;
        }
    }

    private PrefixMapParser(CharSequence input, int startIndex) {
        super(input, startIndex);
    }
}

