/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.sax;

import oracle.bali.xml.sax.LexicalHandlerWrapper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLFilterImpl;

public class StringCaptureXmlFilter
extends XMLFilterImpl {
    private static final String _INDENT_CHARS = "  ";
    private String _lastOpenedTag = null;
    private int _indentLevel = 0;
    private boolean _inCdataSection = false;
    private boolean _preserveCdataSections = true;
    private final boolean _addXmlDecl;
    private final StringBuffer _buffer = new StringBuffer();

    public StringCaptureXmlFilter() {
        this(null);
    }

    public StringCaptureXmlFilter(XMLReader parent) {
        this(parent, true);
    }

    public StringCaptureXmlFilter(XMLReader parent, boolean addXmlDecl) {
        super(parent);
        this._addXmlDecl = addXmlDecl;
        LexicalHandler baseLex = null;
        try {
            Object b = this.getProperty("http://xml.org/sax/properties/lexical-handler");
            if (b instanceof LexicalHandler) {
                baseLex = (LexicalHandler)b;
            }
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        try {
            this.setProperty("http://xml.org/sax/properties/lexical-handler", new LexHandler(baseLex));
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public void setPreserveCdataSections(boolean val) {
        this._preserveCdataSections = val;
    }

    public String getXMLSource() {
        return this._buffer.toString();
    }

    @Override
    public void startDocument() throws SAXException {
        this._buffer.delete(0, this._buffer.length());
        if (this._addXmlDecl) {
            this._buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        }
        super.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this._closeStartTagIfNeeded();
        this._newline();
        super.endDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        this._closeStartTagIfNeeded();
        this._newlineBeforeCurrent();
        this._buffer.append('<');
        this._lastOpenedTag = this._getName(qName, localName);
        this._buffer.append(this._lastOpenedTag);
        int numAttrs = attrs.getLength();
        for (int i = 0; i < numAttrs; ++i) {
            String value;
            this._buffer.append(' ');
            String name = attrs.getQName(i);
            if (name == null) {
                name = attrs.getLocalName(i);
            }
            if ((value = attrs.getValue(i)) == null) {
                value = "";
            }
            this._buffer.append(name);
            this._buffer.append("=\"");
            this._buffer.append(this._escape(value));
            this._buffer.append("\"");
        }
        ++this._indentLevel;
        super.startElement(uri, localName, qName, attrs);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        --this._indentLevel;
        String name = this._getName(qName, localName);
        if (this._lastOpenedTag != null && !name.equals(this._lastOpenedTag)) {
            throw new IllegalStateException("last opened tag != null but not right! last opened=" + this._lastOpenedTag + " end now=" + name);
        }
        if (!name.equals(this._lastOpenedTag)) {
            this._newlineInsideCurrent();
            this._buffer.append("</");
            this._buffer.append(name);
            this._buffer.append('>');
        } else {
            this._buffer.append(" />");
            this._lastOpenedTag = null;
        }
        super.endElement(uri, localName, qName);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this._closeStartTagIfNeeded();
        this._newlineBeforeCurrent();
        this._buffer.append("<?");
        this._buffer.append(target);
        this._buffer.append(' ');
        this._buffer.append(data);
        this._buffer.append("?>");
        super.processingInstruction(target, data);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this._closeStartTagIfNeeded();
        if (this._inCdataSection) {
            this._buffer.append(ch, start, length);
        } else {
            String chars = new String(ch, start, length);
            this._buffer.append(this._escape(chars));
        }
        super.characters(ch, start, length);
    }

    protected StringBuffer getBuffer() {
        return this._buffer;
    }

    protected boolean putWhitespaceBeforeCurrent() {
        return true;
    }

    protected boolean putWhitespaceInsideCurrent() {
        return true;
    }

    private void _closeStartTagIfNeeded() {
        if (this._lastOpenedTag != null) {
            this._buffer.append('>');
            this._lastOpenedTag = null;
        }
    }

    private String _getName(String qName, String localName) {
        return qName != null ? qName : localName;
    }

    private void _newlineBeforeCurrent() {
        if (this.putWhitespaceBeforeCurrent()) {
            this._newline();
        }
    }

    private void _newlineInsideCurrent() {
        if (this.putWhitespaceInsideCurrent()) {
            this._newline();
        }
    }

    private void _newline() {
        if (this._buffer.length() == 0) {
            return;
        }
        this._buffer.append('\n');
        for (int i = 0; i < this._indentLevel; ++i) {
            this._buffer.append(_INDENT_CHARS);
        }
    }

    private String _escape(String in) {
        String out = in.replaceAll("&", "&amp;");
        out = out.replaceAll("<", "&lt;");
        out = out.replaceAll(">", "&gt;");
        out = out.replaceAll("\"", "&quot;");
        return out;
    }

    private class LexHandler
    extends LexicalHandlerWrapper {
        public LexHandler(LexicalHandler parent) {
            super(parent);
        }

        @Override
        public void startCDATA() throws SAXException {
            super.startCDATA();
            if (StringCaptureXmlFilter.this._preserveCdataSections) {
                StringCaptureXmlFilter.this._closeStartTagIfNeeded();
                StringCaptureXmlFilter.this._newlineBeforeCurrent();
                StringCaptureXmlFilter.this._buffer.append("<![CDATA[");
                StringCaptureXmlFilter.this._inCdataSection = true;
            }
        }

        @Override
        public void endCDATA() throws SAXException {
            if (StringCaptureXmlFilter.this._preserveCdataSections) {
                StringCaptureXmlFilter.this._buffer.append("]]>");
                StringCaptureXmlFilter.this._inCdataSection = false;
            }
            super.endCDATA();
        }

        @Override
        public void comment(char[] chars, int start, int length) {
            StringCaptureXmlFilter.this._closeStartTagIfNeeded();
            StringCaptureXmlFilter.this._newlineBeforeCurrent();
            StringCaptureXmlFilter.this._buffer.append("<!--");
            StringCaptureXmlFilter.this._buffer.append(chars, start, length);
            StringCaptureXmlFilter.this._buffer.append("-->");
        }
    }
}

