/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.standalone;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.metadata.XmlMetadataProvider;
import oracle.bali.xml.metadata.standalone.GrammarMetadata;
import oracle.bali.xml.metadata.standalone.OracleStandaloneMetadataFactory;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFile;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFileException;
import oracle.bali.xml.metadata.standalone.StandaloneMetadataFileRegistry;
import oracle.bali.xml.metadata.standalone.StandaloneUtils;
import oracle.bali.xml.metadata.structured.StructuredMetadataBean;

public class StandaloneMetadataProvider
extends XmlMetadataProvider {
    private final ConcurrentHashMap<XmlKey, Map> _layerMetadataMap = new ConcurrentHashMap(53, 0.75f, 5);
    private final ConcurrentHashMap<XmlKey, Collection<XmlKey>> _layerPseudoXmlKeyMap = new ConcurrentHashMap(33, 0.75f, 5);
    private final StandaloneMetadataFileRegistry _registry;

    public static MetadataProvider create(URL ... urls) throws StandaloneMetadataFileException {
        StandaloneMetadataFileRegistry registry = new StandaloneMetadataFileRegistry();
        for (URL url : urls) {
            StandaloneMetadataFile f = OracleStandaloneMetadataFactory.createStandaloneMetadataFile(url);
            registry.addStandaloneMetadataFile(f);
        }
        return new StandaloneMetadataProvider(registry);
    }

    public static MetadataProvider create(List<URL> urls) throws StandaloneMetadataFileException {
        StandaloneMetadataFileRegistry registry = new StandaloneMetadataFileRegistry();
        for (URL url : urls) {
            StandaloneMetadataFile f = OracleStandaloneMetadataFactory.createStandaloneMetadataFile(url);
            registry.addStandaloneMetadataFile(f);
        }
        return new StandaloneMetadataProvider(registry);
    }

    public static MetadataProvider create(MetadataProvider base, URL ... urls) throws StandaloneMetadataFileException {
        StandaloneMetadataFileRegistry registry = new StandaloneMetadataFileRegistry();
        for (URL url : urls) {
            StandaloneMetadataFile f = OracleStandaloneMetadataFactory.createStandaloneMetadataFile(url);
            registry.addStandaloneMetadataFile(f);
        }
        return new StandaloneMetadataProvider(base, registry);
    }

    public static MetadataProvider create(MetadataProvider base, List<URL> urls) throws StandaloneMetadataFileException {
        StandaloneMetadataFileRegistry registry = new StandaloneMetadataFileRegistry();
        for (URL url : urls) {
            StandaloneMetadataFile f = OracleStandaloneMetadataFactory.createStandaloneMetadataFile(url);
            registry.addStandaloneMetadataFile(f);
        }
        return new StandaloneMetadataProvider(base, registry);
    }

    public StandaloneMetadataProvider(StandaloneMetadataFileRegistry registry) {
        this(null, registry);
    }

    public StandaloneMetadataProvider(MetadataProvider base, StandaloneMetadataFileRegistry registry) {
        super(base);
        this._registry = registry;
    }

    @Override
    protected Map getLayerMetadata(Object key) {
        XmlKey xmlKey;
        Map layerMetadata = null;
        if (key instanceof XmlKey && (layerMetadata = this._layerMetadataMap.get(xmlKey = (XmlKey)key)) == null) {
            layerMetadata = StandaloneUtils.getMetadataMap(this._registry, xmlKey);
            this._layerMetadataMap.put(xmlKey, layerMetadata);
        }
        return layerMetadata;
    }

    @Override
    protected Object getLayerMetadataItem(Object key, Object itemKey) {
        Object metadataItem = null;
        Map metadata = this.getLayerMetadata(key);
        if (metadata != null) {
            metadataItem = metadata.get(itemKey);
        }
        return metadataItem;
    }

    @Override
    protected Object getLayerFunction(String prefix, String name) {
        for (StandaloneMetadataFile file : this._registry.getStandaloneMetadataFiles()) {
            GrammarMetadata gmd = file.getGrammarMetadata();
            Object function = gmd.getFunction(prefix, name);
            if (function == null) continue;
            return function;
        }
        return null;
    }

    @Override
    protected List<StructuredMetadataBean> getLayerGlobalMetadata(QualifiedName globalItemName) {
        ArrayList<StructuredMetadataBean> combinedList = new ArrayList<StructuredMetadataBean>();
        for (StandaloneMetadataFile file : this._registry.getStandaloneMetadataFiles()) {
            GrammarMetadata gmd = file.getGrammarMetadata();
            List<StructuredMetadataBean> perGrammarList = gmd.getGlobalMetadata(globalItemName);
            if (perGrammarList == null) continue;
            combinedList.addAll(perGrammarList);
        }
        if (combinedList.isEmpty()) {
            return Collections.emptyList();
        }
        return combinedList;
    }

    @Override
    protected Collection getLayerPseudoXmlKeys(Object baseKey) {
        XmlKey baseXmlKey;
        Collection<Object> pseudoKeys = null;
        if (baseKey instanceof XmlKey && (baseXmlKey = (XmlKey)baseKey).getNodeType() == 1 && (pseudoKeys = this._layerPseudoXmlKeyMap.get(baseXmlKey)) == null) {
            pseudoKeys = StandaloneUtils.getPseudoXmlKeys(baseXmlKey, this._registry);
            this._layerPseudoXmlKeyMap.put(baseXmlKey, pseudoKeys);
        }
        if (pseudoKeys == null) {
            pseudoKeys = Collections.emptyList();
        }
        return pseudoKeys;
    }
}

