/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.el.impl;

import oracle.bali.xml.metadata.el.ELException;
import oracle.bali.xml.metadata.el.VariableResolver;
import oracle.bali.xml.metadata.el.impl.ASTBinaryOperator;
import oracle.bali.xml.metadata.el.impl.ASTOperand;
import oracle.bali.xml.metadata.el.impl.Arithmetic;
import oracle.bali.xml.metadata.el.impl.Coercions;
import oracle.bali.xml.metadata.el.impl.PrimitiveTypes;

final class ASTPlus
extends ASTBinaryOperator {
    private static final ASTPlus _sInstance = new ASTPlus();

    @Override
    public Object apply(VariableResolver vResolver, ASTOperand left, ASTOperand right) throws ELException {
        Object lhs = left.getValue(vResolver);
        Object rhs = right.getValue(vResolver);
        if (lhs == null && rhs == null) {
            return PrimitiveTypes.getLong(0L);
        }
        if (Arithmetic.isBigDecimal(lhs) || Arithmetic.isBigDecimal(rhs)) {
            return Coercions.toBigDecimal(lhs).add(Coercions.toBigDecimal(rhs));
        }
        if (Arithmetic.shouldCoercetoDouble(lhs) || Arithmetic.shouldCoercetoDouble(rhs)) {
            if (Arithmetic.isBigInteger(lhs) || Arithmetic.isBigInteger(rhs)) {
                return Coercions.toBigDecimal(lhs).add(Coercions.toBigDecimal(rhs));
            }
            return PrimitiveTypes.getDouble(Coercions.toDouble(lhs) + Coercions.toDouble(rhs));
        }
        if (Arithmetic.isBigInteger(lhs) || Arithmetic.isBigInteger(rhs)) {
            return Coercions.toBigInteger(lhs).add(Coercions.toBigInteger(rhs));
        }
        return PrimitiveTypes.getLong(Coercions.toLong(lhs) + Coercions.toLong(rhs));
    }

    @Override
    public Class getType(VariableResolver vResolver, ASTOperand left, ASTOperand right) throws ELException {
        return Number.class;
    }

    @Override
    public void toString(StringBuffer buffer, ASTOperand left, ASTOperand right) {
        buffer.append('(');
        left.toString(buffer);
        buffer.append(" + ");
        right.toString(buffer);
        buffer.append(')');
    }

    public static ASTPlus sharedInstance() {
        return _sInstance;
    }

    private ASTPlus() {
    }
}

