/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata.el.impl;

import oracle.bali.xml.metadata.el.ELException;
import oracle.bali.xml.metadata.el.VariableResolver;
import oracle.bali.xml.metadata.el.impl.ASTBinaryOperator;
import oracle.bali.xml.metadata.el.impl.ASTOperand;
import oracle.bali.xml.metadata.el.impl.Coercions;
import oracle.bali.xml.metadata.el.impl.PrimitiveTypes;

final class ASTLogicalOr
extends ASTBinaryOperator {
    private static final ASTLogicalOr _sInstance = new ASTLogicalOr();

    @Override
    public Object apply(VariableResolver vResolver, ASTOperand left, ASTOperand right) throws ELException {
        return PrimitiveTypes.getBoolean(Coercions.toBoolean(left.getValue(vResolver)) || Coercions.toBoolean(right.getValue(vResolver)));
    }

    @Override
    public void toString(StringBuffer buffer, ASTOperand left, ASTOperand right) {
        buffer.append('(');
        left.toString(buffer);
        buffer.append(" || ");
        right.toString(buffer);
        buffer.append(')');
    }

    @Override
    public boolean isConstant(ASTOperand left, ASTOperand right) {
        return left.isConstant() && (Boolean.TRUE.equals(left.getValue(null)) || right.isConstant());
    }

    @Override
    public Class getType(VariableResolver vResolver, ASTOperand left, ASTOperand right) throws ELException {
        return Boolean.class;
    }

    public static ASTLogicalOr sharedInstance() {
        return _sInstance;
    }

    private ASTLogicalOr() {
    }
}

