/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.grammar.resolver.GrammarResolverAdapter;
import oracle.bali.xml.grammar.resolver.GrammarResolverEvent;
import oracle.bali.xml.metadata.BaliElEvaluator;
import oracle.bali.xml.metadata.LayeredMetadataEvaluator;
import oracle.bali.xml.metadata.MetadataEvaluator;
import oracle.bali.xml.metadata.MetadataException;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.MetadataSchemaRegistry;
import oracle.bali.xml.metadata.MetadataValueConverter;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.metadata.structured.MutableStructuredMetadataBean;
import oracle.bali.xml.metadata.structured.StructuredMetadataBean;
import oracle.bali.xml.metadata.structured.StructuredMetadataConverter;
import org.w3c.dom.Node;

public class CoreMetadataEvaluator
extends LayeredMetadataEvaluator {
    private final MetadataProvider _provider;
    private final GrammarResolver _grammarResolver;
    private final MetadataProvider _metadataLanguageProvider;
    private final GrammarResolver _metadataLanguageGrammarResolver;
    private final Map _implicitObjects;
    private final MetadataValueConverter _converter;
    private final BaliElEvaluator _elEvaluator;
    private static final QualifiedName _PREFERRED_PREFIX = QualifiedName.getQualifiedName("http://xmlns.oracle.com/bali/xml/metadata", "preferredPrefix");
    private static final Set<Class<?>> _TYPES_EL_SUPPORTS = new HashSet<Class>(Arrays.asList(String.class, Boolean.class, Integer.class, Float.class, Double.class, Number.class, Short.class, Long.class, Byte.class, Character.class));

    public CoreMetadataEvaluator(MetadataProvider provider, GrammarResolver grammarResolver) {
        this(provider, grammarResolver, null);
    }

    public CoreMetadataEvaluator(MetadataProvider provider, GrammarResolver grammarResolver, MetadataEvaluator base) {
        this(provider, grammarResolver, base, Locale.getDefault());
    }

    public CoreMetadataEvaluator(MetadataProvider provider, GrammarResolver grammarResolver, MetadataEvaluator base, Locale locale) {
        this(provider, grammarResolver, MetadataSchemaRegistry.getInstance().getMetadataProvider(), MetadataSchemaRegistry.getInstance().getMetadataGrammarResolver(), base, locale);
    }

    public CoreMetadataEvaluator(MetadataProvider provider, GrammarResolver grammarResolver, MetadataProvider metadataLanguageProvider, GrammarResolver metadataLanguageGrammarResolver, MetadataEvaluator base, Locale locale) {
        super(base);
        if (provider == null) {
            throw new IllegalArgumentException("MetadataProvider must not be null");
        }
        if (grammarResolver == null) {
            throw new IllegalArgumentException("GrammarResolver must not be null");
        }
        if (metadataLanguageProvider == null) {
            throw new IllegalArgumentException("metadataLanguageProvider must not be null");
        }
        if (metadataLanguageGrammarResolver == null) {
            throw new IllegalArgumentException("metadataLanguageGrammarResolver must not be null");
        }
        this._provider = provider;
        this._grammarResolver = grammarResolver;
        this._metadataLanguageProvider = metadataLanguageProvider;
        this._metadataLanguageGrammarResolver = metadataLanguageGrammarResolver;
        this._implicitObjects = new HashMap();
        this._implicitObjects.put("evaluator", this);
        this._implicitObjects.put("provider", provider);
        this._implicitObjects.put("locale", locale);
        this._converter = new MetadataValueConverter(this._metadataLanguageGrammarResolver);
        this._elEvaluator = new BaliElEvaluator(this.getMetadataProvider(), this._metadataLanguageProvider);
        this._grammarResolver.addGrammarResolverListener(new GrammarResolverListener());
    }

    @Override
    protected Collection getLayerPseudoXmlKeys(Object masterKey) {
        return this._provider.getPseudoXmlKeys(masterKey);
    }

    @Override
    protected List<StructuredMetadataBean> getLayerGlobalMetadata(QualifiedName globalItemName) {
        List<StructuredMetadataBean> beans = this._provider.getGlobalMetadata(globalItemName);
        ArrayList<StructuredMetadataBean> convertedBeans = new ArrayList<StructuredMetadataBean>();
        for (StructuredMetadataBean bean : beans) {
            NamespaceStructuredMetadataConverter converter = new NamespaceStructuredMetadataConverter(bean.getOwnerNS());
            convertedBeans.add(converter.convertStructuredMetadataBean(bean, null));
        }
        return convertedBeans;
    }

    @Override
    protected LayeredMetadataEvaluator.MetadataInfo getLayerMetadataInfo(Object key, Object itemKey, Node node) {
        LayeredMetadataEvaluator.MetadataInfo info = null;
        try {
            Object metadata;
            HashMap<String, Object> additionalObjects = new HashMap<String, Object>();
            additionalObjects.put("node", node);
            additionalObjects.put("key", key);
            additionalObjects.put("itemKey", itemKey);
            Class expectedType = this._converter.getExpectedMetadataType(itemKey);
            Class elSupportedType = Object.class;
            if (_TYPES_EL_SUPPORTS.contains(expectedType)) {
                elSupportedType = expectedType;
            }
            if ((metadata = this.getMetadataProvider().getMetadataItem(key, itemKey)) != null) {
                if (metadata instanceof String) {
                    String value = (String)metadata;
                    if (value.length() > 0 && (info = this.evaluateValue(value, elSupportedType, additionalObjects)) != null) {
                        info.value = this._converter.coerceMetadataValue(info.value, itemKey);
                    }
                } else if (expectedType.isInstance(metadata)) {
                    info = new LayeredMetadataEvaluator.MetadataInfo(metadata, 0);
                } else {
                    this.getLogger().log(Level.WARNING, "Metadata for key " + key + ", item key " + itemKey + ", node " + node + "is not of expected type: " + expectedType);
                }
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Error getting metadata for key " + key + ", item key " + itemKey + ", node " + node, e);
        }
        return info;
    }

    protected LayeredMetadataEvaluator.MetadataInfo evaluateValue(String value, Class expectedType, Map additionalObjects) throws MetadataException {
        return this._elEvaluator.evaluateValue(value, expectedType, this.getImplicitObjects(), additionalObjects);
    }

    protected MetadataProvider getMetadataProvider() {
        return this._provider;
    }

    protected Map getImplicitObjects() {
        return this._implicitObjects;
    }

    public CoreMetadataEvaluator(MetadataProvider provider, GrammarProvider grammarProvider) {
        this(provider, grammarProvider, null);
    }

    public CoreMetadataEvaluator(MetadataProvider provider, GrammarProvider grammarProvider, MetadataEvaluator base) {
        this(provider, grammarProvider, base, Locale.getDefault());
    }

    public CoreMetadataEvaluator(MetadataProvider provider, GrammarProvider grammarProvider, MetadataEvaluator base, Locale locale) {
        this(provider, grammarProvider, MetadataSchemaRegistry.getInstance().getMetadataProvider(), MetadataSchemaRegistry.getInstance().getMetadataGrammars(), base, locale);
    }

    public CoreMetadataEvaluator(MetadataProvider provider, GrammarProvider grammarProvider, MetadataProvider metadataLanguageProvider, GrammarProvider metadataLanguageGrammarProvider, MetadataEvaluator base, Locale locale) {
        this(provider, new GrammarResolver(grammarProvider), metadataLanguageProvider, new GrammarResolver(metadataLanguageGrammarProvider), base, locale);
    }

    private class GrammarResolverListener
    extends GrammarResolverAdapter {
        private GrammarResolverListener() {
        }

        @Override
        public void invalidate(GrammarResolverEvent e) {
            CoreMetadataEvaluator.this.clearMetadataCache();
        }
    }

    private class NamespaceStructuredMetadataConverter
    extends StructuredMetadataConverter {
        private final XmlKey _ownerNSKey;

        public NamespaceStructuredMetadataConverter(XmlKey ownerNSKey) {
            this._ownerNSKey = ownerNSKey;
        }

        @Override
        public void addProperty(MutableStructuredMetadataBean bean, QualifiedName propertyName, String value) {
            bean.addProperty(propertyName, this.convertValue(value));
        }

        @Override
        public void setBeanTextValue(MutableStructuredMetadataBean bean, String beanTextValue) {
            bean.setValue(this.convertValue(beanTextValue));
        }

        private String convertValue(String value) {
            try {
                LayeredMetadataEvaluator.MetadataInfo info;
                HashMap<String, XmlKey> additionalObjects = new HashMap<String, XmlKey>();
                additionalObjects.put("ownerNS", this._ownerNSKey);
                if (value != null && value.length() > 0 && (info = CoreMetadataEvaluator.this.evaluateValue(value, String.class, additionalObjects)) != null) {
                    return (String)info.value;
                }
            }
            catch (Exception e) {
                CoreMetadataEvaluator.this.getLogger().log(Level.WARNING, "Error converting value,  " + value, e);
            }
            return value;
        }
    }
}

