/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar.automata;

import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.Wildcard;
import oracle.bali.xml.grammar.automata.State;
import oracle.bali.xml.grammar.automata.Transition;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.grammar.util.TypeUtils;

public class WildcardTransition
extends Transition {
    private static final String _ERROR_NULL_NAME = "Cannot pass a null Wildcard to constructor";
    private Wildcard _wildcard = null;

    public WildcardTransition(State fromState, State toState, Wildcard wildcard) {
        super(fromState, toState);
        if (wildcard == null) {
            throw new IllegalArgumentException(_ERROR_NULL_NAME);
        }
        this._wildcard = wildcard;
    }

    public Wildcard getWildcard() {
        return this._wildcard;
    }

    @Override
    public boolean accepts(GrammarResolver resolver, QualifiedName name) {
        return TypeUtils.wildcardAllowsName(this._wildcard, name);
    }

    @Override
    public Transition clone(State fromState, State toState) {
        return new WildcardTransition(fromState, toState, this.getWildcard());
    }
}

