/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import oracle.bali.xml.grammar.QualifiedName;

class FixedAttributeQualifiedName
extends QualifiedName {
    private final String _attributeNamespace;
    private final String _attributeName;
    private final String _attributeValue;
    private static final long serialVersionUID = 1L;
    private static ConcurrentHashMap<String, FixedAttributeQualifiedName> _sQNameMap = new ConcurrentHashMap(103, 0.75f, 10);

    public static FixedAttributeQualifiedName getFixedAttributeQualifiedName(String namespace, String name, String attributeNamespace, String attributeName, String attributeValue) {
        FixedAttributeQualifiedName newName;
        String key;
        FixedAttributeQualifiedName qName;
        StringBuffer buffer = new StringBuffer();
        if (namespace != null) {
            buffer.append(namespace);
        }
        buffer.append(":");
        if (name != null) {
            buffer.append(name);
        }
        buffer.append(":");
        if (attributeNamespace != null) {
            buffer.append(attributeNamespace);
        }
        buffer.append(":");
        if (attributeName != null) {
            buffer.append(attributeName);
        }
        buffer.append(":");
        if (attributeValue != null) {
            buffer.append(attributeValue);
        }
        if ((qName = _sQNameMap.get(key = buffer.toString())) == null && (qName = _sQNameMap.putIfAbsent(key, newName = new FixedAttributeQualifiedName(namespace, name, attributeNamespace, attributeName, attributeValue))) == null) {
            qName = newName;
        }
        return qName;
    }

    private FixedAttributeQualifiedName(String namespace, String name, String attributeNamespace, String attributeName, String attributeValue) {
        super(namespace, name);
        this.validateNamespaceName(attributeNamespace, attributeName);
        if (attributeValue == null) {
            throw new IllegalArgumentException("fixed attribute value may not be null!");
        }
        this._attributeNamespace = attributeNamespace;
        this._attributeName = attributeName;
        this._attributeValue = attributeValue;
    }

    @Override
    public String getAttributeName() {
        return this._attributeName;
    }

    @Override
    public String getAttributeNamespace() {
        return this._attributeNamespace;
    }

    @Override
    public String getAttributeValue() {
        return this._attributeValue;
    }

    @Override
    public boolean isVariation() {
        return true;
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private Object writeReplace() {
        return new FixedAttributeQualifiedNameSerializationProxy(this);
    }

    private static class FixedAttributeQualifiedNameSerializationProxy
    implements Serializable {
        private final String _namespace;
        private final String _localName;
        private final String _attributeNamespace;
        private final String _attributeName;
        private final String _attributeValue;
        private static final long serialVersionUID = 1L;

        FixedAttributeQualifiedNameSerializationProxy(FixedAttributeQualifiedName qName) {
            this._namespace = qName.getNamespace();
            this._localName = qName.getName();
            this._attributeNamespace = qName.getAttributeNamespace();
            this._attributeName = qName.getAttributeName();
            this._attributeValue = qName.getAttributeValue();
        }

        private Object readResolve() {
            return FixedAttributeQualifiedName.getFixedAttributeQualifiedName(this._namespace, this._localName, this._attributeNamespace, this._attributeName, this._attributeValue);
        }
    }
}

