/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.grammar;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.GrammarProviderEvent;
import oracle.bali.xml.grammar.GrammarProviderListener;

public class AggregateGrammarProvider
extends GrammarProvider {
    private GrammarProvider _base;
    private GrammarProvider _layer;
    private GrammarProviderListener _layerPercolator = new IdenticalGrammarEventPercolator();
    private GrammarProviderListener _basePercolator = new FilteredGrammarEventPercolator();

    public AggregateGrammarProvider(GrammarProvider base, GrammarProvider layer) {
        this._base = base;
        this._layer = layer;
    }

    @Override
    public final Map getGrammarMap() {
        LinkedHashMap combinedGrammars = new LinkedHashMap();
        if (this._base != null) {
            combinedGrammars.putAll(this._base.getGrammarMap());
        }
        if (this._layer != null) {
            combinedGrammars.putAll(this._layer.getGrammarMap());
        }
        return Collections.unmodifiableMap(combinedGrammars);
    }

    @Override
    public Grammar getGrammarForNamespace(String targetNamespace) {
        Grammar result = null;
        if (this._layer != null) {
            result = this._layer.getGrammarForNamespace(targetNamespace);
        }
        if (result == null && this._base != null) {
            result = this._base.getGrammarForNamespace(targetNamespace);
        }
        return result;
    }

    @Override
    protected void firstListenerAttached() {
        if (this._base != null) {
            this._base.addGrammarProviderListener(this._basePercolator);
        }
        if (this._layer != null) {
            this._layer.addGrammarProviderListener(this._layerPercolator);
        }
    }

    @Override
    protected void lastListenerDetached() {
        if (this._base != null) {
            this._base.removeGrammarProviderListener(this._basePercolator);
        }
        if (this._layer != null) {
            this._layer.removeGrammarProviderListener(this._layerPercolator);
        }
    }

    private class IdenticalGrammarEventPercolator
    implements GrammarProviderListener {
        private IdenticalGrammarEventPercolator() {
        }

        @Override
        public void grammarProviderChanged(GrammarProviderEvent e) {
            AggregateGrammarProvider.this.fireEvent(e.getGrammarsAdded(), e.getGrammarsRemoved(), e.getGrammarsChanged());
        }
    }

    private class FilteredGrammarEventPercolator
    implements GrammarProviderListener {
        private FilteredGrammarEventPercolator() {
        }

        @Override
        public void grammarProviderChanged(GrammarProviderEvent e) {
            Set grammarsAdded = this._filterSet(e.getGrammarsAdded());
            Set grammarsRemoved = this._filterSet(e.getGrammarsRemoved());
            Set grammarsChanged = this._filterSet(e.getGrammarsChanged());
            AggregateGrammarProvider.this.fireEvent(grammarsAdded, grammarsRemoved, grammarsChanged);
        }

        private Set _filterSet(Set grammars) {
            Set<Grammar> filteredGrammars = grammars;
            if (!grammars.isEmpty()) {
                filteredGrammars = new HashSet();
                Iterator iter = grammars.iterator();
                Map layerMap = AggregateGrammarProvider.this._layer.getGrammarMap();
                while (iter.hasNext()) {
                    Grammar g = (Grammar)iter.next();
                    String targetNamespace = g.getTargetNamespace();
                    if (layerMap == null || layerMap.containsKey(targetNamespace)) continue;
                    filteredGrammars.add(g);
                }
                if (filteredGrammars.isEmpty()) {
                    filteredGrammars = Collections.EMPTY_SET;
                }
            }
            return filteredGrammars;
        }
    }
}

