/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plusplus.connections.db;

import oracle.dbtools.raptor.newscriptrunner.util.parser.Factory;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.OptionBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParameterBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;
import oracle.dbtools.raptor.newscriptrunner.util.parser.TypeBuilder;

public class ConnectionStoreOptions {
    static final String BASE_COMMAND_S = "CM";
    static final String DUPLICATES_S = "D";
    static final String DUPLICATES_M = "DUPS";
    static final String STRIP_S = "S";
    static final String STRIP_M = "STRIP";
    static final Type IMPORT_COMMAND;
    static final Type LIST_COMMAND;
    private static final String CONNECTION_NAME_S = "N";
    static final Type SHOW_COMMAND;
    private static final String USERNAME_S = "U";
    static final Type TEST_COMMAND;
    private static final String ORIGINAL_S = "O";
    static final Type CLONE_COMMAND;
    static final Type COMMAND;

    private static String createHelpKey(Symbol cmd, Symbol param) {
        return cmd.name() + "_" + param.name() + "_P";
    }

    static {
        TypeBuilder builder = Factory.type(Symbol.IMPORT);
        builder.add(((OptionBuilder)Factory.option(Symbol.DUPLICATES).abbrevs(DUPLICATES_S, DUPLICATES_M).helpId(ConnectionStoreOptions.createHelpKey(Symbol.IMPORT, Symbol.DUPLICATES)).defaultValue(DuplicatesPolicy.DEFAULT_DUPLICATE_OPTION.name())).build());
        builder.add(Factory.option(Symbol.KEY).helpId(ConnectionStoreOptions.createHelpKey(Symbol.IMPORT, Symbol.KEY)).build());
        builder.add(Factory.option(Symbol.STRIP_PASSWORDS).flag().abbrevs(STRIP_S, STRIP_M).helpId(ConnectionStoreOptions.createHelpKey(Symbol.IMPORT, Symbol.STRIP_PASSWORDS)).build());
        builder.add(Factory.parameter(Symbol.PATH).helpId(ConnectionStoreOptions.createHelpKey(Symbol.IMPORT, Symbol.PATH)).build());
        IMPORT_COMMAND = builder.build();
        builder = Factory.type(Symbol.LIST);
        LIST_COMMAND = builder.build();
        builder = Factory.type(Symbol.SHOW);
        builder.add(((ParameterBuilder)Factory.parameter(Symbol.CONNECTION_NAME).required()).helpId(ConnectionStoreOptions.createHelpKey(Symbol.SHOW, Symbol.CONNECTION_NAME)).build());
        SHOW_COMMAND = builder.build();
        builder = Factory.type(Symbol.TEST);
        builder.add(Factory.option(Symbol.USERNAME).abbrevs(USERNAME_S).helpId(ConnectionStoreOptions.createHelpKey(Symbol.TEST, Symbol.USERNAME)).build());
        builder.add(((ParameterBuilder)Factory.parameter(Symbol.CONNECTION_NAME).required()).helpId(ConnectionStoreOptions.createHelpKey(Symbol.TEST, Symbol.CONNECTION_NAME)).build());
        TEST_COMMAND = builder.build();
        builder = Factory.type(Symbol.CLONE);
        builder.add(((OptionBuilder)Factory.option(Symbol.ORIGINAL).abbrevs(ORIGINAL_S).required()).helpId(ConnectionStoreOptions.createHelpKey(Symbol.CLONE, Symbol.ORIGINAL)).build());
        builder.add(Factory.option(Symbol.USERNAME).abbrevs(USERNAME_S).helpId(ConnectionStoreOptions.createHelpKey(Symbol.CLONE, Symbol.USERNAME)).build());
        builder.add(Factory.option(Symbol.NOPWD).flag().helpId(ConnectionStoreOptions.createHelpKey(Symbol.CLONE, Symbol.NOPWD)).build());
        builder.add(((ParameterBuilder)Factory.parameter(Symbol.CONNECTION_NAME).required()).helpId(ConnectionStoreOptions.createHelpKey(Symbol.CLONE, Symbol.CONNECTION_NAME)).build());
        CLONE_COMMAND = builder.build();
        COMMAND = Factory.type(Symbol.CONNMGR).abbrevs(BASE_COMMAND_S).helpId(Symbol.CONNMGR.name().toUpperCase()).add(IMPORT_COMMAND).add(LIST_COMMAND).add(SHOW_COMMAND).add(TEST_COMMAND).add(CLONE_COMMAND).build();
    }

    public static enum DuplicatesPolicy {
        IGNORE,
        RENAME,
        REPLACE;

        static final DuplicatesPolicy DEFAULT_DUPLICATE_OPTION;

        static {
            DEFAULT_DUPLICATE_OPTION = IGNORE;
        }
    }

    public static enum Symbol implements Id
    {
        CONNMGR,
        IMPORT,
        DUPLICATES,
        KEY,
        STRIP_PASSWORDS,
        PATH,
        LIST,
        SHOW,
        CONNECTION_NAME,
        TEST,
        USERNAME,
        CLONE,
        ORIGINAL,
        NOPWD;

    }
}

